/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CP;
import ca.uhn.hl7v2.model.v251.datatype.CX;
import ca.uhn.hl7v2.model.v251.datatype.DT;
import ca.uhn.hl7v2.model.v251.datatype.FC;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.JCC;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.SI;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.XAD;
import ca.uhn.hl7v2.model.v251.datatype.XON;
import ca.uhn.hl7v2.model.v251.datatype.XPN;
import ca.uhn.hl7v2.model.v251.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class GT1
extends AbstractSegment {
    public GT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        Message message = this.getMessage();
        try {
            this.add(SI.class, true, 1, 4, new Object[]{message}, "Set ID - GT1");
            this.add(CX.class, false, 0, 250, new Object[]{message}, "Guarantor Number");
            this.add(XPN.class, true, 0, 250, new Object[]{message}, "Guarantor Name");
            this.add(XPN.class, false, 0, 250, new Object[]{message}, "Guarantor Spouse Name");
            this.add(XAD.class, false, 0, 250, new Object[]{message}, "Guarantor Address");
            this.add(XTN.class, false, 0, 250, new Object[]{message}, "Guarantor Ph Num - Home");
            this.add(XTN.class, false, 0, 250, new Object[]{message}, "Guarantor Ph Num - Business");
            this.add(TS.class, false, 1, 26, new Object[]{message}, "Guarantor Date/Time Of Birth");
            this.add(IS.class, false, 1, 1, new Object[]{message, new Integer(1)}, "Guarantor Administrative Sex");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(68)}, "Guarantor Type");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Guarantor Relationship");
            this.add(ST.class, false, 1, 11, new Object[]{message}, "Guarantor SSN");
            this.add(DT.class, false, 1, 8, new Object[]{message}, "Guarantor Date - Begin");
            this.add(DT.class, false, 1, 8, new Object[]{message}, "Guarantor Date - End");
            this.add(NM.class, false, 1, 2, new Object[]{message}, "Guarantor Priority");
            this.add(XPN.class, false, 0, 250, new Object[]{message}, "Guarantor Employer Name");
            this.add(XAD.class, false, 0, 250, new Object[]{message}, "Guarantor Employer Address");
            this.add(XTN.class, false, 0, 250, new Object[]{message}, "Guarantor Employer Phone Number");
            this.add(CX.class, false, 0, 250, new Object[]{message}, "Guarantor Employee ID Number");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(66)}, "Guarantor Employment Status");
            this.add(XON.class, false, 0, 250, new Object[]{message}, "Guarantor Organization Name");
            this.add(ID.class, false, 1, 1, new Object[]{message, new Integer(136)}, "Guarantor Billing Hold Flag");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Guarantor Credit Rating Code");
            this.add(TS.class, false, 1, 26, new Object[]{message}, "Guarantor Death Date And Time");
            this.add(ID.class, false, 1, 1, new Object[]{message, new Integer(136)}, "Guarantor Death Flag");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Guarantor Charge Adjustment Code");
            this.add(CP.class, false, 1, 10, new Object[]{message}, "Guarantor Household Annual Income");
            this.add(NM.class, false, 1, 3, new Object[]{message}, "Guarantor Household Size");
            this.add(CX.class, false, 0, 250, new Object[]{message}, "Guarantor Employer ID Number");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Guarantor Marital Status Code");
            this.add(DT.class, false, 1, 8, new Object[]{message}, "Guarantor Hire Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{message}, "Employment Stop Date");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(223)}, "Living Dependency");
            this.add(IS.class, false, 0, 2, new Object[]{message, new Integer(9)}, "Ambulatory Status");
            this.add(CE.class, false, 0, 250, new Object[]{message}, "Citizenship");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Primary Language");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(220)}, "Living Arrangement");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Publicity Code");
            this.add(ID.class, false, 1, 1, new Object[]{message, new Integer(136)}, "Protection Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(231)}, "Student Indicator");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Religion");
            this.add(XPN.class, false, 0, 250, new Object[]{message}, "Mother's Maiden Name");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Nationality");
            this.add(CE.class, false, 0, 250, new Object[]{message}, "Ethnic Group");
            this.add(XPN.class, false, 0, 250, new Object[]{message}, "Contact Person's Name");
            this.add(XTN.class, false, 0, 250, new Object[]{message}, "Contact Person's Telephone Number");
            this.add(CE.class, false, 1, 250, new Object[]{message}, "Contact Reason");
            this.add(IS.class, false, 1, 3, new Object[]{message, new Integer(63)}, "Contact Relationship");
            this.add(ST.class, false, 1, 20, new Object[]{message}, "Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{message}, "Job Code/Class");
            this.add(XON.class, false, 0, 250, new Object[]{message}, "Guarantor Employer's Organization Name");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(295)}, "Handicap");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(311)}, "Job Status");
            this.add(FC.class, false, 1, 50, new Object[]{message}, "Guarantor Financial Class");
            this.add(CE.class, false, 0, 250, new Object[]{message}, "Guarantor Race");
            this.add(ST.class, false, 1, 250, new Object[]{message}, "Guarantor Birth Place");
            this.add(IS.class, false, 1, 2, new Object[]{message, new Integer(99)}, "VIP Indicator");
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)("Can't instantiate " + ((Object)((Object)this)).getClass().getName()), (Throwable)he);
        }
    }

    public SI getSetIDGT1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getGt11_SetIDGT1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getGuarantorNumber(int rep) throws HL7Exception {
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CX[] getGuarantorNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorNumberReps() {
        try {
            return this.getField(2).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertGuarantorNumber(int index) throws HL7Exception {
        return (CX)super.insertRepetition(2, index);
    }

    public CX removeGuarantorNumber(int index) throws HL7Exception {
        return (CX)super.removeRepetition(2, index);
    }

    public CX getGt12_GuarantorNumber(int rep) throws HL7Exception {
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CX[] getGt12_GuarantorNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt12_GuarantorNumberReps() {
        try {
            return this.getField(2).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertGt12_GuarantorNumber(int index) throws HL7Exception {
        return (CX)super.insertRepetition(2, index);
    }

    public CX removeGt12_GuarantorNumber(int index) throws HL7Exception {
        return (CX)super.removeRepetition(2, index);
    }

    public XPN getGuarantorName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGuarantorName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorNameReps() {
        try {
            return this.getField(3).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGuarantorName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(3, index);
    }

    public XPN removeGuarantorName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(3, index);
    }

    public XPN getGt13_GuarantorName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGt13_GuarantorName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt13_GuarantorNameReps() {
        try {
            return this.getField(3).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGt13_GuarantorName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(3, index);
    }

    public XPN removeGt13_GuarantorName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(3, index);
    }

    public XPN getGuarantorSpouseName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGuarantorSpouseName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorSpouseNameReps() {
        try {
            return this.getField(4).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGuarantorSpouseName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(4, index);
    }

    public XPN removeGuarantorSpouseName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(4, index);
    }

    public XPN getGt14_GuarantorSpouseName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGt14_GuarantorSpouseName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt14_GuarantorSpouseNameReps() {
        try {
            return this.getField(4).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGt14_GuarantorSpouseName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(4, index);
    }

    public XPN removeGt14_GuarantorSpouseName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(4, index);
    }

    public XAD getGuarantorAddress(int rep) throws HL7Exception {
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XAD[] getGuarantorAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorAddressReps() {
        try {
            return this.getField(5).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertGuarantorAddress(int index) throws HL7Exception {
        return (XAD)super.insertRepetition(5, index);
    }

    public XAD removeGuarantorAddress(int index) throws HL7Exception {
        return (XAD)super.removeRepetition(5, index);
    }

    public XAD getGt15_GuarantorAddress(int rep) throws HL7Exception {
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XAD[] getGt15_GuarantorAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt15_GuarantorAddressReps() {
        try {
            return this.getField(5).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertGt15_GuarantorAddress(int index) throws HL7Exception {
        return (XAD)super.insertRepetition(5, index);
    }

    public XAD removeGt15_GuarantorAddress(int index) throws HL7Exception {
        return (XAD)super.removeRepetition(5, index);
    }

    public XTN getGuarantorPhNumHome(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGuarantorPhNumHome() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorPhNumHomeReps() {
        try {
            return this.getField(6).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGuarantorPhNumHome(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(6, index);
    }

    public XTN removeGuarantorPhNumHome(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(6, index);
    }

    public XTN getGt16_GuarantorPhNumHome(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGt16_GuarantorPhNumHome() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt16_GuarantorPhNumHomeReps() {
        try {
            return this.getField(6).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGt16_GuarantorPhNumHome(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(6, index);
    }

    public XTN removeGt16_GuarantorPhNumHome(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(6, index);
    }

    public XTN getGuarantorPhNumBusiness(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGuarantorPhNumBusiness() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorPhNumBusinessReps() {
        try {
            return this.getField(7).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGuarantorPhNumBusiness(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(7, index);
    }

    public XTN removeGuarantorPhNumBusiness(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(7, index);
    }

    public XTN getGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGt17_GuarantorPhNumBusiness() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt17_GuarantorPhNumBusinessReps() {
        try {
            return this.getField(7).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGt17_GuarantorPhNumBusiness(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(7, index);
    }

    public XTN removeGt17_GuarantorPhNumBusiness(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(7, index);
    }

    public TS getGuarantorDateTimeOfBirth() {
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getGt18_GuarantorDateTimeOfBirth() {
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGuarantorAdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt19_GuarantorAdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGuarantorType() {
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt110_GuarantorType() {
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGuarantorRelationship() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt111_GuarantorRelationship() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getGuarantorSSN() {
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getGt112_GuarantorSSN() {
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGuarantorDateBegin() {
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGt113_GuarantorDateBegin() {
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGuarantorDateEnd() {
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGt114_GuarantorDateEnd() {
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGuarantorPriority() {
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGt115_GuarantorPriority() {
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getGuarantorEmployerName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGuarantorEmployerName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorEmployerNameReps() {
        try {
            return this.getField(16).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGuarantorEmployerName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(16, index);
    }

    public XPN removeGuarantorEmployerName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(16, index);
    }

    public XPN getGt116_GuarantorEmployerName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGt116_GuarantorEmployerName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt116_GuarantorEmployerNameReps() {
        try {
            return this.getField(16).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGt116_GuarantorEmployerName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(16, index);
    }

    public XPN removeGt116_GuarantorEmployerName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(16, index);
    }

    public XAD getGuarantorEmployerAddress(int rep) throws HL7Exception {
        XAD ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XAD[] getGuarantorEmployerAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorEmployerAddressReps() {
        try {
            return this.getField(17).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertGuarantorEmployerAddress(int index) throws HL7Exception {
        return (XAD)super.insertRepetition(17, index);
    }

    public XAD removeGuarantorEmployerAddress(int index) throws HL7Exception {
        return (XAD)super.removeRepetition(17, index);
    }

    public XAD getGt117_GuarantorEmployerAddress(int rep) throws HL7Exception {
        XAD ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XAD[] getGt117_GuarantorEmployerAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt117_GuarantorEmployerAddressReps() {
        try {
            return this.getField(17).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertGt117_GuarantorEmployerAddress(int index) throws HL7Exception {
        return (XAD)super.insertRepetition(17, index);
    }

    public XAD removeGt117_GuarantorEmployerAddress(int index) throws HL7Exception {
        return (XAD)super.removeRepetition(17, index);
    }

    public XTN getGuarantorEmployerPhoneNumber(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGuarantorEmployerPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(18);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorEmployerPhoneNumberReps() {
        try {
            return this.getField(18).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGuarantorEmployerPhoneNumber(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(18, index);
    }

    public XTN removeGuarantorEmployerPhoneNumber(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(18, index);
    }

    public XTN getGt118_GuarantorEmployerPhoneNumber(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGt118_GuarantorEmployerPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(18);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt118_GuarantorEmployerPhoneNumberReps() {
        try {
            return this.getField(18).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGt118_GuarantorEmployerPhoneNumber(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(18, index);
    }

    public XTN removeGt118_GuarantorEmployerPhoneNumber(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(18, index);
    }

    public CX getGuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        CX ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CX[] getGuarantorEmployeeIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorEmployeeIDNumberReps() {
        try {
            return this.getField(19).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertGuarantorEmployeeIDNumber(int index) throws HL7Exception {
        return (CX)super.insertRepetition(19, index);
    }

    public CX removeGuarantorEmployeeIDNumber(int index) throws HL7Exception {
        return (CX)super.removeRepetition(19, index);
    }

    public CX getGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        CX ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CX[] getGt119_GuarantorEmployeeIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt119_GuarantorEmployeeIDNumberReps() {
        try {
            return this.getField(19).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertGt119_GuarantorEmployeeIDNumber(int index) throws HL7Exception {
        return (CX)super.insertRepetition(19, index);
    }

    public CX removeGt119_GuarantorEmployeeIDNumber(int index) throws HL7Exception {
        return (CX)super.removeRepetition(19, index);
    }

    public IS getGuarantorEmploymentStatus() {
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt120_GuarantorEmploymentStatus() {
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getGuarantorOrganizationName(int rep) throws HL7Exception {
        XON ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XON[] getGuarantorOrganizationName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(21);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorOrganizationNameReps() {
        try {
            return this.getField(21).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XON insertGuarantorOrganizationName(int index) throws HL7Exception {
        return (XON)super.insertRepetition(21, index);
    }

    public XON removeGuarantorOrganizationName(int index) throws HL7Exception {
        return (XON)super.removeRepetition(21, index);
    }

    public XON getGt121_GuarantorOrganizationName(int rep) throws HL7Exception {
        XON ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XON[] getGt121_GuarantorOrganizationName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(21);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt121_GuarantorOrganizationNameReps() {
        try {
            return this.getField(21).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XON insertGt121_GuarantorOrganizationName(int index) throws HL7Exception {
        return (XON)super.insertRepetition(21, index);
    }

    public XON removeGt121_GuarantorOrganizationName(int index) throws HL7Exception {
        return (XON)super.removeRepetition(21, index);
    }

    public ID getGuarantorBillingHoldFlag() {
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getGt122_GuarantorBillingHoldFlag() {
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGuarantorCreditRatingCode() {
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt123_GuarantorCreditRatingCode() {
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getGuarantorDeathDateAndTime() {
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getGt124_GuarantorDeathDateAndTime() {
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getGuarantorDeathFlag() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getGt125_GuarantorDeathFlag() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGuarantorChargeAdjustmentCode() {
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt126_GuarantorChargeAdjustmentCode() {
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getGuarantorHouseholdAnnualIncome() {
        CP ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getGt127_GuarantorHouseholdAnnualIncome() {
        CP ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGuarantorHouseholdSize() {
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGt128_GuarantorHouseholdSize() {
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getGuarantorEmployerIDNumber(int rep) throws HL7Exception {
        CX ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CX[] getGuarantorEmployerIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(29);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorEmployerIDNumberReps() {
        try {
            return this.getField(29).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertGuarantorEmployerIDNumber(int index) throws HL7Exception {
        return (CX)super.insertRepetition(29, index);
    }

    public CX removeGuarantorEmployerIDNumber(int index) throws HL7Exception {
        return (CX)super.removeRepetition(29, index);
    }

    public CX getGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception {
        CX ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CX[] getGt129_GuarantorEmployerIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(29);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt129_GuarantorEmployerIDNumberReps() {
        try {
            return this.getField(29).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertGt129_GuarantorEmployerIDNumber(int index) throws HL7Exception {
        return (CX)super.insertRepetition(29, index);
    }

    public CX removeGt129_GuarantorEmployerIDNumber(int index) throws HL7Exception {
        return (CX)super.removeRepetition(29, index);
    }

    public CE getGuarantorMaritalStatusCode() {
        CE ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt130_GuarantorMaritalStatusCode() {
        CE ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGuarantorHireEffectiveDate() {
        DT ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGt131_GuarantorHireEffectiveDate() {
        DT ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getEmploymentStopDate() {
        DT ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getGt132_EmploymentStopDate() {
        DT ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getLivingDependency() {
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt133_LivingDependency() {
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAmbulatoryStatus(int rep) throws HL7Exception {
        IS ret = null;
        try {
            Type t = this.getField(34, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public IS[] getAmbulatoryStatus() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(34);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAmbulatoryStatusReps() {
        try {
            return this.getField(34).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertAmbulatoryStatus(int index) throws HL7Exception {
        return (IS)super.insertRepetition(34, index);
    }

    public IS removeAmbulatoryStatus(int index) throws HL7Exception {
        return (IS)super.removeRepetition(34, index);
    }

    public IS getGt134_AmbulatoryStatus(int rep) throws HL7Exception {
        IS ret = null;
        try {
            Type t = this.getField(34, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public IS[] getGt134_AmbulatoryStatus() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(34);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt134_AmbulatoryStatusReps() {
        try {
            return this.getField(34).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertGt134_AmbulatoryStatus(int index) throws HL7Exception {
        return (IS)super.insertRepetition(34, index);
    }

    public IS removeGt134_AmbulatoryStatus(int index) throws HL7Exception {
        return (IS)super.removeRepetition(34, index);
    }

    public CE getCitizenship(int rep) throws HL7Exception {
        CE ret = null;
        try {
            Type t = this.getField(35, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CE[] getCitizenship() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(35);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCitizenshipReps() {
        try {
            return this.getField(35).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertCitizenship(int index) throws HL7Exception {
        return (CE)super.insertRepetition(35, index);
    }

    public CE removeCitizenship(int index) throws HL7Exception {
        return (CE)super.removeRepetition(35, index);
    }

    public CE getGt135_Citizenship(int rep) throws HL7Exception {
        CE ret = null;
        try {
            Type t = this.getField(35, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CE[] getGt135_Citizenship() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(35);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt135_CitizenshipReps() {
        try {
            return this.getField(35).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertGt135_Citizenship(int index) throws HL7Exception {
        return (CE)super.insertRepetition(35, index);
    }

    public CE removeGt135_Citizenship(int index) throws HL7Exception {
        return (CE)super.removeRepetition(35, index);
    }

    public CE getPrimaryLanguage() {
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt136_PrimaryLanguage() {
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getLivingArrangement() {
        IS ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt137_LivingArrangement() {
        IS ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPublicityCode() {
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt138_PublicityCode() {
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getProtectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getGt139_ProtectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getStudentIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt140_StudentIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getReligion() {
        CE ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt141_Religion() {
        CE ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getMotherSMaidenName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(42, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getMotherSMaidenName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(42);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMotherSMaidenNameReps() {
        try {
            return this.getField(42).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertMotherSMaidenName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(42, index);
    }

    public XPN removeMotherSMaidenName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(42, index);
    }

    public XPN getGt142_MotherSMaidenName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(42, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGt142_MotherSMaidenName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(42);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt142_MotherSMaidenNameReps() {
        try {
            return this.getField(42).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGt142_MotherSMaidenName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(42, index);
    }

    public XPN removeGt142_MotherSMaidenName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(42, index);
    }

    public CE getNationality() {
        CE ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt143_Nationality() {
        CE ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getEthnicGroup(int rep) throws HL7Exception {
        CE ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CE[] getEthnicGroup() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(44);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEthnicGroupReps() {
        try {
            return this.getField(44).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertEthnicGroup(int index) throws HL7Exception {
        return (CE)super.insertRepetition(44, index);
    }

    public CE removeEthnicGroup(int index) throws HL7Exception {
        return (CE)super.removeRepetition(44, index);
    }

    public CE getGt144_EthnicGroup(int rep) throws HL7Exception {
        CE ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CE[] getGt144_EthnicGroup() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(44);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt144_EthnicGroupReps() {
        try {
            return this.getField(44).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertGt144_EthnicGroup(int index) throws HL7Exception {
        return (CE)super.insertRepetition(44, index);
    }

    public CE removeGt144_EthnicGroup(int index) throws HL7Exception {
        return (CE)super.removeRepetition(44, index);
    }

    public XPN getContactPersonSName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(45, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getContactPersonSName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(45);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactPersonSNameReps() {
        try {
            return this.getField(45).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertContactPersonSName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(45, index);
    }

    public XPN removeContactPersonSName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(45, index);
    }

    public XPN getGt145_ContactPersonSName(int rep) throws HL7Exception {
        XPN ret = null;
        try {
            Type t = this.getField(45, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XPN[] getGt145_ContactPersonSName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(45);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt145_ContactPersonSNameReps() {
        try {
            return this.getField(45).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertGt145_ContactPersonSName(int index) throws HL7Exception {
        return (XPN)super.insertRepetition(45, index);
    }

    public XPN removeGt145_ContactPersonSName(int index) throws HL7Exception {
        return (XPN)super.removeRepetition(45, index);
    }

    public XTN getContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(46, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(46);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactPersonSTelephoneNumberReps() {
        try {
            return this.getField(46).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertContactPersonSTelephoneNumber(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(46, index);
    }

    public XTN removeContactPersonSTelephoneNumber(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(46, index);
    }

    public XTN getGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        XTN ret = null;
        try {
            Type t = this.getField(46, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XTN[] getGt146_ContactPersonSTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(46);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt146_ContactPersonSTelephoneNumberReps() {
        try {
            return this.getField(46).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertGt146_ContactPersonSTelephoneNumber(int index) throws HL7Exception {
        return (XTN)super.insertRepetition(46, index);
    }

    public XTN removeGt146_ContactPersonSTelephoneNumber(int index) throws HL7Exception {
        return (XTN)super.removeRepetition(46, index);
    }

    public CE getContactReason() {
        CE ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGt147_ContactReason() {
        CE ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getContactRelationship() {
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt148_ContactRelationship() {
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getJobTitle() {
        ST ret = null;
        try {
            Type t = this.getField(49, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getGt149_JobTitle() {
        ST ret = null;
        try {
            Type t = this.getField(49, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public JCC getJobCodeClass() {
        JCC ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (JCC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public JCC getGt150_JobCodeClass() {
        JCC ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (JCC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getGuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        XON ret = null;
        try {
            Type t = this.getField(51, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XON[] getGuarantorEmployerSOrganizationName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(51);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorEmployerSOrganizationNameReps() {
        try {
            return this.getField(51).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XON insertGuarantorEmployerSOrganizationName(int index) throws HL7Exception {
        return (XON)super.insertRepetition(51, index);
    }

    public XON removeGuarantorEmployerSOrganizationName(int index) throws HL7Exception {
        return (XON)super.removeRepetition(51, index);
    }

    public XON getGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        XON ret = null;
        try {
            Type t = this.getField(51, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public XON[] getGt151_GuarantorEmployerSOrganizationName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(51);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt151_GuarantorEmployerSOrganizationNameReps() {
        try {
            return this.getField(51).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XON insertGt151_GuarantorEmployerSOrganizationName(int index) throws HL7Exception {
        return (XON)super.insertRepetition(51, index);
    }

    public XON removeGt151_GuarantorEmployerSOrganizationName(int index) throws HL7Exception {
        return (XON)super.removeRepetition(51, index);
    }

    public IS getHandicap() {
        IS ret = null;
        try {
            Type t = this.getField(52, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt152_Handicap() {
        IS ret = null;
        try {
            Type t = this.getField(52, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getJobStatus() {
        IS ret = null;
        try {
            Type t = this.getField(53, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt153_JobStatus() {
        IS ret = null;
        try {
            Type t = this.getField(53, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FC getGuarantorFinancialClass() {
        FC ret = null;
        try {
            Type t = this.getField(54, 0);
            ret = (FC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FC getGt154_GuarantorFinancialClass() {
        FC ret = null;
        try {
            Type t = this.getField(54, 0);
            ret = (FC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGuarantorRace(int rep) throws HL7Exception {
        CE ret = null;
        try {
            Type t = this.getField(55, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CE[] getGuarantorRace() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(55);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGuarantorRaceReps() {
        try {
            return this.getField(55).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertGuarantorRace(int index) throws HL7Exception {
        return (CE)super.insertRepetition(55, index);
    }

    public CE removeGuarantorRace(int index) throws HL7Exception {
        return (CE)super.removeRepetition(55, index);
    }

    public CE getGt155_GuarantorRace(int rep) throws HL7Exception {
        CE ret = null;
        try {
            Type t = this.getField(55, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public CE[] getGt155_GuarantorRace() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(55);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGt155_GuarantorRaceReps() {
        try {
            return this.getField(55).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertGt155_GuarantorRace(int index) throws HL7Exception {
        return (CE)super.insertRepetition(55, index);
    }

    public CE removeGt155_GuarantorRace(int index) throws HL7Exception {
        return (CE)super.removeRepetition(55, index);
    }

    public ST getGuarantorBirthPlace() {
        ST ret = null;
        try {
            Type t = this.getField(56, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getGt156_GuarantorBirthPlace() {
        ST ret = null;
        try {
            Type t = this.getField(56, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getVIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(57, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGt157_VIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(57, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new XPN(this.getMessage());
            }
            case 3: {
                return new XPN(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new XTN(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(68));
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new XAD(this.getMessage());
            }
            case 17: {
                return new XTN(this.getMessage());
            }
            case 18: {
                return new CX(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(66));
            }
            case 20: {
                return new XON(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 22: {
                return new CE(this.getMessage());
            }
            case 23: {
                return new TS(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CP(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CX(this.getMessage());
            }
            case 29: {
                return new CE(this.getMessage());
            }
            case 30: {
                return new DT(this.getMessage());
            }
            case 31: {
                return new DT(this.getMessage());
            }
            case 32: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 34: {
                return new CE(this.getMessage());
            }
            case 35: {
                return new CE(this.getMessage());
            }
            case 36: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 39: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 40: {
                return new CE(this.getMessage());
            }
            case 41: {
                return new XPN(this.getMessage());
            }
            case 42: {
                return new CE(this.getMessage());
            }
            case 43: {
                return new CE(this.getMessage());
            }
            case 44: {
                return new XPN(this.getMessage());
            }
            case 45: {
                return new XTN(this.getMessage());
            }
            case 46: {
                return new CE(this.getMessage());
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(63));
            }
            case 48: {
                return new ST(this.getMessage());
            }
            case 49: {
                return new JCC(this.getMessage());
            }
            case 50: {
                return new XON(this.getMessage());
            }
            case 51: {
                return new IS(this.getMessage(), new Integer(295));
            }
            case 52: {
                return new IS(this.getMessage(), new Integer(311));
            }
            case 53: {
                return new FC(this.getMessage());
            }
            case 54: {
                return new CE(this.getMessage());
            }
            case 55: {
                return new ST(this.getMessage());
            }
            case 56: {
                return new IS(this.getMessage(), new Integer(99));
            }
        }
        return null;
    }
}

