/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreClientFactory;
import org.apache.hadoop.hbase.backup.RestoreClient;
import org.apache.hadoop.hbase.backup.RestoreRequest;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.backup.util.BackupSet;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.BackupAdmin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HBaseBackupAdmin
implements BackupAdmin {
    private static final Log LOG = LogFactory.getLog(HBaseBackupAdmin.class);
    private final HBaseAdmin admin;
    private final Connection conn;

    HBaseBackupAdmin(HBaseAdmin admin) {
        this.admin = admin;
        this.conn = admin.getConnection();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public BackupInfo getBackupInfo(String backupId) throws IOException {
        BackupInfo backupInfo = null;
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            BackupInfo backupInfo2 = backupInfo = table.readBackupInfo(backupId);
            return backupInfo2;
        }
    }

    @Override
    public int getProgress(String backupId) throws IOException {
        BackupInfo backupInfo = null;
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            if (backupId == null) {
                ArrayList<BackupInfo> recentSessions = table.getBackupContexts(BackupInfo.BackupState.RUNNING);
                if (recentSessions.isEmpty()) {
                    LOG.warn((Object)"No ongoing sessions found.");
                    int n = -1;
                    return n;
                }
                int n = recentSessions.get(0).getProgress();
                return n;
            }
            backupInfo = table.readBackupInfo(backupId);
            if (backupInfo != null) {
                int n = backupInfo.getProgress();
                return n;
            }
            LOG.warn((Object)("No information found for backupID=" + backupId));
            int n = -1;
            return n;
        }
    }

    @Override
    public int deleteBackups(String[] backupIds) throws IOException {
        BackupInfo backupInfo = null;
        String backupId = null;
        int totalDeleted = 0;
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            for (int i = 0; i < backupIds.length; ++i) {
                backupId = backupIds[i];
                LOG.info((Object)("Deleting backup for backupID=" + backupId + " ..."));
                backupInfo = table.readBackupInfo(backupId);
                if (backupInfo != null) {
                    BackupClientUtil.cleanupBackupData(backupInfo, this.admin.getConfiguration());
                    Map<byte[], String> map = table.readBulkLoadedFiles(backupId);
                    FileSystem fs = FileSystem.get((Configuration)this.conn.getConfiguration());
                    boolean succ = true;
                    int numDeleted = 0;
                    for (String f : map.values()) {
                        Path p = new Path(f);
                        try {
                            if (!fs.delete(p)) {
                                if (!fs.exists(p)) continue;
                                LOG.warn((Object)(f + " was not deleted"));
                                succ = false;
                                continue;
                            }
                            ++numDeleted;
                        }
                        catch (IOException ioe) {
                            LOG.warn((Object)(f + " was not deleted"), (Throwable)ioe);
                            succ = false;
                        }
                    }
                    LOG.debug((Object)(numDeleted + " bulk loaded files out of " + map.size() + " were deleted"));
                    if (succ) {
                        table.deleteBulkLoadedFiles(map);
                    }
                    table.deleteBackupInfo(backupInfo.getBackupId());
                    LOG.info((Object)("Delete backup for backupID=" + backupId + " completed."));
                    ++totalDeleted;
                    continue;
                }
                LOG.warn((Object)("Delete backup failed: no information found for backupID=" + backupId));
            }
        }
        return totalDeleted;
    }

    @Override
    public List<BackupInfo> getHistory(int n) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            ArrayList<BackupInfo> history = table.getBackupHistory();
            if (history.size() <= n) {
                ArrayList<BackupInfo> arrayList = history;
                return arrayList;
            }
            ArrayList<BackupInfo> list = new ArrayList<BackupInfo>();
            for (int i = 0; i < n; ++i) {
                list.add((BackupInfo)history.get(i));
            }
            ArrayList<BackupInfo> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public List<BackupSet> listBackupSets() throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            List<String> list = table.listBackupSets();
            ArrayList<BackupSet> bslist = new ArrayList<BackupSet>();
            for (String s : list) {
                List<TableName> tables = table.describeBackupSet(s);
                if (tables == null) continue;
                bslist.add(new BackupSet(s, tables));
            }
            ArrayList<BackupSet> arrayList = bslist;
            return arrayList;
        }
    }

    @Override
    public BackupSet getBackupSet(String name) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            List<TableName> list = table.describeBackupSet(name);
            if (list == null) {
                BackupSet backupSet = null;
                return backupSet;
            }
            BackupSet backupSet = new BackupSet(name, list);
            return backupSet;
        }
    }

    @Override
    public boolean deleteBackupSet(String name) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            if (table.describeBackupSet(name) == null) {
                boolean bl = false;
                return bl;
            }
            table.deleteBackupSet(name);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void addToBackupSet(String name, TableName[] tables) throws IOException {
        Object[] tableNames = new String[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            tableNames[i] = tables[i].getNameAsString();
            if (this.admin.tableExists(tableNames[i])) continue;
            throw new IOException("Cannot add " + (String)tableNames[i] + " because it doesn't exist");
        }
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            table.addToBackupSet(name, (String[])tableNames);
            LOG.info((Object)("Added tables [" + StringUtils.join((Object[])tableNames, (String)" ") + "] to '" + name + "' backup set"));
        }
    }

    @Override
    public void removeFromBackupSet(String name, String[] tables) throws IOException {
        LOG.info((Object)("Removing tables [" + StringUtils.join((Object[])tables, (String)" ") + "] from '" + name + "'"));
        try (BackupSystemTable table = new BackupSystemTable(this.conn);){
            table.removeFromBackupSet(name, tables);
            LOG.info((Object)("Removing tables [" + StringUtils.join((Object[])tables, (String)" ") + "] from '" + name + "' completed."));
        }
    }

    @Override
    public void restore(RestoreRequest request) throws IOException {
        RestoreClient client = BackupRestoreClientFactory.getRestoreClient(this.admin.getConfiguration());
        client.restore(request.getBackupRootDir(), request.getBackupId(), request.isCheck(), request.getFromTables(), request.getToTables(), request.isOverwrite());
    }

    @Override
    public String backupTables(BackupRequest userRequest) throws IOException {
        return this.admin.backupTables(userRequest);
    }

    @Override
    public Future<String> backupTablesAsync(BackupRequest userRequest) throws IOException {
        return this.admin.backupTablesAsync(userRequest);
    }
}

