/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AuthUtil {
    private static final Log LOG = LogFactory.getLog(AuthUtil.class);

    private AuthUtil() {
    }

    @Deprecated
    public static void launchAuthChore(Configuration conf) throws IOException {
        final ChoreService choreService = new ChoreService("authUtilCore");
        ScheduledChore authChore = AuthUtil.getAuthChore(conf);
        if (authChore != null) {
            choreService.scheduleChore(authChore);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                choreService.shutdown();
            }
        });
    }

    public static ScheduledChore getAuthChore(Configuration conf) throws IOException {
        boolean securityEnabled;
        UserProvider userProvider = UserProvider.instantiate(conf);
        boolean bl = securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (!securityEnabled) {
            return null;
        }
        String host = null;
        try {
            host = Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)conf.get("hbase.client.dns.interface", "default"), (String)conf.get("hbase.client.dns.nameserver", "default")));
            userProvider.login("hbase.client.keytab.file", "hbase.client.kerberos.principal", host);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Error resolving host name: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)("Error while trying to perform the initial login: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        final UserGroupInformation ugi = userProvider.getCurrent().getUGI();
        Stoppable stoppable = new Stoppable(){
            private volatile boolean isStopped = false;

            @Override
            public void stop(String why) {
                this.isStopped = true;
            }

            @Override
            public boolean isStopped() {
                return this.isStopped;
            }
        };
        int CHECK_TGT_INTERVAL = 30000;
        ScheduledChore refreshCredentials = new ScheduledChore("RefreshCredentials", stoppable, 30000){

            @Override
            protected void chore() {
                try {
                    ugi.checkTGTAndReloginFromKeytab();
                }
                catch (IOException e) {
                    LOG.error((Object)("Got exception while trying to refresh credentials: " + e.getMessage()), (Throwable)e);
                }
            }
        };
        return refreshCredentials;
    }
}

