/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.BoundedArrayQueue;

@InterfaceAudience.Private
public class BoundedByteBufferPool {
    private static final Log LOG = LogFactory.getLog(BoundedByteBufferPool.class);
    @VisibleForTesting
    final Queue<ByteBuffer> buffers;
    private final int maxByteBufferSizeToCache;
    @VisibleForTesting
    volatile int runningAverage;
    private volatile int totalReservoirCapacity;
    private AtomicLong allocations = new AtomicLong(0L);
    private ReentrantLock lock = new ReentrantLock();
    private boolean createDirectByteBuffer;

    public BoundedByteBufferPool(int maxByteBufferSizeToCache, int initialByteBufferSize, int maxToCache, boolean createDirectByteBuffer) {
        this.maxByteBufferSizeToCache = maxByteBufferSizeToCache;
        this.runningAverage = initialByteBufferSize;
        this.buffers = new BoundedArrayQueue<ByteBuffer>(maxToCache);
        this.createDirectByteBuffer = createDirectByteBuffer;
    }

    public ByteBuffer getBuffer() {
        ByteBuffer bb = null;
        this.lock.lock();
        try {
            bb = this.buffers.poll();
            if (bb != null) {
                this.totalReservoirCapacity -= bb.capacity();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (bb != null) {
            bb.clear();
        } else {
            bb = this.createDirectByteBuffer ? ByteBuffer.allocateDirect(this.runningAverage) : ByteBuffer.allocate(this.runningAverage);
            this.allocations.incrementAndGet();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("runningAverage=" + this.runningAverage + ", totalCapacity=" + this.totalReservoirCapacity + ", count=" + this.buffers.size() + ", allocations=" + this.allocations.get()));
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBuffer(ByteBuffer bb) {
        if (bb.capacity() > this.maxByteBufferSizeToCache) {
            return;
        }
        boolean success = false;
        int average = 0;
        this.lock.lock();
        try {
            success = this.buffers.offer(bb);
            if (success) {
                this.totalReservoirCapacity += bb.capacity();
                average = this.totalReservoirCapacity / this.buffers.size();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!success) {
            LOG.warn((Object)("At capacity: " + this.buffers.size()));
        } else if (average > this.runningAverage && average < this.maxByteBufferSizeToCache) {
            this.runningAverage = average;
        }
    }
}

