/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class HFileWriterV2
extends AbstractHFileWriter {
    static final Log LOG = LogFactory.getLog(HFileWriterV2.class);
    public static final byte[] MAX_MEMSTORE_TS_KEY = Bytes.toBytes((String)"MAX_MEMSTORE_TS_KEY");
    public static final byte[] KEY_VALUE_VERSION = Bytes.toBytes((String)"KEY_VALUE_VERSION");
    public static final int KEY_VALUE_VER_WITH_MEMSTORE = 1;
    private List<InlineBlockWriter> inlineBlockWriters = new ArrayList<InlineBlockWriter>();
    private HFileBlock.Writer fsBlockWriter;
    private HFileBlockIndex.BlockIndexWriter dataBlockIndexWriter;
    private HFileBlockIndex.BlockIndexWriter metaBlockIndexWriter;
    private long firstDataBlockOffset = -1L;
    private long lastDataBlockOffset;
    private byte[] lastKeyOfPreviousBlock = null;
    private List<HFileBlock.BlockWritable> additionalLoadOnOpenData = new ArrayList<HFileBlock.BlockWritable>();
    private ChecksumType checksumType = HFile.DEFAULT_CHECKSUM_TYPE;
    private int bytesPerChecksum = 16384;
    private final boolean includeMemstoreTS;
    private long maxMemstoreTS = 0L;

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path, FSDataOutputStream ostream, int blockSize, Compression.Algorithm compressAlgo, HFileDataBlockEncoder blockEncoder, KeyValue.KeyComparator comparator, ChecksumType checksumType, int bytesPerChecksum, boolean includeMVCCReadpoint) throws IOException {
        super(cacheConf, ostream == null ? HFileWriterV2.createOutputStream(conf, fs, path, null) : ostream, path, blockSize, compressAlgo, blockEncoder, comparator);
        this.checksumType = checksumType;
        this.bytesPerChecksum = bytesPerChecksum;
        this.includeMemstoreTS = includeMVCCReadpoint;
        this.finishInit(conf);
    }

    private void finishInit(Configuration conf) {
        if (this.fsBlockWriter != null) {
            throw new IllegalStateException("finishInit called twice");
        }
        this.fsBlockWriter = new HFileBlock.Writer(this.compressAlgo, this.blockEncoder, this.includeMemstoreTS, this.checksumType, this.bytesPerChecksum);
        boolean cacheIndexesOnWrite = this.cacheConf.shouldCacheIndexesOnWrite();
        this.dataBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter(this.fsBlockWriter, cacheIndexesOnWrite ? this.cacheConf.getBlockCache() : null, cacheIndexesOnWrite ? this.name : null);
        this.dataBlockIndexWriter.setMaxChunkSize(HFileBlockIndex.getMaxChunkSize(conf));
        this.inlineBlockWriters.add(this.dataBlockIndexWriter);
        this.metaBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Initialized with " + this.cacheConf));
        }
    }

    private void checkBlockBoundary() throws IOException {
        if (this.fsBlockWriter.blockSizeWritten() < this.blockSize) {
            return;
        }
        this.finishBlock();
        this.writeInlineBlocks(false);
        this.newBlock();
    }

    private void finishBlock() throws IOException {
        if (!this.fsBlockWriter.isWriting() || this.fsBlockWriter.blockSizeWritten() == 0) {
            return;
        }
        long startTimeNs = System.nanoTime();
        if (this.firstDataBlockOffset == -1L) {
            this.firstDataBlockOffset = this.outputStream.getPos();
        }
        this.lastDataBlockOffset = this.outputStream.getPos();
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        int onDiskSize = this.fsBlockWriter.getOnDiskSizeWithHeader();
        if (this.comparator instanceof KeyValue.KeyComparator) {
            byte[] fakeKey = ((KeyValue.KeyComparator)this.comparator).getShortMidpointKey(this.lastKeyOfPreviousBlock, this.firstKeyInBlock);
            if (this.comparator.compare((Object)fakeKey, (Object)this.firstKeyInBlock) > 0) {
                throw new IOException("Unexpected getShortMidpointKey result, fakeKey:" + fakeKey + ", firstKeyInBlock:" + this.firstKeyInBlock);
            }
            if (this.lastKeyOfPreviousBlock != null && this.comparator.compare((Object)this.lastKeyOfPreviousBlock, (Object)fakeKey) >= 0) {
                throw new IOException("Unexpected getShortMidpointKey result, lastKeyOfPreviousBlock:" + Bytes.toString((byte[])this.lastKeyOfPreviousBlock) + ", fakeKey:" + Bytes.toString((byte[])fakeKey));
            }
            this.dataBlockIndexWriter.addEntry(fakeKey, this.lastDataBlockOffset, onDiskSize);
        } else {
            this.dataBlockIndexWriter.addEntry(this.firstKeyInBlock, this.lastDataBlockOffset, onDiskSize);
        }
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        HFile.offerWriteLatency(System.nanoTime() - startTimeNs);
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.doCacheOnWrite(this.lastDataBlockOffset);
        }
    }

    private void writeInlineBlocks(boolean closing) throws IOException {
        for (InlineBlockWriter ibw : this.inlineBlockWriters) {
            while (ibw.shouldWriteBlock(closing)) {
                long offset = this.outputStream.getPos();
                boolean cacheThisBlock = ibw.getCacheOnWrite();
                ibw.writeInlineBlock(this.fsBlockWriter.startWriting(ibw.getInlineBlockType()));
                this.fsBlockWriter.writeHeaderAndData(this.outputStream);
                ibw.blockWritten(offset, this.fsBlockWriter.getOnDiskSizeWithHeader(), this.fsBlockWriter.getUncompressedSizeWithoutHeader());
                this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
                if (!cacheThisBlock) continue;
                this.doCacheOnWrite(offset);
            }
        }
    }

    private void doCacheOnWrite(long offset) {
        boolean isCompaction = false;
        HFileBlock cacheFormatBlock = this.blockEncoder.diskToCacheFormat(this.fsBlockWriter.getBlockForCaching(), false);
        this.cacheConf.getBlockCache().cacheBlock(new BlockCacheKey(this.name, offset, this.blockEncoder.getEncodingInCache(), cacheFormatBlock.getBlockType()), cacheFormatBlock);
    }

    private void newBlock() throws IOException {
        this.fsBlockWriter.startWriting(BlockType.DATA);
        this.firstKeyInBlock = null;
        if (this.lastKeyLength > 0) {
            this.lastKeyOfPreviousBlock = new byte[this.lastKeyLength];
            System.arraycopy(this.lastKeyBuffer, this.lastKeyOffset, this.lastKeyOfPreviousBlock, 0, this.lastKeyLength);
        }
    }

    @Override
    public void appendMetaBlock(String metaBlockName, Writable content) {
        byte[] cur;
        int i;
        byte[] key = Bytes.toBytes((String)metaBlockName);
        for (i = 0; i < this.metaNames.size() && Bytes.BYTES_RAWCOMPARATOR.compare(cur = (byte[])this.metaNames.get(i), 0, cur.length, key, 0, key.length) <= 0; ++i) {
        }
        this.metaNames.add(i, key);
        this.metaData.add(i, content);
    }

    @Override
    public void append(KeyValue kv) throws IOException {
        this.append(kv.getMvccVersion(), kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        this.maxMemstoreTS = Math.max(this.maxMemstoreTS, kv.getMvccVersion());
    }

    @Override
    public void append(byte[] key, byte[] value) throws IOException {
        this.append(0L, key, 0, key.length, value, 0, value.length);
    }

    private void append(long memstoreTS, byte[] key, int koffset, int klength, byte[] value, int voffset, int vlength) throws IOException {
        boolean dupKey = this.checkKey(key, koffset, klength);
        this.checkValue(value, voffset, vlength);
        if (!dupKey) {
            this.checkBlockBoundary();
        }
        if (!this.fsBlockWriter.isWriting()) {
            this.newBlock();
        }
        DataOutputStream out = this.fsBlockWriter.getUserDataStream();
        out.writeInt(klength);
        this.totalKeyLength += (long)klength;
        out.writeInt(vlength);
        this.totalValueLength += (long)vlength;
        out.write(key, koffset, klength);
        out.write(value, voffset, vlength);
        if (this.includeMemstoreTS) {
            WritableUtils.writeVLong((DataOutput)out, (long)memstoreTS);
        }
        if (this.firstKeyInBlock == null) {
            this.firstKeyInBlock = new byte[klength];
            System.arraycopy(key, koffset, this.firstKeyInBlock, 0, klength);
        }
        this.lastKeyBuffer = key;
        this.lastKeyOffset = koffset;
        this.lastKeyLength = klength;
        ++this.entryCount;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        this.blockEncoder.saveMetadata(this);
        this.finishBlock();
        this.writeInlineBlocks(true);
        FixedFileTrailer trailer = new FixedFileTrailer(2, 3);
        if (!this.metaNames.isEmpty()) {
            for (int i = 0; i < this.metaNames.size(); ++i) {
                long offset = this.outputStream.getPos();
                DataOutputStream dos = this.fsBlockWriter.startWriting(BlockType.META);
                ((Writable)this.metaData.get(i)).write((DataOutput)dos);
                this.fsBlockWriter.writeHeaderAndData(this.outputStream);
                this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
                this.metaBlockIndexWriter.addEntry((byte[])this.metaNames.get(i), offset, this.fsBlockWriter.getOnDiskSizeWithHeader());
            }
        }
        long rootIndexOffset = this.dataBlockIndexWriter.writeIndexBlocks(this.outputStream);
        trailer.setLoadOnOpenOffset(rootIndexOffset);
        this.metaBlockIndexWriter.writeSingleLevelIndex(this.fsBlockWriter.startWriting(BlockType.ROOT_INDEX), "meta");
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        if (this.includeMemstoreTS) {
            this.appendFileInfo(MAX_MEMSTORE_TS_KEY, Bytes.toBytes((long)this.maxMemstoreTS));
            this.appendFileInfo(KEY_VALUE_VERSION, Bytes.toBytes((int)1));
        }
        this.writeFileInfo(trailer, this.fsBlockWriter.startWriting(BlockType.FILE_INFO));
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        for (HFileBlock.BlockWritable w : this.additionalLoadOnOpenData) {
            this.fsBlockWriter.writeBlock(w, this.outputStream);
            this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        }
        trailer.setNumDataIndexLevels(this.dataBlockIndexWriter.getNumLevels());
        trailer.setUncompressedDataIndexSize(this.dataBlockIndexWriter.getTotalUncompressedSize());
        trailer.setFirstDataBlockOffset(this.firstDataBlockOffset);
        trailer.setLastDataBlockOffset(this.lastDataBlockOffset);
        trailer.setComparatorClass(this.comparator.getClass());
        trailer.setDataIndexCount(this.dataBlockIndexWriter.getNumRootEntries());
        this.finishClose(trailer);
        this.fsBlockWriter.release();
    }

    @Override
    public void addInlineBlockWriter(InlineBlockWriter ibw) {
        this.inlineBlockWriters.add(ibw);
    }

    @Override
    public void addGeneralBloomFilter(BloomFilterWriter bfw) {
        this.addBloomFilter(bfw, BlockType.GENERAL_BLOOM_META);
    }

    @Override
    public void addDeleteFamilyBloomFilter(BloomFilterWriter bfw) {
        this.addBloomFilter(bfw, BlockType.DELETE_FAMILY_BLOOM_META);
    }

    private void addBloomFilter(final BloomFilterWriter bfw, final BlockType blockType) {
        if (bfw.getKeyCount() <= 0L) {
            return;
        }
        if (blockType != BlockType.GENERAL_BLOOM_META && blockType != BlockType.DELETE_FAMILY_BLOOM_META) {
            throw new RuntimeException("Block Type: " + blockType.toString() + "is not supported");
        }
        this.additionalLoadOnOpenData.add(new HFileBlock.BlockWritable(){

            @Override
            public BlockType getBlockType() {
                return blockType;
            }

            @Override
            public void writeToBlock(DataOutput out) throws IOException {
                bfw.getMetaWriter().write(out);
                Writable dataWriter = bfw.getDataWriter();
                if (dataWriter != null) {
                    dataWriter.write(out);
                }
            }
        });
    }

    static class WriterFactoryV2
    extends HFile.WriterFactory {
        WriterFactoryV2(Configuration conf, CacheConfig cacheConf) {
            super(conf, cacheConf);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path, FSDataOutputStream ostream, int blockSize, Compression.Algorithm compress, HFileDataBlockEncoder blockEncoder, KeyValue.KeyComparator comparator, ChecksumType checksumType, int bytesPerChecksum, boolean includeMVCCReadpoint) throws IOException {
            return new HFileWriterV2(this.conf, this.cacheConf, fs, path, ostream, blockSize, compress, blockEncoder, comparator, checksumType, bytesPerChecksum, includeMVCCReadpoint);
        }
    }
}

