/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.BlockingService;
import java.net.InetAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class RequestContext {
    private static ThreadLocal<RequestContext> instance = new ThreadLocal<RequestContext>(){

        @Override
        protected RequestContext initialValue() {
            return new RequestContext(null, null, null);
        }
    };
    private User user;
    private InetAddress remoteAddress;
    private BlockingService service;
    private boolean inRequest;

    public static RequestContext get() {
        return instance.get();
    }

    public static User getRequestUser() {
        RequestContext ctx = instance.get();
        if (ctx != null) {
            return ctx.getUser();
        }
        return null;
    }

    public static String getRequestUserName() {
        User user = RequestContext.getRequestUser();
        if (user != null) {
            return user.getShortName();
        }
        return null;
    }

    public static boolean isInRequestContext() {
        RequestContext ctx = instance.get();
        if (ctx != null) {
            return ctx.isInRequest();
        }
        return false;
    }

    public static void set(User user, InetAddress remoteAddress, BlockingService service) {
        RequestContext ctx = instance.get();
        ctx.user = user;
        ctx.remoteAddress = remoteAddress;
        ctx.service = service;
        ctx.inRequest = true;
    }

    public static void clear() {
        RequestContext ctx = instance.get();
        ctx.user = null;
        ctx.remoteAddress = null;
        ctx.service = null;
        ctx.inRequest = false;
    }

    private RequestContext(User user, InetAddress remoteAddr, BlockingService service) {
        this.user = user;
        this.remoteAddress = remoteAddr;
        this.service = service;
    }

    public User getUser() {
        return this.user;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public BlockingService getService() {
        return this.service;
    }

    public boolean isInRequest() {
        return this.inRequest;
    }
}

