/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CellCounter {
    private static final Log LOG = LogFactory.getLog((String)CellCounter.class.getName());
    static final String NAME = "CellCounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path outputDir = new Path(args[1]);
        String reportSeparatorString = args.length > 2 ? args[2] : ":";
        conf.set("ReportSeparator", reportSeparatorString);
        Job job = new Job(conf, "CellCounter_" + tableName);
        job.setJarByClass(CellCounter.class);
        Scan scan = CellCounter.getConfiguredScanForJob(conf, args);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, CellCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(1);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setReducerClass(IntSumReducer.class);
        return job;
    }

    private static Scan getConfiguredScanForJob(Configuration conf, String[] args) throws IOException {
        Filter rowFilter;
        Scan s = new Scan();
        s.setMaxVersions(Integer.MAX_VALUE);
        s.setCacheBlocks(false);
        if (conf.get("hbase.mapreduce.scan.column.family") != null) {
            s.addFamily(Bytes.toBytes((String)conf.get("hbase.mapreduce.scan.column.family")));
        }
        if ((rowFilter = CellCounter.getRowFilter(args)) != null) {
            LOG.info((Object)"Setting Row Filter for counter.");
            s.setFilter(rowFilter);
        }
        return s;
    }

    private static Filter getRowFilter(String[] args) {
        String filterCriteria;
        PrefixFilter rowFilter = null;
        String string = filterCriteria = args.length > 3 ? args[3] : null;
        if (filterCriteria == null) {
            return null;
        }
        if (filterCriteria.startsWith("^")) {
            String regexPattern = filterCriteria.substring(1, filterCriteria.length());
            rowFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(regexPattern));
        } else {
            rowFilter = new PrefixFilter(Bytes.toBytes((String)filterCriteria));
        }
        return rowFilter;
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 1) {
            System.err.println("ERROR: Wrong number of parameters: " + args.length);
            System.err.println("Usage: CellCounter <tablename> <outputDir> <reportSeparator> [^[regex pattern] or [Prefix] for row filter]] ");
            System.err.println("  Note: -D properties will be applied to the conf used. ");
            System.err.println("  Additionally, the following SCAN properties can be specified");
            System.err.println("  to get fine grained control on what is counted..");
            System.err.println("   -D hbase.mapreduce.scan.column.family=<familyName>");
            System.err.println(" <reportSeparator> parameter can be used to override the default report separator string : used to separate the rowId/column family name and qualifier name.");
            System.err.println(" [^[regex pattern] or [Prefix] parameter can be used to limit the cell counter count operation to a limited subset of rows from the table based on regex or prefix pattern.");
            System.exit(-1);
        }
        System.exit((job = CellCounter.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class IntSumReducer<Key>
    extends Reducer<Key, IntWritable, Key, IntWritable> {
        private IntWritable result = new IntWritable();

        IntSumReducer() {
        }

        public void reduce(Key key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write(key, (Object)this.result);
        }
    }

    static class CellCounterMapper
    extends TableMapper<Text, IntWritable> {
        CellCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            Preconditions.checkState((values != null ? 1 : 0) != 0, (Object)"values passed to the map is null");
            String currentFamilyName = null;
            String currentQualifierName = null;
            String currentRowKey = null;
            Configuration config = context.getConfiguration();
            String separator = config.get("ReportSeparator", ":");
            try {
                context.getCounter((Enum)Counters.ROWS).increment(1L);
                context.write((Object)new Text("Total ROWS"), (Object)new IntWritable(1));
                for (KeyValue value : values.list()) {
                    String thisRowQualifierName;
                    currentRowKey = Bytes.toStringBinary((byte[])value.getRow());
                    String thisRowFamilyName = Bytes.toStringBinary((byte[])value.getFamily());
                    if (thisRowFamilyName != null && !thisRowFamilyName.equals(currentFamilyName)) {
                        currentFamilyName = thisRowFamilyName;
                        context.getCounter("CF", thisRowFamilyName).increment(1L);
                        context.write((Object)new Text("Total Families Across all Rows"), (Object)new IntWritable(1));
                        context.write((Object)new Text(thisRowFamilyName), (Object)new IntWritable(1));
                    }
                    if ((thisRowQualifierName = thisRowFamilyName + separator + Bytes.toStringBinary((byte[])value.getQualifier())) != null && !thisRowQualifierName.equals(currentQualifierName)) {
                        currentQualifierName = thisRowQualifierName;
                        context.getCounter("CFQL", thisRowQualifierName).increment(1L);
                        context.write((Object)new Text("Total Qualifiers across all Rows"), (Object)new IntWritable(1));
                        context.write((Object)new Text(thisRowQualifierName), (Object)new IntWritable(1));
                        context.getCounter("QL_VERSIONS", currentRowKey + separator + thisRowQualifierName).increment(1L);
                        context.write((Object)new Text(currentRowKey + separator + thisRowQualifierName + "_Versions"), (Object)new IntWritable(1));
                        continue;
                    }
                    currentQualifierName = thisRowQualifierName;
                    context.getCounter("QL_VERSIONS", currentRowKey + separator + thisRowQualifierName).increment(1L);
                    context.write((Object)new Text(currentRowKey + separator + thisRowQualifierName + "_Versions"), (Object)new IntWritable(1));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public static enum Counters {
            ROWS;

        }
    }
}

