/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HFileOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, KeyValue> {
    static Log LOG = LogFactory.getLog(HFileOutputFormat.class);
    static final String COMPRESSION_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    private static final String BLOOM_TYPE_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    private static final String DATABLOCK_ENCODING_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    private static final String BLOCK_SIZE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";

    public RecordWriter<ImmutableBytesWritable, KeyValue> getRecordWriter(final TaskAttemptContext context) throws IOException, InterruptedException {
        HFileDataBlockEncoder encoder;
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        final Path outputdir = new FileOutputCommitter(outputPath, context).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        final String defaultCompression = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        final Map<byte[], String> compressionMap = HFileOutputFormat.createFamilyCompressionMap(conf);
        final Map<byte[], String> bloomTypeMap = HFileOutputFormat.createFamilyBloomMap(conf);
        final Map<byte[], String> blockSizeMap = HFileOutputFormat.createFamilyBlockSizeMap(conf);
        String dataBlockEncodingStr = conf.get(DATABLOCK_ENCODING_CONF_KEY);
        if (dataBlockEncodingStr == null) {
            encoder = NoOpDataBlockEncoder.INSTANCE;
        } else {
            try {
                encoder = new HFileDataBlockEncoderImpl(DataBlockEncoding.valueOf((String)dataBlockEncodingStr));
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Invalid data block encoding type configured for the param hbase.mapreduce.hfileoutputformat.datablock.encoding : " + dataBlockEncodingStr);
            }
        }
        return new RecordWriter<ImmutableBytesWritable, KeyValue>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final byte[] now = Bytes.toBytes((long)System.currentTimeMillis());
            private boolean rollRequested = false;

            public void write(ImmutableBytesWritable row, KeyValue kv) throws IOException {
                if (row == null && kv == null) {
                    this.rollWriters();
                    return;
                }
                byte[] rowKey = kv.getRow();
                long length = kv.getLength();
                byte[] family = kv.getFamily();
                WriterLength wl = this.writers.get(family);
                if (wl == null) {
                    fs.mkdirs(new Path(outputdir, Bytes.toString((byte[])family)));
                }
                if (wl != null && wl.written + length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo((byte[])this.previousRow, (byte[])rowKey) != 0) {
                    this.rollWriters();
                }
                if (wl == null || wl.writer == null) {
                    wl = this.getNewWriter(family, conf);
                }
                kv.updateLatestStamp(this.now);
                wl.writer.append(kv);
                wl.written += length;
                this.previousRow = rowKey;
            }

            private void rollWriters() throws IOException {
                for (WriterLength wl : this.writers.values()) {
                    if (wl.writer != null) {
                        LOG.info((Object)("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written)));
                        this.close(wl.writer);
                    }
                    wl.writer = null;
                    wl.written = 0L;
                }
                this.rollRequested = false;
            }

            private WriterLength getNewWriter(byte[] family, Configuration conf2) throws IOException {
                String blockSizeString;
                WriterLength wl = new WriterLength();
                Path familydir = new Path(outputdir, Bytes.toString((byte[])family));
                String compression = (String)compressionMap.get(family);
                compression = compression == null ? defaultCompression : compression;
                String bloomTypeStr = (String)bloomTypeMap.get(family);
                BloomType bloomType = BloomType.NONE;
                if (bloomTypeStr != null) {
                    bloomType = BloomType.valueOf((String)bloomTypeStr);
                }
                int blockSize = (blockSizeString = (String)blockSizeMap.get(family)) == null ? 65536 : Integer.parseInt(blockSizeString);
                Configuration tempConf = new Configuration(conf2);
                tempConf.setFloat("hfile.block.cache.size", 0.0f);
                wl.writer = new StoreFile.WriterBuilder(conf2, new CacheConfig(tempConf), fs, blockSize).withOutputDir(familydir).withCompression(AbstractHFileWriter.compressionByName(compression)).withBloomType(bloomType).withComparator(KeyValue.COMPARATOR).withDataBlockEncoder(encoder).withChecksumType(HStore.getChecksumType(conf2)).withBytesPerChecksum(HStore.getBytesPerChecksum(conf2)).build();
                this.writers.put(family, wl);
                return wl;
            }

            private void close(StoreFile.Writer w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
                    w.appendFileInfo(StoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes((String)context.getTaskAttemptID().toString()));
                    w.appendFileInfo(StoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)true));
                    w.appendFileInfo(StoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes((boolean)compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        LOG.info((Object)("Writing partition information to " + partitionsPath));
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);
        try {
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
        finally {
            writer.close();
        }
    }

    public static void configureIncrementalLoad(Job job, HTable table) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        if (KeyValue.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(KeyValueSortReducer.class);
        } else if (Put.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else if (Text.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(TextSortReducer.class);
        } else {
            LOG.warn((Object)("Unknown map output value type:" + job.getMapOutputValueClass()));
        }
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), KeyValueSerialization.class.getName()});
        LOG.info((Object)("Looking up current regions for table " + Bytes.toString((byte[])table.getTableName())));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat.getRegionStartKeys(table);
        LOG.info((Object)("Configuring " + startKeys.size() + " reduce partitions " + "to match current region count"));
        job.setNumReduceTasks(startKeys.size());
        HFileOutputFormat.configurePartitioner(job, startKeys);
        HFileOutputFormat.configureCompression(table, conf);
        HFileOutputFormat.configureBloomType(table, conf);
        HFileOutputFormat.configureBlockSize(table, conf);
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info((Object)("Incremental table " + Bytes.toString((byte[])table.getTableName()) + " output configured."));
    }

    private static void configureBlockSize(HTable table, Configuration conf) throws IOException {
        StringBuilder blockSizeConfigValue = new StringBuilder();
        HTableDescriptor tableDescriptor = table.getTableDescriptor();
        if (tableDescriptor == null) {
            return;
        }
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                blockSizeConfigValue.append('&');
            }
            blockSizeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            blockSizeConfigValue.append('=');
            blockSizeConfigValue.append(URLEncoder.encode(String.valueOf(familyDescriptor.getBlocksize()), "UTF-8"));
        }
        conf.set(BLOCK_SIZE_CONF_KEY, blockSizeConfigValue.toString());
    }

    static Map<byte[], String> createFamilyCompressionMap(Configuration conf) {
        return HFileOutputFormat.createFamilyConfValueMap(conf, COMPRESSION_CONF_KEY);
    }

    private static Map<byte[], String> createFamilyBloomMap(Configuration conf) {
        return HFileOutputFormat.createFamilyConfValueMap(conf, BLOOM_TYPE_CONF_KEY);
    }

    private static Map<byte[], String> createFamilyBlockSizeMap(Configuration conf) {
        return HFileOutputFormat.createFamilyConfValueMap(conf, BLOCK_SIZE_CONF_KEY);
    }

    private static Map<byte[], String> createFamilyConfValueMap(Configuration conf, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = conf.get(confName, "");
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(URLDecoder.decode(familySplit[0], "UTF-8").getBytes(), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, List<ImmutableBytesWritable> splitPoints) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
        Path partitionsPath = new Path("/tmp", "partitions_" + UUID.randomUUID());
        fs.makeQualified(partitionsPath);
        fs.deleteOnExit(partitionsPath);
        HFileOutputFormat.writePartitions(job.getConfiguration(), partitionsPath, splitPoints);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile((Configuration)job.getConfiguration(), (Path)partitionsPath);
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    static void configureCompression(HTable table, Configuration conf) throws IOException {
        StringBuilder compressionConfigValue = new StringBuilder();
        HTableDescriptor tableDescriptor = table.getTableDescriptor();
        if (tableDescriptor == null) {
            return;
        }
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                compressionConfigValue.append('&');
            }
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            compressionConfigValue.append('=');
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getCompression().getName(), "UTF-8"));
        }
        conf.set(COMPRESSION_CONF_KEY, compressionConfigValue.toString());
    }

    static void configureBloomType(HTable table, Configuration conf) throws IOException {
        HTableDescriptor tableDescriptor = table.getTableDescriptor();
        if (tableDescriptor == null) {
            return;
        }
        StringBuilder bloomTypeConfigValue = new StringBuilder();
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                bloomTypeConfigValue.append('&');
            }
            bloomTypeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            bloomTypeConfigValue.append('=');
            String bloomType = familyDescriptor.getBloomFilterType().toString();
            if (bloomType == null) {
                bloomType = HColumnDescriptor.DEFAULT_BLOOMFILTER;
            }
            bloomTypeConfigValue.append(URLEncoder.encode(bloomType, "UTF-8"));
        }
        conf.set(BLOOM_TYPE_CONF_KEY, bloomTypeConfigValue.toString());
    }

    static class WriterLength {
        long written = 0L;
        StoreFile.Writer writer = null;

        WriterLength() {
        }
    }
}

