/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterSourceFactory;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsMaster {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private MetricsMasterSource masterSource;

    public MetricsMaster(MetricsMasterWrapper masterWrapper) {
        this.masterSource = ((MetricsMasterSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsMasterSourceFactory.class)).create(masterWrapper);
    }

    public MetricsMasterSource getMetricsSource() {
        return this.masterSource;
    }

    public synchronized void addSplit(long time, long size) {
        this.masterSource.updateSplitTime(time);
        this.masterSource.updateSplitSize(size);
    }

    public synchronized void addMetaWALSplit(long time, long size) {
        this.masterSource.updateMetaWALSplitTime(time);
        this.masterSource.updateMetaWALSplitSize(size);
    }

    public void incrementRequests(int inc) {
        this.masterSource.incRequests(inc);
    }

    public void updateRITCount(int ritCount) {
        this.masterSource.setRIT(ritCount);
    }

    public void updateRITCountOverThreshold(int ritCountOverThreshold) {
        this.masterSource.setRITCountOverThreshold(ritCountOverThreshold);
    }

    public void updateRITOldestAge(long timestamp) {
        this.masterSource.setRITOldestAge(timestamp);
    }

    public void addSnapshot(long time) {
        this.masterSource.updateSnapshotTime(time);
    }

    public void addSnapshotRestore(long time) {
        this.masterSource.updateSnapshotRestoreTime(time);
    }

    public void addSnapshotClone(long time) {
        this.masterSource.updateSnapshotCloneTime(time);
    }
}

