/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionStates {
    private static final Log LOG = LogFactory.getLog(RegionStates.class);
    final HashMap<String, RegionState> regionsInTransition;
    private final Map<String, RegionState> regionStates = new HashMap<String, RegionState>();
    private final Map<ServerName, Set<HRegionInfo>> serverHoldings;
    private final TreeMap<HRegionInfo, ServerName> regionAssignments;
    private final ServerManager serverManager;
    private final Server server;

    RegionStates(Server master, ServerManager serverManager) {
        this.regionsInTransition = new HashMap();
        this.serverHoldings = new HashMap<ServerName, Set<HRegionInfo>>();
        this.regionAssignments = new TreeMap();
        this.serverManager = serverManager;
        this.server = master;
    }

    public synchronized Map<HRegionInfo, ServerName> getRegionAssignments() {
        return (Map)this.regionAssignments.clone();
    }

    public synchronized ServerName getRegionServerOfRegion(HRegionInfo hri) {
        return this.regionAssignments.get(hri);
    }

    public synchronized Map<String, RegionState> getRegionsInTransition() {
        return (Map)this.regionsInTransition.clone();
    }

    public synchronized boolean isRegionInTransition(HRegionInfo hri) {
        return this.regionsInTransition.containsKey(hri.getEncodedName());
    }

    public synchronized boolean isRegionInTransition(String regionName) {
        return this.regionsInTransition.containsKey(regionName);
    }

    public synchronized boolean isRegionsInTransition() {
        return !this.regionsInTransition.isEmpty();
    }

    public synchronized boolean isRegionAssigned(HRegionInfo hri) {
        return this.regionAssignments.containsKey(hri);
    }

    public synchronized boolean isRegionInState(HRegionInfo hri, RegionState.State state) {
        RegionState regionState = this.getRegionState(hri);
        RegionState.State s = regionState != null ? regionState.getState() : null;
        return s == state;
    }

    public synchronized void waitForUpdate(long timeout) throws InterruptedException {
        this.wait(timeout);
    }

    public synchronized RegionState getRegionTransitionState(HRegionInfo hri) {
        return this.regionsInTransition.get(hri.getEncodedName());
    }

    public synchronized RegionState getRegionTransitionState(String regionName) {
        return this.regionsInTransition.get(regionName);
    }

    public synchronized void createRegionStates(List<HRegionInfo> hris) {
        for (HRegionInfo hri : hris) {
            this.createRegionState(hri);
        }
    }

    public synchronized RegionState createRegionState(HRegionInfo hri) {
        String regionName = hri.getEncodedName();
        RegionState regionState = this.regionStates.get(regionName);
        if (regionState != null) {
            LOG.warn((Object)("Tried to create a state of a region already in RegionStates, used existing state: " + regionState + ", ignored new state: state=OFFLINE, server=null"));
        } else {
            regionState = new RegionState(hri, RegionState.State.OFFLINE);
            this.regionStates.put(regionName, regionState);
        }
        return regionState;
    }

    public synchronized RegionState updateRegionState(HRegionInfo hri, RegionState.State state) {
        RegionState regionState = this.regionStates.get(hri.getEncodedName());
        ServerName serverName = regionState == null || state == RegionState.State.CLOSED || state == RegionState.State.OFFLINE ? null : regionState.getServerName();
        return this.updateRegionState(hri, state, serverName);
    }

    public synchronized RegionState updateRegionState(RegionTransition transition, RegionState.State state) {
        byte[] regionName = transition.getRegionName();
        HRegionInfo regionInfo = this.getRegionInfo(regionName);
        if (regionInfo == null) {
            String prettyRegionName = HRegionInfo.prettyPrint((String)HRegionInfo.encodeRegionName((byte[])regionName));
            LOG.warn((Object)("Failed to find region " + prettyRegionName + " in updating its state to " + state + " based on region transition " + transition));
            return null;
        }
        return this.updateRegionState(regionInfo, state, transition.getServerName());
    }

    public synchronized RegionState updateRegionState(HRegionInfo hri, RegionState.State state, ServerName serverName) {
        RegionState regionState;
        String regionName;
        RegionState oldState;
        ServerName newServerName = serverName;
        if (serverName != null && (state == RegionState.State.CLOSED || state == RegionState.State.OFFLINE)) {
            LOG.warn((Object)("Closed region " + hri.getShortNameToLog() + " still on " + serverName + "? Ignored, reset it to null"));
            newServerName = null;
        }
        if (state == RegionState.State.FAILED_CLOSE || state == RegionState.State.FAILED_OPEN) {
            LOG.warn((Object)("Failed to transition " + hri.getShortNameToLog() + " on " + serverName + ", set to " + state));
        }
        if ((oldState = this.regionStates.put(regionName = hri.getEncodedName(), regionState = new RegionState(hri, state, System.currentTimeMillis(), newServerName))) == null || oldState.getState() != regionState.getState()) {
            LOG.info((Object)("Transitioned from " + oldState + " to " + regionState));
        }
        if (newServerName != null || state != RegionState.State.PENDING_CLOSE && state != RegionState.State.CLOSING) {
            this.regionsInTransition.put(regionName, regionState);
        }
        this.notifyAll();
        return regionState;
    }

    public synchronized void regionOnline(HRegionInfo hri, ServerName serverName) {
        String regionName = hri.getEncodedName();
        RegionState oldState = this.regionStates.get(regionName);
        if (oldState == null) {
            LOG.warn((Object)("Online a region not in RegionStates: " + hri.getShortNameToLog()));
        } else {
            RegionState.State state = oldState.getState();
            ServerName sn = oldState.getServerName();
            if (state != RegionState.State.OPEN || sn == null || !sn.equals((Object)serverName)) {
                LOG.debug((Object)("Online a region " + hri.getShortNameToLog() + " with current state=" + state + ", expected state=OPEN" + ", assigned to server: " + sn + " expected " + serverName));
            }
        }
        this.updateRegionState(hri, RegionState.State.OPEN, serverName);
        this.regionsInTransition.remove(regionName);
        ServerName oldServerName = this.regionAssignments.put(hri, serverName);
        if (!serverName.equals((Object)oldServerName)) {
            LOG.info((Object)("Onlined " + hri.getShortNameToLog() + " on " + serverName));
            Set<HRegionInfo> regions = this.serverHoldings.get(serverName);
            if (regions == null) {
                regions = new HashSet<HRegionInfo>();
                this.serverHoldings.put(serverName, regions);
            }
            regions.add(hri);
            if (oldServerName != null) {
                LOG.info((Object)("Offlined " + hri.getShortNameToLog() + " from " + oldServerName));
                this.serverHoldings.get(oldServerName).remove(hri);
            }
        }
    }

    public void regionOffline(HRegionInfo hri) {
        this.regionOffline(hri, null);
    }

    public synchronized void regionOffline(HRegionInfo hri, RegionState.State expectedState) {
        Preconditions.checkArgument((expectedState == null || expectedState == RegionState.State.OFFLINE || expectedState == RegionState.State.SPLIT || expectedState == RegionState.State.MERGED ? 1 : 0) != 0, (Object)("Offlined region should be in state OFFLINE/SPLIT/MERGED instead of " + expectedState));
        String regionName = hri.getEncodedName();
        RegionState oldState = this.regionStates.get(regionName);
        if (oldState == null) {
            LOG.warn((Object)("Offline a region not in RegionStates: " + hri.getShortNameToLog()));
        } else if (LOG.isDebugEnabled()) {
            RegionState.State state = oldState.getState();
            ServerName sn = oldState.getServerName();
            if (state != RegionState.State.OFFLINE && state != RegionState.State.SPLITTING && state != RegionState.State.MERGING) {
                LOG.debug((Object)("Offline a region " + hri.getShortNameToLog() + " with current state=" + state + ", expected state=OFFLINE/SPLITTING/MERGING"));
            }
            if (sn != null && state == RegionState.State.OFFLINE) {
                LOG.debug((Object)("Offline a region " + hri.getShortNameToLog() + " with current state=OFFLINE, assigned to server: " + sn + ", expected null"));
            }
        }
        RegionState.State newState = expectedState;
        if (newState == null) {
            newState = RegionState.State.OFFLINE;
        }
        this.updateRegionState(hri, newState);
        this.regionsInTransition.remove(regionName);
        ServerName oldServerName = this.regionAssignments.remove(hri);
        if (oldServerName != null) {
            LOG.info((Object)("Offlined " + hri.getShortNameToLog() + " from " + oldServerName));
            this.serverHoldings.get(oldServerName).remove(hri);
        }
    }

    public synchronized List<HRegionInfo> serverOffline(ZooKeeperWatcher watcher, ServerName sn) {
        ArrayList<HRegionInfo> rits = new ArrayList<HRegionInfo>();
        Set<HRegionInfo> assignedRegions = this.serverHoldings.remove(sn);
        if (assignedRegions == null) {
            assignedRegions = new HashSet<HRegionInfo>();
        }
        for (HRegionInfo region : assignedRegions) {
            this.regionAssignments.remove(region);
        }
        for (RegionState state : this.regionsInTransition.values()) {
            HRegionInfo hri = state.getRegion();
            if (assignedRegions.contains(hri)) {
                LOG.info((Object)("Transitioning " + state + " will be handled by SSH for " + sn));
                if (!state.isSplitting() && !state.isMerging()) continue;
                LOG.info((Object)("Offline splitting/merging region " + state));
                try {
                    ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)watcher, (HRegionInfo)hri);
                    this.regionOffline(hri);
                }
                catch (KeeperException ke) {
                    this.server.abort("Unexpected ZK exception deleting node " + hri, (Throwable)ke);
                }
                continue;
            }
            if (!sn.equals((Object)state.getServerName())) continue;
            if (state.isPendingOpen() || state.isOpening()) {
                LOG.info((Object)("Found opening region " + state + " to be reassigned by SSH for " + sn));
                rits.add(hri);
                continue;
            }
            LOG.warn((Object)("THIS SHOULD NOT HAPPEN: unexpected state " + state + " of region in transition on server " + sn));
        }
        assignedRegions.clear();
        this.notifyAll();
        return rits;
    }

    public synchronized List<HRegionInfo> getRegionsOfTable(TableName tableName) {
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        HRegionInfo boundary = new HRegionInfo(tableName, null, null, false, 0L);
        for (HRegionInfo hri : this.regionAssignments.tailMap(boundary).keySet()) {
            if (!hri.getTableName().equals((Object)tableName)) break;
            tableRegions.add(hri);
        }
        return tableRegions;
    }

    public synchronized void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws InterruptedException {
        if (!this.isRegionInTransition(hri)) {
            return;
        }
        while (!this.server.isStopped() && this.isRegionInTransition(hri)) {
            RegionState rs = this.getRegionState(hri);
            LOG.info((Object)("Waiting on " + rs + " to clear regions-in-transition"));
            this.waitForUpdate(100L);
        }
        if (this.server.isStopped()) {
            LOG.info((Object)"Giving up wait on region in transition because stoppable.isStopped is set");
        }
    }

    public synchronized void waitForAssignment(HRegionInfo hri) throws InterruptedException {
        if (!this.isRegionAssigned(hri)) {
            return;
        }
        while (!this.server.isStopped() && !this.isRegionAssigned(hri)) {
            RegionState rs = this.getRegionState(hri);
            LOG.info((Object)("Waiting on " + rs + " to be assigned"));
            this.waitForUpdate(100L);
        }
        if (this.server.isStopped()) {
            LOG.info((Object)"Giving up wait on region assignment because stoppable.isStopped is set");
        }
    }

    protected synchronized double getAverageLoad() {
        int numServers = 0;
        int totalLoad = 0;
        for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
            Set<HRegionInfo> regions = e.getValue();
            ServerName serverName = e.getKey();
            int regionCount = regions.size();
            if (regionCount <= 0 && !this.serverManager.isServerOnline(serverName)) continue;
            totalLoad += regionCount;
            ++numServers;
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<TableName, Map<ServerName, List<HRegionInfo>>> getAssignmentsByTable() {
        HashMap<TableName, Map<ServerName, List<HRegionInfo>>> result = new HashMap<TableName, Map<ServerName, List<HRegionInfo>>>();
        RegionStates regionStates = this;
        synchronized (regionStates) {
            if (!this.server.getConfiguration().getBoolean("hbase.master.loadbalance.bytable", false)) {
                HashMap svrToRegions = new HashMap(this.serverHoldings.size());
                for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
                    svrToRegions.put(e.getKey(), new ArrayList(e.getValue()));
                }
                result.put(TableName.valueOf((String)"ensemble"), svrToRegions);
            } else {
                for (Map.Entry<ServerName, Set<HRegionInfo>> e : this.serverHoldings.entrySet()) {
                    for (HRegionInfo hri : e.getValue()) {
                        ArrayList<HRegionInfo> regions;
                        if (hri.isMetaRegion()) continue;
                        TableName tablename = hri.getTableName();
                        HashMap<ServerName, ArrayList<HRegionInfo>> svrToRegions = (HashMap<ServerName, ArrayList<HRegionInfo>>)result.get(tablename);
                        if (svrToRegions == null) {
                            svrToRegions = new HashMap<ServerName, ArrayList<HRegionInfo>>(this.serverHoldings.size());
                            result.put(tablename, svrToRegions);
                        }
                        if ((regions = (ArrayList<HRegionInfo>)svrToRegions.get(e.getKey())) == null) {
                            regions = new ArrayList<HRegionInfo>();
                            svrToRegions.put(e.getKey(), regions);
                        }
                        regions.add(hri);
                    }
                }
            }
        }
        Map<ServerName, ServerLoad> onlineSvrs = this.serverManager.getOnlineServers();
        for (Map map : result.values()) {
            for (ServerName svr : onlineSvrs.keySet()) {
                if (map.containsKey(svr)) continue;
                map.put(svr, new ArrayList());
            }
        }
        return result;
    }

    protected synchronized RegionState getRegionState(HRegionInfo hri) {
        return this.regionStates.get(hri.getEncodedName());
    }

    protected synchronized RegionState getRegionState(String regionName) {
        return this.regionStates.get(regionName);
    }

    protected HRegionInfo getRegionInfo(byte[] regionName) {
        String encodedName = HRegionInfo.encodeRegionName((byte[])regionName);
        RegionState regionState = this.regionStates.get(encodedName);
        if (regionState != null) {
            return regionState.getRegion();
        }
        try {
            HRegionInfo hri;
            Pair p = MetaReader.getRegion((CatalogTracker)this.server.getCatalogTracker(), (byte[])regionName);
            HRegionInfo hRegionInfo = hri = p == null ? null : (HRegionInfo)p.getFirst();
            if (hri != null) {
                this.createRegionState(hri);
            }
            return hri;
        }
        catch (IOException e) {
            this.server.abort("Aborting because error occoured while reading " + Bytes.toStringBinary((byte[])regionName) + " from .META.", (Throwable)e);
            return null;
        }
    }
}

