/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZKNamespaceManager;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class TableNamespaceManager {
    private static final Log LOG = LogFactory.getLog(TableNamespaceManager.class);
    private Configuration conf;
    private MasterServices masterServices;
    private HTable table;
    private ZKNamespaceManager zkNamespaceManager;

    public TableNamespaceManager(MasterServices masterServices) throws IOException {
        this.masterServices = masterServices;
        this.conf = masterServices.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        TableName tableName = TableName.NAMESPACE_TABLE_NAME;
        try {
            if (!MetaReader.tableExists((CatalogTracker)this.masterServices.getCatalogTracker(), (TableName)tableName)) {
                LOG.info((Object)"Namespace table not found. Creating...");
                this.createNamespaceTable(this.masterServices);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Wait for namespace table assignment interrupted", e);
        }
        this.table = new HTable(this.conf, tableName);
        this.zkNamespaceManager = new ZKNamespaceManager(this.masterServices.getZooKeeper());
        this.zkNamespaceManager.start();
        if (this.get(NamespaceDescriptor.DEFAULT_NAMESPACE.getName()) == null) {
            this.create(NamespaceDescriptor.DEFAULT_NAMESPACE);
        }
        if (this.get(NamespaceDescriptor.SYSTEM_NAMESPACE.getName()) == null) {
            this.create(NamespaceDescriptor.SYSTEM_NAMESPACE);
        }
        ResultScanner scanner = this.table.getScanner(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES);
        try {
            for (Result result : scanner) {
                NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((byte[])result.getColumnLatest(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES).getValue()));
                this.zkNamespaceManager.update(ns);
            }
        }
        finally {
            scanner.close();
        }
    }

    public synchronized NamespaceDescriptor get(String name) throws IOException {
        Result res = this.table.get(new Get(Bytes.toBytes((String)name)));
        if (res.isEmpty()) {
            return null;
        }
        return ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((byte[])res.getColumnLatest(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES).getValue()));
    }

    public synchronized void create(NamespaceDescriptor ns) throws IOException {
        if (this.get(ns.getName()) != null) {
            throw new ConstraintException("Namespace " + ns.getName() + " already exists");
        }
        FileSystem fs = this.masterServices.getMasterFileSystem().getFileSystem();
        fs.mkdirs(FSUtils.getNamespaceDir(this.masterServices.getMasterFileSystem().getRootDir(), ns.getName()));
        this.upsert(ns);
    }

    public synchronized void update(NamespaceDescriptor ns) throws IOException {
        if (this.get(ns.getName()) == null) {
            throw new ConstraintException("Namespace " + ns.getName() + " does not exist");
        }
        this.upsert(ns);
    }

    private void upsert(NamespaceDescriptor ns) throws IOException {
        Put p = new Put(Bytes.toBytes((String)ns.getName()));
        p.add(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES, ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns).toByteArray());
        this.table.put(p);
        try {
            this.zkNamespaceManager.update(ns);
        }
        catch (IOException ex) {
            String msg = "Failed to update namespace information in ZK. Aborting.";
            LOG.fatal((Object)msg, (Throwable)ex);
            this.masterServices.abort(msg, ex);
        }
    }

    public synchronized void remove(String name) throws IOException {
        if (NamespaceDescriptor.RESERVED_NAMESPACES.contains(name)) {
            throw new ConstraintException("Reserved namespace " + name + " cannot be removed.");
        }
        int tableCount = this.masterServices.listTableDescriptorsByNamespace(name).size();
        if (tableCount > 0) {
            throw new ConstraintException("Only empty namespaces can be removed. Namespace " + name + " has " + tableCount + " tables");
        }
        Delete d = new Delete(Bytes.toBytes((String)name));
        this.table.delete(d);
        this.zkNamespaceManager.remove(name);
        FileSystem fs = this.masterServices.getMasterFileSystem().getFileSystem();
        for (FileStatus status : fs.listStatus(FSUtils.getNamespaceDir(this.masterServices.getMasterFileSystem().getRootDir(), name))) {
            if (HConstants.HBASE_NON_TABLE_DIRS.contains(status.getPath().getName())) continue;
            throw new IOException("Namespace directory contains table dir: " + status.getPath());
        }
        if (!fs.delete(FSUtils.getNamespaceDir(this.masterServices.getMasterFileSystem().getRootDir(), name), true)) {
            throw new IOException("Failed to remove namespace: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NavigableSet<NamespaceDescriptor> list() throws IOException {
        TreeSet ret = Sets.newTreeSet((Comparator)NamespaceDescriptor.NAMESPACE_DESCRIPTOR_COMPARATOR);
        ResultScanner scanner = this.table.getScanner(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES);
        try {
            for (Result r : scanner) {
                ret.add(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((byte[])r.getColumnLatest(HTableDescriptor.NAMESPACE_FAMILY_INFO_BYTES, HTableDescriptor.NAMESPACE_COL_DESC_BYTES).getValue())));
            }
        }
        finally {
            scanner.close();
        }
        return ret;
    }

    private void createNamespaceTable(MasterServices masterServices) throws IOException, InterruptedException {
        int tries;
        HRegionInfo[] newRegions = new HRegionInfo[]{new HRegionInfo(HTableDescriptor.NAMESPACE_TABLEDESC.getTableName(), null, null)};
        masterServices.getExecutorService().submit(new CreateTableHandler(masterServices, masterServices.getMasterFileSystem(), HTableDescriptor.NAMESPACE_TABLEDESC, masterServices.getConfiguration(), newRegions, masterServices).prepare());
        for (tries = this.conf.getInt("hbase.master.namespace.init.timeout", 600); masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(newRegions[0]) == null && tries > 0; --tries) {
            Thread.sleep(100L);
        }
        if (tries <= 0) {
            throw new IOException("Failed to create namespace table.");
        }
    }
}

