/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;

public class ClusterLoadState {
    private final Map<ServerName, List<HRegionInfo>> clusterState;
    private final NavigableMap<ServerAndLoad, List<HRegionInfo>> serversByLoad;
    private boolean emptyRegionServerPresent = false;
    private int numRegions = 0;
    private int numServers = 0;

    public ClusterLoadState(Map<ServerName, List<HRegionInfo>> clusterState) {
        this.numServers = clusterState.size();
        this.clusterState = clusterState;
        this.serversByLoad = new TreeMap<ServerAndLoad, List<HRegionInfo>>();
        for (Map.Entry<ServerName, List<HRegionInfo>> server : clusterState.entrySet()) {
            List<HRegionInfo> regions = server.getValue();
            int sz = regions.size();
            if (sz == 0) {
                this.emptyRegionServerPresent = true;
            }
            this.numRegions += sz;
            this.serversByLoad.put(new ServerAndLoad(server.getKey(), sz), regions);
        }
    }

    Map<ServerName, List<HRegionInfo>> getClusterState() {
        return this.clusterState;
    }

    NavigableMap<ServerAndLoad, List<HRegionInfo>> getServersByLoad() {
        return this.serversByLoad;
    }

    boolean isEmptyRegionServerPresent() {
        return this.emptyRegionServerPresent;
    }

    int getNumRegions() {
        return this.numRegions;
    }

    int getNumServers() {
        return this.numServers;
    }

    float getLoadAverage() {
        return (float)this.numRegions / (float)this.numServers;
    }

    int getMinLoad() {
        return ((ServerAndLoad)this.getServersByLoad().lastKey()).getLoad();
    }

    int getMaxLoad() {
        return ((ServerAndLoad)this.getServersByLoad().firstKey()).getLoad();
    }
}

