/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeLoadBalancer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class FavoredNodeAssignmentHelper {
    private static final Log LOG = LogFactory.getLog(FavoredNodeAssignmentHelper.class);
    private RackManager rackManager;
    private Map<String, List<ServerName>> rackToRegionServerMap;
    private List<String> uniqueRackList;
    private Map<ServerName, String> regionServerToRackMap;
    private Random random;
    private List<ServerName> servers;
    public static final byte[] FAVOREDNODES_QUALIFIER = Bytes.toBytes((String)"fn");
    public static final short FAVORED_NODES_NUM = 3;

    public FavoredNodeAssignmentHelper(List<ServerName> servers, Configuration conf) {
        this(servers, new RackManager(conf));
    }

    public FavoredNodeAssignmentHelper(List<ServerName> servers, RackManager rackManager) {
        this.servers = servers;
        this.rackManager = rackManager;
        this.rackToRegionServerMap = new HashMap<String, List<ServerName>>();
        this.regionServerToRackMap = new HashMap<ServerName, String>();
        this.uniqueRackList = new ArrayList<String>();
        this.random = new Random();
    }

    public static Map<HRegionInfo, ServerName> fullScan(CatalogTracker catalogTracker, final Set<TableName> disabledTables, final boolean excludeOfflinedSplitParents, FavoredNodeLoadBalancer balancer) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        final HashMap<HRegionInfo, ServerName[]> favoredNodesMap = new HashMap<HRegionInfo, ServerName[]>();
        MetaReader.Visitor v = new MetaReader.Visitor(){

            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                Pair region = HRegionInfo.getHRegionInfoAndServerName((Result)r);
                HRegionInfo hri = (HRegionInfo)region.getFirst();
                if (hri == null) {
                    return true;
                }
                if (hri.getTableName() == null) {
                    return true;
                }
                if (disabledTables.contains(hri.getTableName())) {
                    return true;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                regions.put(hri, region.getSecond());
                byte[] favoredNodes = r.getValue(HConstants.CATALOG_FAMILY, FAVOREDNODES_QUALIFIER);
                if (favoredNodes != null) {
                    ServerName[] favoredServerList = FavoredNodeAssignmentHelper.getFavoredNodesList(favoredNodes);
                    favoredNodesMap.put(hri, favoredServerList);
                }
                return true;
            }
        };
        MetaReader.fullScan((CatalogTracker)catalogTracker, (MetaReader.Visitor)v);
        balancer.noteFavoredNodes(favoredNodesMap);
        return regions;
    }

    public static void updateMetaWithFavoredNodesInfo(Map<HRegionInfo, List<ServerName>> regionToFavoredNodes, CatalogTracker catalogTracker) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            Put put2 = FavoredNodeAssignmentHelper.makePutFromRegionInfo(entry.getKey(), entry.getValue());
            if (put2 == null) continue;
            puts.add(put2);
        }
        MetaEditor.putsToMetaTable(catalogTracker, puts);
        LOG.info((Object)("Added " + puts.size() + " regions in META"));
    }

    static Put makePutFromRegionInfo(HRegionInfo regionInfo, List<ServerName> favoredNodeList) throws IOException {
        Put put2 = null;
        if (favoredNodeList != null) {
            put2 = MetaEditor.makePutFromRegionInfo(regionInfo);
            byte[] favoredNodes = FavoredNodeAssignmentHelper.getFavoredNodes(favoredNodeList);
            put2.add(HConstants.CATALOG_FAMILY, FAVOREDNODES_QUALIFIER, EnvironmentEdgeManager.currentTimeMillis(), favoredNodes);
            LOG.info((Object)("Create the region " + regionInfo.getRegionNameAsString() + " with favored nodes " + favoredNodes));
        }
        return put2;
    }

    public static ServerName[] getFavoredNodesList(byte[] favoredNodes) throws InvalidProtocolBufferException {
        HBaseProtos.FavoredNodes f = HBaseProtos.FavoredNodes.parseFrom((byte[])favoredNodes);
        List protoNodes = f.getFavoredNodeList();
        ServerName[] servers = new ServerName[protoNodes.size()];
        int i = 0;
        for (HBaseProtos.ServerName node : protoNodes) {
            servers[i++] = ProtobufUtil.toServerName((HBaseProtos.ServerName)node);
        }
        return servers;
    }

    static byte[] getFavoredNodes(List<ServerName> serverAddrList) {
        HBaseProtos.FavoredNodes.Builder f = HBaseProtos.FavoredNodes.newBuilder();
        for (ServerName s : serverAddrList) {
            HBaseProtos.ServerName.Builder b = HBaseProtos.ServerName.newBuilder();
            b.setHostName(s.getHostname());
            b.setPort(s.getPort());
            b.setStartCode(s.getStartcode());
            f.addFavoredNode(b.build());
        }
        return f.build().toByteArray();
    }

    void placePrimaryRSAsRoundRobin(Map<ServerName, List<HRegionInfo>> assignmentMap, Map<HRegionInfo, ServerName> primaryRSMap, List<HRegionInfo> regions) {
        int firstServerIndex;
        ArrayList<String> rackList = new ArrayList<String>(this.rackToRegionServerMap.size());
        rackList.addAll(this.rackToRegionServerMap.keySet());
        int rackIndex = this.random.nextInt(rackList.size());
        int maxRackSize = 0;
        for (Map.Entry<String, List<ServerName>> r : this.rackToRegionServerMap.entrySet()) {
            if (r.getValue().size() <= maxRackSize) continue;
            maxRackSize = r.getValue().size();
        }
        int numIterations = 0;
        int serverIndex = firstServerIndex = this.random.nextInt(maxRackSize);
        for (HRegionInfo regionInfo : regions) {
            List<ServerName> currentServerList;
            while (true) {
                String rackName = (String)rackList.get(rackIndex);
                ++numIterations;
                currentServerList = this.rackToRegionServerMap.get(rackName);
                if (serverIndex < currentServerList.size()) break;
                if (numIterations % rackList.size() == 0 && ++serverIndex >= maxRackSize) {
                    serverIndex = 0;
                }
                if (++rackIndex < rackList.size()) continue;
                rackIndex = 0;
            }
            ServerName currentServer = currentServerList.get(serverIndex);
            primaryRSMap.put(regionInfo, currentServer);
            List<HRegionInfo> regionsForServer = assignmentMap.get(currentServer);
            if (regionsForServer == null) {
                regionsForServer = new ArrayList<HRegionInfo>();
                assignmentMap.put(currentServer, regionsForServer);
            }
            regionsForServer.add(regionInfo);
            if (numIterations % rackList.size() == 0) {
                ++serverIndex;
            }
            if (++rackIndex < rackList.size()) continue;
            rackIndex = 0;
        }
    }

    Map<HRegionInfo, ServerName[]> placeSecondaryAndTertiaryRS(Map<HRegionInfo, ServerName> primaryRSMap) {
        HashMap<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = new HashMap<HRegionInfo, ServerName[]>();
        for (Map.Entry<HRegionInfo, ServerName> entry : primaryRSMap.entrySet()) {
            HRegionInfo regionInfo = entry.getKey();
            ServerName primaryRS = entry.getValue();
            try {
                String primaryRack = this.rackManager.getRack(primaryRS);
                ServerName[] favoredNodes = this.getTotalNumberOfRacks() == 1 ? this.singleRackCase(regionInfo, primaryRS, primaryRack) : this.multiRackCase(regionInfo, primaryRS, primaryRack);
                if (favoredNodes == null) continue;
                secondaryAndTertiaryMap.put(regionInfo, favoredNodes);
                LOG.debug((Object)("Place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot place the favored nodes for region " + regionInfo.getRegionNameAsString() + " because " + e));
            }
        }
        return secondaryAndTertiaryMap;
    }

    private ServerName[] singleRackCase(HRegionInfo regionInfo, ServerName primaryRS, String primaryRack) throws IOException {
        List<ServerName> serverList = this.getServersFromRack(primaryRack);
        if (serverList.size() <= 2) {
            return null;
        }
        HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
        serverSkipSet.add(primaryRS);
        ServerName secondaryRS = this.getOneRandomServer(primaryRack, serverSkipSet);
        serverSkipSet.add(secondaryRS);
        ServerName tertiaryRS = this.getOneRandomServer(primaryRack, serverSkipSet);
        if (secondaryRS == null || tertiaryRS == null) {
            LOG.error((Object)("Cannot place the secondary and terinaryregion server for region " + regionInfo.getRegionNameAsString()));
        }
        ServerName[] favoredNodes = new ServerName[]{secondaryRS, tertiaryRS};
        return favoredNodes;
    }

    private ServerName[] multiRackCase(HRegionInfo regionInfo, ServerName primaryRS, String primaryRack) throws IOException {
        HashSet<String> rackSkipSet = new HashSet<String>();
        rackSkipSet.add(primaryRack);
        ServerName[] favoredNodes = new ServerName[2];
        String secondaryRack = this.getOneRandomRack(rackSkipSet);
        List<ServerName> serverList = this.getServersFromRack(secondaryRack);
        if (serverList.size() >= 2) {
            ServerName secondaryRS = this.getOneRandomServer(secondaryRack);
            HashSet<ServerName> skipServerSet = new HashSet<ServerName>();
            skipServerSet.add(secondaryRS);
            ServerName tertiaryRS = this.getOneRandomServer(secondaryRack, skipServerSet);
            if (secondaryRS == null || tertiaryRS == null) {
                LOG.error((Object)("Cannot place the secondary and terinaryregion server for region " + regionInfo.getRegionNameAsString()));
            }
            favoredNodes[0] = secondaryRS;
            favoredNodes[1] = tertiaryRS;
        } else {
            favoredNodes[0] = this.getOneRandomServer(secondaryRack);
            if (this.getTotalNumberOfRacks() == 2) {
                HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
                serverSkipSet.add(primaryRS);
                favoredNodes[1] = this.getOneRandomServer(primaryRack, serverSkipSet);
            } else {
                rackSkipSet.add(secondaryRack);
                String tertiaryRandomRack = this.getOneRandomRack(rackSkipSet);
                favoredNodes[1] = this.getOneRandomServer(tertiaryRandomRack);
            }
        }
        return favoredNodes;
    }

    boolean canPlaceFavoredNodes() {
        int serverSize = this.regionServerToRackMap.size();
        return serverSize >= 3;
    }

    void initialize() {
        for (ServerName sn : this.servers) {
            String rackName = this.rackManager.getRack(sn);
            List<ServerName> serverList = this.rackToRegionServerMap.get(rackName);
            if (serverList == null) {
                serverList = new ArrayList<ServerName>();
                this.uniqueRackList.add(rackName);
            }
            if (serverList.contains(sn)) continue;
            serverList.add(sn);
            this.rackToRegionServerMap.put(rackName, serverList);
            this.regionServerToRackMap.put(sn, rackName);
        }
    }

    private int getTotalNumberOfRacks() {
        return this.uniqueRackList.size();
    }

    private List<ServerName> getServersFromRack(String rack) {
        return this.rackToRegionServerMap.get(rack);
    }

    private ServerName getOneRandomServer(String rack, Set<ServerName> skipServerSet) throws IOException {
        ServerName randomServer;
        if (rack == null) {
            return null;
        }
        List<ServerName> serverList = this.rackToRegionServerMap.get(rack);
        if (serverList == null) {
            return null;
        }
        if (skipServerSet != null && serverList.size() <= skipServerSet.size()) {
            throw new IOException("Cannot randomly pick another random server");
        }
        do {
            int randomIndex = this.random.nextInt(serverList.size());
            randomServer = serverList.get(randomIndex);
        } while (skipServerSet != null && skipServerSet.contains(randomServer));
        return randomServer;
    }

    private ServerName getOneRandomServer(String rack) throws IOException {
        return this.getOneRandomServer(rack, null);
    }

    private String getOneRandomRack(Set<String> skipRackSet) throws IOException {
        int randomIndex;
        String randomRack;
        if (skipRackSet == null || this.uniqueRackList.size() <= skipRackSet.size()) {
            throw new IOException("Cannot randomly pick another random server");
        }
        while (skipRackSet.contains(randomRack = this.uniqueRackList.get(randomIndex = this.random.nextInt(this.uniqueRackList.size())))) {
        }
        return randomRack;
    }
}

