/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.jboss.netty.util.internal.ConcurrentHashMap;

@InterfaceAudience.Private
public class FavoredNodes {
    protected static final Log LOG = LogFactory.getLog((String)FavoredNodes.class.getName());
    private Map<HRegionInfo, List<ServerName>> favoredNodesMap = new ConcurrentHashMap();

    public synchronized void updateFavoredNodesMap(HRegionInfo region, List<ServerName> servers) {
        if (region == null || servers == null || servers.size() == 0) {
            return;
        }
        this.favoredNodesMap.put(region, servers);
    }

    public synchronized List<ServerName> getFavoredNodes(HRegionInfo region) {
        return this.favoredNodesMap.get(region);
    }

    static Position getFavoredServerPosition(List<ServerName> favoredNodes, ServerName server) {
        if (favoredNodes == null || server == null || favoredNodes.size() != 3) {
            return null;
        }
        for (Position p : Position.values()) {
            if (!favoredNodes.get(p.ordinal()).equals((Object)server)) continue;
            return p;
        }
        return null;
    }

    public static enum Position {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

