/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MergedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(MergedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo merged;
    private final HRegionInfo region_a;
    private final HRegionInfo region_b;
    private final ServerName sn;

    public MergedRegionHandler(Server server, AssignmentManager assignmentManager, ServerName sn, List<HRegionInfo> mergeRegions) {
        super(server, EventType.RS_ZK_REGION_MERGED);
        assert (mergeRegions.size() == 3);
        this.assignmentManager = assignmentManager;
        this.merged = mergeRegions.get(0);
        this.region_a = mergeRegions.get(1);
        this.region_b = mergeRegions.get(2);
        this.sn = sn;
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.merged;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String mergedRegion = "UnknownRegion";
        if (this.merged != null) {
            mergedRegion = this.merged.getRegionNameAsString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + mergedRegion;
    }

    @Override
    public void process() {
        String encodedRegionName = this.merged.getEncodedName();
        LOG.debug((Object)("Handling MERGE event for " + encodedRegionName + "; deleting node"));
        this.assignmentManager.handleRegionsMergeReport(this.sn, this.merged, this.region_a, this.region_b);
        try {
            boolean successful = false;
            while (!successful) {
                successful = ZKAssign.deleteNode((ZooKeeperWatcher)this.server.getZooKeeper(), (String)encodedRegionName, (EventType)EventType.RS_ZK_REGION_MERGED);
            }
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException) {
                String znodePath = ZKUtil.joinZNode((String)this.server.getZooKeeper().splitLogZNode, (String)encodedRegionName);
                LOG.debug((Object)("The znode " + znodePath + " does not exist.  May be deleted already."));
            }
            this.server.abort("Error deleting MERGED node in ZK for transition ZK node (" + this.merged.getEncodedName() + ")", (Throwable)e);
        }
        LOG.info((Object)("Handled MERGED event; merged=" + this.merged.getRegionNameAsString() + " region_a=" + this.region_a.getRegionNameAsString() + "region_b=" + this.region_b.getRegionNameAsString()));
    }
}

