/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.LogReplayHandler;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ServerShutdownHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(ServerShutdownHandler.class);
    protected final ServerName serverName;
    protected final MasterServices services;
    protected final DeadServer deadServers;
    protected final boolean shouldSplitHlog;
    protected final boolean distributedLogReplay;
    protected final int regionAssignmentWaitTimeout;

    public ServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName, boolean shouldSplitHlog) {
        this(server, services, deadServers, serverName, EventType.M_SERVER_SHUTDOWN, shouldSplitHlog);
    }

    ServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName, EventType type, boolean shouldSplitHlog) {
        super(server, type);
        this.serverName = serverName;
        this.server = server;
        this.services = services;
        this.deadServers = deadServers;
        if (!this.deadServers.isDeadServer(this.serverName)) {
            LOG.warn((Object)(this.serverName + " is NOT in deadservers; it should be!"));
        }
        this.shouldSplitHlog = shouldSplitHlog;
        this.distributedLogReplay = server.getConfiguration().getBoolean("hbase.master.distributed.log.replay", false);
        this.regionAssignmentWaitTimeout = server.getConfiguration().getInt("hbase.master.log.replay.wait.region.timeout", 15000);
    }

    @Override
    public String getInformativeName() {
        if (this.serverName != null) {
            return this.getClass().getSimpleName() + " for " + this.serverName;
        }
        return super.getInformativeName();
    }

    boolean isCarryingMeta() {
        return false;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        boolean hasLogReplayWork = false;
        ServerName serverName = this.serverName;
        try {
            if (this.isCarryingMeta() || !this.services.getAssignmentManager().isFailoverCleanupDone()) {
                this.services.getServerManager().processDeadServer(serverName, this.shouldSplitHlog);
                return;
            }
            NavigableMap hris = null;
            while (!this.server.isStopped()) {
                try {
                    this.server.getCatalogTracker().waitForMeta();
                    hris = MetaReader.getServerUserRegions((CatalogTracker)this.server.getCatalogTracker(), (ServerName)this.serverName);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted", e);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Received exception accessing META during server shutdown of " + serverName + ", retrying META read"), (Throwable)ioe);
                }
            }
            if (this.server.isStopped()) {
                throw new IOException("Server is stopped");
            }
            try {
                if (this.shouldSplitHlog) {
                    LOG.info((Object)("Splitting logs for " + serverName + " before assignment."));
                    if (this.distributedLogReplay) {
                        LOG.info((Object)"Mark regions in recovery before assignment.");
                        HashSet<ServerName> serverNames = new HashSet<ServerName>();
                        serverNames.add(serverName);
                        this.services.getMasterFileSystem().prepareLogReplay(serverNames);
                    } else {
                        this.services.getMasterFileSystem().splitLog(serverName);
                    }
                } else {
                    LOG.info((Object)("Skipping log splitting for " + serverName));
                }
            }
            catch (IOException ioe) {
                this.resubmit(serverName, ioe);
            }
            AssignmentManager am = this.services.getAssignmentManager();
            List<HRegionInfo> regionsInTransition = am.processServerShutdown(serverName);
            LOG.info((Object)("Reassigning " + (hris == null ? 0 : hris.size()) + " region(s) that " + (serverName == null ? "null" : serverName) + " was carrying (and " + regionsInTransition.size() + " regions(s) that were opening on this server)"));
            ArrayList<HRegionInfo> toAssignRegions = new ArrayList<HRegionInfo>();
            toAssignRegions.addAll(regionsInTransition);
            if (hris != null) {
                RegionStates regionStates = am.getRegionStates();
                for (Map.Entry e : hris.entrySet()) {
                    HRegionInfo hri = (HRegionInfo)e.getKey();
                    if (regionsInTransition.contains(hri)) continue;
                    RegionState rit = regionStates.getRegionTransitionState(hri);
                    if (ServerShutdownHandler.processDeadRegion(hri, (Result)e.getValue(), am, this.server.getCatalogTracker())) {
                        ServerName addressFromAM = regionStates.getRegionServerOfRegion(hri);
                        if (addressFromAM != null && !addressFromAM.equals((Object)this.serverName)) {
                            LOG.info((Object)("Skip assigning region " + hri.getRegionNameAsString() + " because it has been opened in " + addressFromAM.getServerName()));
                            continue;
                        }
                        if (rit != null) {
                            if (!rit.isOnServer(serverName) || rit.isClosed() || rit.isOpened()) {
                                LOG.info((Object)("Skip assigning region " + rit));
                                continue;
                            }
                            try {
                                LOG.info((Object)("Reassigning region with rs = " + rit + " and deleting zk node if exists"));
                                ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)this.services.getZooKeeper(), (HRegionInfo)hri);
                            }
                            catch (KeeperException ke) {
                                this.server.abort("Unexpected ZK exception deleting unassigned node " + hri, (Throwable)ke);
                                this.deadServers.finish(serverName);
                                return;
                            }
                        }
                        toAssignRegions.add(hri);
                        continue;
                    }
                    if (rit == null) continue;
                    if ((rit.isClosing() || rit.isPendingClose()) && am.getZKTable().isDisablingOrDisabledTable(hri.getTableName())) {
                        am.deleteClosingOrClosedNode(hri);
                        am.regionOffline(hri);
                        continue;
                    }
                    LOG.warn((Object)("THIS SHOULD NOT HAPPEN: unexpected region in transition " + rit + " not to be assigned by SSH of server " + serverName));
                }
            }
            try {
                am.assign(toAssignRegions);
            }
            catch (InterruptedException ie) {
                LOG.error((Object)("Caught " + ie + " during round-robin assignment"));
                throw new IOException(ie);
            }
            if (this.shouldSplitHlog && this.distributedLogReplay) {
                for (HRegionInfo hri : toAssignRegions) {
                    try {
                        if (am.waitOnRegionToClearRegionsInTransition(hri, this.regionAssignmentWaitTimeout)) continue;
                        LOG.warn((Object)("Region " + hri.getEncodedName() + " didn't complete assignment in time"));
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException("Caught " + ie + " during waitOnRegionToClearRegionsInTransition");
                    }
                }
                this.services.getExecutorService().submit(new LogReplayHandler(this.server, this.services, this.deadServers, this.serverName));
                hasLogReplayWork = true;
            }
        }
        finally {
            this.deadServers.finish(serverName);
        }
        if (!hasLogReplayWork) {
            LOG.info((Object)("Finished processing of shutdown of " + serverName));
        }
    }

    private void resubmit(ServerName serverName, IOException ex) throws IOException {
        this.services.getExecutorService().submit(this);
        this.deadServers.add(serverName);
        throw new IOException("failed log splitting for " + serverName + ", will retry", ex);
    }

    public static boolean processDeadRegion(HRegionInfo hri, Result result, AssignmentManager assignmentManager, CatalogTracker catalogTracker) throws IOException {
        boolean tablePresent = assignmentManager.getZKTable().isTablePresent(hri.getTableName());
        if (!tablePresent) {
            LOG.info((Object)("The table " + hri.getTableName() + " was deleted.  Hence not proceeding."));
            return false;
        }
        boolean disabled = assignmentManager.getZKTable().isDisabledTable(hri.getTableName());
        if (disabled) {
            LOG.info((Object)("The table " + hri.getTableName() + " was disabled.  Hence not proceeding."));
            return false;
        }
        if (hri.isOffline() && hri.isSplit()) {
            return false;
        }
        boolean disabling = assignmentManager.getZKTable().isDisablingTable(hri.getTableName());
        if (disabling) {
            LOG.info((Object)("The table " + hri.getTableName() + " is disabled.  Hence not assigning region" + hri.getEncodedName()));
            return false;
        }
        return true;
    }
}

