/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SplitRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(SplitRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo parent;
    private final ServerName sn;
    private final List<HRegionInfo> daughters;
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TEST_SKIP = false;

    public SplitRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo, ServerName sn, List<HRegionInfo> daughters) {
        super(server, EventType.RS_ZK_REGION_SPLIT);
        this.assignmentManager = assignmentManager;
        this.parent = regionInfo;
        this.sn = sn;
        this.daughters = daughters;
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.parent;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String parentRegion = "UnknownRegion";
        if (this.parent != null) {
            parentRegion = this.parent.getRegionNameAsString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + parentRegion;
    }

    @Override
    public void process() {
        String encodedRegionName = this.parent.getEncodedName();
        LOG.debug((Object)("Handling SPLIT event for " + encodedRegionName + "; deleting node"));
        if (TEST_SKIP) {
            LOG.warn((Object)"Skipping split message, TEST_SKIP is set");
            return;
        }
        this.assignmentManager.handleSplitReport(this.sn, this.parent, this.daughters.get(0), this.daughters.get(1));
        try {
            boolean successful = false;
            while (!successful) {
                successful = ZKAssign.deleteNode((ZooKeeperWatcher)this.server.getZooKeeper(), (String)encodedRegionName, (EventType)EventType.RS_ZK_REGION_SPLIT);
            }
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException) {
                String znodePath = ZKUtil.joinZNode((String)this.server.getZooKeeper().splitLogZNode, (String)encodedRegionName);
                LOG.debug((Object)("The znode " + znodePath + " does not exist.  May be deleted already."));
            }
            this.server.abort("Error deleting SPLIT node in ZK for transition ZK node (" + this.parent.getEncodedName() + ")", (Throwable)e);
        }
        LOG.info((Object)("Handled SPLIT event; parent=" + this.parent.getRegionNameAsString() + " daughter a=" + this.daughters.get(0).getRegionNameAsString() + "daughter b=" + this.daughters.get(1).getRegionNameAsString()));
    }
}

