/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.cliffc.high_scale_lib.Counter;

@Deprecated
public class ExactCounterMetric
extends MetricsBase {
    private static final int DEFAULT_TOP_N = 5;
    private final int topN;
    private final Map<String, Counter> counts = new MapMaker().makeComputingMap((Function)new Function<String, Counter>(){

        public Counter apply(String input) {
            return new Counter();
        }
    });
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ExactCounterMetric(String nam, MetricsRegistry registry, String description, int topN) {
        super(nam, description);
        this.topN = topN;
        if (registry != null) {
            registry.add(nam, (MetricsBase)this);
        }
    }

    public ExactCounterMetric(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription", 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String type) {
        this.lock.readLock().lock();
        try {
            this.counts.get(type).increment();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String type, long count) {
        this.lock.readLock().lock();
        try {
            this.counts.get(type).add(count);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, Long>> getTop(int n) {
        ArrayList countsSnapshot = Lists.newArrayListWithCapacity((int)this.counts.size());
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Counter> entry : this.counts.entrySet()) {
                countsSnapshot.add(Pair.newPair((Object)entry.getKey(), (Object)entry.getValue().get()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Collections.sort(countsSnapshot, new Comparator<Pair<String, Long>>(){

            @Override
            public int compare(Pair<String, Long> a, Pair<String, Long> b) {
                return ((Long)b.getSecond()).compareTo((Long)a.getSecond());
            }
        });
        return countsSnapshot.subList(0, Math.min(n, countsSnapshot.size()));
    }

    public void pushMetric(MetricsRecord mr) {
        List<Pair<String, Long>> topKeys = this.getTop(Integer.MAX_VALUE);
        int sum = 0;
        int counter = 0;
        for (Pair<String, Long> keyCount : topKeys) {
            if (++counter <= this.topN) {
                mr.setMetric(this.getName() + "_" + (String)keyCount.getFirst(), ((Long)keyCount.getSecond()).longValue());
            }
            sum = (int)((long)sum + (Long)keyCount.getSecond());
        }
        mr.setMetric(this.getName() + "_map_size", this.counts.size());
        mr.setMetric(this.getName() + "_total_count", sum);
    }
}

