/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.migration.NamespaceUpgrade;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileV1Detector;
import org.apache.hadoop.hbase.util.ZKDataMigrator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class UpgradeTo96
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(UpgradeTo96.class);
    private Options options = new Options();
    private boolean upgrade;
    private boolean checkForHFileV1;
    private String dirToCheckForHFileV1;

    UpgradeTo96() {
        this.setOptions();
    }

    private void setOptions() {
        this.options.addOption("h", "help", false, "Help");
        this.options.addOption(new Option("check", false, "Run upgrade check; looks for HFileV1  under ${hbase.rootdir} or provided 'dir' directory."));
        this.options.addOption(new Option("execute", false, "Run upgrade; zk and hdfs must be up, hbase down"));
        Option pathOption = new Option("dir", true, "Relative path of dir to check for HFileV1s.");
        pathOption.setRequired(false);
        this.options.addOption(pathOption);
    }

    private boolean parseOption(String[] args) throws ParseException {
        if (args.length == 0) {
            return false;
        }
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(this.options, args);
        if (cmd.hasOption("h")) {
            this.printUsage();
            return false;
        }
        if (cmd.hasOption("execute")) {
            this.upgrade = true;
        }
        if (cmd.hasOption("check")) {
            this.checkForHFileV1 = true;
        }
        if (this.checkForHFileV1 && cmd.hasOption("dir")) {
            this.dirToCheckForHFileV1 = cmd.getOptionValue("dir");
        }
        return true;
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("$bin/hbase upgrade -check [-dir DIR]|-execute", this.options);
        System.out.println("Read http://hbase.apache.org/book.html#upgrade0.96 before attempting upgrade");
        System.out.println();
        System.out.println("Example usage:");
        System.out.println();
        System.out.println("Run upgrade check; looks for HFileV1s under ${hbase.rootdir}:");
        System.out.println(" $ bin/hbase upgrade -check");
        System.out.println();
        System.out.println("Run the upgrade: ");
        System.out.println(" $ bin/hbase upgrade -execute");
    }

    public int run(String[] args) throws Exception {
        if (!this.parseOption(args)) {
            this.printUsage();
            return -1;
        }
        if (this.checkForHFileV1) {
            int res = this.doHFileV1Check();
            if (res == 0) {
                LOG.info((Object)"No HFileV1 found.");
            } else {
                LOG.warn((Object)"There are some HFileV1, or corrupt files (files with incorrect major version).");
                return -1;
            }
        }
        if (this.upgrade) {
            if (this.isAnyHBaseProcessAlive()) {
                LOG.error((Object)"Some HBase processes are still alive, or znodes not expired yet. Please stop them before upgrade or try after some time.");
                throw new IOException("Some HBase processes are still alive, or znodes not expired yet");
            }
            return this.upgradeNamespaceAndZnodes();
        }
        return -1;
    }

    private boolean isAnyHBaseProcessAlive() throws IOException {
        ZooKeeperWatcher zkw = null;
        try {
            byte[] data;
            List regionServers;
            List backupMasters;
            zkw = new ZooKeeperWatcher(this.getConf(), "Check Live Processes.", new Abortable(){
                private boolean aborted = false;

                public void abort(String why, Throwable e) {
                    LOG.warn((Object)("Got aborted with reason: " + why + ", and error: " + e));
                    this.aborted = true;
                }

                public boolean isAborted() {
                    return this.aborted;
                }
            });
            boolean liveProcessesExists = false;
            if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)zkw.baseZNode) == -1) {
                boolean bl = false;
                return bl;
            }
            if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)zkw.backupMasterAddressesZNode) != -1 && !(backupMasters = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.backupMasterAddressesZNode)).isEmpty()) {
                LOG.warn((Object)("Backup master(s) " + backupMasters + " are alive or backup-master znodes not expired."));
                liveProcessesExists = true;
            }
            if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)zkw.rsZNode) != -1 && !(regionServers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.rsZNode)).isEmpty()) {
                LOG.warn((Object)("Region server(s) " + regionServers + " are alive or rs znodes not expired."));
                liveProcessesExists = true;
            }
            if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)zkw.getMasterAddressZNode()) != -1 && (data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)zkw.getMasterAddressZNode())) != null && !Bytes.equals((byte[])data, (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                LOG.warn((Object)("Active master at address " + Bytes.toString((byte[])data) + " is still alive or master znode not expired."));
                liveProcessesExists = true;
            }
            boolean bl = liveProcessesExists;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception while checking live hbase processes", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
        }
    }

    private int doHFileV1Check() throws Exception {
        String[] args = null;
        if (this.dirToCheckForHFileV1 != null) {
            args = new String[]{"-p" + this.dirToCheckForHFileV1};
        }
        return ToolRunner.run((Configuration)this.getConf(), (Tool)new HFileV1Detector(), args);
    }

    private int upgradeNamespaceAndZnodes() throws Exception {
        int res = this.upgradeNamespace();
        if (res == 0) {
            return this.upgradeZnodes();
        }
        LOG.warn((Object)("Namespace upgrade returned: " + res + ", expected 0. Aborting the upgrade"));
        throw new Exception("Unexpected return code from Namespace upgrade");
    }

    private int upgradeNamespace() throws Exception {
        LOG.info((Object)"Upgrading Namespace");
        try {
            int res = ToolRunner.run((Configuration)this.getConf(), (Tool)new NamespaceUpgrade(), (String[])new String[]{"--upgrade"});
            LOG.info((Object)"Successfully Upgraded NameSpace.");
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception while upgrading Namespace", (Throwable)e);
            throw e;
        }
    }

    private int upgradeZnodes() throws Exception {
        LOG.info((Object)"Upgrading Znodes");
        try {
            int res = ToolRunner.run((Configuration)this.getConf(), (Tool)new ZKDataMigrator(), null);
            LOG.info((Object)"Succesfully upgraded znodes.");
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception while upgrading Znodes", (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new UpgradeTo96(), (String[])args));
    }
}

