/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.SizedCellScanner;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class ReplicationProtbufUtil {
    public static HLog.Entry[] toHLogEntries(List<AdminProtos.WALEntry> protoList) throws IOException {
        ArrayList<HLog.Entry> entries = new ArrayList<HLog.Entry>();
        for (AdminProtos.WALEntry entry : protoList) {
            WALProtos.WALKey walKey = entry.getKey();
            HLogKey key = new HLogKey(walKey);
            WALEdit edit = new WALEdit();
            for (ByteString keyValue : entry.getKeyValueBytesList()) {
                edit.add(new KeyValue(keyValue.toByteArray()));
            }
            if (walKey.getScopesCount() > 0) {
                TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                for (WALProtos.FamilyScope scope : walKey.getScopesList()) {
                    scopes.put(scope.getFamily().toByteArray(), scope.getScopeType().ordinal());
                }
                key.setScopes(scopes);
            }
            entries.add(new HLog.Entry(key, edit));
        }
        return entries.toArray(new HLog.Entry[entries.size()]);
    }

    public static void replicateWALEntry(AdminProtos.AdminService.BlockingInterface admin, HLog.Entry[] entries) throws IOException {
        Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> p = ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries);
        try {
            PayloadCarryingRpcController controller = new PayloadCarryingRpcController((CellScanner)p.getSecond());
            admin.replicateWALEntry((RpcController)controller, (AdminProtos.ReplicateWALEntryRequest)p.getFirst());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException((ServiceException)se);
        }
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(HLog.Entry[] entries) {
        ArrayList<List<? extends Cell>> allkvs = new ArrayList<List<? extends Cell>>(entries.length);
        int size = 0;
        WALProtos.FamilyScope.Builder scopeBuilder = WALProtos.FamilyScope.newBuilder();
        AdminProtos.WALEntry.Builder entryBuilder = AdminProtos.WALEntry.newBuilder();
        AdminProtos.ReplicateWALEntryRequest.Builder builder = AdminProtos.ReplicateWALEntryRequest.newBuilder();
        for (HLog.Entry entry : entries) {
            entryBuilder.clear();
            WALProtos.WALKey.Builder keyBuilder = entryBuilder.getKeyBuilder();
            HLogKey key = entry.getKey();
            keyBuilder.setEncodedRegionName(ByteString.copyFrom((byte[])key.getEncodedRegionName()));
            keyBuilder.setTableName(ByteString.copyFrom((byte[])key.getTablename().getName()));
            keyBuilder.setLogSequenceNumber(key.getLogSeqNum());
            keyBuilder.setWriteTime(key.getWriteTime());
            UUID clusterId = key.getClusterId();
            if (clusterId != null) {
                HBaseProtos.UUID.Builder uuidBuilder = keyBuilder.getClusterIdBuilder();
                uuidBuilder.setLeastSigBits(clusterId.getLeastSignificantBits());
                uuidBuilder.setMostSigBits(clusterId.getMostSignificantBits());
            }
            WALEdit edit = entry.getEdit();
            NavigableMap<byte[], Integer> scopes = key.getScopes();
            if (scopes != null && !scopes.isEmpty()) {
                for (Map.Entry scope : scopes.entrySet()) {
                    scopeBuilder.setFamily(ByteString.copyFrom((byte[])((byte[])scope.getKey())));
                    WALProtos.ScopeType scopeType = WALProtos.ScopeType.valueOf((int)((Integer)scope.getValue()));
                    scopeBuilder.setScopeType(scopeType);
                    keyBuilder.addScopes(scopeBuilder.build());
                }
            }
            List<KeyValue> kvs = edit.getKeyValues();
            for (KeyValue kv : kvs) {
                size += kv.getLength();
            }
            allkvs.add(kvs);
            entryBuilder.setAssociatedCellCount(kvs.size());
            builder.addEntry(entryBuilder.build());
        }
        return new Pair((Object)builder.build(), (Object)ReplicationProtbufUtil.getCellScanner(allkvs, size));
    }

    static CellScanner getCellScanner(final List<List<? extends Cell>> cells, final int size) {
        return new SizedCellScanner(){
            private final Iterator<List<? extends Cell>> entries;
            private Iterator<? extends Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = cells.iterator();
                this.currentIterator = null;
            }

            public Cell current() {
                return this.currentCell;
            }

            public boolean advance() {
                if (this.currentIterator == null) {
                    if (!this.entries.hasNext()) {
                        return false;
                    }
                    this.currentIterator = this.entries.next().iterator();
                }
                if (this.currentIterator.hasNext()) {
                    this.currentCell = this.currentIterator.next();
                    return true;
                }
                this.currentCell = null;
                this.currentIterator = null;
                return this.advance();
            }

            public long heapSize() {
                return size;
            }
        };
    }
}

