/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServerCommandLine;
import org.apache.hadoop.hbase.regionserver.HRegionThriftServer;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.MetaLogRoller;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperImpl;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.QosFunction;
import org.apache.hadoop.hbase.regionserver.RSDumpServlet;
import org.apache.hadoop.hbase.regionserver.RSStatusServlet;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerRunningException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.ReplicationService;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.handler.CloseMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.RecoveringRegionWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.cliffc.high_scale_lib.Counter;

@InterfaceAudience.Private
public class HRegionServer
implements ClientProtos.ClientService.BlockingInterface,
AdminProtos.AdminService.BlockingInterface,
Runnable,
RegionServerServices,
HBaseRPCErrorHandler,
LastSequenceId {
    public static final Log LOG = LogFactory.getLog(HRegionServer.class);
    private final Random rand;
    protected static final String OPEN = "OPEN";
    protected static final String CLOSE = "CLOSE";
    protected final ConcurrentMap<byte[], Boolean> regionsInTransitionInRS = new ConcurrentSkipListMap<byte[], Boolean>(Bytes.BYTES_COMPARATOR);
    protected long maxScannerResultSize;
    protected MemStoreFlusher cacheFlusher;
    protected CatalogTracker catalogTracker;
    private RecoveringRegionWatcher recoveringRegionWatcher;
    protected TableDescriptors tableDescriptors;
    protected ReplicationSourceService replicationSourceHandler;
    protected ReplicationSinkService replicationSinkHandler;
    public CompactSplitThread compactSplitThread;
    final ConcurrentHashMap<String, RegionScannerHolder> scanners = new ConcurrentHashMap();
    protected final Map<String, HRegion> onlineRegions = new ConcurrentHashMap<String, HRegion>();
    protected final Map<String, InetSocketAddress[]> regionFavoredNodesMap = new ConcurrentHashMap<String, InetSocketAddress[]>();
    protected final Map<String, HRegion> recoveringRegions = Collections.synchronizedMap(new HashMap());
    protected Leases leases;
    protected ExecutorService service;
    final Counter requestCount = new Counter();
    protected volatile boolean fsOk = true;
    protected HFileSystem fs;
    protected volatile boolean stopped = false;
    protected volatile boolean abortRequested;
    protected int webuiport = -1;
    ConcurrentMap<String, Integer> rowlocks = new ConcurrentHashMap<String, Integer>();
    private boolean stopping = false;
    private volatile boolean killed = false;
    protected final Configuration conf;
    private boolean useHBaseChecksum;
    private Path rootDir;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final int numRetries;
    protected final int threadWakeFrequency;
    private final int msgInterval;
    protected final int numRegionsToReport;
    private RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rssStub;
    RpcClient rpcClient;
    RpcServerInterface rpcServer;
    private final InetSocketAddress isa;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    InfoServer infoServer;
    public static final String REGIONSERVER = "regionserver";
    public static final String REGIONSERVER_CONF = "regionserver_conf";
    private MetricsRegionServer metricsRegionServer;
    Chore compactionChecker;
    Chore periodicFlusher;
    protected volatile HLog hlog;
    protected volatile HLog hlogForMeta;
    LogRoller hlogRoller;
    LogRoller metaHLogRoller;
    protected volatile boolean isOnline;
    private ZooKeeperWatcher zooKeeper;
    private MasterAddressTracker masterAddressManager;
    private ClusterStatusTracker clusterStatusTracker;
    private SplitLogWorker splitLogWorker;
    private final Sleeper sleeper;
    private final int rpcTimeout;
    private final RegionServerAccounting regionServerAccounting;
    final CacheConfig cacheConfig;
    private volatile HRegionThriftServer thriftServer;
    private HealthCheckChore healthCheckChore;
    private ServerName serverNameFromMasterPOV;
    private final long startcode;
    private String clusterId;
    private ObjectName mxBean = null;
    private MovedRegionsCleaner movedRegionsCleaner;
    private final int scannerLeaseTimeoutPeriod;
    private final QosFunction qosFunction;
    private RegionServerCoprocessorHost rsHost;
    RegionServerSnapshotManager snapshotManager;
    private final boolean distributedLogReplay;
    private TableLockManager tableLockManager;
    protected Map<String, MovedRegionInfo> movedRegions = new ConcurrentHashMap<String, MovedRegionInfo>(3000);
    private static final int TIMEOUT_REGION_MOVED = 120000;

    public HRegionServer(Configuration conf) throws IOException, InterruptedException {
        int port;
        this.conf = conf;
        this.isOnline = false;
        HRegionServer.checkCodecs(this.conf);
        this.useHBaseChecksum = conf.getBoolean("hbase.regionserver.checksum.verify", false);
        boolean shortCircuitSkipChecksum = conf.getBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        if (shortCircuitSkipChecksum) {
            LOG.warn((Object)("Configuration \"dfs.client.read.shortcircuit.skip.checksum\" should not be set to true." + (this.useHBaseChecksum ? " HBase checksum doesn't require it, see https://issues.apache.org/jira/browse/HBASE-6868." : "")));
            assert (!shortCircuitSkipChecksum);
        }
        this.numRetries = this.conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
        this.sleeper = new Sleeper(this.msgInterval, (Stoppable)this);
        this.maxScannerResultSize = conf.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.numRegionsToReport = conf.getInt("hbase.regionserver.numregionstoreport", 10);
        this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_SHORTOPERATION_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_SHORTOPERATION_TIMEOUT);
        this.abortRequested = false;
        this.stopped = false;
        this.scannerLeaseTimeoutPeriod = HBaseConfiguration.getInt((Configuration)conf, (String)HConstants.HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD, (String)HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, (int)HConstants.DEFAULT_HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD);
        String hostname = conf.get("hbase.regionserver.ipc.address", Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.regionserver.dns.interface", "default"), (String)conf.get("hbase.regionserver.dns.nameserver", "default"))));
        InetSocketAddress initialIsa = new InetSocketAddress(hostname, port = conf.getInt("hbase.regionserver.port", 60020));
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.rand = new Random(initialIsa.hashCode());
        String name = "regionserver/" + initialIsa.toString();
        HConnectionManager.setServerSideHConnectionRetries((Configuration)this.conf, (String)name, (Log)LOG);
        this.rpcServer = new RpcServer(this, name, this.getServices(), initialIsa, conf.getInt("hbase.regionserver.handler.count", 10), conf.getInt("hbase.regionserver.metahandler.count", 10), conf, 10);
        this.isa = this.rpcServer.getListenerAddress();
        this.rpcServer.setErrorHandler(this);
        this.qosFunction = new QosFunction(this);
        this.rpcServer.setQosFunction(this.qosFunction);
        this.startcode = System.currentTimeMillis();
        ZKUtil.loginClient((Configuration)this.conf, (String)"hbase.zookeeper.client.keytab.file", (String)"hbase.zookeeper.client.kerberos.principal", (String)this.isa.getHostName());
        User.login((Configuration)this.conf, (String)"hbase.regionserver.keytab.file", (String)"hbase.regionserver.kerberos.principal", (String)this.isa.getHostName());
        this.regionServerAccounting = new RegionServerAccounting();
        this.cacheConfig = new CacheConfig(conf);
        this.uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HRegionServer.this.abort("Uncaught exception in service thread " + t.getName(), e);
            }
        };
        this.rsHost = new RegionServerCoprocessorHost(this, this.conf);
        this.distributedLogReplay = this.conf.getBoolean("hbase.master.distributed.log.replay", false);
    }

    private List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(2);
        bssi.add(new RpcServer.BlockingServiceAndInterface(ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this), ClientProtos.ClientService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService((AdminProtos.AdminService.BlockingInterface)this), AdminProtos.AdminService.BlockingInterface.class));
        return bssi;
    }

    private static void checkCodecs(Configuration c) throws IOException {
        String[] codecs = c.getStrings("hbase.regionserver.codecs", (String[])null);
        if (codecs == null) {
            return;
        }
        for (String codec : codecs) {
            if (CompressionTest.testCompression(codec)) continue;
            throw new IOException("Compression codec " + codec + " not supported, aborting RS construction");
        }
    }

    String getClusterId() {
        return this.clusterId;
    }

    QosFunction getQosFunction() {
        return this.qosFunction;
    }

    RegionScanner getScanner(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.s;
        }
        return null;
    }

    private void preRegistrationInitialization() {
        try {
            this.initializeZooKeeper();
            this.initializeThreads();
        }
        catch (Throwable t) {
            this.rpcServer.stop();
            this.abort("Initialization of RS failed.  Hence aborting RS.", t);
        }
    }

    private void initializeZooKeeper() throws IOException, InterruptedException {
        this.zooKeeper = new ZooKeeperWatcher(this.conf, "regionserver:" + this.isa.getPort(), (Abortable)this);
        this.masterAddressManager = new MasterAddressTracker(this.zooKeeper, (Abortable)this);
        this.masterAddressManager.start();
        this.blockAndCheckIfStopped((ZooKeeperNodeTracker)this.masterAddressManager);
        this.clusterStatusTracker = new ClusterStatusTracker(this.zooKeeper, (Abortable)this);
        this.clusterStatusTracker.start();
        this.blockAndCheckIfStopped(this.clusterStatusTracker);
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.conf, (Abortable)this);
        this.catalogTracker.start();
        try {
            this.clusterId = ZKClusterId.readClusterIdZNode((ZooKeeperWatcher)this.zooKeeper);
            if (this.clusterId == null) {
                this.abort("Cluster ID has not been set");
            }
            LOG.info((Object)("ClusterId : " + this.clusterId));
        }
        catch (KeeperException e) {
            this.abort("Failed to retrieve Cluster ID", e);
        }
        try {
            this.snapshotManager = new RegionServerSnapshotManager(this);
        }
        catch (KeeperException e) {
            this.abort("Failed to reach zk cluster when creating snapshot handler.");
        }
        this.tableLockManager = TableLockManager.createTableLockManager(this.conf, this.zooKeeper, new ServerName(this.isa.getHostName(), this.isa.getPort(), this.startcode));
        if (this.distributedLogReplay) {
            this.recoveringRegionWatcher = new RecoveringRegionWatcher(this.zooKeeper, this);
        }
    }

    private void blockAndCheckIfStopped(ZooKeeperNodeTracker tracker) throws IOException, InterruptedException {
        while (tracker.blockUntilAvailable((long)this.msgInterval, false) == null) {
            if (!this.stopped) continue;
            throw new IOException("Received the shutdown message while waiting.");
        }
    }

    private boolean isClusterUp() {
        return this.clusterStatusTracker.isClusterUp();
    }

    private void initializeThreads() throws IOException {
        this.cacheFlusher = new MemStoreFlusher(this.conf, this);
        this.compactSplitThread = new CompactSplitThread(this);
        this.compactionChecker = new CompactionChecker(this, this.threadWakeFrequency, (Stoppable)this);
        this.periodicFlusher = new PeriodicMemstoreFlusher(this.threadWakeFrequency, this);
        int sleepTime = this.conf.getInt("hbase.node.health.script.frequency", 10000);
        if (this.isHealthCheckerConfigured()) {
            this.healthCheckChore = new HealthCheckChore(sleepTime, (Stoppable)this, this.getConfiguration());
        }
        this.leases = new Leases(this.threadWakeFrequency);
        if (this.conf.getBoolean("hbase.regionserver.export.thrift", false)) {
            this.thriftServer = new HRegionThriftServer(this, this.conf);
            this.thriftServer.start();
            LOG.info((Object)"Started Thrift API from Region Server.");
        }
        this.movedRegionsCleaner = MovedRegionsCleaner.createAndStart(this);
        this.rpcClient = new RpcClient(this.conf, this.clusterId);
    }

    @Override
    public void run() {
        block47: {
            try {
                this.preRegistrationInitialization();
            }
            catch (Throwable e) {
                this.abort("Fatal exception during initialization", e);
            }
            try {
                while (this.keepLooping()) {
                    RegionServerStatusProtos.RegionServerStartupResponse w = this.reportForDuty();
                    if (w == null) {
                        LOG.warn((Object)"reportForDuty failed; sleeping and then retrying.");
                        this.sleeper.sleep();
                        continue;
                    }
                    this.handleReportForDutyResponse(w);
                    break;
                }
                if (!this.stopped && this.isHealthy()) {
                    this.snapshotManager.start();
                }
                long lastMsg = 0L;
                long oldRequestCount = -1L;
                while (!this.stopped && this.isHealthy()) {
                    long now;
                    if (!this.isClusterUp()) {
                        if (this.isOnlineRegionsEmpty()) {
                            this.stop("Exiting; cluster shutdown set and not carrying any regions");
                        } else if (!this.stopping) {
                            this.stopping = true;
                            LOG.info((Object)"Closing user regions");
                            this.closeUserRegions(this.abortRequested);
                        } else if (this.stopping) {
                            boolean allUserRegionsOffline = this.areAllUserRegionsOffline();
                            if (allUserRegionsOffline) {
                                if (oldRequestCount == this.requestCount.get()) {
                                    this.stop("Stopped; only catalog regions remaining online");
                                    break;
                                }
                                oldRequestCount = this.requestCount.get();
                            } else {
                                this.closeUserRegions(this.abortRequested);
                            }
                            LOG.debug((Object)("Waiting on " + this.getOnlineRegionsAsPrintableString()));
                        }
                    }
                    if ((now = System.currentTimeMillis()) - lastMsg >= (long)this.msgInterval) {
                        this.tryRegionServerReport(lastMsg, now);
                        lastMsg = System.currentTimeMillis();
                    }
                    if (this.stopped) continue;
                    this.sleeper.sleep();
                }
            }
            catch (Throwable t) {
                if (this.checkOOME(t)) break block47;
                String prefix = t instanceof YouAreDeadException ? "" : "Unhandled: ";
                this.abort(prefix + t.getMessage(), t);
            }
        }
        if (this.mxBean != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mxBean);
            this.mxBean = null;
        }
        if (this.thriftServer != null) {
            this.thriftServer.shutdown();
        }
        this.leases.closeAfterLeasesExpire();
        this.rpcServer.stop();
        if (this.splitLogWorker != null) {
            this.splitLogWorker.stop();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.cacheConfig.isBlockCacheEnabled()) {
            this.cacheConfig.getBlockCache().shutdown();
        }
        this.movedRegionsCleaner.stop("Region Server stopping");
        if (this.cacheFlusher != null) {
            this.cacheFlusher.interruptIfNecessary();
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.interruptIfNecessary();
        }
        if (this.hlogRoller != null) {
            this.hlogRoller.interruptIfNecessary();
        }
        if (this.metaHLogRoller != null) {
            this.metaHLogRoller.interruptIfNecessary();
        }
        if (this.compactionChecker != null) {
            this.compactionChecker.interrupt();
        }
        if (this.healthCheckChore != null) {
            this.healthCheckChore.interrupt();
        }
        try {
            if (this.snapshotManager != null) {
                this.snapshotManager.stop(this.abortRequested || this.killed);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to close snapshot handler cleanly", (Throwable)e);
        }
        if (!this.killed) {
            if (this.abortRequested) {
                if (this.fsOk) {
                    this.closeUserRegions(this.abortRequested);
                }
                LOG.info((Object)("aborting server " + this.serverNameFromMasterPOV));
            } else {
                this.closeUserRegions(this.abortRequested);
                this.closeAllScanners();
                LOG.info((Object)("stopping server " + this.serverNameFromMasterPOV));
            }
        }
        if (this.catalogTracker != null) {
            this.catalogTracker.stop();
        }
        if (!this.killed && this.containsMetaTableRegions() && (!this.abortRequested || this.fsOk)) {
            if (this.compactSplitThread != null) {
                this.compactSplitThread.join();
                this.compactSplitThread = null;
            }
            this.closeMetaTableRegions(this.abortRequested);
        }
        if (!this.killed && this.fsOk) {
            this.waitOnAllRegionsToClose(this.abortRequested);
            LOG.info((Object)("stopping server " + this.serverNameFromMasterPOV + "; all regions closed."));
        }
        if (this.fsOk) {
            this.closeWAL(!this.abortRequested);
        }
        if (this.rssStub != null) {
            this.rssStub = null;
        }
        this.rpcClient.stop();
        this.leases.close();
        if (!this.killed) {
            this.join();
        }
        try {
            this.deleteMyEphemeralNode();
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed deleting my ephemeral node", (Throwable)e);
        }
        ZNodeClearer.deleteMyEphemeralNodeOnDisk();
        this.zooKeeper.close();
        LOG.info((Object)("stopping server " + this.serverNameFromMasterPOV + "; zookeeper connection closed."));
        LOG.info((Object)(Thread.currentThread().getName() + " exiting"));
    }

    private boolean containsMetaTableRegions() {
        return this.onlineRegions.containsKey(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
    }

    private boolean areAllUserRegionsOffline() {
        if (this.getNumberOfOnlineRegions() > 2) {
            return false;
        }
        boolean allUserRegionsOffline = true;
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            if (e.getValue().getRegionInfo().isMetaTable()) continue;
            allUserRegionsOffline = false;
            break;
        }
        return allUserRegionsOffline;
    }

    void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
        if (this.rssStub == null) {
            return;
        }
        ClusterStatusProtos.ServerLoad sl = this.buildServerLoad(reportStartTime, reportEndTime);
        try {
            RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
            ServerName sn = ServerName.parseVersionedServerName((byte[])this.serverNameFromMasterPOV.getVersionedBytes());
            request.setServer(ProtobufUtil.toServerName((ServerName)sn));
            request.setLoad(sl);
            this.rssStub.regionServerReport(null, request.build());
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof YouAreDeadException) {
                throw ioe;
            }
            Pair<ServerName, RegionServerStatusProtos.RegionServerStatusService.BlockingInterface> p = this.createRegionServerStatusStub();
            this.rssStub = (RegionServerStatusProtos.RegionServerStatusService.BlockingInterface)p.getSecond();
        }
    }

    ClusterStatusProtos.ServerLoad buildServerLoad(long reportStartTime, long reportEndTime) {
        MetricsRegionServerWrapper regionServerWrapper = this.metricsRegionServer.getRegionServerWrapper();
        Collection<HRegion> regions = this.getOnlineRegionsLocalContext();
        MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        ClusterStatusProtos.ServerLoad.Builder serverLoad = ClusterStatusProtos.ServerLoad.newBuilder();
        serverLoad.setNumberOfRequests((int)regionServerWrapper.getRequestsPerSecond());
        serverLoad.setTotalNumberOfRequests((int)regionServerWrapper.getTotalRequestCount());
        serverLoad.setUsedHeapMB((int)(memory.getUsed() / 1024L / 1024L));
        serverLoad.setMaxHeapMB((int)(memory.getMax() / 1024L / 1024L));
        Set<String> coprocessors = this.hlog.getCoprocessorHost().getCoprocessors();
        for (String coprocessor : coprocessors) {
            serverLoad.addCoprocessors(HBaseProtos.Coprocessor.newBuilder().setName(coprocessor).build());
        }
        for (HRegion region : regions) {
            serverLoad.addRegionLoads(this.createRegionLoad(region));
        }
        serverLoad.setReportStartTime(reportStartTime);
        serverLoad.setReportEndTime(reportEndTime);
        if (this.infoServer != null) {
            serverLoad.setInfoServerPort(this.infoServer.getPort());
        } else {
            serverLoad.setInfoServerPort(-1);
        }
        return serverLoad.build();
    }

    String getOnlineRegionsAsPrintableString() {
        StringBuilder sb = new StringBuilder();
        for (HRegion r : this.onlineRegions.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(r.getRegionInfo().getEncodedName());
        }
        return sb.toString();
    }

    private void waitOnAllRegionsToClose(boolean abort) {
        int lastCount = -1;
        long previousLogTime = 0L;
        HashSet<String> closedRegions = new HashSet<String>();
        while (!this.isOnlineRegionsEmpty()) {
            int count = this.getNumberOfOnlineRegions();
            if (count != lastCount && System.currentTimeMillis() > previousLogTime + 1000L) {
                previousLogTime = System.currentTimeMillis();
                lastCount = count;
                LOG.info((Object)("Waiting on " + count + " regions to close"));
                if (count < 10 && LOG.isDebugEnabled()) {
                    LOG.debug(this.onlineRegions);
                }
            }
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegionInfo hri = e.getValue().getRegionInfo();
                if (this.regionsInTransitionInRS.containsKey(hri.getEncodedNameAsBytes()) || closedRegions.contains(hri.getEncodedName())) continue;
                closedRegions.add(hri.getEncodedName());
                this.closeRegionIgnoreErrors(hri, abort);
            }
            if (this.regionsInTransitionInRS.isEmpty()) {
                if (this.isOnlineRegionsEmpty()) break;
                LOG.info((Object)"We were exiting though online regions are not empty, because some regions failed closing");
                break;
            }
            Threads.sleep((long)200L);
        }
    }

    private void closeWAL(boolean delete) {
        if (this.hlogForMeta != null) {
            try {
                this.hlogForMeta.close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Metalog close and delete failed", RemoteExceptionHandler.checkThrowable((Throwable)e));
            }
        }
        if (this.hlog != null) {
            try {
                if (delete) {
                    this.hlog.closeAndDelete();
                } else {
                    this.hlog.close();
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Close and delete failed", RemoteExceptionHandler.checkThrowable((Throwable)e));
            }
        }
    }

    private void closeAllScanners() {
        for (Map.Entry<String, RegionScannerHolder> e : this.scanners.entrySet()) {
            try {
                e.getValue().s.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + e.getKey()), (Throwable)ioe);
            }
        }
    }

    protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
        try {
            for (HBaseProtos.NameStringPair e : c.getMapEntriesList()) {
                String key = e.getName();
                if (key.equals("hbase.regionserver.hostname.seen.by.master")) {
                    String hostnameFromMasterPOV = e.getValue();
                    this.serverNameFromMasterPOV = new ServerName(hostnameFromMasterPOV, this.isa.getPort(), this.startcode);
                    if (hostnameFromMasterPOV.equals(this.isa.getHostName())) continue;
                    LOG.info((Object)("Master passed us a different hostname to use; was=" + this.isa.getHostName() + ", but now=" + hostnameFromMasterPOV));
                    continue;
                }
                String value = e.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Config from master: " + key + "=" + value));
                }
                this.conf.set(key, value);
            }
            if (this.conf.get("mapred.task.id") == null) {
                this.conf.set("mapred.task.id", "hb_rs_" + this.serverNameFromMasterPOV.toString());
            }
            this.createMyEphemeralNode();
            ZNodeClearer.writeMyEphemeralNodeOnDisk(this.getMyEphemeralNodePath());
            FSUtils.setFsDefault(this.conf, FSUtils.getRootDir(this.conf));
            this.fs = new HFileSystem(this.conf, this.useHBaseChecksum);
            this.rootDir = FSUtils.getRootDir(this.conf);
            this.tableDescriptors = new FSTableDescriptors((FileSystem)this.fs, this.rootDir, true);
            this.hlog = this.setupWALAndReplication();
            this.metricsRegionServer = new MetricsRegionServer(new MetricsRegionServerWrapperImpl(this));
            this.startServiceThreads();
            LOG.info((Object)("Serving as " + this.serverNameFromMasterPOV + ", RpcServer on " + this.isa + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId())));
            this.isOnline = true;
        }
        catch (Throwable e) {
            this.isOnline = false;
            this.stop("Failed initialization");
            throw this.convertThrowableToIOE(this.cleanup(e, "Failed init"), "Region server startup failed");
        }
        finally {
            this.sleeper.skipSleepCycle();
        }
    }

    private void createMyEphemeralNode() throws KeeperException {
        ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)this.zooKeeper, (String)this.getMyEphemeralNodePath(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    private void deleteMyEphemeralNode() throws KeeperException {
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zooKeeper, (String)this.getMyEphemeralNodePath());
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return this.regionServerAccounting;
    }

    @Override
    public TableLockManager getTableLockManager() {
        return this.tableLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterStatusProtos.RegionLoad createRegionLoad(HRegion r) {
        byte[] name = r.getRegionName();
        int stores = 0;
        int storefiles = 0;
        int storeUncompressedSizeMB = 0;
        int storefileSizeMB = 0;
        int memstoreSizeMB = (int)(r.memstoreSize.get() / 1024L / 1024L);
        int storefileIndexSizeMB = 0;
        int rootIndexSizeKB = 0;
        int totalStaticIndexSizeKB = 0;
        int totalStaticBloomSizeKB = 0;
        long totalCompactingKVs = 0L;
        long currentCompactedKVs = 0L;
        Map<byte[], Store> map = r.stores;
        synchronized (map) {
            stores += r.stores.size();
            for (Store store : r.stores.values()) {
                storefiles += store.getStorefilesCount();
                storeUncompressedSizeMB += (int)(store.getStoreSizeUncompressed() / 1024L / 1024L);
                storefileSizeMB += (int)(store.getStorefilesSize() / 1024L / 1024L);
                storefileIndexSizeMB += (int)(store.getStorefilesIndexSize() / 1024L / 1024L);
                CompactionProgress progress = store.getCompactionProgress();
                if (progress != null) {
                    totalCompactingKVs += progress.totalCompactingKVs;
                    currentCompactedKVs += progress.currentCompactedKVs;
                }
                rootIndexSizeKB += (int)(store.getStorefilesIndexSize() / 1024L);
                totalStaticIndexSizeKB += (int)(store.getTotalStaticIndexSize() / 1024L);
                totalStaticBloomSizeKB += (int)(store.getTotalStaticBloomSize() / 1024L);
            }
        }
        ClusterStatusProtos.RegionLoad.Builder regionLoad = ClusterStatusProtos.RegionLoad.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        regionSpecifier.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
        regionSpecifier.setValue(ByteString.copyFrom((byte[])name));
        regionLoad.setRegionSpecifier(regionSpecifier.build()).setStores(stores).setStorefiles(storefiles).setStoreUncompressedSizeMB(storeUncompressedSizeMB).setStorefileSizeMB(storefileSizeMB).setMemstoreSizeMB(memstoreSizeMB).setStorefileIndexSizeMB(storefileIndexSizeMB).setRootIndexSizeKB(rootIndexSizeKB).setTotalStaticIndexSizeKB(totalStaticIndexSizeKB).setTotalStaticBloomSizeKB(totalStaticBloomSizeKB).setReadRequestsCount((long)((int)r.readRequestsCount.get())).setWriteRequestsCount((long)((int)r.writeRequestsCount.get())).setTotalCompactingKVs(totalCompactingKVs).setCurrentCompactedKVs(currentCompactedKVs).setCompleteSequenceId(r.completeSequenceId);
        return regionLoad.build();
    }

    public ClusterStatusProtos.RegionLoad createRegionLoad(String encodedRegionName) {
        HRegion r = null;
        r = this.onlineRegions.get(encodedRegionName);
        return r != null ? this.createRegionLoad(r) : null;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    private HLog setupWALAndReplication() throws IOException {
        Path oldLogDir = new Path(this.rootDir, "oldWALs");
        String logName = HLogUtil.getHLogDirectoryName(this.serverNameFromMasterPOV.toString());
        Path logdir = new Path(this.rootDir, logName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logdir=" + logdir));
        }
        if (this.fs.exists(logdir)) {
            throw new RegionServerRunningException("Region server has already created directory at " + this.serverNameFromMasterPOV.toString());
        }
        HRegionServer.createNewReplicationInstance(this.conf, this, (FileSystem)this.fs, logdir, oldLogDir);
        return this.instantiateHLog(this.rootDir, logName);
    }

    private HLog getMetaWAL() throws IOException {
        if (this.hlogForMeta != null) {
            return this.hlogForMeta;
        }
        String logName = HLogUtil.getHLogDirectoryName(this.serverNameFromMasterPOV.toString());
        Path logdir = new Path(this.rootDir, logName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logdir=" + logdir));
        }
        this.hlogForMeta = HLogFactory.createMetaHLog(this.fs.getBackingFs(), this.rootDir, logName, this.conf, this.getMetaWALActionListeners(), this.serverNameFromMasterPOV.toString());
        return this.hlogForMeta;
    }

    protected HLog instantiateHLog(Path rootdir, String logName) throws IOException {
        return HLogFactory.createHLog(this.fs.getBackingFs(), rootdir, logName, this.conf, this.getWALActionListeners(), this.serverNameFromMasterPOV.toString());
    }

    protected List<WALActionsListener> getWALActionListeners() {
        ArrayList<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
        this.hlogRoller = new LogRoller(this, this);
        listeners.add(this.hlogRoller);
        if (this.replicationSourceHandler != null && this.replicationSourceHandler.getWALActionsListener() != null) {
            listeners.add(this.replicationSourceHandler.getWALActionsListener());
        }
        return listeners;
    }

    protected List<WALActionsListener> getMetaWALActionListeners() {
        ArrayList<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
        MetaLogRoller tmpLogRoller = new MetaLogRoller(this, this);
        String n = Thread.currentThread().getName();
        Threads.setDaemonThreadRunning((Thread)tmpLogRoller.getThread(), (String)(n + "-MetaLogRoller"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        this.metaHLogRoller = tmpLogRoller;
        tmpLogRoller = null;
        listeners.add(this.metaHLogRoller);
        return listeners;
    }

    protected LogRoller getLogRoller() {
        return this.hlogRoller;
    }

    public MetricsRegionServer getMetrics() {
        return this.metricsRegionServer;
    }

    public MasterAddressTracker getMasterAddressManager() {
        return this.masterAddressManager;
    }

    private void startServiceThreads() throws IOException {
        String n = Thread.currentThread().getName();
        this.service = new ExecutorService(this.getServerName().toShortString());
        this.service.startExecutorService(ExecutorType.RS_OPEN_REGION, this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3));
        this.service.startExecutorService(ExecutorType.RS_OPEN_META, this.conf.getInt("hbase.regionserver.executor.openmeta.threads", 1));
        this.service.startExecutorService(ExecutorType.RS_CLOSE_REGION, this.conf.getInt("hbase.regionserver.executor.closeregion.threads", 3));
        this.service.startExecutorService(ExecutorType.RS_CLOSE_META, this.conf.getInt("hbase.regionserver.executor.closemeta.threads", 1));
        if (this.conf.getBoolean("hbase.storescanner.parallel.seek.enable", false)) {
            this.service.startExecutorService(ExecutorType.RS_PARALLEL_SEEK, this.conf.getInt("hbase.storescanner.parallel.seek.threads", 10));
        }
        Threads.setDaemonThreadRunning((Thread)this.hlogRoller.getThread(), (String)(n + ".logRoller"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        this.cacheFlusher.start(this.uncaughtExceptionHandler);
        Threads.setDaemonThreadRunning((Thread)this.compactionChecker.getThread(), (String)(n + ".compactionChecker"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        Threads.setDaemonThreadRunning((Thread)this.periodicFlusher.getThread(), (String)(n + ".periodicFlusher"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        if (this.healthCheckChore != null) {
            Threads.setDaemonThreadRunning((Thread)this.healthCheckChore.getThread(), (String)(n + ".healthChecker"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        }
        this.leases.setName(n + ".leaseChecker");
        this.leases.start();
        this.webuiport = this.putUpWebUI();
        if (this.replicationSourceHandler == this.replicationSinkHandler && this.replicationSourceHandler != null) {
            this.replicationSourceHandler.startReplicationService();
        } else if (this.replicationSourceHandler != null) {
            this.replicationSourceHandler.startReplicationService();
        } else if (this.replicationSinkHandler != null) {
            this.replicationSinkHandler.startReplicationService();
        }
        this.rpcServer.start();
        Configuration sinkConf = HBaseConfiguration.create((Configuration)this.conf);
        sinkConf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, this.conf.getInt("hbase.log.replay.retries.number", 8));
        sinkConf.setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, this.conf.getInt("hbase.log.replay.rpc.timeout", 30000));
        sinkConf.setInt("hbase.client.serverside.retries.multiplier", 1);
        this.splitLogWorker = new SplitLogWorker(this.zooKeeper, sinkConf, (RegionServerServices)this, this);
        this.splitLogWorker.start();
    }

    private int putUpWebUI() throws IOException {
        int port = this.conf.getInt("hbase.regionserver.info.port", 60030);
        if (port < 0) {
            return port;
        }
        String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
        boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
        while (true) {
            try {
                this.infoServer = new InfoServer(REGIONSERVER, addr, port, false, this.conf);
                this.infoServer.addServlet("status", "/rs-status", RSStatusServlet.class);
                this.infoServer.addServlet("dump", "/dump", RSDumpServlet.class);
                this.infoServer.setAttribute(REGIONSERVER, this);
                this.infoServer.setAttribute(REGIONSERVER_CONF, this.conf);
                this.infoServer.start();
            }
            catch (BindException e) {
                if (!auto) {
                    LOG.error((Object)("Failed binding http info server to port: " + port));
                    throw e;
                }
                LOG.info((Object)("Failed binding http info server to port: " + port));
                ++port;
                continue;
            }
            break;
        }
        return port;
    }

    private boolean isHealthy() {
        if (!this.fsOk) {
            return false;
        }
        if (!(this.leases.isAlive() && this.cacheFlusher.isAlive() && this.hlogRoller.isAlive() && this.compactionChecker.isAlive() || !this.periodicFlusher.isAlive())) {
            this.stop("One or more threads are no longer alive -- stop");
            return false;
        }
        if (this.metaHLogRoller != null && !this.metaHLogRoller.isAlive()) {
            this.stop("Meta HLog roller thread is no longer alive -- stop");
            return false;
        }
        return true;
    }

    public HLog getWAL() {
        try {
            return this.getWAL(null);
        }
        catch (IOException e) {
            LOG.warn((Object)("getWAL threw exception " + e));
            return null;
        }
    }

    @Override
    public HLog getWAL(HRegionInfo regionInfo) throws IOException {
        if (regionInfo != null && regionInfo.isMetaTable()) {
            return this.getMetaWAL();
        }
        return this.hlog;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    public void stop(String msg) {
        try {
            this.rsHost.preStop(msg);
            this.stopped = true;
            LOG.info((Object)("STOPPED: " + msg));
            this.sleeper.skipSleepCycle();
        }
        catch (IOException exp) {
            LOG.warn((Object)"The region server did not stop", (Throwable)exp);
        }
    }

    public void waitForServerOnline() {
        while (!this.isOnline() && !this.isStopped()) {
            this.sleeper.sleep();
        }
    }

    @Override
    public void postOpenDeployTasks(HRegion r, CatalogTracker ct) throws KeeperException, IOException {
        this.checkOpen();
        LOG.info((Object)("Post open deploy tasks for region=" + r.getRegionNameAsString()));
        for (Store s : r.getStores().values()) {
            if (!s.hasReferences() && !s.needsCompaction()) continue;
            this.compactSplitThread.requestSystemCompaction(r, s, "Opening Region");
        }
        long openSeqNum = r.getOpenSeqNum();
        if (openSeqNum == -1L) {
            LOG.error((Object)("No sequence number found when opening " + r.getRegionNameAsString()));
            openSeqNum = 0L;
        }
        this.updateRecoveringRegionLastFlushedSequenceId(r);
        if (r.getRegionInfo().isMetaRegion()) {
            MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.getZooKeeper(), (ServerName)this.serverNameFromMasterPOV);
        } else {
            MetaEditor.updateRegionLocation(ct, r.getRegionInfo(), this.serverNameFromMasterPOV, openSeqNum);
        }
        LOG.info((Object)("Done with post open deploy task for region=" + r.getRegionNameAsString()));
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return this.rpcServer;
    }

    public void abort(String reason, Throwable cause) {
        String msg = "ABORTING region server " + this + ": " + reason;
        if (cause != null) {
            LOG.fatal((Object)msg, cause);
        } else {
            LOG.fatal((Object)msg);
        }
        this.abortRequested = true;
        LOG.fatal((Object)("RegionServer abort: loaded coprocessors are: " + CoprocessorHost.getLoadedCoprocessors()));
        try {
            if (cause != null) {
                msg = msg + "\nCause:\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)cause);
            }
            if (this.rssStub != null && this.serverNameFromMasterPOV != null) {
                RegionServerStatusProtos.ReportRSFatalErrorRequest.Builder builder = RegionServerStatusProtos.ReportRSFatalErrorRequest.newBuilder();
                ServerName sn = ServerName.parseVersionedServerName((byte[])this.serverNameFromMasterPOV.getVersionedBytes());
                builder.setServer(ProtobufUtil.toServerName((ServerName)sn));
                builder.setErrorMessage(msg);
                this.rssStub.reportRSFatalError(null, builder.build());
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)"Unable to report fatal error to master", t);
        }
        this.stop(reason);
    }

    public void abort(String reason) {
        this.abort(reason, null);
    }

    public boolean isAborted() {
        return this.abortRequested;
    }

    protected void kill() {
        this.killed = true;
        this.abort("Simulated kill");
    }

    protected void join() {
        Threads.shutdown((Thread)this.compactionChecker.getThread());
        Threads.shutdown((Thread)this.periodicFlusher.getThread());
        this.cacheFlusher.join();
        if (this.healthCheckChore != null) {
            Threads.shutdown((Thread)this.healthCheckChore.getThread());
        }
        if (this.hlogRoller != null) {
            Threads.shutdown((Thread)this.hlogRoller.getThread());
        }
        if (this.metaHLogRoller != null) {
            Threads.shutdown((Thread)this.metaHLogRoller.getThread());
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.join();
        }
        if (this.service != null) {
            this.service.shutdown();
        }
        if (this.replicationSourceHandler != null && this.replicationSourceHandler == this.replicationSinkHandler) {
            this.replicationSourceHandler.stopReplicationService();
        } else if (this.replicationSourceHandler != null) {
            this.replicationSourceHandler.stopReplicationService();
        } else if (this.replicationSinkHandler != null) {
            this.replicationSinkHandler.stopReplicationService();
        }
    }

    ReplicationSourceService getReplicationSourceService() {
        return this.replicationSourceHandler;
    }

    ReplicationSinkService getReplicationSinkService() {
        return this.replicationSinkHandler;
    }

    private Pair<ServerName, RegionServerStatusProtos.RegionServerStatusService.BlockingInterface> createRegionServerStatusStub() {
        ServerName sn = null;
        long previousLogTime = 0L;
        Object master = null;
        boolean refresh = false;
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface intf = null;
        while (this.keepLooping() && master == null) {
            sn = this.masterAddressManager.getMasterAddress(refresh);
            if (sn == null) {
                if (!this.keepLooping()) {
                    LOG.debug((Object)"No master found and cluster is stopped; bailing out");
                    return null;
                }
                LOG.debug((Object)"No master found; retry");
                previousLogTime = System.currentTimeMillis();
                refresh = true;
                this.sleeper.sleep();
                continue;
            }
            new InetSocketAddress(sn.getHostname(), sn.getPort());
            try {
                BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, User.getCurrent(), this.rpcTimeout);
                intf = RegionServerStatusProtos.RegionServerStatusService.newBlockingStub((BlockingRpcChannel)channel);
                break;
            }
            catch (IOException e) {
                IOException iOException = e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
                if (e instanceof ServerNotRunningYetException) {
                    if (System.currentTimeMillis() > previousLogTime + 1000L) {
                        LOG.info((Object)"Master isn't available yet, retrying");
                        previousLogTime = System.currentTimeMillis();
                    }
                } else if (System.currentTimeMillis() > previousLogTime + 1000L) {
                    LOG.warn((Object)"Unable to connect to master. Retrying. Error was:", (Throwable)e);
                    previousLogTime = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        return new Pair(sn, intf);
    }

    private boolean keepLooping() {
        return !this.stopped && this.isClusterUp();
    }

    private RegionServerStatusProtos.RegionServerStartupResponse reportForDuty() throws IOException {
        RegionServerStatusProtos.RegionServerStartupResponse result = null;
        Pair<ServerName, RegionServerStatusProtos.RegionServerStatusService.BlockingInterface> p = this.createRegionServerStatusStub();
        this.rssStub = (RegionServerStatusProtos.RegionServerStatusService.BlockingInterface)p.getSecond();
        ServerName masterServerName = (ServerName)p.getFirst();
        if (masterServerName == null) {
            return result;
        }
        try {
            this.requestCount.set(0L);
            LOG.info((Object)("reportForDuty to master=" + masterServerName + " with port=" + this.isa.getPort() + ", startcode=" + this.startcode));
            long now = EnvironmentEdgeManager.currentTimeMillis();
            int port = this.isa.getPort();
            RegionServerStatusProtos.RegionServerStartupRequest.Builder request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            request.setPort(port);
            request.setServerStartCode(this.startcode);
            request.setServerCurrentTime(now);
            result = this.rssStub.regionServerStartup(null, request.build());
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof ClockOutOfSyncException) {
                LOG.fatal((Object)"Master rejected startup because clock is out of sync", (Throwable)ioe);
                throw ioe;
            }
            if (ioe instanceof ServerNotRunningYetException) {
                LOG.debug((Object)"Master is not running yet");
            }
            LOG.warn((Object)"error telling master we are up", (Throwable)se);
        }
        return result;
    }

    @Override
    public long getLastSequenceId(byte[] region) {
        Long lastFlushedSequenceId = -1L;
        try {
            RegionServerStatusProtos.GetLastFlushedSequenceIdRequest req = RequestConverter.buildGetLastFlushedSequenceIdRequest((byte[])region);
            lastFlushedSequenceId = this.rssStub.getLastFlushedSequenceId(null, req).getLastFlushedSequenceId();
        }
        catch (ServiceException e) {
            lastFlushedSequenceId = -1L;
            LOG.warn((Object)"Unable to connect to the master to check the last flushed sequence id", (Throwable)e);
        }
        return lastFlushedSequenceId;
    }

    protected void closeAllRegions(boolean abort) {
        this.closeUserRegions(abort);
        this.closeMetaTableRegions(abort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeMetaTableRegions(boolean abort) {
        HRegion meta = null;
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegionInfo hri = e.getValue().getRegionInfo();
                if (hri.isMetaRegion()) {
                    meta = e.getValue();
                }
                if (meta == null) continue;
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (meta != null) {
            this.closeRegionIgnoreErrors(meta.getRegionInfo(), abort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUserRegions(boolean abort) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegion r = e.getValue();
                if (r.getRegionInfo().isMetaTable() || !r.isAvailable()) continue;
                this.closeRegionIgnoreErrors(r.getRegionInfo(), abort);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public Map<String, HRegion> getRecoveringRegions() {
        return this.recoveringRegions;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.lock.writeLock();
    }

    public int getNumberOfOnlineRegions() {
        return this.onlineRegions.size();
    }

    boolean isOnlineRegionsEmpty() {
        return this.onlineRegions.isEmpty();
    }

    public Collection<HRegion> getOnlineRegionsLocalContext() {
        Collection<HRegion> regions = this.onlineRegions.values();
        return Collections.unmodifiableCollection(regions);
    }

    @Override
    public void addToOnlineRegions(HRegion region) {
        this.onlineRegions.put(region.getRegionInfo().getEncodedName(), region);
    }

    SortedMap<Long, HRegion> getCopyOfOnlineRegionsSortedBySize() {
        TreeMap<Long, HRegion> sortedRegions = new TreeMap<Long, HRegion>(new Comparator<Long>(){

            @Override
            public int compare(Long a, Long b) {
                return -1 * a.compareTo(b);
            }
        });
        for (HRegion region : this.onlineRegions.values()) {
            sortedRegions.put(region.memstoreSize.get(), region);
        }
        return sortedRegions;
    }

    public long getStartcode() {
        return this.startcode;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return this.cacheFlusher;
    }

    protected HRegionInfo[] getMostLoadedRegions() {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        for (HRegion r : this.onlineRegions.values()) {
            if (!r.isAvailable()) continue;
            if (regions.size() >= this.numRegionsToReport) break;
            regions.add(r.getRegionInfo());
        }
        return regions.toArray(new HRegionInfo[regions.size()]);
    }

    @Override
    public Leases getLeases() {
        return this.leases;
    }

    protected Path getRootDir() {
        return this.rootDir;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    public String toString() {
        return this.getServerName().toString();
    }

    public int getThreadWakeFrequency() {
        return this.threadWakeFrequency;
    }

    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    public ServerName getServerName() {
        return this.serverNameFromMasterPOV == null ? new ServerName(this.isa.getHostName(), this.isa.getPort(), this.startcode) : this.serverNameFromMasterPOV;
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return this.compactSplitThread;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    public RegionServerCoprocessorHost getCoprocessorHost() {
        return this.rsHost;
    }

    @Override
    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.regionsInTransitionInRS;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.service;
    }

    private static void createNewReplicationInstance(Configuration conf, HRegionServer server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        String sinkClassname;
        if (!conf.getBoolean("hbase.replication", false)) {
            return;
        }
        String sourceClassname = conf.get("hbase.replication.source.service", "org.apache.hadoop.hbase.replication.regionserver.Replication");
        if (sourceClassname.equals(sinkClassname = conf.get("hbase.replication.sink.service", "org.apache.hadoop.hbase.replication.regionserver.Replication"))) {
            server.replicationSourceHandler = (ReplicationSourceService)HRegionServer.newReplicationInstance(sourceClassname, conf, server, fs, logDir, oldLogDir);
            server.replicationSinkHandler = (ReplicationSinkService)((Object)server.replicationSourceHandler);
        } else {
            server.replicationSourceHandler = (ReplicationSourceService)HRegionServer.newReplicationInstance(sourceClassname, conf, server, fs, logDir, oldLogDir);
            server.replicationSinkHandler = (ReplicationSinkService)HRegionServer.newReplicationInstance(sinkClassname, conf, server, fs, logDir, oldLogDir);
        }
    }

    private static ReplicationService newReplicationInstance(String classname, Configuration conf, HRegionServer server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(classname, true, classLoader);
        }
        catch (ClassNotFoundException nfe) {
            throw new IOException("Could not find class for " + classname);
        }
        ReplicationService service = (ReplicationService)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        service.initialize(server, fs, logDir, oldLogDir);
        return service;
    }

    public static Thread startRegionServer(HRegionServer hrs) throws IOException {
        return HRegionServer.startRegionServer(hrs, REGIONSERVER + hrs.isa.getPort());
    }

    public static Thread startRegionServer(HRegionServer hrs, String name) throws IOException {
        Thread t = new Thread(hrs);
        t.setName(name);
        t.start();
        ShutdownHook.install(hrs.getConfiguration(), FileSystem.get((Configuration)hrs.getConfiguration()), (Stoppable)hrs, t);
        return t;
    }

    public static HRegionServer constructRegionServer(Class<? extends HRegionServer> regionServerClass, Configuration conf2) {
        try {
            Constructor<? extends HRegionServer> c = regionServerClass.getConstructor(Configuration.class);
            return c.newInstance(conf2);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Regionserver: " + regionServerClass.toString(), e);
        }
    }

    public static void main(String[] args) throws Exception {
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        Class regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        new HRegionServerCommandLine(regionServerClass).doMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HRegion> getOnlineRegions(TableName tableName) {
        ArrayList<HRegion> tableRegions = new ArrayList<HRegion>();
        Map<String, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion region : this.onlineRegions.values()) {
                HRegionInfo regionInfo = region.getRegionInfo();
                if (!regionInfo.getTableName().equals((Object)tableName)) continue;
                tableRegions.add(region);
            }
        }
        return tableRegions;
    }

    public String[] getCoprocessors() {
        TreeSet<String> coprocessors = new TreeSet<String>(this.hlog.getCoprocessorHost().getCoprocessors());
        Collection<HRegion> regions = this.getOnlineRegionsLocalContext();
        for (HRegion region : regions) {
            coprocessors.addAll(region.getCoprocessorHost().getCoprocessors());
        }
        return coprocessors.toArray(new String[coprocessors.size()]);
    }

    protected void checkOpen() throws IOException {
        if (this.stopped || this.abortRequested) {
            throw new RegionServerStoppedException("Server " + this.getServerName() + " not running" + (this.abortRequested ? ", aborting" : ""));
        }
        if (!this.fsOk) {
            throw new RegionServerStoppedException("File system not available");
        }
    }

    private void closeRegionIgnoreErrors(HRegionInfo region, boolean abort) {
        try {
            if (!this.closeRegion(region.getEncodedName(), abort, false, -1, null)) {
                LOG.warn((Object)("Failed to close " + region.getRegionNameAsString() + " - ignoring and continuing"));
            }
        }
        catch (NotServingRegionException e) {
            LOG.warn((Object)("Failed to close " + region.getRegionNameAsString() + " - ignoring and continuing"), (Throwable)e);
        }
    }

    protected boolean closeRegion(String encodedName, boolean abort, boolean zk, int versionOfClosingNode, ServerName sn) throws NotServingRegionException {
        Boolean previous;
        HRegion actualRegion = this.getFromOnlineRegions(encodedName);
        if (actualRegion != null && actualRegion.getCoprocessorHost() != null) {
            try {
                actualRegion.getCoprocessorHost().preClose(false);
            }
            catch (IOException exp) {
                LOG.warn((Object)"Unable to close region: the coprocessor launched an error ", (Throwable)exp);
                return false;
            }
        }
        if (Boolean.TRUE.equals(previous = this.regionsInTransitionInRS.putIfAbsent(encodedName.getBytes(), Boolean.FALSE))) {
            LOG.info((Object)("Received CLOSE for the region:" + encodedName + " , which we are already " + "trying to OPEN. Cancelling OPENING."));
            if (!this.regionsInTransitionInRS.replace(encodedName.getBytes(), previous, Boolean.FALSE)) {
                LOG.warn((Object)("The opening for region " + encodedName + " was done before we could cancel it." + " Doing a standard close now"));
                return this.closeRegion(encodedName, abort, zk, versionOfClosingNode, sn);
            }
            LOG.info((Object)"The opening previously in progress has been cancelled by a CLOSE request.");
            throw new NotServingRegionException("The region " + encodedName + " was opening but not yet served. Opening is cancelled.");
        }
        if (Boolean.FALSE.equals(previous)) {
            LOG.info((Object)("Received CLOSE for the region: " + encodedName + " ,which we are already trying to CLOSE"));
            throw new NotServingRegionException("The region " + encodedName + " was already closing. New CLOSE request is ignored.");
        }
        if (actualRegion == null) {
            LOG.error((Object)"Received CLOSE for a region which is not online, and we're not opening.");
            this.regionsInTransitionInRS.remove(encodedName.getBytes());
            throw new NotServingRegionException("The region " + encodedName + " is not online, and is not opening.");
        }
        HRegionInfo hri = actualRegion.getRegionInfo();
        CloseRegionHandler crh = hri.isMetaRegion() ? new CloseMetaHandler(this, this, hri, abort, zk, versionOfClosingNode) : new CloseRegionHandler((Server)this, (RegionServerServices)this, hri, abort, zk, versionOfClosingNode, sn);
        this.service.submit(crh);
        return true;
    }

    public HRegion getOnlineRegion(byte[] regionName) {
        String encodedRegionName = HRegionInfo.encodeRegionName((byte[])regionName);
        return this.onlineRegions.get(encodedRegionName);
    }

    public InetSocketAddress[] getRegionBlockLocations(String encodedRegionName) {
        return this.regionFavoredNodesMap.get(encodedRegionName);
    }

    @Override
    public HRegion getFromOnlineRegions(String encodedRegionName) {
        return this.onlineRegions.get(encodedRegionName);
    }

    @Override
    public boolean removeFromOnlineRegions(HRegion r, ServerName destination) {
        HRegion toReturn = this.onlineRegions.remove(r.getRegionInfo().getEncodedName());
        if (destination != null) {
            HLog wal = this.getWAL();
            long closeSeqNum = wal.getEarliestMemstoreSeqNum(r.getRegionInfo().getEncodedNameAsBytes());
            if (closeSeqNum == -1L && (closeSeqNum = r.getOpenSeqNum()) == -1L) {
                closeSeqNum = 0L;
            }
            this.addToMovedRegions(r.getRegionInfo().getEncodedName(), destination, closeSeqNum);
        }
        this.regionFavoredNodesMap.remove(r.getRegionInfo().getEncodedName());
        return toReturn != null;
    }

    protected HRegion getRegion(byte[] regionName) throws NotServingRegionException {
        String encodedRegionName = HRegionInfo.encodeRegionName((byte[])regionName);
        return this.getRegionByEncodedName(encodedRegionName);
    }

    protected HRegion getRegionByEncodedName(String encodedRegionName) throws NotServingRegionException {
        HRegion region = this.onlineRegions.get(encodedRegionName);
        if (region == null) {
            MovedRegionInfo moveInfo = this.getMovedRegion(encodedRegionName);
            if (moveInfo != null) {
                throw new RegionMovedException(moveInfo.getServerName(), moveInfo.getSeqNum());
            }
            Boolean isOpening = (Boolean)this.regionsInTransitionInRS.get(Bytes.toBytes((String)encodedRegionName));
            if (isOpening != null && isOpening.booleanValue()) {
                throw new RegionOpeningException("Region is being opened: " + encodedRegionName);
            }
            throw new NotServingRegionException("Region is not online: " + encodedRegionName);
        }
        return region;
    }

    protected Throwable cleanup(Throwable t) {
        return this.cleanup(t, null);
    }

    protected Throwable cleanup(Throwable t, String msg) {
        if (t instanceof NotServingRegionException) {
            LOG.debug((Object)("NotServingRegionException; " + t.getMessage()));
            return t;
        }
        if (msg == null) {
            LOG.error((Object)"", RemoteExceptionHandler.checkThrowable((Throwable)t));
        } else {
            LOG.error((Object)msg, RemoteExceptionHandler.checkThrowable((Throwable)t));
        }
        if (!this.checkOOME(t)) {
            this.checkFileSystem();
        }
        return t;
    }

    protected IOException convertThrowableToIOE(Throwable t) {
        return this.convertThrowableToIOE(t, null);
    }

    protected IOException convertThrowableToIOE(Throwable t, String msg) {
        return t instanceof IOException ? (IOException)t : (msg == null || msg.length() == 0 ? new IOException(t) : new IOException(msg, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.fatal((Object)"Run out of memory; HRegionServer will abort itself immediately", e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    public boolean checkFileSystem() {
        if (this.fsOk && this.fs != null) {
            try {
                FSUtils.checkFileSystemAvailable((FileSystem)this.fs);
            }
            catch (IOException e) {
                this.abort("File System not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    protected long addScanner(RegionScanner s) throws Leases.LeaseStillHeldException {
        String scannerName;
        RegionScannerHolder existing;
        long scannerId = -1L;
        while ((scannerId = this.rand.nextLong()) == -1L || (existing = this.scanners.putIfAbsent(scannerName = String.valueOf(scannerId), new RegionScannerHolder(s))) != null) {
        }
        this.leases.createLease(scannerName, this.scannerLeaseTimeoutPeriod, new ScannerListener(scannerName));
        return scannerId;
    }

    protected long nextLong() {
        long n = this.rand.nextLong();
        if (n == 0L) {
            return this.nextLong();
        }
        if (n < 0L) {
            n = -n;
        }
        return n;
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTimeMillis();
        try {
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
            ClientProtos.Get get2 = request.getGet();
            Boolean existence = null;
            Result r = null;
            if (request.getClosestRowBefore()) {
                if (get2.getColumnCount() != 1) {
                    throw new DoNotRetryIOException("get ClosestRowBefore supports one and only one family now, not " + get2.getColumnCount() + " families");
                }
                byte[] row = get2.getRow().toByteArray();
                byte[] family = get2.getColumn(0).getFamily().toByteArray();
                r = region.getClosestRowBefore(row, family);
            } else {
                Get clientGet = ProtobufUtil.toGet((ClientProtos.Get)get2);
                if (request.getExistenceOnly() && region.getCoprocessorHost() != null) {
                    existence = region.getCoprocessorHost().preExists(clientGet);
                }
                if (existence == null) {
                    r = region.get(clientGet);
                    if (request.getExistenceOnly()) {
                        boolean exists2;
                        boolean bl = exists2 = r != null && !r.isEmpty();
                        if (region.getCoprocessorHost() != null) {
                            exists2 = region.getCoprocessorHost().postExists(clientGet, exists2);
                        }
                        existence = exists2;
                    }
                }
            }
            if (existence != null) {
                builder.setExists(existence.booleanValue());
            } else if (r != null) {
                builder.setResult(ProtobufUtil.toResult((Result)r));
            }
            ClientProtos.GetResponse getResponse = builder.build();
            return getResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            this.metricsRegionServer.updateGet(EnvironmentEdgeManager.currentTimeMillis() - before);
        }
    }

    public ClientProtos.MultiGetResponse multiGet(RpcController controller, ClientProtos.MultiGetRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTimeMillis();
        try {
            this.requestCount.add((long)request.getGetCount());
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.MultiGetResponse.Builder builder = ClientProtos.MultiGetResponse.newBuilder();
            for (ClientProtos.Get get2 : request.getGetList()) {
                Boolean existence = null;
                Result r = null;
                if (request.getClosestRowBefore()) {
                    if (get2.getColumnCount() != 1) {
                        throw new DoNotRetryIOException("get ClosestRowBefore supports one and only one family now, not " + get2.getColumnCount() + " families");
                    }
                    byte[] row = get2.getRow().toByteArray();
                    byte[] family = get2.getColumn(0).getFamily().toByteArray();
                    r = region.getClosestRowBefore(row, family);
                } else {
                    Get clientGet = ProtobufUtil.toGet((ClientProtos.Get)get2);
                    if (request.getExistenceOnly() && region.getCoprocessorHost() != null) {
                        existence = region.getCoprocessorHost().preExists(clientGet);
                    }
                    if (existence == null) {
                        r = region.get(clientGet);
                        if (request.getExistenceOnly()) {
                            boolean exists2;
                            boolean bl = exists2 = r != null && !r.isEmpty();
                            if (region.getCoprocessorHost() != null) {
                                exists2 = region.getCoprocessorHost().postExists(clientGet, exists2);
                            }
                            existence = exists2;
                        }
                    }
                }
                if (existence != null) {
                    builder.addExists(existence.booleanValue());
                    continue;
                }
                if (r == null) continue;
                builder.addResult(ProtobufUtil.toResult((Result)r));
            }
            ClientProtos.MultiGetResponse multiGetResponse = builder.build();
            return multiGetResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            this.metricsRegionServer.updateGet(EnvironmentEdgeManager.currentTimeMillis() - before);
        }
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
        controller.setCellScanner(null);
        try {
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
            ClientProtos.MutationProto mutation = request.getMutation();
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Result r = null;
            Boolean processed = null;
            ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
            switch (type) {
                case APPEND: {
                    r = this.append(region, mutation, cellScanner);
                    break;
                }
                case INCREMENT: {
                    r = this.increment(region, mutation, cellScanner);
                    break;
                }
                case PUT: {
                    Put put2 = ProtobufUtil.toPut((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                    if (request.hasCondition()) {
                        ClientProtos.Condition condition = request.getCondition();
                        byte[] row = condition.getRow().toByteArray();
                        byte[] family = condition.getFamily().toByteArray();
                        byte[] qualifier = condition.getQualifier().toByteArray();
                        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                        ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                        if (region.getCoprocessorHost() != null) {
                            processed = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, compareOp, comparator, put2);
                        }
                        if (processed != null) break;
                        boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)put2, true);
                        if (region.getCoprocessorHost() != null) {
                            result = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, compareOp, comparator, put2, result);
                        }
                        processed = result;
                        break;
                    }
                    region.put(put2);
                    processed = Boolean.TRUE;
                    break;
                }
                case DELETE: {
                    Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                    if (request.hasCondition()) {
                        ClientProtos.Condition condition = request.getCondition();
                        byte[] row = condition.getRow().toByteArray();
                        byte[] family = condition.getFamily().toByteArray();
                        byte[] qualifier = condition.getQualifier().toByteArray();
                        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                        ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                        if (region.getCoprocessorHost() != null) {
                            processed = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, compareOp, comparator, delete);
                        }
                        if (processed != null) break;
                        boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)delete, true);
                        if (region.getCoprocessorHost() != null) {
                            result = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, compareOp, comparator, delete, result);
                        }
                        processed = result;
                        break;
                    }
                    region.delete(delete);
                    processed = Boolean.TRUE;
                    break;
                }
                default: {
                    throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                }
            }
            Result cellsToReturn = null;
            if (processed != null) {
                builder.setProcessed(processed.booleanValue());
            } else if (r != null) {
                builder.setResult(ProtobufUtil.toResultNoData((Result)r));
                cellsToReturn = r;
            }
            if (cellsToReturn != null) {
                controller.setCellScanner(cellsToReturn.cellScanner());
            }
            return builder.build();
        }
        catch (IOException ie) {
            this.checkFileSystem();
            throw new ServiceException((Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        Leases.Lease lease = null;
        String scannerName = null;
        try {
            if (!request.hasScannerId() && !request.hasScan()) {
                throw new DoNotRetryIOException("Missing required input: scannerId or scan");
            }
            long scannerId = -1L;
            if (request.hasScannerId()) {
                scannerId = request.getScannerId();
                scannerName = String.valueOf(scannerId);
            }
            try {
                this.checkOpen();
            }
            catch (IOException e) {
                if (scannerName != null) {
                    try {
                        this.leases.cancelLease(scannerName);
                    }
                    catch (LeaseException le) {
                        LOG.info((Object)("Server shutting down and client tried to access missing scanner " + scannerName));
                    }
                }
                throw e;
            }
            this.requestCount.increment();
            try {
                int ttl = 0;
                HRegion region = null;
                RegionScanner scanner = null;
                RegionScannerHolder rsh = null;
                boolean moreResults = true;
                boolean closeScanner2 = false;
                ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
                if (request.hasCloseScanner()) {
                    closeScanner2 = request.getCloseScanner();
                }
                int rows = 1;
                if (request.hasNumberOfRows()) {
                    rows = request.getNumberOfRows();
                }
                if (request.hasScannerId()) {
                    rsh = this.scanners.get(scannerName);
                    if (rsh == null) {
                        LOG.info((Object)("Client tried to access missing scanner " + scannerName));
                        throw new UnknownScannerException("Name: " + scannerName + ", already closed?");
                    }
                    scanner = rsh.s;
                    region = this.getRegion(scanner.getRegionInfo().getRegionName());
                } else {
                    region = this.getRegion(request.getRegion());
                    ClientProtos.Scan protoScan = request.getScan();
                    boolean isLoadingCfsOnDemandSet = protoScan.hasLoadColumnFamiliesOnDemand();
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
                    if (!isLoadingCfsOnDemandSet) {
                        scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
                    }
                    byte[] hasMetrics = scan.getAttribute("scan.attributes.metrics.enable");
                    region.prepareScanner(scan);
                    if (region.getCoprocessorHost() != null) {
                        scanner = region.getCoprocessorHost().preScannerOpen(scan);
                    }
                    if (scanner == null) {
                        scanner = region.getScanner(scan);
                    }
                    if (region.getCoprocessorHost() != null) {
                        scanner = region.getCoprocessorHost().postScannerOpen(scan, scanner);
                    }
                    scannerId = this.addScanner(scanner);
                    scannerName = String.valueOf(scannerId);
                    ttl = this.scannerLeaseTimeoutPeriod;
                }
                if (rows > 0) {
                    if (request.hasNextCallSeq()) {
                        if (rsh == null) {
                            rsh = this.scanners.get(scannerName);
                        }
                        if (rsh != null) {
                            if (request.getNextCallSeq() != rsh.nextCallSeq) {
                                throw new OutOfOrderScannerNextException("Expected nextCallSeq: " + rsh.nextCallSeq + " But the nextCallSeq got from client: " + request.getNextCallSeq() + "; request=" + TextFormat.shortDebugString((MessageOrBuilder)request));
                            }
                            rsh.nextCallSeq++;
                        }
                    }
                    try {
                        lease = this.leases.removeLease(scannerName);
                        ArrayList<Result> results = new ArrayList<Result>(rows);
                        long currentScanResultSize = 0L;
                        boolean done = false;
                        if (region != null && region.getCoprocessorHost() != null) {
                            Boolean bypass = region.getCoprocessorHost().preScannerNext(scanner, results, rows);
                            if (!results.isEmpty()) {
                                for (Result r : results) {
                                    if (this.maxScannerResultSize >= Long.MAX_VALUE) continue;
                                    for (KeyValue kv : r.raw()) {
                                        currentScanResultSize += kv.heapSize();
                                    }
                                }
                            }
                            if (bypass != null && bypass.booleanValue()) {
                                done = true;
                            }
                        }
                        if (!done) {
                            long maxResultSize = scanner.getMaxResultSize();
                            if (maxResultSize <= 0L) {
                                maxResultSize = this.maxScannerResultSize;
                            }
                            ArrayList<KeyValue> values = new ArrayList<KeyValue>();
                            MultiVersionConsistencyControl.setThreadReadPoint(scanner.getMvccReadPoint());
                            region.startRegionOperation(HRegion.Operation.SCAN);
                            try {
                                int i;
                                RegionScanner regionScanner = scanner;
                                synchronized (regionScanner) {
                                    for (i = 0; i < rows && currentScanResultSize < maxResultSize; ++i) {
                                        boolean moreRows = scanner.nextRaw(values);
                                        if (!values.isEmpty()) {
                                            if (this.maxScannerResultSize < Long.MAX_VALUE) {
                                                for (KeyValue kv : values) {
                                                    currentScanResultSize += kv.heapSize();
                                                }
                                            }
                                            results.add(new Result(values));
                                        }
                                        if (!moreRows) break;
                                        values.clear();
                                    }
                                }
                                region.readRequestsCount.add((long)i);
                            }
                            finally {
                                region.closeRegionOperation();
                            }
                            if (region != null && region.getCoprocessorHost() != null) {
                                region.getCoprocessorHost().postScannerNext(scanner, results, rows, true);
                            }
                        }
                        if (scanner.isFilterDone() && results.isEmpty()) {
                            moreResults = false;
                            results = null;
                        } else {
                            ClientProtos.ResultCellMeta.Builder rcmBuilder = ClientProtos.ResultCellMeta.newBuilder();
                            ArrayList<Result> cellScannables = new ArrayList<Result>(results.size());
                            for (Result res : results) {
                                cellScannables.add(res);
                                rcmBuilder.addCellsLength(res.size());
                            }
                            builder.setResultCellMeta(rcmBuilder.build());
                            ((PayloadCarryingRpcController)controller).setCellScanner(CellUtil.createCellScanner(cellScannables));
                        }
                    }
                    finally {
                        if (this.scanners.containsKey(scannerName)) {
                            if (lease != null) {
                                this.leases.addLease(lease);
                            }
                            ttl = this.scannerLeaseTimeoutPeriod;
                        }
                    }
                }
                if (!moreResults || closeScanner2) {
                    ttl = 0;
                    moreResults = false;
                    if (region != null && region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(scanner)) {
                        return builder.build();
                    }
                    rsh = this.scanners.remove(scannerName);
                    if (rsh != null) {
                        scanner = rsh.s;
                        scanner.close();
                        this.leases.cancelLease(scannerName);
                        if (region != null && region.getCoprocessorHost() != null) {
                            region.getCoprocessorHost().postScannerClose(scanner);
                        }
                    }
                }
                if (ttl > 0) {
                    builder.setTtl(ttl);
                }
                builder.setScannerId(scannerId);
                builder.setMoreResults(moreResults);
                return builder.build();
            }
            catch (Throwable t) {
                if (scannerName != null && t instanceof NotServingRegionException) {
                    this.scanners.remove(scannerName);
                }
                throw this.convertThrowableToIOE(this.cleanup(t));
            }
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        try {
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
            for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                familyPaths.add((Pair<byte[], String>)new Pair((Object)familyPath.getFamily().toByteArray(), (Object)familyPath.getPath()));
            }
            boolean bypass = false;
            if (region.getCoprocessorHost() != null) {
                bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
            }
            boolean loaded = false;
            if (!bypass) {
                loaded = region.bulkLoadHFiles(familyPaths, request.getAssignSeqNum());
            }
            if (region.getCoprocessorHost() != null) {
                loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
            }
            ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
            builder.setLoaded(loaded);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ServerRpcController execController = new ServerRpcController();
            Message result = region.execService((RpcController)execController, request.getCall());
            if (execController.getFailedOn() != null) {
                throw execController.getFailedOn();
            }
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])region.getRegionName()));
            builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
        controller.setCellScanner(null);
        ArrayList<Result> cellsToReturn = null;
        try {
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
            ArrayList<ClientProtos.MutationProto> mutations = new ArrayList<ClientProtos.MutationProto>(request.getActionCount());
            if (request.hasAtomic() && request.getAtomic()) {
                for (ClientProtos.MultiAction actionUnion : request.getActionList()) {
                    if (actionUnion.hasMutation()) {
                        mutations.add(actionUnion.getMutation());
                        continue;
                    }
                    throw new DoNotRetryIOException("Unsupported atomic action type: " + actionUnion);
                }
                if (!mutations.isEmpty()) {
                    this.mutateRows(region, mutations, cellScanner);
                }
            } else {
                ClientProtos.ActionResult.Builder resultBuilder = null;
                cellsToReturn = new ArrayList<Result>(request.getActionCount());
                for (ClientProtos.MultiAction actionUnion : request.getActionList()) {
                    this.requestCount.increment();
                    ClientProtos.Result result = null;
                    try {
                        if (actionUnion.hasGet()) {
                            Get get2 = ProtobufUtil.toGet((ClientProtos.Get)actionUnion.getGet());
                            Result r = region.get(get2);
                            if (r != null) {
                                result = ProtobufUtil.toResultNoData((Result)r);
                                cellsToReturn.add(r);
                            }
                        } else if (actionUnion.hasMutation()) {
                            ClientProtos.MutationProto mutation = actionUnion.getMutation();
                            ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
                            if (type != ClientProtos.MutationProto.MutationType.PUT && type != ClientProtos.MutationProto.MutationType.DELETE) {
                                if (!mutations.isEmpty()) {
                                    this.doBatchOp(builder, region, mutations, cellScanner);
                                    mutations.clear();
                                } else if (!region.getRegionInfo().isMetaTable()) {
                                    this.cacheFlusher.reclaimMemStoreMemory();
                                }
                            }
                            Result r = null;
                            switch (type) {
                                case APPEND: {
                                    r = this.append(region, mutation, cellScanner);
                                    break;
                                }
                                case INCREMENT: {
                                    r = this.increment(region, mutation, cellScanner);
                                    break;
                                }
                                case PUT: 
                                case DELETE: {
                                    mutations.add(mutation);
                                    break;
                                }
                                default: {
                                    throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                                }
                            }
                            if (r != null) {
                                result = ProtobufUtil.toResultNoData((Result)r);
                                cellsToReturn.add(r);
                            }
                        } else {
                            LOG.warn((Object)("Error: invalid action: " + actionUnion + ". " + "it must be a Get, Mutate, or Exec."));
                            throw new DoNotRetryIOException("Invalid action, it must be a Get, Mutate, or Exec.");
                        }
                        if (result == null) continue;
                        if (resultBuilder == null) {
                            resultBuilder = ClientProtos.ActionResult.newBuilder();
                        } else {
                            resultBuilder.clear();
                        }
                        resultBuilder.setValue(result);
                        builder.addResult(resultBuilder.build());
                    }
                    catch (IOException ie) {
                        builder.addResult(ResponseConverter.buildActionResult((Throwable)ie));
                    }
                }
                if (!mutations.isEmpty()) {
                    this.doBatchOp(builder, region, mutations, cellScanner);
                }
            }
            if (cellsToReturn != null && !cellsToReturn.isEmpty()) {
                controller.setCellScanner(CellUtil.createCellScanner(cellsToReturn));
            }
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            HRegionInfo info = region.getRegionInfo();
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(HRegionInfo.convert((HRegionInfo)info));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(region.getCompactionState());
            }
            builder.setIsRecovering(region.isRecovering());
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        try {
            Set<byte[]> columnFamilies;
            HRegion region = this.getRegion(request.getRegion());
            this.requestCount.increment();
            if (request.getFamilyCount() == 0) {
                columnFamilies = region.getStores().keySet();
            } else {
                columnFamilies = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
                for (ByteString cf : request.getFamilyList()) {
                    columnFamilies.add(cf.toByteArray());
                }
            }
            int nCF = columnFamilies.size();
            List<String> fileList = region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
            AdminProtos.GetStoreFileResponse.Builder builder = AdminProtos.GetStoreFileResponse.newBuilder();
            builder.addAllStoreFile(fileList);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>(this.onlineRegions.size());
            for (HRegion region : this.onlineRegions.values()) {
                list.add(region.getRegionInfo());
            }
            Collections.sort(list);
            return ResponseConverter.buildGetOnlineRegionResponse(list);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.requestCount.increment();
        AdminProtos.OpenRegionResponse.Builder builder = AdminProtos.OpenRegionResponse.newBuilder();
        int regionCount = request.getOpenInfoCount();
        HashMap<TableName, HTableDescriptor> htds = new HashMap<TableName, HTableDescriptor>(regionCount);
        boolean isBulkAssign = regionCount > 1;
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            HRegionInfo region = HRegionInfo.convert((HBaseProtos.RegionInfo)regionOpenInfo.getRegion());
            int versionOfOfflineNode = -1;
            if (regionOpenInfo.hasVersionOfOfflineNode()) {
                versionOfOfflineNode = regionOpenInfo.getVersionOfOfflineNode();
            }
            try {
                Boolean previous;
                HRegion onlineRegion = this.getFromOnlineRegions(region.getEncodedName());
                if (onlineRegion != null) {
                    if (onlineRegion.getCoprocessorHost() != null) {
                        onlineRegion.getCoprocessorHost().preOpen();
                    }
                    Pair p = MetaReader.getRegion((CatalogTracker)this.catalogTracker, (byte[])region.getRegionName());
                    if (this.getServerName().equals(p.getSecond())) {
                        Boolean closing = (Boolean)this.regionsInTransitionInRS.get(region.getEncodedNameAsBytes());
                        if (!Boolean.FALSE.equals(closing) && this.getFromOnlineRegions(region.getEncodedName()) != null) {
                            LOG.warn((Object)("Attempted open of " + region.getEncodedName() + " but already online on this server"));
                            builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED);
                            continue;
                        }
                    } else {
                        LOG.warn((Object)("The region " + region.getEncodedName() + " is online on this server" + " but META does not have this server - continue opening."));
                        this.removeFromOnlineRegions(onlineRegion, null);
                    }
                }
                LOG.info((Object)("Open " + region.getRegionNameAsString()));
                HTableDescriptor htd = (HTableDescriptor)htds.get(region.getTableName());
                if (htd == null) {
                    htd = this.tableDescriptors.get(region.getTableName());
                    htds.put(region.getTableName(), htd);
                }
                if (Boolean.FALSE.equals(previous = this.regionsInTransitionInRS.putIfAbsent(region.getEncodedNameAsBytes(), Boolean.TRUE))) {
                    OpenRegionHandler.tryTransitionFromOfflineToFailedOpen(this, region, versionOfOfflineNode);
                    throw new RegionAlreadyInTransitionException("Received OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to CLOSE ");
                }
                if (Boolean.TRUE.equals(previous)) {
                    LOG.info((Object)("Receiving OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to OPEN" + " - ignoring this new request for this region."));
                }
                this.removeFromMovedRegions(region.getEncodedName());
                if (previous == null) {
                    if (SplitLogManager.isRegionMarkedRecoveringInZK(this.getZooKeeper(), region.getEncodedName())) {
                        this.recoveringRegions.put(region.getEncodedName(), null);
                    }
                    if (region.isMetaRegion()) {
                        this.service.submit(new OpenMetaHandler(this, this, region, htd, versionOfOfflineNode));
                    } else {
                        this.updateRegionFavoredNodesMapping(region.getEncodedName(), regionOpenInfo.getFavoredNodesList());
                        this.service.submit(new OpenRegionHandler(this, this, region, htd, versionOfOfflineNode));
                    }
                }
                builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
            }
            catch (KeeperException zooKeeperEx) {
                LOG.error((Object)"Can't retrieve recovering state from zookeeper", (Throwable)zooKeeperEx);
                throw new ServiceException((Throwable)zooKeeperEx);
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed opening region " + region.getRegionNameAsString()), (Throwable)ie);
                if (isBulkAssign) {
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                    continue;
                }
                throw new ServiceException((Throwable)ie);
            }
        }
        return builder.build();
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
        InetSocketAddress[] addr = new InetSocketAddress[favoredNodes.size()];
        for (int i = 0; i < favoredNodes.size(); ++i) {
            addr[i] = InetSocketAddress.createUnresolved(favoredNodes.get(i).getHostName(), favoredNodes.get(i).getPort());
        }
        this.regionFavoredNodesMap.put(encodedRegionName, addr);
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return this.regionFavoredNodesMap.get(encodedRegionName);
    }

    @QosPriority(priority=100)
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        int versionOfClosingNode = -1;
        if (request.hasVersionOfClosingNode()) {
            versionOfClosingNode = request.getVersionOfClosingNode();
        }
        boolean zk = request.getTransitionInZK();
        ServerName sn = request.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getDestinationServer()) : null;
        try {
            this.checkOpen();
            String encodedRegionName = ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)request.getRegion());
            HRegion region = this.getFromOnlineRegions(encodedRegionName);
            if (region != null && region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().preClose(false);
            }
            this.requestCount.increment();
            LOG.info((Object)("Received close region: " + encodedRegionName + "Transitioning in ZK: " + (zk ? "yes" : "no") + ". Version of ZK closing node:" + versionOfClosingNode + ". Destination server:" + sn));
            boolean closed = this.closeRegion(encodedRegionName, false, zk, versionOfClosingNode, sn);
            AdminProtos.CloseRegionResponse.Builder builder = AdminProtos.CloseRegionResponse.newBuilder().setClosed(closed);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            LOG.info((Object)("Flushing " + region.getRegionNameAsString()));
            boolean shouldFlush = true;
            if (request.hasIfOlderThanTs()) {
                shouldFlush = region.getLastFlushTime() < request.getIfOlderThanTs();
            }
            AdminProtos.FlushRegionResponse.Builder builder = AdminProtos.FlushRegionResponse.newBuilder();
            if (shouldFlush) {
                boolean result = region.flushcache();
                if (result) {
                    this.compactSplitThread.requestSystemCompaction(region, "Compaction through user triggered flush");
                }
                builder.setFlushed(result);
            }
            builder.setLastFlushTime(region.getLastFlushTime());
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.SplitRegionResponse splitRegion(RpcController controller, AdminProtos.SplitRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            region.startRegionOperation(HRegion.Operation.SPLIT_REGION);
            LOG.info((Object)("Splitting " + region.getRegionNameAsString()));
            region.flushcache();
            byte[] splitPoint = null;
            if (request.hasSplitPoint()) {
                splitPoint = request.getSplitPoint().toByteArray();
            }
            region.forceSplit(splitPoint);
            this.compactSplitThread.requestSplit(region, region.checkSplit());
            return AdminProtos.SplitRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.MergeRegionsResponse mergeRegions(RpcController controller, AdminProtos.MergeRegionsRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion regionA = this.getRegion(request.getRegionA());
            HRegion regionB = this.getRegion(request.getRegionB());
            boolean forcible = request.getForcible();
            regionA.startRegionOperation(HRegion.Operation.MERGE_REGION);
            regionB.startRegionOperation(HRegion.Operation.MERGE_REGION);
            LOG.info((Object)("Receiving merging request for  " + regionA + ", " + regionB + ",forcible=" + forcible));
            regionA.flushcache();
            regionB.flushcache();
            this.compactSplitThread.requestRegionsMerge(regionA, regionB, forcible);
            return AdminProtos.MergeRegionsResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            region.startRegionOperation(HRegion.Operation.COMPACT_REGION);
            LOG.info((Object)("Compacting " + region.getRegionNameAsString()));
            boolean major = false;
            byte[] family = null;
            Store store = null;
            if (request.hasFamily() && (store = region.getStore(family = request.getFamily().toByteArray())) == null) {
                throw new ServiceException((Throwable)new IOException("column family " + Bytes.toString((byte[])family) + " does not exist in region " + region.getRegionNameAsString()));
            }
            if (request.hasMajor()) {
                major = request.getMajor();
            }
            if (major) {
                if (family != null) {
                    store.triggerMajorCompaction();
                } else {
                    region.triggerMajorCompaction();
                }
            }
            String familyLogMsg = family != null ? " for column family: " + Bytes.toString((byte[])family) : "";
            LOG.trace((Object)("User-triggered compaction requested for region " + region.getRegionNameAsString() + familyLogMsg));
            String log = "User-triggered " + (major ? "major " : "") + "compaction" + familyLogMsg;
            if (family != null) {
                this.compactSplitThread.requestCompaction(region, store, log, 1, null);
            } else {
                this.compactSplitThread.requestCompaction(region, log, 1, null);
            }
            return AdminProtos.CompactRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=5)
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        try {
            if (this.replicationSinkHandler != null) {
                this.checkOpen();
                this.requestCount.increment();
                this.replicationSinkHandler.replicateLogEntries(request.getEntryList(), ((PayloadCarryingRpcController)controller).cellScanner());
            }
            return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=6)
    public ClientProtos.MultiResponse replay(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTimeMillis();
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
        controller.setCellScanner(null);
        try {
            this.checkOpen();
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
            ArrayList<ClientProtos.MutationProto> mutates = new ArrayList<ClientProtos.MutationProto>();
            for (ClientProtos.MultiAction actionUnion : request.getActionList()) {
                if (actionUnion.hasMutation()) {
                    ClientProtos.MutationProto mutate = actionUnion.getMutation();
                    ClientProtos.MutationProto.MutationType type = mutate.getMutateType();
                    switch (type) {
                        case PUT: 
                        case DELETE: {
                            mutates.add(mutate);
                            break;
                        }
                        default: {
                            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                        }
                    }
                    continue;
                }
                LOG.warn((Object)("Error: invalid action: " + actionUnion + ". " + "it must be a Mutation."));
                throw new DoNotRetryIOException("Invalid action, it must be a Mutation.");
            }
            if (!mutates.isEmpty()) {
                this.doBatchOp(builder, region, mutates, cellScanner, true);
            }
            ClientProtos.MultiResponse multiResponse = builder.build();
            return multiResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            this.metricsRegionServer.updateReplay(EnvironmentEdgeManager.currentTimeMillis() - before);
        }
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        try {
            this.requestCount.increment();
            HLog wal = this.getWAL();
            byte[][] regionsToFlush = wal.rollWriter(true);
            AdminProtos.RollWALWriterResponse.Builder builder = AdminProtos.RollWALWriterResponse.newBuilder();
            if (regionsToFlush != null) {
                for (byte[] region : regionsToFlush) {
                    builder.addRegionToFlush(ByteString.copyFrom((byte[])region));
                }
            }
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        this.requestCount.increment();
        String reason = request.getReason();
        this.stop(reason);
        return AdminProtos.StopServerResponse.newBuilder().build();
    }

    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        ServerName serverName = this.getServerName();
        this.requestCount.increment();
        return ResponseConverter.buildGetServerInfoResponse((ServerName)serverName, (int)this.webuiport);
    }

    protected HRegion getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
        return this.getRegionByEncodedName(ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)regionSpecifier));
    }

    protected Result append(HRegion region, ClientProtos.MutationProto m, CellScanner cellScanner) throws IOException {
        long before = EnvironmentEdgeManager.currentTimeMillis();
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)m, (CellScanner)cellScanner);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preAppend(append);
        }
        if (r == null) {
            r = region.append(append);
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postAppend(append, r);
            }
        }
        this.metricsRegionServer.updateAppend(EnvironmentEdgeManager.currentTimeMillis() - before);
        return r;
    }

    protected Result increment(HRegion region, ClientProtos.MutationProto mutation, CellScanner cells) throws IOException {
        long before = EnvironmentEdgeManager.currentTimeMillis();
        Increment increment2 = ProtobufUtil.toIncrement((ClientProtos.MutationProto)mutation, (CellScanner)cells);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preIncrement(increment2);
        }
        if (r == null) {
            r = region.increment(increment2);
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postIncrement(increment2, r);
            }
        }
        this.metricsRegionServer.updateIncrement(EnvironmentEdgeManager.currentTimeMillis() - before);
        return r;
    }

    protected void doBatchOp(ClientProtos.MultiResponse.Builder builder, HRegion region, List<ClientProtos.MutationProto> mutates, CellScanner cells) {
        this.doBatchOp(builder, region, mutates, cells, false);
    }

    protected void doBatchOp(ClientProtos.MultiResponse.Builder builder, HRegion region, List<ClientProtos.MutationProto> mutations, CellScanner cells, boolean isReplay) {
        Mutation[] mArray = new Mutation[mutations.size()];
        long before = EnvironmentEdgeManager.currentTimeMillis();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            ClientProtos.ActionResult.Builder resultBuilder = ClientProtos.ActionResult.newBuilder();
            resultBuilder.setValue(ClientProtos.Result.newBuilder().build());
            ClientProtos.ActionResult result = resultBuilder.build();
            int i = 0;
            for (ClientProtos.MutationProto m : mutations) {
                Put mutation;
                if (m.getMutateType() == ClientProtos.MutationProto.MutationType.PUT) {
                    mutation = ProtobufUtil.toPut((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsPuts = true;
                } else {
                    mutation = ProtobufUtil.toDelete((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsDelete = true;
                }
                mArray[i++] = mutation;
                builder.addResult(result);
            }
            this.requestCount.add((long)mutations.size());
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] codes = region.batchMutate(mArray, isReplay);
            for (i = 0; i < codes.length; ++i) {
                switch (codes[i].getOperationStatusCode()) {
                    case BAD_FAMILY: {
                        result = ResponseConverter.buildActionResult((Throwable)new NoSuchColumnFamilyException(codes[i].getExceptionMsg()));
                        builder.setResult(i, result);
                        break;
                    }
                    case SANITY_CHECK_FAILURE: {
                        result = ResponseConverter.buildActionResult((Throwable)new FailedSanityCheckException(codes[i].getExceptionMsg()));
                        builder.setResult(i, result);
                        break;
                    }
                    default: {
                        result = ResponseConverter.buildActionResult((Throwable)new DoNotRetryIOException(codes[i].getExceptionMsg()));
                        builder.setResult(i, result);
                    }
                    case SUCCESS: 
                }
                if (!isReplay || codes[i].getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ie) {
            ClientProtos.ActionResult result = ResponseConverter.buildActionResult((Throwable)ie);
            for (int i = 0; i < mutations.size(); ++i) {
                builder.setResult(i, result);
                if (isReplay) break;
            }
        }
        long after = EnvironmentEdgeManager.currentTimeMillis();
        if (batchContainsPuts) {
            this.metricsRegionServer.updatePut(after - before);
        }
        if (batchContainsDelete) {
            this.metricsRegionServer.updateDelete(after - before);
        }
    }

    protected void mutateRows(HRegion region, List<ClientProtos.MutationProto> mutations, CellScanner cellScanner) throws IOException {
        ClientProtos.MutationProto firstMutate = mutations.get(0);
        if (!region.getRegionInfo().isMetaTable()) {
            this.cacheFlusher.reclaimMemStoreMemory();
        }
        byte[] row = firstMutate.getRow().toByteArray();
        RowMutations rm = new RowMutations(row);
        block4: for (ClientProtos.MutationProto mutate : mutations) {
            ClientProtos.MutationProto.MutationType type = mutate.getMutateType();
            switch (mutate.getMutateType()) {
                case PUT: {
                    rm.add(ProtobufUtil.toPut((ClientProtos.MutationProto)mutate, (CellScanner)cellScanner));
                    continue block4;
                }
                case DELETE: {
                    rm.add(ProtobufUtil.toDelete((ClientProtos.MutationProto)mutate, (CellScanner)cellScanner));
                    continue block4;
                }
            }
            throw new DoNotRetryIOException("mutate supports atomic put and/or delete, not " + type.name());
        }
        region.mutateRow(rm);
    }

    protected void addToMovedRegions(String encodedName, ServerName destination, long closeSeqNum) {
        if (ServerName.isSameHostnameAndPort((ServerName)destination, (ServerName)this.getServerName())) {
            LOG.warn((Object)("Not adding moved region record: " + encodedName + " to self."));
            return;
        }
        LOG.info((Object)("Adding moved region record: " + encodedName + " to " + destination.getServerName() + ":" + destination.getPort() + " as of " + closeSeqNum));
        this.movedRegions.put(encodedName, new MovedRegionInfo(destination, closeSeqNum));
    }

    private void removeFromMovedRegions(String encodedName) {
        this.movedRegions.remove(encodedName);
    }

    private MovedRegionInfo getMovedRegion(String encodedRegionName) {
        MovedRegionInfo dest = this.movedRegions.get(encodedRegionName);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (dest != null) {
            if (dest.getMoveTime() > now - 120000L) {
                return dest;
            }
            this.movedRegions.remove(encodedRegionName);
        }
        return null;
    }

    protected void cleanMovedRegions() {
        long cutOff = System.currentTimeMillis() - 120000L;
        Iterator<Map.Entry<String, MovedRegionInfo>> it = this.movedRegions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MovedRegionInfo> e = it.next();
            if (e.getValue().getMoveTime() >= cutOff) continue;
            it.remove();
        }
    }

    private String getMyEphemeralNodePath() {
        return ZKUtil.joinZNode((String)this.zooKeeper.rsZNode, (String)this.getServerName().toString());
    }

    private boolean isHealthCheckerConfigured() {
        String healthScriptLocation = this.conf.get("hbase.node.health.script.location");
        return StringUtils.isNotBlank((String)healthScriptLocation);
    }

    public CompactSplitThread getCompactSplitThread() {
        return this.compactSplitThread;
    }

    private void updateRecoveringRegionLastFlushedSequenceId(HRegion r) throws KeeperException, IOException {
        if (!r.isRecovering()) {
            return;
        }
        HRegionInfo region = r.getRegionInfo();
        ZooKeeperWatcher zkw = this.getZooKeeper();
        String previousRSName = this.getLastFailedRSFromZK(region.getEncodedName());
        Map<byte[], Long> maxSeqIdInStores = r.getMaxStoreSeqIdForLogReplay();
        long minSeqIdForLogReplay = -1L;
        for (byte[] columnFamily : maxSeqIdInStores.keySet()) {
            Long storeSeqIdForReplay = maxSeqIdInStores.get(columnFamily);
            if (minSeqIdForLogReplay != -1L && storeSeqIdForReplay >= minSeqIdForLogReplay) continue;
            minSeqIdForLogReplay = storeSeqIdForReplay;
        }
        long lastRecordedFlushedSequenceId = -1L;
        String nodePath = ZKUtil.joinZNode((String)this.zooKeeper.recoveringRegionsZNode, (String)region.getEncodedName());
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)nodePath);
        if (data != null) {
            lastRecordedFlushedSequenceId = SplitLogManager.parseLastFlushedSequenceIdFrom(data);
        }
        if (data == null || lastRecordedFlushedSequenceId < minSeqIdForLogReplay) {
            ZKUtil.setData((ZooKeeperWatcher)zkw, (String)nodePath, (byte[])ZKUtil.positionToByteArray((long)minSeqIdForLogReplay));
        }
        if (previousRSName != null) {
            nodePath = ZKUtil.joinZNode((String)nodePath, (String)previousRSName);
            ZKUtil.setData((ZooKeeperWatcher)zkw, (String)nodePath, (byte[])ZKUtil.regionSequenceIdsToByteArray((Long)minSeqIdForLogReplay, maxSeqIdInStores));
            LOG.debug((Object)("Update last flushed sequence id of region " + region.getEncodedName() + " for " + previousRSName));
        } else {
            LOG.warn((Object)("Can't find failed region server for recovering region " + region.getEncodedName()));
        }
    }

    private String getLastFailedRSFromZK(String encodedRegionName) throws KeeperException {
        String nodePath;
        String result = null;
        long maxZxid = 0L;
        ZooKeeperWatcher zkw = this.getZooKeeper();
        List failedServers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)(nodePath = ZKUtil.joinZNode((String)zkw.recoveringRegionsZNode, (String)encodedRegionName)));
        if (failedServers == null || failedServers.isEmpty()) {
            return result;
        }
        for (String failedServer : failedServers) {
            String rsPath = ZKUtil.joinZNode((String)nodePath, (String)failedServer);
            Stat stat = new Stat();
            ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)rsPath, (Stat)stat);
            if (maxZxid >= stat.getCzxid()) continue;
            maxZxid = stat.getCzxid();
            result = failedServer;
        }
        return result;
    }

    private static class RegionScannerHolder {
        private RegionScanner s;
        private long nextCallSeq = 0L;

        public RegionScannerHolder(RegionScanner s) {
            this.s = s;
        }
    }

    protected static class MovedRegionsCleaner
    extends Chore
    implements Stoppable {
        private HRegionServer regionServer;
        Stoppable stoppable;

        private MovedRegionsCleaner(HRegionServer regionServer, Stoppable stoppable) {
            super("MovedRegionsCleaner for region " + regionServer, 120000, stoppable);
            this.regionServer = regionServer;
            this.stoppable = stoppable;
        }

        static MovedRegionsCleaner createAndStart(HRegionServer rs) {
            Stoppable stoppable = new Stoppable(){
                private volatile boolean isStopped = false;

                public void stop(String why) {
                    this.isStopped = true;
                }

                public boolean isStopped() {
                    return this.isStopped;
                }
            };
            return new MovedRegionsCleaner(rs, stoppable);
        }

        protected void chore() {
            this.regionServer.cleanMovedRegions();
        }

        public void stop(String why) {
            this.stoppable.stop(why);
        }

        public boolean isStopped() {
            return this.stoppable.isStopped();
        }
    }

    private static class MovedRegionInfo {
        private final ServerName serverName;
        private final long seqNum;
        private final long ts;

        public MovedRegionInfo(ServerName serverName, long closeSeqNum) {
            this.serverName = serverName;
            this.seqNum = closeSeqNum;
            this.ts = EnvironmentEdgeManager.currentTimeMillis();
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public long getSeqNum() {
            return this.seqNum;
        }

        public long getMoveTime() {
            return this.ts;
        }
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        @Override
        public void leaseExpired() {
            RegionScannerHolder rsh = HRegionServer.this.scanners.remove(this.scannerName);
            if (rsh != null) {
                RegionScanner s = rsh.s;
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired on region " + s.getRegionInfo().getRegionNameAsString()));
                try {
                    HRegion region = HRegionServer.this.getRegion(s.getRegionInfo().getRegionName());
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().preScannerClose(s);
                    }
                    s.close();
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(s);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Closing scanner for " + s.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                }
            } else {
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired"));
            }
        }
    }

    class PeriodicMemstoreFlusher
    extends Chore {
        final HRegionServer server;
        static final int RANGE_OF_DELAY = 20000;
        static final int MIN_DELAY_TIME = 3000;

        public PeriodicMemstoreFlusher(int cacheFlushInterval, HRegionServer server) {
            super(server.getServerName() + "-MemstoreFlusherChore", cacheFlushInterval, (Stoppable)server);
            this.server = server;
        }

        protected void chore() {
            for (HRegion r : this.server.onlineRegions.values()) {
                FlushRequester requester;
                if (r == null || !r.shouldFlush() || (requester = this.server.getFlushRequester()) == null) continue;
                long randomDelay = HRegionServer.this.rand.nextInt(20000) + 3000;
                LOG.info((Object)(this.getName() + " requesting flush for region " + r.getRegionNameAsString() + " after a delay of " + randomDelay));
                requester.requestDelayedFlush(r, randomDelay);
            }
        }
    }

    private static class CompactionChecker
    extends Chore {
        private final HRegionServer instance;
        private final int majorCompactPriority;
        private static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;
        private long iteration = 0L;

        CompactionChecker(HRegionServer h, int sleepTime, Stoppable stopper) {
            super("CompactionChecker", sleepTime, (Stoppable)h);
            this.instance = h;
            LOG.info((Object)(this.getName() + " runs every " + org.apache.hadoop.util.StringUtils.formatTime((long)sleepTime)));
            this.majorCompactPriority = this.instance.conf.getInt("hbase.regionserver.compactionChecker.majorCompactPriority", Integer.MAX_VALUE);
        }

        protected void chore() {
            for (HRegion r : this.instance.onlineRegions.values()) {
                if (r == null) continue;
                for (Store s : r.getStores().values()) {
                    try {
                        long multiplier = s.getCompactionCheckMultiplier();
                        assert (multiplier > 0L);
                        if (this.iteration % multiplier != 0L) continue;
                        if (s.needsCompaction()) {
                            this.instance.compactSplitThread.requestSystemCompaction(r, s, this.getName() + " requests compaction");
                            continue;
                        }
                        if (!s.isMajorCompaction()) continue;
                        if (this.majorCompactPriority == Integer.MAX_VALUE || this.majorCompactPriority > r.getCompactPriority()) {
                            this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests major compaction; use default priority", null);
                            continue;
                        }
                        this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests major compaction; use configured priority", this.majorCompactPriority, null);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed major compaction check on " + r), (Throwable)e);
                    }
                }
            }
            this.iteration = this.iteration == Long.MAX_VALUE ? 0L : this.iteration + 1L;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface QosPriority {
        public int priority() default 0;
    }
}

