/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MiniBatchOperationInProgress<T> {
    private final T[] operations;
    private final OperationStatus[] retCodeDetails;
    private final WALEdit[] walEditsFromCoprocessors;
    private final int firstIndex;
    private final int lastIndexExclusive;

    public MiniBatchOperationInProgress(T[] operations, OperationStatus[] retCodeDetails, WALEdit[] walEditsFromCoprocessors, int firstIndex, int lastIndexExclusive) {
        this.operations = operations;
        this.retCodeDetails = retCodeDetails;
        this.walEditsFromCoprocessors = walEditsFromCoprocessors;
        this.firstIndex = firstIndex;
        this.lastIndexExclusive = lastIndexExclusive;
    }

    public int size() {
        return this.lastIndexExclusive - this.firstIndex;
    }

    public T getOperation(int index) {
        return this.operations[this.getAbsoluteIndex(index)];
    }

    public void setOperationStatus(int index, OperationStatus opStatus) {
        this.retCodeDetails[this.getAbsoluteIndex((int)index)] = opStatus;
    }

    public OperationStatus getOperationStatus(int index) {
        return this.retCodeDetails[this.getAbsoluteIndex(index)];
    }

    public void setWalEdit(int index, WALEdit walEdit) {
        this.walEditsFromCoprocessors[this.getAbsoluteIndex((int)index)] = walEdit;
    }

    public WALEdit getWalEdit(int index) {
        return this.walEditsFromCoprocessors[this.getAbsoluteIndex(index)];
    }

    private int getAbsoluteIndex(int index) {
        if (index < 0 || this.firstIndex + index >= this.lastIndexExclusive) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.firstIndex + index;
    }
}

