/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class OpenRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(OpenRegionHandler.class);
    protected final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private final HTableDescriptor htd;
    private boolean tomActivated;
    private int assignmentTimeout;
    private volatile int version = -1;
    private volatile int versionOfOfflineNode = -1;

    public OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, HTableDescriptor htd) {
        this(server, rsServices, regionInfo, htd, EventType.M_RS_OPEN_REGION, -1);
    }

    public OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, HTableDescriptor htd, int versionOfOfflineNode) {
        this(server, rsServices, regionInfo, htd, EventType.M_RS_OPEN_REGION, versionOfOfflineNode);
    }

    protected OpenRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, HTableDescriptor htd, EventType eventType, int versionOfOfflineNode) {
        super(server, eventType);
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.htd = htd;
        this.versionOfOfflineNode = versionOfOfflineNode;
        this.tomActivated = this.server.getConfiguration().getBoolean("hbase.assignment.timeout.management", false);
        this.assignmentTimeout = this.server.getConfiguration().getInt("hbase.master.assignment.timeoutmonitor.period", 10000);
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        String regionName;
        boolean openSuccessful;
        block62: {
            HRegion region;
            boolean transitionedToOpening;
            block60: {
                block61: {
                    block58: {
                        block59: {
                            block56: {
                                block57: {
                                    block54: {
                                        block55: {
                                            String encodedName;
                                            block52: {
                                                block53: {
                                                    block50: {
                                                        block51: {
                                                            block48: {
                                                                block49: {
                                                                    openSuccessful = false;
                                                                    transitionedToOpening = false;
                                                                    regionName = this.regionInfo.getRegionNameAsString();
                                                                    region = null;
                                                                    try {
                                                                        if (!this.server.isStopped() && !this.rsServices.isStopping()) break block48;
                                                                        if (openSuccessful) break block49;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        if (!openSuccessful) {
                                                                            this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                                                                        }
                                                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                                        if (openSuccessful) {
                                                                            if (current == null) {
                                                                                LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                                                                            } else if (Boolean.FALSE.equals(current)) {
                                                                                LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                                                                            }
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                    this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                                                                }
                                                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                                if (openSuccessful) {
                                                                    if (current == null) {
                                                                        LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                                                                    } else if (Boolean.FALSE.equals(current)) {
                                                                        LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                                                                    }
                                                                }
                                                                return;
                                                            }
                                                            encodedName = this.regionInfo.getEncodedName();
                                                            if (this.rsServices.getFromOnlineRegions(encodedName) == null) break block50;
                                                            LOG.error((Object)("Region " + encodedName + " was already online when we started processing the opening. " + "Marking this new attempt as failed"));
                                                            if (openSuccessful) break block51;
                                                            this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                                                        }
                                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                        if (openSuccessful) {
                                                            if (current == null) {
                                                                LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                                                            } else if (Boolean.FALSE.equals(current)) {
                                                                LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    if (this.isRegionStillOpening()) break block52;
                                                    LOG.error((Object)("Region " + encodedName + " opening cancelled"));
                                                    if (openSuccessful) break block53;
                                                    this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                                                }
                                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                                if (openSuccessful) {
                                                    if (current == null) {
                                                        LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                                                    } else if (Boolean.FALSE.equals(current)) {
                                                        LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                                                    }
                                                }
                                                return;
                                            }
                                            if (this.transitionZookeeperOfflineToOpening(encodedName, this.versionOfOfflineNode)) break block54;
                                            LOG.warn((Object)("Region was hijacked? Opening cancelled for encodedName=" + encodedName));
                                            if (openSuccessful) break block55;
                                            this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                                        }
                                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                        if (openSuccessful) {
                                            if (current == null) {
                                                LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                                            } else if (Boolean.FALSE.equals(current)) {
                                                LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                                            }
                                        }
                                        return;
                                    }
                                    transitionedToOpening = true;
                                    region = this.openRegion();
                                    if (region != null) break block56;
                                    if (openSuccessful) break block57;
                                    this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                                }
                                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                                if (openSuccessful) {
                                    if (current == null) {
                                        LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                                    } else if (Boolean.FALSE.equals(current)) {
                                        LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                                    }
                                }
                                return;
                            }
                            region.setRecovering(false);
                            Map<String, HRegion> recoveringRegions = this.rsServices.getRecoveringRegions();
                            if (recoveringRegions != null && !recoveringRegions.isEmpty() && recoveringRegions.containsKey(region.getRegionInfo().getEncodedName())) {
                                region.setRecovering(true);
                                recoveringRegions.put(region.getRegionInfo().getEncodedName(), region);
                            }
                            boolean failed = true;
                            if (this.tickleOpening("post_region_open") && this.updateMeta(region)) {
                                failed = false;
                            }
                            if (!failed && !this.server.isStopped() && !this.rsServices.isStopping()) break block58;
                            if (openSuccessful) break block59;
                            this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                        }
                        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                        if (openSuccessful) {
                            if (current == null) {
                                LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                            } else if (Boolean.FALSE.equals(current)) {
                                LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                            }
                        }
                        return;
                    }
                    if (this.isRegionStillOpening() && this.transitionToOpened(region)) break block60;
                    if (openSuccessful) break block61;
                    this.doCleanUpOnFailedOpen(region, transitionedToOpening);
                }
                Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
                if (openSuccessful) {
                    if (current == null) {
                        LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
                    } else if (Boolean.FALSE.equals(current)) {
                        LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
                    }
                }
                return;
            }
            this.rsServices.addToOnlineRegions(region);
            openSuccessful = true;
            LOG.debug((Object)("Opened " + regionName + " on server:" + this.server.getServerName()));
            if (openSuccessful) break block62;
            this.doCleanUpOnFailedOpen(region, transitionedToOpening);
        }
        Boolean current = (Boolean)this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        if (openSuccessful) {
            if (current == null) {
                LOG.error((Object)("Bad state: we've just opened a region that was NOT in transition. Region=" + regionName));
            } else if (Boolean.FALSE.equals(current)) {
                LOG.error((Object)("Race condition: we've finished to open a region, while a close was requested  on region=" + regionName + ". It can be a critical error, as a region that" + " should be closed is now opened."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCleanUpOnFailedOpen(HRegion region, boolean transitionedToOpening) throws IOException {
        if (transitionedToOpening) {
            try {
                if (region == null) return;
                this.cleanupFailedOpen(region);
                return;
            }
            finally {
                this.tryTransitionFromOpeningToFailedOpen(this.regionInfo);
            }
        } else {
            OpenRegionHandler.tryTransitionFromOfflineToFailedOpen(this.rsServices, this.regionInfo, this.versionOfOfflineNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateMeta(HRegion r) {
        if (this.server.isStopped() || this.rsServices.isStopping()) {
            return false;
        }
        AtomicBoolean signaller = new AtomicBoolean(false);
        PostOpenDeployTasksThread t = new PostOpenDeployTasksThread(r, this.server, this.rsServices, signaller);
        t.start();
        long timeout = this.assignmentTimeout * 10;
        long now = System.currentTimeMillis();
        long endTime = now + timeout;
        long period = Math.max(1, this.assignmentTimeout / 3);
        long lastUpdate = now;
        boolean tickleOpening = true;
        while (!signaller.get() && t.isAlive() && !this.server.isStopped() && !this.rsServices.isStopping() && endTime > now) {
            long elapsed = now - lastUpdate;
            if (elapsed > period) {
                lastUpdate = now;
                tickleOpening = this.tickleOpening("post_open_deploy");
            }
            AtomicBoolean atomicBoolean = signaller;
            synchronized (atomicBoolean) {
                try {
                    signaller.wait(period);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        if (t.isAlive()) {
            if (!signaller.get()) {
                LOG.debug((Object)("Interrupting thread " + t));
                t.interrupt();
            }
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted joining " + r.getRegionInfo().getRegionNameAsString()), (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        return !Thread.interrupted() && t.getException() == null && tickleOpening;
    }

    private boolean transitionToOpened(HRegion r) throws IOException {
        boolean result = false;
        HRegionInfo hri = r.getRegionInfo();
        String name = hri.getRegionNameAsString();
        try {
            if (ZKAssign.transitionNodeOpened((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)hri, (ServerName)this.server.getServerName(), (int)this.version) == -1) {
                LOG.warn((Object)("Completed the OPEN of region " + name + " but when transitioning from " + " OPENING to OPENED got a version mismatch, someone else clashed " + "so now unassigning -- closing region on server: " + this.server.getServerName()));
            } else {
                LOG.debug((Object)("region transitioned to opened in zookeeper: " + r.getRegionInfo() + ", server: " + this.server.getServerName()));
                result = true;
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed transitioning node " + name + " from OPENING to OPENED -- closing region"), (Throwable)e);
        }
        return result;
    }

    private boolean tryTransitionFromOpeningToFailedOpen(HRegionInfo hri) {
        boolean result = false;
        String name = hri.getRegionNameAsString();
        try {
            LOG.info((Object)("Opening of region " + hri + " failed, transitioning" + " from OPENING to FAILED_OPEN in ZK, expecting version " + this.version));
            if (ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)hri, (ServerName)this.server.getServerName(), (EventType)EventType.RS_ZK_REGION_OPENING, (EventType)EventType.RS_ZK_REGION_FAILED_OPEN, (int)this.version) == -1) {
                LOG.warn((Object)("Unable to mark region " + hri + " as FAILED_OPEN. " + "It's likely that the master already timed out this open " + "attempt, and thus another RS already has the region."));
            } else {
                result = true;
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed transitioning node " + name + " from OPENING to FAILED_OPEN"), (Throwable)e);
        }
        return result;
    }

    public static boolean tryTransitionFromOfflineToFailedOpen(RegionServerServices rsServices, HRegionInfo hri, int versionOfOfflineNode) {
        boolean result = false;
        String name = hri.getRegionNameAsString();
        try {
            LOG.info((Object)("Opening of region " + hri + " failed, transitioning" + " from OFFLINE to FAILED_OPEN in ZK, expecting version " + versionOfOfflineNode));
            if (ZKAssign.transitionNode((ZooKeeperWatcher)rsServices.getZooKeeper(), (HRegionInfo)hri, (ServerName)rsServices.getServerName(), (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_FAILED_OPEN, (int)versionOfOfflineNode) == -1) {
                LOG.warn((Object)("Unable to mark region " + hri + " as FAILED_OPEN. " + "It's likely that the master already timed out this open " + "attempt, and thus another RS already has the region."));
            } else {
                result = true;
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed transitioning node " + name + " from OFFLINE to FAILED_OPEN"), (Throwable)e);
        }
        return result;
    }

    HRegion openRegion() {
        HRegion region;
        block2: {
            region = null;
            try {
                region = HRegion.openHRegion(this.regionInfo, this.htd, this.rsServices.getWAL(this.regionInfo), this.server.getConfiguration(), this.rsServices, new CancelableProgressable(){

                    @Override
                    public boolean progress() {
                        return OpenRegionHandler.this.tickleOpening("open_region_progress");
                    }
                });
            }
            catch (Throwable t) {
                RegionServerAccounting rsAccounting;
                LOG.error((Object)("Failed open of region=" + this.regionInfo.getRegionNameAsString() + ", starting to roll back the global memstore size."), t);
                if (this.rsServices == null || (rsAccounting = this.rsServices.getRegionServerAccounting()) == null) break block2;
                rsAccounting.rollbackRegionReplayEditsSize(this.regionInfo.getRegionName());
            }
        }
        return region;
    }

    void cleanupFailedOpen(HRegion region) throws IOException {
        if (region != null) {
            region.close();
        }
    }

    private boolean isRegionStillOpening() {
        byte[] encodedName = this.regionInfo.getEncodedNameAsBytes();
        Boolean action = (Boolean)this.rsServices.getRegionsInTransitionInRS().get(encodedName);
        return Boolean.TRUE.equals(action);
    }

    boolean transitionZookeeperOfflineToOpening(String encodedName, int versionOfOfflineNode) {
        try {
            this.version = ZKAssign.transitionNode((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)this.regionInfo, (ServerName)this.server.getServerName(), (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)versionOfOfflineNode);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error transition from OFFLINE to OPENING for region=" + encodedName), (Throwable)e);
            this.version = -1;
            return false;
        }
        boolean b = this.isGoodVersion();
        if (!b) {
            LOG.warn((Object)("Failed transition from OFFLINE to OPENING for region=" + encodedName));
        }
        return b;
    }

    boolean tickleOpening(String context) {
        if (!this.isRegionStillOpening()) {
            LOG.warn((Object)"Open region aborted since it isn't opening any more");
            return false;
        }
        if (!this.isGoodVersion()) {
            return false;
        }
        String encodedName = this.regionInfo.getEncodedName();
        try {
            this.version = ZKAssign.retransitionNodeOpening((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)this.regionInfo, (ServerName)this.server.getServerName(), (int)this.version, (boolean)this.tomActivated);
        }
        catch (KeeperException e) {
            this.server.abort("Exception refreshing OPENING; region=" + encodedName + ", context=" + context, (Throwable)e);
            this.version = -1;
            return false;
        }
        boolean b = this.isGoodVersion();
        if (!b) {
            LOG.warn((Object)("Failed refreshing OPENING; region=" + encodedName + ", context=" + context));
        }
        return b;
    }

    private boolean isGoodVersion() {
        return this.version != -1;
    }

    static class PostOpenDeployTasksThread
    extends Thread {
        private Exception exception = null;
        private final Server server;
        private final RegionServerServices services;
        private final HRegion region;
        private final AtomicBoolean signaller;

        PostOpenDeployTasksThread(HRegion region, Server server, RegionServerServices services, AtomicBoolean signaller) {
            super("PostOpenDeployTasks:" + region.getRegionInfo().getEncodedName());
            this.setDaemon(true);
            this.server = server;
            this.services = services;
            this.region = region;
            this.signaller = signaller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.services.postOpenDeployTasks(this.region, this.server.getCatalogTracker());
            }
            catch (Exception e) {
                LOG.warn((Object)("Exception running postOpenDeployTasks; region=" + this.region.getRegionInfo().getEncodedName()), (Throwable)e);
                this.exception = e;
            }
            this.signaller.set(true);
            AtomicBoolean atomicBoolean = this.signaller;
            synchronized (atomicBoolean) {
                this.signaller.notify();
            }
        }

        Exception getException() {
            return this.exception;
        }
    }
}

