/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogPrettyPrinter;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.DrainBarrier;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
class FSHLog
implements HLog,
Syncable {
    static final Log LOG = LogFactory.getLog(FSHLog.class);
    private final FileSystem fs;
    private final Path rootDir;
    private final Path dir;
    private final Configuration conf;
    private List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    private final long optionalFlushInterval;
    private final long blocksize;
    private final String prefix;
    private final AtomicLong unflushedEntries = new AtomicLong(0L);
    private volatile long syncedTillHere = 0L;
    private long lastDeferredTxid;
    private final Path oldLogDir;
    private volatile boolean logRollRunning;
    private WALCoprocessorHost coprocessorHost;
    private FSDataOutputStream hdfs_out;
    private int minTolerableReplication;
    private Method getNumCurrentReplicas;
    static final Object[] NO_ARGS = new Object[0];
    private DrainBarrier closeBarrier = new DrainBarrier();
    HLog.Writer writer;
    final SortedMap<Long, Path> outputfiles = Collections.synchronizedSortedMap(new TreeMap());
    private final Object oldestSeqNumsLock = new Object();
    private final Object rollWriterLock = new Object();
    private final ConcurrentSkipListMap<byte[], Long> oldestUnflushedSeqNums = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Long> oldestFlushingSeqNums = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private volatile boolean closed = false;
    private final AtomicLong logSeqNum = new AtomicLong(0L);
    private boolean forMeta = false;
    private volatile long filenum = -1L;
    private final AtomicInteger numEntries = new AtomicInteger(0);
    private AtomicInteger consecutiveLogRolls = new AtomicInteger(0);
    private final int lowReplicationRollLimit;
    private volatile boolean lowReplicationRollEnabled = true;
    private final long logrollsize;
    private final Object updateLock = new Object();
    private final Object flushLock = new Object();
    private final boolean enabled;
    private final int maxLogs;
    private final LogSyncer logSyncer;
    private final int closeErrorsTolerated;
    private final AtomicInteger closeErrorCount = new AtomicInteger();
    private final MetricsWAL metrics;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24));

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, null, true, null, false);
    }

    public FSHLog(FileSystem fs, Path root, String logDir, String oldLogDir, Configuration conf) throws IOException {
        this(fs, root, logDir, oldLogDir, conf, null, true, null, false);
    }

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf, List<WALActionsListener> listeners, String prefix) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, listeners, true, prefix, false);
    }

    public FSHLog(FileSystem fs, Path root, String logDir, String oldLogDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfLogDirExists, String prefix, boolean forMeta) throws IOException {
        this.fs = fs;
        this.rootDir = root;
        this.dir = new Path(this.rootDir, logDir);
        this.oldLogDir = new Path(this.rootDir, oldLogDir);
        this.forMeta = forMeta;
        this.conf = conf;
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.blocksize = this.conf.getLong("hbase.regionserver.hlog.blocksize", FSUtils.getDefaultBlockSize(this.fs, this.dir));
        float multi = conf.getFloat("hbase.regionserver.logroll.multiplier", 0.95f);
        this.logrollsize = (long)((float)this.blocksize * multi);
        this.optionalFlushInterval = conf.getLong("hbase.regionserver.optionallogflushinterval", 1000L);
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", 32);
        this.minTolerableReplication = conf.getInt("hbase.regionserver.hlog.tolerable.lowreplication", (int)FSUtils.getDefaultReplication(fs, this.dir));
        this.lowReplicationRollLimit = conf.getInt("hbase.regionserver.hlog.lowreplication.rolllimit", 5);
        this.enabled = conf.getBoolean("hbase.regionserver.hlog.enabled", true);
        this.closeErrorsTolerated = conf.getInt("hbase.regionserver.logroll.errors.tolerated", 0);
        this.logSyncer = new LogSyncer(this.optionalFlushInterval);
        LOG.info((Object)("WAL/HLog configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", enabled=" + this.enabled + ", optionallogflushinternal=" + this.optionalFlushInterval + "ms"));
        this.prefix = prefix == null || prefix.isEmpty() ? "hlog" : URLEncoder.encode(prefix, "UTF8");
        boolean dirExists = false;
        if (failIfLogDirExists && (dirExists = this.fs.exists(this.dir))) {
            throw new IOException("Target HLog directory already exists: " + this.dir);
        }
        if (!dirExists && !fs.mkdirs(this.dir)) {
            throw new IOException("Unable to mkdir " + this.dir);
        }
        if (!fs.exists(this.oldLogDir) && !fs.mkdirs(this.oldLogDir)) {
            throw new IOException("Unable to mkdir " + this.oldLogDir);
        }
        this.rollWriter();
        this.getNumCurrentReplicas = this.getGetNumCurrentReplicas(this.hdfs_out);
        if (this.optionalFlushInterval > 0L) {
            Threads.setDaemonThreadRunning((Thread)this.logSyncer.getThread(), (String)(Thread.currentThread().getName() + ".logSyncer"));
        } else {
            LOG.info((Object)("hbase.regionserver.optionallogflushinterval is set as " + this.optionalFlushInterval + ". Deferred log syncing won't work. " + "Any Mutation, marked to be deferred synced, will be flushed immediately."));
        }
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
        this.metrics = new MetricsWAL();
    }

    private Method getGetNumCurrentReplicas(FSDataOutputStream os) {
        Method m = null;
        if (os != null) {
            Class<?> wrappedStreamClass = os.getWrappedStream().getClass();
            try {
                m = wrappedStreamClass.getDeclaredMethod("getNumCurrentReplicas", new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Object)("FileSystem's output stream doesn't support getNumCurrentReplicas; --HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()));
            }
            catch (SecurityException e) {
                LOG.info((Object)("Doesn't have access to getNumCurrentReplicas on FileSystems's output stream --HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()), (Throwable)e);
                m = null;
            }
        }
        if (m != null && LOG.isTraceEnabled()) {
            LOG.trace((Object)"Using getNumCurrentReplicas--HDFS-826");
        }
        return m;
    }

    @Override
    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public long getFilenum() {
        return this.filenum;
    }

    @Override
    public void setSequenceNumber(long newvalue) {
        long id = this.logSeqNum.get();
        while (id < newvalue && !this.logSeqNum.compareAndSet(id, newvalue)) {
            LOG.debug((Object)("Changed sequenceid from " + id + " to " + newvalue));
            id = this.logSeqNum.get();
        }
    }

    @Override
    public long getSequenceNumber() {
        return this.logSeqNum.get();
    }

    OutputStream getOutputStream() {
        return this.hdfs_out.getWrappedStream();
    }

    @Override
    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
        Object object = this.rollWriterLock;
        synchronized (object) {
            if (!force && this.writer != null && this.numEntries.get() <= 0) {
                return null;
            }
            byte[][] regionsToFlush = null;
            if (this.closed) {
                LOG.debug((Object)"HLog closed. Skipping rolling of writer");
                return null;
            }
            try {
                this.logRollRunning = true;
                if (!this.closeBarrier.beginOp()) {
                    LOG.debug((Object)"HLog closing. Skipping rolling of writer");
                    byte[][] byArray = regionsToFlush;
                    return byArray;
                }
                long currentFilenum = this.filenum;
                Path oldPath = null;
                if (currentFilenum > 0L) {
                    oldPath = this.computeFilename(currentFilenum);
                }
                this.filenum = System.currentTimeMillis();
                Path newPath = this.computeFilename();
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogRoll(oldPath, newPath);
                    }
                }
                HLog.Writer nextWriter = this.createWriterInstance(this.fs, newPath, this.conf);
                FSDataOutputStream nextHdfsOut = null;
                if (nextWriter instanceof ProtobufLogWriter) {
                    nextHdfsOut = ((ProtobufLogWriter)nextWriter).getStream();
                }
                Path oldFile = null;
                int oldNumEntries = 0;
                Object object2 = this.updateLock;
                synchronized (object2) {
                    oldNumEntries = this.numEntries.get();
                    oldFile = this.cleanupCurrentWriter(currentFilenum);
                    this.writer = nextWriter;
                    this.hdfs_out = nextHdfsOut;
                    this.numEntries.set(0);
                }
                if (oldFile == null) {
                    LOG.info((Object)("New WAL " + FSUtils.getPath(newPath)));
                } else {
                    LOG.info((Object)("Rolled WAL " + FSUtils.getPath(oldFile) + " with entries=" + oldNumEntries + ", filesize=" + StringUtils.humanReadableInt((long)this.fs.getFileStatus(oldFile).getLen()) + "; new WAL " + FSUtils.getPath(newPath)));
                }
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.postLogRoll(oldPath, newPath);
                    }
                }
                if (this.getNumLogFiles() > 0) {
                    this.cleanOldLogs();
                    regionsToFlush = this.getRegionsToForceFlush();
                }
            }
            finally {
                this.logRollRunning = false;
                this.closeBarrier.endOp();
            }
            return regionsToFlush;
        }
    }

    protected HLog.Writer createWriterInstance(FileSystem fs, Path path, Configuration conf) throws IOException {
        if (this.forMeta) {
            // empty if block
        }
        return HLogFactory.createWriter(fs, path, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldLogs() throws IOException {
        long oldestOutstandingSeqNum = Long.MAX_VALUE;
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            Long oldestFlushing = this.oldestFlushingSeqNums.size() > 0 ? Collections.min(this.oldestFlushingSeqNums.values()) : Long.MAX_VALUE;
            Long oldestUnflushed = this.oldestUnflushedSeqNums.size() > 0 ? Collections.min(this.oldestUnflushedSeqNums.values()) : Long.MAX_VALUE;
            oldestOutstandingSeqNum = Math.min(oldestFlushing, oldestUnflushed);
        }
        TreeSet<Long> sequenceNumbers = new TreeSet<Long>(this.outputfiles.headMap(oldestOutstandingSeqNum).keySet());
        if (LOG.isDebugEnabled() && sequenceNumbers.size() > 0) {
            LOG.debug((Object)("Found " + sequenceNumbers.size() + " hlogs to remove" + " out of total " + this.outputfiles.size() + ";" + " oldest outstanding sequenceid is " + oldestOutstandingSeqNum));
        }
        for (Long seq : sequenceNumbers) {
            this.archiveLogFile((Path)this.outputfiles.remove(seq), seq);
        }
    }

    static byte[][] findMemstoresWithEditsEqualOrOlderThan(long walSeqNum, Map<byte[], Long> regionsToSeqNums) {
        ArrayList<byte[]> regions = null;
        for (Map.Entry<byte[], Long> e : regionsToSeqNums.entrySet()) {
            if (e.getValue() > walSeqNum) continue;
            if (regions == null) {
                regions = new ArrayList<byte[]>();
            }
            regions.add(e.getKey());
        }
        return regions == null ? (byte[][])null : (byte[][])regions.toArray((T[])new byte[][]{HConstants.EMPTY_BYTE_ARRAY});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] getRegionsToForceFlush() throws IOException {
        byte[][] regions = null;
        int logCount = this.getNumLogFiles();
        if (logCount > this.maxLogs && logCount > 0) {
            Object object = this.oldestSeqNumsLock;
            synchronized (object) {
                regions = FSHLog.findMemstoresWithEditsEqualOrOlderThan(this.outputfiles.firstKey(), this.oldestUnflushedSeqNums);
            }
            if (regions != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < regions.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(Bytes.toStringBinary((byte[])regions[i]));
                }
                LOG.info((Object)("Too many hlogs: logs=" + logCount + ", maxlogs=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString()));
            }
        }
        return regions;
    }

    Path cleanupCurrentWriter(long currentfilenum) throws IOException {
        Path oldFile = null;
        if (this.writer != null) {
            try {
                if (this.unflushedEntries.get() != this.syncedTillHere) {
                    LOG.debug((Object)("cleanupCurrentWriter  waiting for transactions to get synced  total " + this.unflushedEntries.get() + " synced till here " + this.syncedTillHere));
                    this.sync();
                }
                this.writer.close();
                this.writer = null;
                this.closeErrorCount.set(0);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed close of HLog writer", (Throwable)e);
                int errors = this.closeErrorCount.incrementAndGet();
                if (errors <= this.closeErrorsTolerated && !this.hasDeferredEntries()) {
                    LOG.warn((Object)("Riding over HLog close failure! error count=" + errors));
                }
                if (this.hasDeferredEntries()) {
                    LOG.error((Object)"Aborting due to unflushed edits in HLog");
                }
                FailedLogCloseException flce = new FailedLogCloseException("#" + currentfilenum);
                flce.initCause((Throwable)e);
                throw flce;
            }
            if (currentfilenum >= 0L) {
                oldFile = this.computeFilename(currentfilenum);
                this.outputfiles.put(this.logSeqNum.get(), oldFile);
            }
        }
        return oldFile;
    }

    private void archiveLogFile(Path p, Long seqno) throws IOException {
        Path newPath = FSHLog.getHLogArchivePath(this.oldLogDir, p);
        LOG.info((Object)("moving old hlog file " + FSUtils.getPath(p) + " whose highest sequenceid is " + seqno + " to " + FSUtils.getPath(newPath)));
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        if (!FSUtils.renameAndSetModifyTime(this.fs, p, newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected Path computeFilename() {
        return this.computeFilename(this.filenum);
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("hlog file number can't be < 0");
        }
        String child = this.prefix + "." + filenum;
        if (this.forMeta) {
            child = child + ".meta";
        }
        return new Path(this.dir, child);
    }

    @Override
    public void closeAndDelete() throws IOException {
        this.close();
        if (!this.fs.exists(this.dir)) {
            return;
        }
        FileStatus[] files = this.fs.listStatus(this.dir);
        if (files != null) {
            for (FileStatus file : files) {
                Path p = FSHLog.getHLogArchivePath(this.oldLogDir, file.getPath());
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogArchive(file.getPath(), p);
                    }
                }
                if (!FSUtils.renameAndSetModifyTime(this.fs, file.getPath(), p)) {
                    throw new IOException("Unable to rename " + file.getPath() + " to " + p);
                }
                if (this.listeners.isEmpty()) continue;
                for (WALActionsListener i : this.listeners) {
                    i.postLogArchive(file.getPath(), p);
                }
            }
            LOG.debug((Object)("Moved " + files.length + " WAL file(s) to " + FSUtils.getPath(this.oldLogDir)));
        }
        if (!this.fs.delete(this.dir, true)) {
            LOG.info((Object)("Unable to delete " + this.dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.optionalFlushInterval > 0L) {
            try {
                this.logSyncer.close();
                this.logSyncer.join(this.optionalFlushInterval * 2L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Exception while waiting for syncer thread to die", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        try {
            this.closeBarrier.stopAndDrainOps();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception while waiting for cache flushes and log rolls", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logCloseRequested();
            }
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.closed = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing WAL writer in " + this.dir.toString()));
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    protected HLogKey makeKey(byte[] encodedRegionName, TableName tableName, long seqnum, long now, UUID clusterId) {
        return new HLogKey(encodedRegionName, tableName, seqnum, now, clusterId);
    }

    @Override
    public void append(HRegionInfo info, TableName tableName, WALEdit edits, long now, HTableDescriptor htd) throws IOException {
        this.append(info, tableName, edits, now, htd, true);
    }

    @Override
    public void append(HRegionInfo info, TableName tableName, WALEdit edits, long now, HTableDescriptor htd, boolean isInMemstore) throws IOException {
        this.append(info, tableName, edits, HConstants.DEFAULT_CLUSTER_ID, now, htd, true, isInMemstore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long append(HRegionInfo info, TableName tableName, WALEdit edits, UUID clusterId, long now, HTableDescriptor htd, boolean doSync, boolean isInMemstore) throws IOException {
        if (edits.isEmpty()) {
            return this.unflushedEntries.get();
        }
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        long txid = 0L;
        Object object = this.updateLock;
        synchronized (object) {
            long seqNum = this.obtainSeqNum();
            byte[] encodedRegionName = info.getEncodedNameAsBytes();
            if (isInMemstore) {
                this.oldestUnflushedSeqNums.putIfAbsent(encodedRegionName, seqNum);
            }
            HLogKey logKey = this.makeKey(encodedRegionName, tableName, seqNum, now, clusterId);
            this.doWrite(info, logKey, edits, htd);
            this.numEntries.incrementAndGet();
            txid = this.unflushedEntries.incrementAndGet();
            if (htd.isDeferredLogFlush()) {
                this.lastDeferredTxid = txid;
            }
        }
        if (doSync && (info.isMetaRegion() || !htd.isDeferredLogFlush())) {
            this.sync(txid);
        }
        return txid;
    }

    @Override
    public long appendNoSync(HRegionInfo info, TableName tableName, WALEdit edits, UUID clusterId, long now, HTableDescriptor htd) throws IOException {
        return this.append(info, tableName, edits, clusterId, now, htd, false, true);
    }

    private void syncer() throws IOException {
        this.syncer(this.unflushedEntries.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncer(long txid) throws IOException {
        block31: {
            HLog.Writer tempWriter;
            if (txid <= this.syncedTillHere) {
                return;
            }
            Object object = this.updateLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                tempWriter = this.writer;
            }
            try {
                Object object2;
                long doneUpto;
                long now = EnvironmentEdgeManager.currentTimeMillis();
                IOException ioe = null;
                List<HLog.Entry> pending = null;
                Object object3 = this.flushLock;
                synchronized (object3) {
                    if (txid <= this.syncedTillHere) {
                        return;
                    }
                    doneUpto = this.unflushedEntries.get();
                    pending = this.logSyncer.getPendingWrites();
                    try {
                        this.logSyncer.hlogFlush(tempWriter, pending);
                    }
                    catch (IOException io) {
                        ioe = io;
                        LOG.error((Object)("syncer encountered error, will retry. txid=" + txid), (Throwable)ioe);
                    }
                }
                if (ioe != null && pending != null) {
                    object3 = this.updateLock;
                    synchronized (object3) {
                        object2 = this.flushLock;
                        synchronized (object2) {
                            tempWriter = this.writer;
                            this.logSyncer.hlogFlush(tempWriter, pending);
                        }
                    }
                }
                if (txid <= this.syncedTillHere) {
                    return;
                }
                try {
                    if (tempWriter != null) {
                        tempWriter.sync();
                    }
                }
                catch (IOException ex) {
                    object2 = this.updateLock;
                    synchronized (object2) {
                        tempWriter = this.writer;
                        if (tempWriter != null) {
                            tempWriter.sync();
                        }
                    }
                }
                this.syncedTillHere = Math.max(this.syncedTillHere, doneUpto);
                this.metrics.finishSync(EnvironmentEdgeManager.currentTimeMillis() - now);
                if (this.logRollRunning) break block31;
                this.checkLowReplication();
                try {
                    if (tempWriter.getLength() > this.logrollsize) {
                        this.requestLogRoll();
                    }
                }
                catch (IOException x) {
                    LOG.debug((Object)"Log roll failed and will be retried. (This is not an error)");
                }
            }
            catch (IOException e) {
                LOG.fatal((Object)"Could not sync. Requesting roll of hlog", (Throwable)e);
                this.requestLogRoll();
                throw e;
            }
        }
    }

    private void checkLowReplication() {
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.minTolerableReplication) {
                if (this.lowReplicationRollEnabled) {
                    if (this.consecutiveLogRolls.get() < this.lowReplicationRollLimit) {
                        LOG.warn((Object)("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting no less than " + this.minTolerableReplication + " replicas. " + " Requesting close of hlog."));
                        this.requestLogRoll();
                        this.consecutiveLogRolls.getAndIncrement();
                    } else {
                        LOG.warn((Object)"Too many consecutive RollWriter requests, it's a sign of the total number of live datanodes is lower than the tolerable replicas.");
                        this.consecutiveLogRolls.set(0);
                        this.lowReplicationRollEnabled = false;
                    }
                }
            } else if (numCurrentReplicas >= this.minTolerableReplication && !this.lowReplicationRollEnabled) {
                if (this.numEntries.get() <= 1) {
                    return;
                }
                this.lowReplicationRollEnabled = true;
                LOG.info((Object)"LowReplication-Roller was enabled.");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to invoke DFSOutputStream.getNumCurrentReplicas" + e + " still proceeding ahead..."));
        }
    }

    int getLogReplication() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object repl;
        if (this.getNumCurrentReplicas != null && this.hdfs_out != null && (repl = this.getNumCurrentReplicas.invoke((Object)this.getOutputStream(), NO_ARGS)) instanceof Integer) {
            return (Integer)repl;
        }
        return 0;
    }

    boolean canGetCurReplicas() {
        return this.getNumCurrentReplicas != null;
    }

    @Override
    public void hsync() throws IOException {
        this.syncer();
    }

    @Override
    public void hflush() throws IOException {
        this.syncer();
    }

    @Override
    public void sync() throws IOException {
        this.syncer();
    }

    @Override
    public void sync(long txid) throws IOException {
        this.syncer(txid);
    }

    private void requestLogRoll() {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested();
            }
        }
    }

    protected void doWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit, HTableDescriptor htd) throws IOException {
        if (!this.enabled) {
            return;
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.visitLogEntryBeforeWrite(htd, logKey, logEdit);
            }
        }
        try {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            if (!this.coprocessorHost.preWALWrite(info, logKey, logEdit)) {
                if (logEdit.isReplay()) {
                    logKey.setScopes(null);
                }
                this.logSyncer.append(new HLog.Entry(logKey, logEdit));
            }
            long took = EnvironmentEdgeManager.currentTimeMillis() - now;
            this.coprocessorHost.postWALWrite(info, logKey, logEdit);
            long len = 0L;
            for (KeyValue kv : logEdit.getKeyValues()) {
                len += (long)kv.getLength();
            }
            this.metrics.finishAppend(took, len);
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not append. Requesting close of hlog", (Throwable)e);
            this.requestLogRoll();
            throw e;
        }
    }

    int getNumEntries() {
        return this.numEntries.get();
    }

    @Override
    public long obtainSeqNum() {
        return this.logSeqNum.incrementAndGet();
    }

    int getNumLogFiles() {
        return this.outputfiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long startCacheFlush(byte[] encodedRegionName) {
        Long oldRegionSeqNum = null;
        if (!this.closeBarrier.beginOp()) {
            return null;
        }
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            oldRegionSeqNum = this.oldestUnflushedSeqNums.remove(encodedRegionName);
            if (oldRegionSeqNum != null) {
                Long oldValue = this.oldestFlushingSeqNums.put(encodedRegionName, oldRegionSeqNum);
                assert (oldValue == null) : "Flushing map not cleaned up for " + Bytes.toString((byte[])encodedRegionName);
            }
        }
        if (oldRegionSeqNum == null) {
            LOG.warn((Object)("Couldn't find oldest seqNum for the region we are about to flush: [" + Bytes.toString((byte[])encodedRegionName) + "]"));
        }
        return this.obtainSeqNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeCacheFlush(byte[] encodedRegionName) {
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            this.oldestFlushingSeqNums.remove(encodedRegionName);
        }
        this.closeBarrier.endOp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortCacheFlush(byte[] encodedRegionName) {
        Long currentSeqNum = null;
        Long seqNumBeforeFlushStarts = null;
        Object object = this.oldestSeqNumsLock;
        synchronized (object) {
            seqNumBeforeFlushStarts = this.oldestFlushingSeqNums.remove(encodedRegionName);
            if (seqNumBeforeFlushStarts != null) {
                currentSeqNum = this.oldestUnflushedSeqNums.put(encodedRegionName, seqNumBeforeFlushStarts);
            }
        }
        this.closeBarrier.endOp();
        if (currentSeqNum != null && currentSeqNum <= seqNumBeforeFlushStarts) {
            String errorStr = "Region " + Bytes.toString((byte[])encodedRegionName) + "acquired edits out of order current memstore seq=" + currentSeqNum + ", previous oldest unflushed id=" + seqNumBeforeFlushStarts;
            LOG.error((Object)errorStr);
            assert (false) : errorStr;
            Runtime.getRuntime().halt(1);
        }
    }

    @Override
    public boolean isLowReplicationRollEnabled() {
        return this.lowReplicationRollEnabled;
    }

    protected Path getDir() {
        return this.dir;
    }

    static Path getHLogArchivePath(Path oldLogDir, Path p) {
        return new Path(oldLogDir, p.getName());
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    private static void usage() {
        System.err.println("Usage: HLog <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: HLog --dump hdfs://example.com:9000/hbase/.logs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: HLog --split hdfs://example.com:9000/hbase/.logs/DIR");
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDir()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = FSUtils.getRootDir(conf);
        Path oldLogDir = new Path(baseDir, "oldWALs");
        HLogSplitter.split(baseDir, p, oldLogDir, fs, conf);
    }

    @Override
    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    boolean hasDeferredEntries() {
        return this.lastDeferredTxid > this.syncedTillHere;
    }

    @Override
    public long getEarliestMemstoreSeqNum(byte[] encodedRegionName) {
        Long result = this.oldestUnflushedSeqNums.get(encodedRegionName);
        return result == null ? -1L : result;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            FSHLog.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            HLogPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Path logPath = new Path(args[i]);
                    FSUtils.setFsDefault(conf, logPath);
                    FSHLog.split(conf, logPath);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            FSHLog.usage();
            System.exit(-1);
        }
    }

    class LogSyncer
    extends HasThread {
        private final long optionalFlushInterval;
        private final AtomicBoolean closeLogSyncer = new AtomicBoolean(false);
        private List<HLog.Entry> pendingWrites = new LinkedList<HLog.Entry>();

        LogSyncer(long optionalFlushInterval) {
            this.optionalFlushInterval = optionalFlushInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isInterrupted() && !this.closeLogSyncer.get()) {
                    try {
                        if (FSHLog.this.unflushedEntries.get() <= FSHLog.this.syncedTillHere) {
                            AtomicBoolean atomicBoolean = this.closeLogSyncer;
                            synchronized (atomicBoolean) {
                                this.closeLogSyncer.wait(this.optionalFlushInterval);
                            }
                        }
                        FSHLog.this.sync();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error while syncing, requesting close of hlog ", (Throwable)e);
                        FSHLog.this.requestLogRoll();
                        Threads.sleep((long)this.optionalFlushInterval);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.debug((Object)(this.getName() + " interrupted while waiting for sync requests"));
            }
            finally {
                LOG.info((Object)(this.getName() + " exiting"));
            }
        }

        synchronized void append(HLog.Entry e) throws IOException {
            this.pendingWrites.add(e);
        }

        synchronized List<HLog.Entry> getPendingWrites() {
            List<HLog.Entry> save = this.pendingWrites;
            this.pendingWrites = new LinkedList<HLog.Entry>();
            return save;
        }

        void hlogFlush(HLog.Writer writer, List<HLog.Entry> pending) throws IOException {
            if (pending == null) {
                return;
            }
            for (HLog.Entry e : pending) {
                writer.append(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            AtomicBoolean atomicBoolean = this.closeLogSyncer;
            synchronized (atomicBoolean) {
                this.closeLogSyncer.set(true);
                this.closeLogSyncer.notifyAll();
            }
        }
    }
}

