/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public interface HLog {
    public static final Log LOG = LogFactory.getLog(HLog.class);
    public static final String SPLITTING_EXT = "-splitting";
    public static final boolean SPLIT_SKIP_ERRORS_DEFAULT = false;
    public static final String META_HLOG_FILE_EXTN = ".meta";
    public static final String WAL_TRAILER_WARN_SIZE = "hbase.regionserver.waltrailer.warn.size";
    public static final int DEFAULT_WAL_TRAILER_WARN_SIZE = 0x100000;
    public static final Pattern EDITFILES_NAME_PATTERN = Pattern.compile("-?[0-9]+");
    public static final String RECOVERED_LOG_TMPFILE_SUFFIX = ".temp";

    public void registerWALActionsListener(WALActionsListener var1);

    public boolean unregisterWALActionsListener(WALActionsListener var1);

    public long getFilenum();

    public void setSequenceNumber(long var1);

    public long getSequenceNumber();

    public byte[][] rollWriter() throws FailedLogCloseException, IOException;

    public byte[][] rollWriter(boolean var1) throws FailedLogCloseException, IOException;

    public void close() throws IOException;

    public void closeAndDelete() throws IOException;

    public void append(HRegionInfo var1, TableName var2, WALEdit var3, long var4, HTableDescriptor var6) throws IOException;

    public void append(HRegionInfo var1, TableName var2, WALEdit var3, long var4, HTableDescriptor var6, boolean var7) throws IOException;

    public long appendNoSync(HRegionInfo var1, TableName var2, WALEdit var3, UUID var4, long var5, HTableDescriptor var7) throws IOException;

    public void hsync() throws IOException;

    public void hflush() throws IOException;

    public void sync() throws IOException;

    public void sync(long var1) throws IOException;

    public long obtainSeqNum();

    public Long startCacheFlush(byte[] var1);

    public void completeCacheFlush(byte[] var1);

    public void abortCacheFlush(byte[] var1);

    public WALCoprocessorHost getCoprocessorHost();

    public boolean isLowReplicationRollEnabled();

    public long getEarliestMemstoreSeqNum(byte[] var1);

    public static class Entry
    implements Writable {
        private WALEdit edit;
        private HLogKey key;

        public Entry() {
            this.edit = new WALEdit();
            this.key = new HLogKey();
        }

        public Entry(HLogKey key, WALEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public WALEdit getEdit() {
            return this.edit;
        }

        public HLogKey getKey() {
            return this.key;
        }

        public void setCompressionContext(CompressionContext compressionContext) {
            this.edit.setCompressionContext(compressionContext);
            this.key.setCompressionContext(compressionContext);
        }

        public String toString() {
            return this.key + "=" + this.edit;
        }

        public void write(DataOutput dataOutput) throws IOException {
            this.key.write(dataOutput);
            this.edit.write(dataOutput);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.key.readFields(dataInput);
            this.edit.readFields(dataInput);
        }
    }

    public static interface Writer {
        public void init(FileSystem var1, Path var2, Configuration var3) throws IOException;

        public void close() throws IOException;

        public void sync() throws IOException;

        public void append(Entry var1) throws IOException;

        public long getLength() throws IOException;

        public void setWALTrailer(WALProtos.WALTrailer var1);
    }

    public static interface Reader {
        public void init(FileSystem var1, Path var2, Configuration var3, FSDataInputStream var4) throws IOException;

        public void close() throws IOException;

        public Entry next() throws IOException;

        public Entry next(Entry var1) throws IOException;

        public void seek(long var1) throws IOException;

        public long getPosition() throws IOException;

        public void reset() throws IOException;

        public WALProtos.WALTrailer getWALTrailer();
    }
}

