/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class HLogKey
implements WritableComparable<HLogKey> {
    public static final Log LOG = LogFactory.getLog(HLogKey.class);
    private static final Version VERSION = Version.COMPRESSED;
    private byte[] encodedRegionName;
    private TableName tablename;
    private long logSeqNum;
    private long writeTime;
    private UUID clusterId;
    private NavigableMap<byte[], Integer> scopes;
    private CompressionContext compressionContext;

    public HLogKey() {
        this(null, null, 0L, Long.MAX_VALUE, HConstants.DEFAULT_CLUSTER_ID);
    }

    public HLogKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, UUID clusterId) {
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
        this.clusterId = clusterId;
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
    }

    public HLogKey(WALProtos.WALKey walKey) throws IOException {
        this.readFieldsFromPb(walKey, null);
    }

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public TableName getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public UUID getClusterId() {
        return this.clusterId;
    }

    public NavigableMap<byte[], Integer> getScopes() {
        return this.scopes;
    }

    public void setScopes(NavigableMap<byte[], Integer> scopes) {
        this.scopes = scopes;
    }

    public void setClusterId(UUID clusterId) {
        this.clusterId = clusterId;
    }

    public String toString() {
        return this.tablename + "/" + Bytes.toString((byte[])this.encodedRegionName) + "/" + this.logSeqNum;
    }

    public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", this.tablename);
        stringMap.put("region", Bytes.toStringBinary((byte[])this.encodedRegionName));
        stringMap.put("sequence", this.logSeqNum);
        return stringMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HLogKey)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode((byte[])this.encodedRegionName);
        result = (int)((long)result ^ this.logSeqNum);
        result = (int)((long)result ^ this.writeTime);
        return result ^= this.clusterId.hashCode();
    }

    public int compareTo(HLogKey o) {
        int result = Bytes.compareTo((byte[])this.encodedRegionName, (byte[])o.encodedRegionName);
        if (result == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.writeTime) {
                    result = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result;
    }

    void internTableName(TableName tablename) {
        assert (tablename.equals((Object)this.tablename));
        this.tablename = tablename;
    }

    void internEncodedRegionName(byte[] encodedRegionName) {
        assert (Bytes.equals((byte[])this.encodedRegionName, (byte[])encodedRegionName));
        this.encodedRegionName = encodedRegionName;
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        LOG.warn((Object)"HLogKey is being serialized to writable - only expected in test code");
        WritableUtils.writeVInt((DataOutput)out, (int)HLogKey.VERSION.code);
        if (this.compressionContext == null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.encodedRegionName);
            Bytes.writeByteArray((DataOutput)out, (byte[])this.tablename.getName());
        } else {
            Compressor.writeCompressed(this.encodedRegionName, 0, this.encodedRegionName.length, out, this.compressionContext.regionDict);
            Compressor.writeCompressed(this.tablename.getName(), 0, this.tablename.getName().length, out, this.compressionContext.tableDict);
        }
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
        if (this.clusterId == HConstants.DEFAULT_CLUSTER_ID) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.clusterId.getMostSignificantBits());
            out.writeLong(this.clusterId.getLeastSignificantBits());
        }
    }

    public void readFields(DataInput in) throws IOException {
        Version version = Version.UNVERSIONED;
        this.scopes = null;
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            version = Version.fromCode(len);
            if (this.compressionContext == null || !version.atLeast(Version.COMPRESSED)) {
                len = WritableUtils.readVInt((DataInput)in);
            }
        }
        if (this.compressionContext == null || !version.atLeast(Version.COMPRESSED)) {
            this.encodedRegionName = new byte[len];
            in.readFully(this.encodedRegionName);
            byte[] tablenameBytes = Bytes.readByteArray((DataInput)in);
            this.tablename = TableName.valueOf((byte[])tablenameBytes);
        } else {
            this.encodedRegionName = Compressor.readCompressed(in, this.compressionContext.regionDict);
            byte[] tablenameBytes = Compressor.readCompressed(in, this.compressionContext.tableDict);
            this.tablename = TableName.valueOf((byte[])tablenameBytes);
        }
        this.logSeqNum = in.readLong();
        this.writeTime = in.readLong();
        this.clusterId = HConstants.DEFAULT_CLUSTER_ID;
        if (version.atLeast(Version.INITIAL)) {
            if (in.readBoolean()) {
                this.clusterId = new UUID(in.readLong(), in.readLong());
            }
        } else {
            try {
                in.readByte();
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }

    public WALProtos.WALKey.Builder getBuilder(WALCellCodec.ByteStringCompressor compressor) throws IOException {
        WALProtos.WALKey.Builder builder = WALProtos.WALKey.newBuilder();
        if (this.compressionContext == null) {
            builder.setEncodedRegionName(ByteString.copyFrom((byte[])this.encodedRegionName));
            builder.setTableName(ByteString.copyFrom((byte[])this.tablename.getName()));
        } else {
            builder.setEncodedRegionName(compressor.compress(this.encodedRegionName, this.compressionContext.regionDict));
            builder.setTableName(compressor.compress(this.tablename.getName(), this.compressionContext.tableDict));
        }
        builder.setLogSequenceNumber(this.logSeqNum);
        builder.setWriteTime(this.writeTime);
        if (this.clusterId != HConstants.DEFAULT_CLUSTER_ID) {
            builder.setClusterId(HBaseProtos.UUID.newBuilder().setLeastSigBits(this.clusterId.getLeastSignificantBits()).setMostSigBits(this.clusterId.getMostSignificantBits()));
        }
        if (this.scopes != null) {
            for (Map.Entry e : this.scopes.entrySet()) {
                ByteString family = this.compressionContext == null ? ByteString.copyFrom((byte[])((byte[])e.getKey())) : compressor.compress((byte[])e.getKey(), this.compressionContext.familyDict);
                builder.addScopes(WALProtos.FamilyScope.newBuilder().setFamily(family).setScopeType(WALProtos.ScopeType.valueOf((int)((Integer)e.getValue()))));
            }
        }
        return builder;
    }

    public void readFieldsFromPb(WALProtos.WALKey walKey, WALCellCodec.ByteStringUncompressor uncompressor) throws IOException {
        if (this.compressionContext != null) {
            this.encodedRegionName = uncompressor.uncompress(walKey.getEncodedRegionName(), this.compressionContext.regionDict);
            byte[] tablenameBytes = uncompressor.uncompress(walKey.getTableName(), this.compressionContext.tableDict);
            this.tablename = TableName.valueOf((byte[])tablenameBytes);
        } else {
            this.encodedRegionName = walKey.getEncodedRegionName().toByteArray();
            this.tablename = TableName.valueOf((byte[])walKey.getTableName().toByteArray());
        }
        this.clusterId = HConstants.DEFAULT_CLUSTER_ID;
        if (walKey.hasClusterId()) {
            this.clusterId = new UUID(walKey.getClusterId().getMostSigBits(), walKey.getClusterId().getLeastSigBits());
        }
        this.scopes = null;
        if (walKey.getScopesCount() > 0) {
            this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (WALProtos.FamilyScope scope : walKey.getScopesList()) {
                byte[] family = this.compressionContext == null ? scope.getFamily().toByteArray() : uncompressor.uncompress(scope.getFamily(), this.compressionContext.familyDict);
                this.scopes.put(family, scope.getScopeType().getNumber());
            }
        }
        this.logSeqNum = walKey.getLogSequenceNumber();
        this.writeTime = walKey.getWriteTime();
    }

    static enum Version {
        UNVERSIONED(0),
        INITIAL(-1),
        COMPRESSED(-2);

        final int code;
        static final Version[] byCode;

        private Version(int code) {
            this.code = code;
        }

        boolean atLeast(Version other) {
            return this.code <= other.code;
        }

        static Version fromCode(int code) {
            return byCode[code * -1];
        }

        static {
            byCode = Version.values();
            for (int i = 0; i < byCode.length; ++i) {
                if (Version.byCode[i].code != -1 * i) {
                    throw new AssertionError((Object)"Values in this enum should be descending by one");
                }
            }
        }
    }
}

