/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ProtobufLogReader
extends ReaderBase {
    private static final Log LOG = LogFactory.getLog(ProtobufLogReader.class);
    static final byte[] PB_WAL_MAGIC = Bytes.toBytes((String)"PWAL");
    static final byte[] PB_WAL_COMPLETE_MAGIC = Bytes.toBytes((String)"LAWP");
    private FSDataInputStream inputStream;
    private Codec.Decoder cellDecoder;
    private WALCellCodec.ByteStringUncompressor byteStringUncompressor;
    private boolean hasCompression = false;
    private long walEditsStopOffset;
    private boolean trailerPresent;

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.inputStream.getPos();
    }

    @Override
    public void reset() throws IOException {
        this.initInternal(null, false);
        this.initAfterCompression();
    }

    @Override
    protected void initReader(FSDataInputStream stream) throws IOException {
        this.initInternal(stream, true);
    }

    private void initInternal(FSDataInputStream stream, boolean isFirst) throws IOException {
        this.close();
        long expectedPos = PB_WAL_MAGIC.length;
        if (stream == null) {
            stream = this.fs.open(this.path);
            stream.seek(expectedPos);
        }
        if (stream.getPos() != expectedPos) {
            throw new IOException("The stream is at invalid position: " + stream.getPos());
        }
        WALProtos.WALHeader.Builder builder = WALProtos.WALHeader.newBuilder();
        boolean hasHeader = builder.mergeDelimitedFrom((InputStream)stream);
        if (!hasHeader) {
            throw new EOFException("Couldn't read WAL PB header");
        }
        if (isFirst) {
            WALProtos.WALHeader header = builder.build();
            this.hasCompression = header.hasHasCompression() && header.getHasCompression();
        }
        this.inputStream = stream;
        this.walEditsStopOffset = this.fileLength;
        long currentPosition = stream.getPos();
        this.trailerPresent = this.setTrailerIfPresent();
        this.seekOnFs(currentPosition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After reading the trailer: walEditsStopOffset: " + this.walEditsStopOffset + ", fileLength: " + this.fileLength + ", " + "trailerPresent: " + this.trailerPresent));
        }
    }

    private boolean setTrailerIfPresent() {
        try {
            long trailerSizeOffset = this.fileLength - (long)(PB_WAL_COMPLETE_MAGIC.length + 4);
            if (trailerSizeOffset <= 0L) {
                return false;
            }
            this.seekOnFs(trailerSizeOffset);
            int trailerSize = this.inputStream.readInt();
            ByteBuffer buf = ByteBuffer.allocate(PB_WAL_COMPLETE_MAGIC.length);
            this.inputStream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            if (!Arrays.equals(buf.array(), PB_WAL_COMPLETE_MAGIC)) {
                LOG.warn((Object)"No trailer found.");
                return false;
            }
            if (trailerSize < 0) {
                LOG.warn((Object)("Invalid trailer Size " + trailerSize + ", ignoring the trailer"));
                return false;
            }
            if (trailerSize > this.trailerWarnSize) {
                LOG.warn((Object)("Please investigate WALTrailer usage. Trailer size > maximum configured size : " + trailerSize + " > " + this.trailerWarnSize));
            }
            long positionOfTrailer = trailerSizeOffset - (long)trailerSize;
            this.seekOnFs(positionOfTrailer);
            buf = ByteBuffer.allocate(trailerSize);
            this.inputStream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            this.trailer = WALProtos.WALTrailer.parseFrom((byte[])buf.array());
            this.walEditsStopOffset = positionOfTrailer;
            return true;
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Got IOE while reading the trailer. Continuing as if no trailer is present.", (Throwable)ioe);
            return false;
        }
    }

    @Override
    protected void initAfterCompression() throws IOException {
        WALCellCodec codec = WALCellCodec.create(this.conf, this.compressionContext);
        this.cellDecoder = codec.getDecoder((InputStream)this.inputStream);
        if (this.hasCompression) {
            this.byteStringUncompressor = codec.getByteStringUncompressor();
        }
    }

    @Override
    protected boolean hasCompression() {
        return this.hasCompression;
    }

    @Override
    protected boolean readNext(HLog.Entry entry) throws IOException {
        WALProtos.WALKey walKey;
        while (true) {
            if (this.trailerPresent && this.inputStream.getPos() == this.walEditsStopOffset) {
                return false;
            }
            WALProtos.WALKey.Builder builder = WALProtos.WALKey.newBuilder();
            boolean hasNext = false;
            try {
                hasNext = builder.mergeDelimitedFrom((InputStream)this.inputStream);
            }
            catch (InvalidProtocolBufferException ipbe) {
                LOG.error((Object)"Invalid PB while reading WAL, probably an unexpected EOF, ignoring", (Throwable)ipbe);
            }
            if (!hasNext) {
                return false;
            }
            if (!builder.isInitialized()) {
                LOG.error((Object)"Partial PB while reading WAL, probably an unexpected EOF, ignoring");
                return false;
            }
            walKey = builder.build();
            entry.getKey().readFieldsFromPb(walKey, this.byteStringUncompressor);
            if (walKey.hasFollowingKvCount() && 0 != walKey.getFollowingKvCount()) break;
            LOG.warn((Object)"WALKey has no KVs that follow it; trying the next one");
        }
        int expectedCells = walKey.getFollowingKvCount();
        long posBefore = this.inputStream.getPos();
        try {
            int actualCells = entry.getEdit().readFromCells(this.cellDecoder, expectedCells);
            if (expectedCells != actualCells) {
                throw new EOFException("Only read " + actualCells);
            }
        }
        catch (Exception ex) {
            String posAfterStr = "<unknown>";
            try {
                posAfterStr = this.inputStream.getPos() + "";
            }
            catch (Throwable t) {
                LOG.trace((Object)"Error getting pos for error message - ignoring", t);
            }
            String message = " while reading " + expectedCells + " WAL KVs; started reading at " + posBefore + " and read up to " + posAfterStr;
            IOException realEofEx = this.extractHiddenEof(ex);
            if (realEofEx != null) {
                LOG.error((Object)("EOF " + message), (Throwable)realEofEx);
                return false;
            }
            message = "Error " + message;
            LOG.error((Object)message);
            throw new IOException(message, ex);
        }
        if (this.trailerPresent && this.inputStream.getPos() > this.walEditsStopOffset) {
            LOG.error((Object)("Read WALTrailer while reading WALEdits. hlog: " + this.path + ", inputStream.getPos(): " + this.inputStream.getPos() + ", walEditsStopOffset: " + this.walEditsStopOffset));
            throw new IOException("Read WALTrailer while reading WALEdits");
        }
        return true;
    }

    private IOException extractHiddenEof(Exception ex) {
        IOException ioEx = null;
        if (ex instanceof EOFException) {
            return (EOFException)ex;
        }
        if (ex instanceof IOException) {
            ioEx = (IOException)ex;
        } else if (ex instanceof RuntimeException && ex.getCause() != null && ex.getCause() instanceof IOException) {
            ioEx = (IOException)ex.getCause();
        }
        if (ioEx != null) {
            if (ioEx.getMessage().contains("EOF")) {
                return ioEx;
            }
            return null;
        }
        return null;
    }

    @Override
    public WALProtos.WALTrailer getWALTrailer() {
        return this.trailer;
    }

    @Override
    protected void seekOnFs(long pos) throws IOException {
        this.inputStream.seek(pos);
    }
}

