/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.Dictionary;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.io.IOUtils;

public class WALCellCodec
implements Codec {
    public static final String WAL_CELL_CODEC_CLASS_KEY = "hbase.regionserver.wal.codec";
    private final CompressionContext compression;
    private final ByteStringUncompressor statelessUncompressor = new ByteStringUncompressor(){

        @Override
        public byte[] uncompress(ByteString data, Dictionary dict) throws IOException {
            return WALCellCodec.uncompressByteString(data, dict);
        }
    };

    public WALCellCodec(Configuration conf, CompressionContext compression) {
        this.compression = compression;
    }

    public static WALCellCodec create(Configuration conf, CompressionContext compression) throws UnsupportedOperationException {
        String className = conf.get(WAL_CELL_CODEC_CLASS_KEY, WALCellCodec.class.getName());
        return (WALCellCodec)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class, CompressionContext.class}, (Object[])new Object[]{conf, compression});
    }

    private static byte[] uncompressByteString(ByteString bs, Dictionary dict) throws IOException {
        InputStream in = bs.newInput();
        byte status = (byte)in.read();
        if (status == -1) {
            byte[] arr = new byte[StreamUtils.readRawVarint32(in)];
            int bytesRead = in.read(arr);
            if (bytesRead != arr.length) {
                throw new IOException("Cannot read; wanted " + arr.length + ", but got " + bytesRead);
            }
            if (dict != null) {
                dict.addEntry(arr, 0, arr.length);
            }
            return arr;
        }
        short dictIdx = StreamUtils.toShort(status, (byte)in.read());
        byte[] entry = dict.getEntry(dictIdx);
        if (entry == null) {
            throw new IOException("Missing dictionary entry for index " + dictIdx);
        }
        return entry;
    }

    public Codec.Decoder getDecoder(InputStream is) {
        return this.compression == null ? new KeyValueCodec.KeyValueDecoder(is) : new CompressedKvDecoder(is, this.compression);
    }

    public Codec.Encoder getEncoder(OutputStream os) {
        return this.compression == null ? new EnsureKvEncoder(os) : new CompressedKvEncoder(os, this.compression);
    }

    public ByteStringCompressor getByteStringCompressor() {
        return new BaosAndCompressor();
    }

    public ByteStringUncompressor getByteStringUncompressor() {
        return this.statelessUncompressor;
    }

    private static class StreamUtils {
        private StreamUtils() {
        }

        public static int computeRawVarint32Size(int value) {
            if ((value & 0xFFFFFF80) == 0) {
                return 1;
            }
            if ((value & 0xFFFFC000) == 0) {
                return 2;
            }
            if ((value & 0xFFE00000) == 0) {
                return 3;
            }
            if ((value & 0xF0000000) == 0) {
                return 4;
            }
            return 5;
        }

        static void writeRawVInt32(OutputStream output, int value) throws IOException {
            assert (value >= 0);
            while (true) {
                if ((value & 0xFFFFFF80) == 0) {
                    output.write(value);
                    return;
                }
                output.write(value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        static int readRawVarint32(InputStream input) throws IOException {
            byte tmp = (byte)input.read();
            if (tmp >= 0) {
                return tmp;
            }
            int result = tmp & 0x7F;
            tmp = (byte)input.read();
            if (tmp >= 0) {
                result |= tmp << 7;
            } else {
                result |= (tmp & 0x7F) << 7;
                tmp = (byte)input.read();
                if (tmp >= 0) {
                    result |= tmp << 14;
                } else {
                    result |= (tmp & 0x7F) << 14;
                    tmp = (byte)input.read();
                    if (tmp >= 0) {
                        result |= tmp << 21;
                    } else {
                        result |= (tmp & 0x7F) << 21;
                        tmp = (byte)input.read();
                        result |= tmp << 28;
                        if (tmp < 0) {
                            for (int i = 0; i < 5; ++i) {
                                if (input.read() < 0) continue;
                                return result;
                            }
                            throw new IOException("Malformed varint");
                        }
                    }
                }
            }
            return result;
        }

        static short toShort(byte hi, byte lo) {
            short s = (short)((hi & 0xFF) << 8 | lo & 0xFF);
            Preconditions.checkArgument((s >= 0 ? 1 : 0) != 0);
            return s;
        }

        static void writeShort(OutputStream out, short v) throws IOException {
            Preconditions.checkArgument((v >= 0 ? 1 : 0) != 0);
            out.write((byte)(0xFF & v >> 8));
            out.write((byte)(0xFF & v));
        }
    }

    public class EnsureKvEncoder
    extends KeyValueCodec.KeyValueEncoder {
        public EnsureKvEncoder(OutputStream out) {
            super(out);
        }

        public void write(Cell cell) throws IOException {
            if (!(cell instanceof KeyValue)) {
                throw new IOException("Cannot write non-KV cells to WAL");
            }
            super.write(cell);
        }
    }

    static class CompressedKvDecoder
    extends BaseDecoder {
        private final CompressionContext compression;

        public CompressedKvDecoder(InputStream in, CompressionContext compression) {
            super(in);
            this.compression = compression;
        }

        protected Cell parseCell() throws IOException {
            int keylength = StreamUtils.readRawVarint32(this.in);
            int vlength = StreamUtils.readRawVarint32(this.in);
            int length = 8 + keylength + vlength;
            byte[] backingArray = new byte[length];
            int pos = 0;
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)keylength);
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)vlength);
            int elemLen = this.readIntoArray(backingArray, pos + 2, this.compression.rowDict);
            CompressedKvDecoder.checkLength(elemLen, Short.MAX_VALUE);
            pos = Bytes.putShort((byte[])backingArray, (int)pos, (short)((short)elemLen));
            pos += elemLen;
            elemLen = this.readIntoArray(backingArray, pos + 1, this.compression.familyDict);
            CompressedKvDecoder.checkLength(elemLen, 127);
            pos = Bytes.putByte((byte[])backingArray, (int)pos, (byte)((byte)elemLen));
            pos += elemLen;
            elemLen = this.readIntoArray(backingArray, pos, this.compression.qualifierDict);
            IOUtils.readFully((InputStream)this.in, (byte[])backingArray, (int)(pos += elemLen), (int)(length - pos));
            return new KeyValue(backingArray);
        }

        private int readIntoArray(byte[] to, int offset, Dictionary dict) throws IOException {
            byte status = (byte)this.in.read();
            if (status == -1) {
                int length = StreamUtils.readRawVarint32(this.in);
                IOUtils.readFully((InputStream)this.in, (byte[])to, (int)offset, (int)length);
                dict.addEntry(to, offset, length);
                return length;
            }
            short dictIdx = StreamUtils.toShort(status, (byte)this.in.read());
            byte[] entry = dict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            Bytes.putBytes((byte[])to, (int)offset, (byte[])entry, (int)0, (int)entry.length);
            return entry.length;
        }

        private static void checkLength(int len, int max) throws IOException {
            if (len < 0 || len > max) {
                throw new IOException("Invalid length for compresesed portion of keyvalue: " + len);
            }
        }
    }

    static class CompressedKvEncoder
    extends BaseEncoder {
        private final CompressionContext compression;

        public CompressedKvEncoder(OutputStream out, CompressionContext compression) {
            super(out);
            this.compression = compression;
        }

        public void write(Cell cell) throws IOException {
            if (!(cell instanceof KeyValue)) {
                throw new IOException("Cannot write non-KV cells to WAL");
            }
            KeyValue kv = (KeyValue)cell;
            byte[] kvBuffer = kv.getBuffer();
            int offset = kv.getOffset();
            StreamUtils.writeRawVInt32(this.out, kv.getKeyLength());
            StreamUtils.writeRawVInt32(this.out, kv.getValueLength());
            this.write(kvBuffer, kv.getRowOffset(), kv.getRowLength(), this.compression.rowDict);
            this.write(kvBuffer, kv.getFamilyOffset(), kv.getFamilyLength(), this.compression.familyDict);
            this.write(kvBuffer, kv.getQualifierOffset(), kv.getQualifierLength(), this.compression.qualifierDict);
            int pos = kv.getTimestampOffset();
            int remainingLength = kv.getLength() + offset - pos;
            this.out.write(kvBuffer, pos, remainingLength);
        }

        private void write(byte[] data, int offset, int length, Dictionary dict) throws IOException {
            short dictIdx = -1;
            if (dict != null) {
                dictIdx = dict.findEntry(data, offset, length);
            }
            if (dictIdx == -1) {
                this.out.write(-1);
                StreamUtils.writeRawVInt32(this.out, length);
                this.out.write(data, offset, length);
            } else {
                StreamUtils.writeShort(this.out, dictIdx);
            }
        }
    }

    static class BaosAndCompressor
    extends ByteArrayOutputStream
    implements ByteStringCompressor {
        BaosAndCompressor() {
        }

        public ByteString toByteString() {
            return ByteString.copyFrom((byte[])this.buf, (int)0, (int)this.count);
        }

        @Override
        public ByteString compress(byte[] data, Dictionary dict) throws IOException {
            this.writeCompressed(data, dict);
            ByteString result = ByteString.copyFrom((byte[])this.buf, (int)0, (int)this.count);
            this.reset();
            return result;
        }

        private void writeCompressed(byte[] data, Dictionary dict) throws IOException {
            assert (dict != null);
            short dictIdx = dict.findEntry(data, 0, data.length);
            if (dictIdx == -1) {
                this.write(-1);
                StreamUtils.writeRawVInt32(this, data.length);
                this.write(data, 0, data.length);
            } else {
                StreamUtils.writeShort(this, dictIdx);
            }
        }
    }

    public static interface ByteStringUncompressor {
        public byte[] uncompress(ByteString var1, Dictionary var2) throws IOException;
    }

    public static interface ByteStringCompressor {
        public ByteString compress(byte[] var1, Dictionary var2) throws IOException;
    }
}

