/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.security.PrivilegedAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionWrapper;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.MetricsREST;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class RESTServlet
implements Constants {
    private static RESTServlet INSTANCE;
    private final Configuration conf;
    private final HTablePool pool;
    private final MetricsREST metrics = new MetricsREST();
    private final HBaseAdmin admin;
    private final UserGroupInformation ugi;

    public static synchronized RESTServlet getInstance() throws IOException {
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public static synchronized RESTServlet getInstance(Configuration conf) throws IOException {
        return RESTServlet.getInstance(conf, null);
    }

    public static synchronized RESTServlet getInstance(Configuration conf, UserGroupInformation ugi) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new RESTServlet(conf, ugi);
        }
        return INSTANCE;
    }

    public static synchronized void stop() {
        if (INSTANCE != null) {
            INSTANCE = null;
        }
    }

    RESTServlet(Configuration conf, final UserGroupInformation ugi) throws IOException {
        this.conf = conf;
        this.ugi = ugi;
        int maxSize = conf.getInt("hbase.rest.htablepool.size", 10);
        if (ugi == null) {
            this.pool = new HTablePool(conf, maxSize);
            this.admin = new HBaseAdmin(conf);
        } else {
            this.admin = new HBaseAdmin((HConnection)new HConnectionWrapper(ugi, HConnectionManager.getConnection((Configuration)new Configuration(conf))));
            this.pool = new HTablePool(conf, maxSize){

                protected HTableInterface createHTable(final String tableName) {
                    return (HTableInterface)ugi.doAs((PrivilegedAction)new PrivilegedAction<HTableInterface>(){

                        @Override
                        public HTableInterface run() {
                            return this.callCreateHTable(tableName);
                        }
                    });
                }

                HTableInterface callCreateHTable(String tableName) {
                    return super.createHTable(tableName);
                }
            };
        }
    }

    HBaseAdmin getAdmin() {
        return this.admin;
    }

    HTablePool getTablePool() {
        return this.pool;
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    MetricsREST getMetrics() {
        return this.metrics;
    }

    boolean isReadOnly() {
        return this.getConfiguration().getBoolean("hbase.rest.readonly", false);
    }

    UserGroupInformation getUser() {
        return this.ugi;
    }
}

