/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class SchemaResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(SchemaResource.class);
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public SchemaResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTableDescriptor getTableSchema() throws IOException, TableNotFoundException {
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = pool.getTable(this.tableResource.getName());
        try {
            HTableDescriptor hTableDescriptor = table.getTableDescriptor();
            return hTableDescriptor;
        }
        finally {
            table.close();
        }
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            Response.ResponseBuilder response = Response.ok((Object)new TableSchemaModel(this.getTableSchema()));
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (TableNotFoundException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    private Response replace(byte[] name, TableSchemaModel model, UriInfo uriInfo, HBaseAdmin admin) {
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        try {
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])name));
            for (Map.Entry<QName, Object> e : model.getAny().entrySet()) {
                htd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
            }
            for (ColumnSchemaModel family : model.getColumns()) {
                HColumnDescriptor hcd = new HColumnDescriptor(family.getName());
                for (Map.Entry<QName, Object> e : family.getAny().entrySet()) {
                    hcd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
                }
                htd.addFamily(hcd);
            }
            if (admin.tableExists(name)) {
                admin.disableTable(name);
                admin.modifyTable(name, htd);
                admin.enableTable(name);
                this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            } else {
                try {
                    admin.createTable(htd);
                    this.servlet.getMetrics().incrementSucessfulPutRequests(1);
                }
                catch (TableExistsException e) {
                    return Response.status((Response.Status)Response.Status.NOT_MODIFIED).type("text/plain").entity((Object)"Not modified\r\n").build();
                }
            }
            return Response.created((URI)uriInfo.getAbsolutePath()).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response update(byte[] name, TableSchemaModel model, UriInfo uriInfo, HBaseAdmin admin) {
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        try {
            HTableDescriptor htd = admin.getTableDescriptor(name);
            admin.disableTable(name);
            try {
                for (ColumnSchemaModel family : model.getColumns()) {
                    HColumnDescriptor hcd = new HColumnDescriptor(family.getName());
                    for (Map.Entry<QName, Object> e : family.getAny().entrySet()) {
                        hcd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
                    }
                    if (htd.hasFamily(hcd.getName())) {
                        admin.modifyColumn(name, hcd);
                        continue;
                    }
                    admin.addColumn(name, hcd);
                }
            }
            catch (IOException e) {
                Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
                return response;
            }
            finally {
                admin.enableTable(this.tableResource.getName());
            }
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            return Response.ok().build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    private Response update(TableSchemaModel model, boolean replace, UriInfo uriInfo) {
        try {
            byte[] name = Bytes.toBytes((String)this.tableResource.getName());
            HBaseAdmin admin = this.servlet.getAdmin();
            if (replace || !admin.tableExists(name)) {
                return this.replace(name, model, uriInfo, admin);
            }
            return this.update(name, model, uriInfo, admin);
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response put(TableSchemaModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        return this.update(model, true, uriInfo);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response post(TableSchemaModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        return this.update(model, false, uriInfo);
    }

    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            HBaseAdmin admin = this.servlet.getAdmin();
            boolean success = false;
            for (int i = 0; i < 10; ++i) {
                try {
                    admin.disableTable(this.tableResource.getName());
                    success = true;
                    break;
                }
                catch (IOException e) {
                    continue;
                }
            }
            if (!success) {
                throw new IOException("could not disable table");
            }
            admin.deleteTable(this.tableResource.getName());
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            return Response.ok().build();
        }
        catch (TableNotFoundException e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

