/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.SnapshotLogSplitter;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class RestoreSnapshotHelper {
    private static final Log LOG = LogFactory.getLog(RestoreSnapshotHelper.class);
    private final Map<byte[], byte[]> regionsMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private final Map<String, Pair<String, String>> parentsMap = new HashMap<String, Pair<String, String>>();
    private final ForeignExceptionDispatcher monitor;
    private final MonitoredTask status;
    private final HBaseProtos.SnapshotDescription snapshotDesc;
    private final TableName snapshotTable;
    private final Path snapshotDir;
    private final HTableDescriptor tableDesc;
    private final Path rootDir;
    private final Path tableDir;
    private final Configuration conf;
    private final FileSystem fs;

    public RestoreSnapshotHelper(Configuration conf, FileSystem fs, HBaseProtos.SnapshotDescription snapshotDescription, Path snapshotDir, HTableDescriptor tableDescriptor, Path rootDir, ForeignExceptionDispatcher monitor, MonitoredTask status) {
        this.fs = fs;
        this.conf = conf;
        this.snapshotDesc = snapshotDescription;
        this.snapshotTable = TableName.valueOf((String)snapshotDescription.getTable());
        this.snapshotDir = snapshotDir;
        this.tableDesc = tableDescriptor;
        this.rootDir = rootDir;
        this.tableDir = FSUtils.getTableDir(rootDir, this.tableDesc.getTableName());
        this.monitor = monitor;
        this.status = status;
    }

    public RestoreMetaChanges restoreHdfsRegions() throws IOException {
        LOG.debug((Object)"starting restore");
        Set<String> snapshotRegionNames = SnapshotReferenceUtil.getSnapshotRegionNames(this.fs, this.snapshotDir);
        if (snapshotRegionNames == null) {
            LOG.warn((Object)("Nothing to restore. Snapshot " + this.snapshotDesc + " looks empty"));
            return null;
        }
        RestoreMetaChanges metaChanges = new RestoreMetaChanges(this.parentsMap);
        List<HRegionInfo> tableRegions = this.getTableRegions();
        if (tableRegions != null) {
            this.monitor.rethrowException();
            for (HRegionInfo regionInfo : tableRegions) {
                String regionName = regionInfo.getEncodedName();
                if (snapshotRegionNames.contains(regionName)) {
                    LOG.info((Object)("region to restore: " + regionName));
                    snapshotRegionNames.remove(regionName);
                    metaChanges.addRegionToRestore(regionInfo);
                    continue;
                }
                LOG.info((Object)("region to remove: " + regionName));
                metaChanges.addRegionToRemove(regionInfo);
            }
            this.monitor.rethrowException();
            this.status.setStatus("Restoring table regions...");
            this.restoreHdfsRegions(metaChanges.getRegionsToRestore());
            this.status.setStatus("Finished restoring all table regions.");
            this.monitor.rethrowException();
            this.status.setStatus("Starting to delete excess regions from table");
            this.removeHdfsRegions(metaChanges.getRegionsToRemove());
            this.status.setStatus("Finished deleting excess regions from table.");
        }
        if (snapshotRegionNames.size() > 0) {
            LinkedList<HRegionInfo> regionsToAdd = new LinkedList<HRegionInfo>();
            this.monitor.rethrowException();
            for (String regionName : snapshotRegionNames) {
                LOG.info((Object)("region to add: " + regionName));
                Path regionDir = new Path(this.snapshotDir, regionName);
                regionsToAdd.add(HRegionFileSystem.loadRegionInfoFileContent(this.fs, regionDir));
            }
            this.monitor.rethrowException();
            this.status.setStatus("Cloning regions...");
            HRegionInfo[] clonedRegions = this.cloneHdfsRegions(regionsToAdd);
            metaChanges.setNewRegions(clonedRegions);
            this.status.setStatus("Finished cloning regions.");
        }
        this.monitor.rethrowException();
        this.status.setStatus("Restoring WALs to table...");
        this.restoreWALs();
        this.status.setStatus("Finished restoring WALs to table.");
        return metaChanges;
    }

    private void removeHdfsRegions(List<HRegionInfo> regions) throws IOException {
        if (regions != null && regions.size() > 0) {
            for (HRegionInfo hri : regions) {
                HFileArchiver.archiveRegion(this.conf, this.fs, hri);
            }
        }
    }

    private void restoreHdfsRegions(List<HRegionInfo> regions) throws IOException {
        if (regions == null || regions.size() == 0) {
            return;
        }
        for (HRegionInfo hri : regions) {
            this.restoreRegion(hri);
        }
    }

    private void restoreRegion(HRegionInfo regionInfo) throws IOException {
        Path snapshotRegionDir = new Path(this.snapshotDir, regionInfo.getEncodedName());
        Map<String, List<String>> snapshotFiles = SnapshotReferenceUtil.getRegionHFileReferences(this.fs, snapshotRegionDir);
        Path regionDir = new Path(this.tableDir, regionInfo.getEncodedName());
        String tableName = this.tableDesc.getTableName().getNameAsString();
        for (Path path : FSUtils.getFamilyDirs(this.fs, regionDir)) {
            byte[] family = Bytes.toBytes((String)path.getName());
            Set<String> familyFiles = this.getTableRegionFamilyFiles(path);
            List<String> snapshotFamilyFiles = snapshotFiles.remove(path.getName());
            if (snapshotFamilyFiles != null) {
                LinkedList<String> hfilesToAdd = new LinkedList<String>();
                for (String hfileName : snapshotFamilyFiles) {
                    if (familyFiles.contains(hfileName)) {
                        familyFiles.remove(hfileName);
                        continue;
                    }
                    hfilesToAdd.add(hfileName);
                }
                for (String hfileName : hfilesToAdd) {
                    LOG.trace((Object)("Adding HFileLink " + hfileName + " to region=" + regionInfo.getEncodedName() + " table=" + tableName));
                    this.restoreStoreFile(path, regionInfo, hfileName);
                }
                for (String hfileName : familyFiles) {
                    Path hfile = new Path(path, hfileName);
                    LOG.trace((Object)("Removing hfile=" + hfile + " from region=" + regionInfo.getEncodedName() + " table=" + tableName));
                    HFileArchiver.archiveStoreFile(this.conf, this.fs, regionInfo, this.tableDir, family, hfile);
                }
                continue;
            }
            LOG.trace((Object)("Removing family=" + Bytes.toString((byte[])family) + " from region=" + regionInfo.getEncodedName() + " table=" + tableName));
            HFileArchiver.archiveFamily(this.fs, this.conf, regionInfo, this.tableDir, family);
            this.fs.delete(path, true);
        }
        for (Map.Entry entry : snapshotFiles.entrySet()) {
            Path familyDir = new Path(regionDir, (String)entry.getKey());
            if (!this.fs.mkdirs(familyDir)) {
                throw new IOException("Unable to create familyDir=" + familyDir);
            }
            for (String hfileName : (List)entry.getValue()) {
                LOG.trace((Object)("Adding HFileLink " + hfileName + " to table=" + tableName));
                this.restoreStoreFile(familyDir, regionInfo, hfileName);
            }
        }
    }

    private Set<String> getTableRegionFamilyFiles(Path familyDir) throws IOException {
        HashSet<String> familyFiles = new HashSet<String>();
        FileStatus[] hfiles = FSUtils.listStatus(this.fs, familyDir);
        if (hfiles == null) {
            return familyFiles;
        }
        for (FileStatus hfileRef : hfiles) {
            String hfileName = hfileRef.getPath().getName();
            familyFiles.add(hfileName);
        }
        return familyFiles;
    }

    private HRegionInfo[] cloneHdfsRegions(List<HRegionInfo> regions) throws IOException {
        if (regions == null || regions.size() == 0) {
            return null;
        }
        final HashMap<String, HRegionInfo> snapshotRegions = new HashMap<String, HRegionInfo>(regions.size());
        HRegionInfo[] clonedRegionsInfo = new HRegionInfo[regions.size()];
        for (int i = 0; i < clonedRegionsInfo.length; ++i) {
            HRegionInfo snapshotRegionInfo = regions.get(i);
            clonedRegionsInfo[i] = this.cloneRegionInfo(snapshotRegionInfo);
            String snapshotRegionName = snapshotRegionInfo.getEncodedName();
            String clonedRegionName = clonedRegionsInfo[i].getEncodedName();
            this.regionsMap.put(Bytes.toBytes((String)snapshotRegionName), Bytes.toBytes((String)clonedRegionName));
            LOG.info((Object)("clone region=" + snapshotRegionName + " as " + clonedRegionName));
            snapshotRegions.put(clonedRegionName, snapshotRegionInfo);
        }
        ModifyRegionUtils.createRegions(this.conf, this.rootDir, this.tableDesc, clonedRegionsInfo, new ModifyRegionUtils.RegionFillTask(){

            @Override
            public void fillRegion(HRegion region) throws IOException {
                RestoreSnapshotHelper.this.cloneRegion(region, (HRegionInfo)snapshotRegions.get(region.getRegionInfo().getEncodedName()));
            }
        });
        return clonedRegionsInfo;
    }

    private void cloneRegion(HRegion region, final HRegionInfo snapshotRegionInfo) throws IOException {
        Path snapshotRegionDir = new Path(this.snapshotDir, snapshotRegionInfo.getEncodedName());
        final Path regionDir = new Path(this.tableDir, region.getRegionInfo().getEncodedName());
        final String tableName = this.tableDesc.getTableName().getNameAsString();
        SnapshotReferenceUtil.visitRegionStoreFiles(this.fs, snapshotRegionDir, new FSVisitor.StoreFileVisitor(){

            @Override
            public void storeFile(String region, String family, String hfile) throws IOException {
                LOG.info((Object)("Adding HFileLink " + hfile + " to table=" + tableName));
                Path familyDir = new Path(regionDir, family);
                RestoreSnapshotHelper.this.restoreStoreFile(familyDir, snapshotRegionInfo, hfile);
            }
        });
    }

    private void restoreStoreFile(Path familyDir, HRegionInfo regionInfo, String hfileName) throws IOException {
        if (HFileLink.isHFileLink(hfileName)) {
            HFileLink.createFromHFileLink(this.conf, this.fs, familyDir, hfileName);
        } else if (StoreFileInfo.isReference(hfileName)) {
            this.restoreReferenceFile(familyDir, regionInfo, hfileName);
        } else {
            HFileLink.create(this.conf, this.fs, familyDir, regionInfo, hfileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreReferenceFile(Path familyDir, HRegionInfo regionInfo, String hfileName) throws IOException {
        FSDataInputStream in;
        Path refPath = StoreFileInfo.getReferredToFile(new Path(new Path(new Path(this.snapshotTable.getNameAsString(), regionInfo.getEncodedName()), familyDir.getName()), hfileName));
        String snapshotRegionName = refPath.getParent().getParent().getName();
        String fileName = refPath.getName();
        String clonedRegionName = Bytes.toString((byte[])this.regionsMap.get(Bytes.toBytes((String)snapshotRegionName)));
        if (clonedRegionName == null) {
            clonedRegionName = snapshotRegionName;
        }
        Path linkPath = null;
        String refLink = fileName;
        if (!HFileLink.isHFileLink(fileName)) {
            refLink = HFileLink.createHFileLinkName(this.snapshotTable, snapshotRegionName, fileName);
            linkPath = new Path(familyDir, HFileLink.createHFileLinkName(this.snapshotTable, regionInfo.getEncodedName(), hfileName));
        }
        Path outPath = new Path(familyDir, refLink + '.' + clonedRegionName);
        if (linkPath != null) {
            in = new HFileLink(this.conf, linkPath).open(this.fs);
        } else {
            linkPath = new Path(new Path(HRegion.getRegionDir(this.snapshotDir, regionInfo.getEncodedName()), familyDir.getName()), hfileName);
            in = this.fs.open(linkPath);
        }
        FSDataOutputStream out = this.fs.create(outPath);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)this.conf);
        String regionName = Bytes.toString((byte[])this.regionsMap.get(regionInfo.getEncodedNameAsBytes()));
        LOG.debug((Object)("Restore reference " + regionName + " to " + clonedRegionName));
        Map<String, Pair<String, String>> map = this.parentsMap;
        synchronized (map) {
            Pair daughters = this.parentsMap.get(clonedRegionName);
            if (daughters == null) {
                daughters = new Pair((Object)regionName, null);
                this.parentsMap.put(clonedRegionName, (Pair<String, String>)daughters);
            } else if (!regionName.equals(daughters.getFirst())) {
                daughters.setSecond((Object)regionName);
            }
        }
    }

    public HRegionInfo cloneRegionInfo(HRegionInfo snapshotRegionInfo) {
        HRegionInfo regionInfo = new HRegionInfo(this.tableDesc.getTableName(), snapshotRegionInfo.getStartKey(), snapshotRegionInfo.getEndKey(), snapshotRegionInfo.isSplit(), snapshotRegionInfo.getRegionId());
        regionInfo.setOffline(snapshotRegionInfo.isOffline());
        return regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWALs() throws IOException {
        final SnapshotLogSplitter logSplitter = new SnapshotLogSplitter(this.conf, this.fs, this.tableDir, this.snapshotTable, this.regionsMap);
        try {
            SnapshotReferenceUtil.visitRecoveredEdits(this.fs, this.snapshotDir, new FSVisitor.RecoveredEditsVisitor(){

                @Override
                public void recoveredEdits(String region, String logfile) throws IOException {
                    Path path = SnapshotReferenceUtil.getRecoveredEdits(RestoreSnapshotHelper.this.snapshotDir, region, logfile);
                    logSplitter.splitRecoveredEdit(path);
                }
            });
            SnapshotReferenceUtil.visitLogFiles(this.fs, this.snapshotDir, new FSVisitor.LogFileVisitor(){

                @Override
                public void logFile(String server, String logfile) throws IOException {
                    logSplitter.splitLog(server, logfile);
                }
            });
        }
        finally {
            logSplitter.close();
        }
    }

    private List<HRegionInfo> getTableRegions() throws IOException {
        LOG.debug((Object)("get table regions: " + this.tableDir));
        FileStatus[] regionDirs = FSUtils.listStatus(this.fs, this.tableDir, new FSUtils.RegionDirFilter(this.fs));
        if (regionDirs == null) {
            return null;
        }
        LinkedList<HRegionInfo> regions = new LinkedList<HRegionInfo>();
        for (FileStatus regionDir : regionDirs) {
            HRegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent(this.fs, regionDir.getPath());
            regions.add(hri);
        }
        LOG.debug((Object)("found " + regions.size() + " regions for table=" + this.tableDesc.getTableName().getNameAsString()));
        return regions;
    }

    public static HTableDescriptor cloneTableSchema(HTableDescriptor snapshotTableDescriptor, TableName tableName) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (HColumnDescriptor hcd : snapshotTableDescriptor.getColumnFamilies()) {
            htd.addFamily(hcd);
        }
        for (Map.Entry e : snapshotTableDescriptor.getValues().entrySet()) {
            htd.setValue((ImmutableBytesWritable)e.getKey(), (ImmutableBytesWritable)e.getValue());
        }
        for (Map.Entry e : snapshotTableDescriptor.getConfiguration().entrySet()) {
            htd.setConfiguration((String)e.getKey(), (String)e.getValue());
        }
        return htd;
    }

    public static class RestoreMetaChanges {
        private final Map<String, Pair<String, String>> parentsMap;
        private List<HRegionInfo> regionsToRestore = null;
        private List<HRegionInfo> regionsToRemove = null;
        private List<HRegionInfo> regionsToAdd = null;

        RestoreMetaChanges(Map<String, Pair<String, String>> parentsMap) {
            this.parentsMap = parentsMap;
        }

        public boolean hasRegionsToAdd() {
            return this.regionsToAdd != null && this.regionsToAdd.size() > 0;
        }

        public List<HRegionInfo> getRegionsToAdd() {
            return this.regionsToAdd;
        }

        public boolean hasRegionsToRestore() {
            return this.regionsToRestore != null && this.regionsToRestore.size() > 0;
        }

        public List<HRegionInfo> getRegionsToRestore() {
            return this.regionsToRestore;
        }

        public boolean hasRegionsToRemove() {
            return this.regionsToRemove != null && this.regionsToRemove.size() > 0;
        }

        public List<HRegionInfo> getRegionsToRemove() {
            return this.regionsToRemove;
        }

        void setNewRegions(HRegionInfo[] hris) {
            this.regionsToAdd = hris != null ? Arrays.asList(hris) : null;
        }

        void addRegionToRemove(HRegionInfo hri) {
            if (this.regionsToRemove == null) {
                this.regionsToRemove = new LinkedList<HRegionInfo>();
            }
            this.regionsToRemove.add(hri);
        }

        void addRegionToRestore(HRegionInfo hri) {
            if (this.regionsToRestore == null) {
                this.regionsToRestore = new LinkedList<HRegionInfo>();
            }
            this.regionsToRestore.add(hri);
        }

        public void updateMetaParentRegions(CatalogTracker catalogTracker, List<HRegionInfo> regionInfos) throws IOException {
            if (regionInfos == null || this.parentsMap.isEmpty()) {
                return;
            }
            HashMap<String, HRegionInfo> regionsByName = new HashMap<String, HRegionInfo>(regionInfos.size());
            LinkedList<HRegionInfo> parentRegions = new LinkedList<HRegionInfo>();
            for (HRegionInfo regionInfo : regionInfos) {
                if (regionInfo.isSplitParent()) {
                    parentRegions.add(regionInfo);
                    continue;
                }
                regionsByName.put(regionInfo.getEncodedName(), regionInfo);
            }
            for (HRegionInfo regionInfo : parentRegions) {
                Pair<String, String> daughters = this.parentsMap.get(regionInfo.getEncodedName());
                if (daughters == null) {
                    LOG.warn((Object)("Skip update of unreferenced offline parent: " + regionInfo));
                    continue;
                }
                if (daughters.getSecond() == null) {
                    daughters.setSecond(daughters.getFirst());
                }
                LOG.debug((Object)("Update splits parent " + regionInfo.getEncodedName() + " -> " + daughters));
                MetaEditor.addRegionToMeta(catalogTracker, regionInfo, (HRegionInfo)regionsByName.get(daughters.getFirst()), (HRegionInfo)regionsByName.get(daughters.getSecond()));
            }
        }
    }
}

