/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TColumn;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ThriftUtilities {
    public static HColumnDescriptor colDescFromThrift(ColumnDescriptor in) throws IllegalArgument {
        Compression.Algorithm comp = Compression.getCompressionAlgorithmByName((String)in.compression.toLowerCase());
        BloomType bt = BloomType.valueOf((String)in.bloomFilterType);
        if (in.name == null || !in.name.hasRemaining()) {
            throw new IllegalArgument("column name is empty");
        }
        byte[] parsedName = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)in.name))[0];
        HColumnDescriptor col = new HColumnDescriptor(parsedName).setMaxVersions(in.maxVersions).setCompressionType(comp).setInMemory(in.inMemory).setBlockCacheEnabled(in.blockCacheEnabled).setTimeToLive(in.timeToLive).setBloomFilterType(bt);
        return col;
    }

    public static ColumnDescriptor colDescFromHbase(HColumnDescriptor in) {
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(Bytes.add((byte[])in.getName(), (byte[])KeyValue.COLUMN_FAMILY_DELIM_ARRAY));
        col.maxVersions = in.getMaxVersions();
        col.compression = in.getCompression().toString();
        col.inMemory = in.isInMemory();
        col.blockCacheEnabled = in.isBlockCacheEnabled();
        col.bloomFilterType = in.getBloomFilterType().toString();
        return col;
    }

    public static List<TCell> cellFromHBase(KeyValue in) {
        ArrayList<TCell> list = new ArrayList<TCell>(1);
        if (in != null) {
            list.add(new TCell(ByteBuffer.wrap(in.getValue()), in.getTimestamp()));
        }
        return list;
    }

    public static List<TCell> cellFromHBase(KeyValue[] in) {
        ArrayList<TCell> list = null;
        if (in != null) {
            list = new ArrayList(in.length);
            for (int i = 0; i < in.length; ++i) {
                list.add(new TCell(ByteBuffer.wrap(in[i].getValue()), in[i].getTimestamp()));
            }
        } else {
            list = new ArrayList<TCell>(0);
        }
        return list;
    }

    public static List<TRowResult> rowResultFromHBase(Result[] in, boolean sortColumns) {
        ArrayList<TRowResult> results = new ArrayList<TRowResult>();
        for (Result result_ : in) {
            if (result_ == null || result_.isEmpty()) continue;
            TRowResult result = new TRowResult();
            result.row = ByteBuffer.wrap(result_.getRow());
            if (sortColumns) {
                result.sortedColumns = new ArrayList<TColumn>();
                for (KeyValue kv : result_.raw()) {
                    result.sortedColumns.add(new TColumn(ByteBuffer.wrap(KeyValue.makeColumn((byte[])kv.getFamily(), (byte[])kv.getQualifier())), new TCell(ByteBuffer.wrap(kv.getValue()), kv.getTimestamp())));
                }
            } else {
                result.columns = new TreeMap<ByteBuffer, TCell>();
                for (KeyValue kv : result_.raw()) {
                    result.columns.put(ByteBuffer.wrap(KeyValue.makeColumn((byte[])kv.getFamily(), (byte[])kv.getQualifier())), new TCell(ByteBuffer.wrap(kv.getValue()), kv.getTimestamp()));
                }
            }
            results.add(result);
        }
        return results;
    }

    public static List<TRowResult> rowResultFromHBase(Result[] in) {
        return ThriftUtilities.rowResultFromHBase(in, false);
    }

    public static List<TRowResult> rowResultFromHBase(Result in) {
        Result[] result = new Result[]{in};
        return ThriftUtilities.rowResultFromHBase(result);
    }

    public static Increment incrementFromThrift(TIncrement tincrement) {
        Increment inc = new Increment(tincrement.getRow());
        byte[][] famAndQf = KeyValue.parseColumn((byte[])tincrement.getColumn());
        if (famAndQf.length < 1) {
            return null;
        }
        byte[] qual = famAndQf.length == 1 ? new byte[]{} : famAndQf[1];
        inc.addColumn(famAndQf[0], qual, tincrement.getAmmount());
        return inc;
    }
}

