/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RSStatusTmplImpl
extends AbstractTemplateImpl
implements RSStatusTmpl.Intf {
    private final HRegionServer regionServer;
    private final String format;
    private final String filter;

    protected static RSStatusTmpl.ImplData __jamon_setOptionalArguments(RSStatusTmpl.ImplData p_implData) {
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        return p_implData;
    }

    public RSStatusTmplImpl(TemplateManager p_templateManager, RSStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RSStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
        this.format = p_implData.getFormat();
        this.filter = p_implData.getFilter();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_0 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_0.setFormat("json");
            __jamon__var_0.setFilter(this.filter);
            __jamon__var_0.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n");
        AdminProtos.ServerInfo serverInfo = ProtobufUtil.getServerInfo((AdminProtos.AdminService.BlockingInterface)this.regionServer);
        ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)serverInfo.getServerName());
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)this.regionServer);
        int masterInfoPort = this.regionServer.getConfiguration().getInt("hbase.master.info.port", 60010);
        jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getHostname()), jamonWriter);
        jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-responsive.css\" rel=\"stylesheet\">\n    <!--[if lt IE 9]>\n      <script src=\"/static/js/html5shiv.js\"></script>\n    <![endif]-->\n  </head>\n\n  <body>\n\n    <div class=\"navbar navbar-fixed-top\">\n      <div class=\"navbar-inner\">\n        <div class=\"container-fluid\">\n          <a class=\"btn btn-navbar\" data-toggle=\"collapse\" data-target=\".nav-collapse\">\n            <span class=\"icon-bar\"></span>\n            <span class=\"icon-bar\"></span>\n            <span class=\"icon-bar\"></span>\n          </a>\n          <a class=\"brand\" href=\"/rs-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n          <div class=\"nav-collapse\">\n            <ul class=\"nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
        }
        jamonWriter.write("\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n<div class=\"container-fluid\">\n    <div class=\"row-fluid inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getHostname()), jamonWriter);
        jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row-fluid\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
        ServerMetricsTmpl __jamon__var_1 = new ServerMetricsTmpl(this.getTemplateManager());
        __jamon__var_1.renderNoFlush(jamonWriter, this.regionServer.getMetrics().getRegionServerWrapper());
        jamonWriter.write("\n    </section>\n\n    <section>\n    ");
        TaskMonitorTmpl __jamon__var_2 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_2.setFilter(this.filter);
        __jamon__var_2.renderNoFlush(jamonWriter);
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
        RegionListTmpl __jamon__var_3 = new RegionListTmpl(this.getTemplateManager());
        __jamon__var_3.renderNoFlush(jamonWriter, this.regionServer, onlineRegions);
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", r");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Zookeeper Quorum</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.regionServer.getZooKeeper().getQuorum()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)Arrays.toString(this.regionServer.getCoprocessors())), jamonWriter);
        jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(this.regionServer.getStartcode())), jamonWriter);
        jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
        if (masterInfoPort < 0) {
            jamonWriter.write("\n                No hbase.master.info.port found\n                ");
        } else {
            jamonWriter.write("\n                ");
            String host = this.regionServer.getMasterAddressManager().getMasterAddress().getHostname() + ":" + masterInfoPort;
            String url = "http://" + host + "/";
            jamonWriter.write("<a href=\"");
            Escaping.HTML.write(StandardEmitter.valueOf((String)url), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)host), jamonWriter);
            jamonWriter.write("</a>\n                ");
        }
        jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n");
    }
}

