/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class ServerMetricsTmplImpl
extends AbstractTemplateImpl
implements ServerMetricsTmpl.Intf {
    private final MetricsRegionServerWrapper mWrap;

    protected static ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(ServerMetricsTmpl.ImplData p_implData) {
        return p_implData;
    }

    public ServerMetricsTmplImpl(TemplateManager p_templateManager, ServerMetricsTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)ServerMetricsTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.mWrap = p_implData.getMWrap();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_queueStats\" data-toggle=\"tab\">Queues</a></li>\n        <li class=\"\"><a href=\"#tab_blockCacheStats\" data-toggle=\"tab\">Block Cache</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
        this.__jamon_innerUnit__baseStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
        this.__jamon_innerUnit__memoryStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
        this.__jamon_innerUnit__requestStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
        this.__jamon_innerUnit__storeStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\">\n            ");
        this.__jamon_innerUnit__queueStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_blockCacheStats\">\n            ");
        this.__jamon_innerUnit__blockCacheStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((double)mWrap.getRequestsPerSecond()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getReadRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getWriteRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__queueStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction queue size</th>\n    <th>Flush queue size</th>\n\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mWrap.getCompactionQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mWrap.getFlushQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__blockCacheStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Cache Size</th>\n    <th>Cache Free</th>\n    <th>Cache Count</th>\n    <th>Cache Hits</th>\n    <th>Cache Misses</th>\n    <th>Cache Hit Ratio</th>\n    <th>Cache Eviction Count</th>\n\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getBlockCacheSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getBlockCacheFreeSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getBlockCacheCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getBlockCacheHitCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getBlockCacheMissCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mWrap.getBlockCacheHitPercent()), jamonWriter);
        jamonWriter.write("%</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getBlockCacheEvictedCount()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__memoryStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Memstore Size</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed())), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax())), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)mWrap.getMemstoreSize())), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__baseStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Slow HLog Append Count</th>\n    </tr>\n    <tr>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((double)mWrap.getRequestsPerSecond()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumOnlineRegions()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mWrap.getPercentFileLocal()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)0), jamonWriter);
        jamonWriter.write("</td>\n    </tr>\n</table>\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumStores()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumStoreFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getStoreFileIndexSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getTotalStaticIndexSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getTotalStaticBloomSize()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }
}

