/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class Canary
implements Tool {
    private static final long DEFAULT_INTERVAL = 6000L;
    private static final Log LOG = LogFactory.getLog(Canary.class);
    private Configuration conf = null;
    private HBaseAdmin admin = null;
    private long interval = 0L;
    private Sink sink = null;

    public Canary() {
        this(new StdOutSink());
    }

    public Canary(Sink sink) {
        this.sink = sink;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        int i;
        int tables_index = -1;
        for (i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.startsWith("-")) {
                if (tables_index >= 0) {
                    System.err.println("Invalid command line options");
                    this.printUsageAndExit();
                }
                if (cmd.equals("-help")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("-daemon") && this.interval == 0L) {
                    this.interval = 6000L;
                    continue;
                }
                if (cmd.equals("-interval")) {
                    if (++i == args.length) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.interval = Long.parseLong(args[i]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                System.err.println(cmd + " options is invalid.");
                this.printUsageAndExit();
                continue;
            }
            if (tables_index >= 0) continue;
            tables_index = i;
        }
        if (this.conf == null) {
            this.conf = HBaseConfiguration.create();
        }
        this.admin = new HBaseAdmin(this.conf);
        try {
            do {
                if (this.admin.isAborted()) {
                    LOG.error((Object)"HBaseAdmin aborted");
                    i = 1;
                    return i;
                }
                if (tables_index >= 0) {
                    for (i = tables_index; i < args.length; ++i) {
                        Canary.sniff(this.admin, this.sink, TableName.valueOf((String)args[i]));
                    }
                } else {
                    this.sniff();
                }
                Thread.sleep(this.interval);
            } while (this.interval > 0L);
        }
        finally {
            this.admin.close();
        }
        return 0;
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [opts] [table 1 [table 2...]]%n", this.getClass().getName());
        System.err.println(" where [opts] are:");
        System.err.println("   -help          Show this help and exit.");
        System.err.println("   -daemon        Continuous check at defined intervals.");
        System.err.println("   -interval <N>  Interval between checks (sec)");
        System.exit(1);
    }

    private void sniff() throws Exception {
        for (HTableDescriptor table : this.admin.listTables()) {
            Canary.sniff(this.admin, this.sink, table);
        }
    }

    public static void sniff(HBaseAdmin admin, TableName tableName) throws Exception {
        Canary.sniff(admin, (Sink)new StdOutSink(), tableName);
    }

    private static void sniff(HBaseAdmin admin, Sink sink, TableName tableName) throws Exception {
        if (admin.isTableAvailable(tableName)) {
            Canary.sniff(admin, sink, admin.getTableDescriptor(tableName));
        } else {
            LOG.warn((Object)String.format("Table %s is not available", tableName));
        }
    }

    private static void sniff(HBaseAdmin admin, Sink sink, HTableDescriptor tableDesc) throws Exception {
        HTable table = null;
        try {
            table = new HTable(admin.getConfiguration(), tableDesc.getTableName());
        }
        catch (TableNotFoundException e) {
            return;
        }
        for (HRegionInfo region : admin.getTableRegions(tableDesc.getTableName())) {
            try {
                Canary.sniffRegion(admin, sink, region, table);
            }
            catch (Exception e) {
                sink.publishReadFailure(region, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sniffRegion(HBaseAdmin admin, Sink sink, HRegionInfo region, HTable table) throws Exception {
        HTableDescriptor tableDesc = table.getTableDescriptor();
        StopWatch stopWatch = new StopWatch();
        for (HColumnDescriptor column : tableDesc.getColumnFamilies()) {
            stopWatch.reset();
            byte[] startKey = region.getStartKey();
            if (startKey == null || startKey.length <= 0) {
                Scan scan = new Scan();
                scan.addFamily(column.getName());
                scan.setBatch(1);
                ResultScanner scanner = null;
                try {
                    stopWatch.start();
                    scanner = table.getScanner(scan);
                    scanner.next();
                    stopWatch.stop();
                    sink.publishReadTiming(region, column, stopWatch.getTime());
                    continue;
                }
                catch (Exception e) {
                    sink.publishReadFailure(region, column, e);
                    continue;
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            Get get2 = new Get(region.getStartKey());
            get2.addFamily(column.getName());
            try {
                stopWatch.start();
                table.get(get2);
                stopWatch.stop();
                sink.publishReadTiming(region, column, stopWatch.getTime());
            }
            catch (Exception e) {
                sink.publishReadFailure(region, column, e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new Canary(), (String[])args);
        System.exit(exitCode);
    }

    public static class StdOutSink
    implements Sink {
        @Override
        public void publishReadFailure(HRegionInfo region, Exception e) {
            LOG.error((Object)String.format("read from region %s failed", region.getRegionNameAsString()), (Throwable)e);
        }

        @Override
        public void publishReadFailure(HRegionInfo region, HColumnDescriptor column, Exception e) {
            LOG.error((Object)String.format("read from region %s column family %s failed", region.getRegionNameAsString(), column.getNameAsString()), (Throwable)e);
        }

        @Override
        public void publishReadTiming(HRegionInfo region, HColumnDescriptor column, long msTime) {
            LOG.info((Object)String.format("read from region %s column family %s in %dms", region.getRegionNameAsString(), column.getNameAsString(), msTime));
        }
    }

    public static interface Sink {
        public void publishReadFailure(HRegionInfo var1, Exception var2);

        public void publishReadFailure(HRegionInfo var1, HColumnDescriptor var2, Exception var3);

        public void publishReadTiming(HRegionInfo var1, HColumnDescriptor var2, long var3);
    }
}

