/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.SpanReceiver;
import org.cloudera.htrace.Trace;
import org.cloudera.htrace.impl.LocalFileSpanReceiver;

public class HBaseLocalFileSpanReceiver
implements SpanReceiver,
Configurable {
    public static final Log LOG = LogFactory.getLog(HBaseLocalFileSpanReceiver.class);
    public static final String FILE_NAME_CONF_KEY = "hbase.trace.spanreceiver.localfilespanreceiver.filename";
    private Configuration conf;
    private LocalFileSpanReceiver rcvr;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration arg0) {
        this.conf = arg0;
        if (this.rcvr != null) {
            try {
                this.rcvr.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Error closing LocalFileSpanReceiver.", (Throwable)e);
            }
        }
        try {
            this.rcvr = new LocalFileSpanReceiver(this.conf.get(FILE_NAME_CONF_KEY));
        }
        catch (IOException e) {
            Trace.removeReceiver((SpanReceiver)this);
            this.rcvr = null;
            LOG.warn((Object)"Unable to initialize LocalFileSpanReceiver, removing owner (HBaseLocalFileSpanReceiver) from receiver list.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.rcvr != null) {
                this.rcvr.close();
            }
        }
        finally {
            this.rcvr = null;
        }
    }

    public void receiveSpan(Span span) {
        if (this.rcvr != null) {
            this.rcvr.receiveSpan(span);
        }
    }
}

