/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.cloudera.htrace.SpanReceiver;
import org.cloudera.htrace.Trace;

public class SpanReceiverHost {
    public static final String SPAN_RECEIVERS_CONF_KEY = "hbase.trace.spanreceiver.classes";
    private static final Log LOG = LogFactory.getLog(SpanReceiverHost.class);
    private Collection<SpanReceiver> receivers = new HashSet<SpanReceiver>();
    private Configuration conf;

    public SpanReceiverHost(Configuration conf) {
        this.conf = conf;
    }

    public void loadSpanReceivers() {
        Class<?> implClass = null;
        String[] receiverNames = this.conf.getStrings(SPAN_RECEIVERS_CONF_KEY);
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        for (String className : receiverNames) {
            className = className.trim();
            try {
                implClass = Class.forName(className);
                this.receivers.add(this.loadInstance(implClass));
                LOG.info((Object)("SpanReceiver " + className + " was loaded successfully."));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Class " + className + " cannot be found. " + e.getMessage()));
            }
            catch (IOException e) {
                LOG.warn((Object)("Load SpanReceiver " + className + " failed. " + e.getMessage()));
            }
        }
        for (SpanReceiver rcvr : this.receivers) {
            Trace.addReceiver((SpanReceiver)rcvr);
        }
    }

    private SpanReceiver loadInstance(Class<?> implClass) throws IOException {
        SpanReceiver impl;
        try {
            Object o = ReflectionUtils.newInstance(implClass, (Configuration)this.conf);
            impl = (SpanReceiver)o;
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        return impl;
    }

    public void closeReceivers() {
        for (SpanReceiver rcvr : this.receivers) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to close SpanReceiver correctly: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

