/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DirectMemoryUtils {
    public static long getDirectMemorySize() {
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = RuntimemxBean.getInputArguments();
        long multiplier = 1L;
        for (String s : arguments) {
            if (!s.contains("-XX:MaxDirectMemorySize=")) continue;
            String memSize = s.toLowerCase().replace("-xx:maxdirectmemorysize=", "").trim();
            if (memSize.contains("k")) {
                multiplier = 1024L;
            } else if (memSize.contains("m")) {
                multiplier = 0x100000L;
            } else if (memSize.contains("g")) {
                multiplier = 0x40000000L;
            }
            memSize = memSize.replaceAll("[^\\d]", "");
            long retValue = Long.parseLong(memSize);
            return retValue * multiplier;
        }
        return 0L;
    }

    public static void destroyDirectByteBuffer(ByteBuffer toBeDestroyed) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Preconditions.checkArgument((boolean)toBeDestroyed.isDirect(), (Object)"toBeDestroyed isn't direct!");
        Method cleanerMethod = toBeDestroyed.getClass().getMethod("cleaner", new Class[0]);
        cleanerMethod.setAccessible(true);
        Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
        cleanMethod.setAccessible(true);
        cleanMethod.invoke(cleaner, new Object[0]);
    }
}

