/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HashedBytes {
    private final byte[] bytes;
    private final int hashCode;

    public HashedBytes(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Bytes.hashCode((byte[])bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashedBytes other = (HashedBytes)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return Bytes.toStringBinary((byte[])this.bytes);
    }
}

