/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class MetaUtils {
    private static final Log LOG = LogFactory.getLog(MetaUtils.class);
    private final Configuration conf;
    private FileSystem fs;
    private HLog log;
    private HRegion metaRegion;
    private Map<byte[], HRegion> metaRegions = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));

    public MetaUtils() throws IOException {
        this(HBaseConfiguration.create());
    }

    public MetaUtils(Configuration conf) throws IOException {
        this.conf = conf;
        conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        this.metaRegion = null;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    public synchronized HLog getLog() throws IOException {
        if (this.log == null) {
            String logName = "WALs_" + System.currentTimeMillis();
            this.log = HLogFactory.createHLog(this.fs, this.fs.getHomeDirectory(), logName, this.conf);
        }
        return this.log;
    }

    public HRegion getMetaRegion() throws IOException {
        if (this.metaRegion == null) {
            this.openMetaRegion();
        }
        return this.metaRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.metaRegion != null) {
            try {
                this.metaRegion.close();
            }
            catch (IOException e) {
                LOG.error((Object)"closing meta region", (Throwable)e);
            }
            finally {
                this.metaRegion = null;
            }
        }
        try {
            for (HRegion r : this.metaRegions.values()) {
                LOG.info((Object)("CLOSING META " + r.toString()));
                r.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"closing meta region", (Throwable)e);
        }
        finally {
            this.metaRegions.clear();
        }
        try {
            if (this.log != null) {
                this.log.rollWriter();
                this.log.closeAndDelete();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"closing HLog", (Throwable)e);
        }
        finally {
            this.log = null;
        }
    }

    private synchronized HRegion openMetaRegion() throws IOException {
        if (this.metaRegion != null) {
            return this.metaRegion;
        }
        this.metaRegion = HRegion.openHRegion(HRegionInfo.FIRST_META_REGIONINFO, HTableDescriptor.META_TABLEDESC, this.getLog(), this.conf);
        this.metaRegion.compactStores();
        return this.metaRegion;
    }
}

