/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public abstract class ModifyRegionUtils {
    private static final Log LOG = LogFactory.getLog(ModifyRegionUtils.class);

    private ModifyRegionUtils() {
    }

    public static List<HRegionInfo> createRegions(Configuration conf, Path rootDir, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions) throws IOException {
        return ModifyRegionUtils.createRegions(conf, rootDir, hTableDescriptor, newRegions, null);
    }

    public static List<HRegionInfo> createRegions(final Configuration conf, final Path rootDir, final HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions, final RegionFillTask task) throws IOException {
        if (newRegions == null) {
            return null;
        }
        int regionNumber = newRegions.length;
        ThreadPoolExecutor regionOpenAndInitThreadPool = ModifyRegionUtils.getRegionOpenAndInitThreadPool(conf, "RegionOpenAndInitThread-" + hTableDescriptor.getTableName(), regionNumber);
        ExecutorCompletionService<HRegionInfo> completionService = new ExecutorCompletionService<HRegionInfo>(regionOpenAndInitThreadPool);
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        for (final HRegionInfo newRegion : newRegions) {
            completionService.submit(new Callable<HRegionInfo>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public HRegionInfo call() throws IOException {
                    HRegion region = HRegion.createHRegion(newRegion, rootDir, conf, hTableDescriptor, null, false, true);
                    try {
                        if (task != null) {
                            task.fillRegion(region);
                        }
                    }
                    finally {
                        region.close();
                    }
                    return region.getRegionInfo();
                }
            });
        }
        try {
            for (int i = 0; i < regionNumber; ++i) {
                Future future = completionService.take();
                HRegionInfo regionInfo = (HRegionInfo)future.get();
                regionInfos.add(regionInfo);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Caught " + e + " during region creation"));
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            regionOpenAndInitThreadPool.shutdownNow();
        }
        return regionInfos;
    }

    static ThreadPoolExecutor getRegionOpenAndInitThreadPool(Configuration conf, final String threadNamePrefix, int regionNumber) {
        int maxThreads = Math.min(regionNumber, conf.getInt("hbase.hregion.open.and.init.threads.max", 10));
        ThreadPoolExecutor regionOpenAndInitThreadPool = Threads.getBoundedCachedThreadPool((int)maxThreads, (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadNamePrefix + "-" + this.count++);
                return t;
            }
        });
        return regionOpenAndInitThreadPool;
    }

    public static void assignRegions(AssignmentManager assignmentManager, List<HRegionInfo> regions) throws IOException {
        try {
            assignmentManager.getRegionStates().createRegionStates(regions);
            assignmentManager.assign(regions);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Caught " + e + " during round-robin assignment"));
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public static interface RegionFillTask {
        public void fillRegion(HRegion var1) throws IOException;
    }
}

