/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.StoreFile;

@InterfaceAudience.LimitedPrivate(value={"Coprocessor"})
public class StoreFileScanner
implements KeyValueScanner {
    static final Log LOG = LogFactory.getLog(HStore.class);
    private final StoreFile.Reader reader;
    private final HFileScanner hfs;
    private KeyValue cur = null;
    private boolean realSeekDone;
    private boolean delayedReseek;
    private KeyValue delayedSeekKV;
    private boolean enforceMVCC = false;
    private boolean hasMVCCInfo = false;
    private static AtomicLong seekCount;
    private ScanQueryMatcher matcher;

    public StoreFileScanner(StoreFile.Reader reader, HFileScanner hfs, boolean useMVCC, boolean hasMVCC) {
        this.reader = reader;
        this.hfs = hfs;
        this.enforceMVCC = useMVCC;
        this.hasMVCCInfo = hasMVCC;
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, false);
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, null);
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher) throws IOException {
        ArrayList<StoreFileScanner> scanners = new ArrayList<StoreFileScanner>(files.size());
        for (StoreFile file : files) {
            StoreFile.Reader r = file.createReader();
            StoreFileScanner scanner = r.getStoreFileScanner(cacheBlocks, usePread, isCompaction);
            scanner.setScanQueryMatcher(matcher);
            scanners.add(scanner);
        }
        return scanners;
    }

    public String toString() {
        return "StoreFileScanner[" + this.hfs.toString() + ", cur=" + this.cur + "]";
    }

    @Override
    public KeyValue peek() {
        return this.cur;
    }

    @Override
    public KeyValue next() throws IOException {
        KeyValue retKey = this.cur;
        try {
            if (this.cur != null) {
                this.hfs.next();
                this.cur = this.hfs.getKeyValue();
                if (this.hasMVCCInfo) {
                    this.skipKVsNewerThanReadpoint();
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Could not iterate " + this, e);
        }
        return retKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean seek(KeyValue key) throws IOException {
        if (seekCount != null) {
            seekCount.incrementAndGet();
        }
        try {
            try {
                if (!StoreFileScanner.seekAtOrAfter(this.hfs, key)) {
                    this.close();
                    boolean bl = false;
                    return bl;
                }
                this.cur = this.hfs.getKeyValue();
                boolean bl = !this.hasMVCCInfo ? true : this.skipKVsNewerThanReadpoint();
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (IOException ioe) {
            throw new IOException("Could not seek " + this + " to key " + key, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean reseek(KeyValue key) throws IOException {
        if (seekCount != null) {
            seekCount.incrementAndGet();
        }
        try {
            try {
                if (!StoreFileScanner.reseekAtOrAfter(this.hfs, key)) {
                    this.close();
                    boolean bl = false;
                    return bl;
                }
                this.cur = this.hfs.getKeyValue();
                boolean bl = !this.hasMVCCInfo ? true : this.skipKVsNewerThanReadpoint();
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (IOException ioe) {
            throw new IOException("Could not reseek " + this + " to key " + key, ioe);
        }
    }

    protected boolean skipKVsNewerThanReadpoint() throws IOException {
        long readPoint = MultiVersionConsistencyControl.getThreadReadPoint();
        while (this.enforceMVCC && this.cur != null && this.cur.getMvccVersion() > readPoint) {
            this.hfs.next();
            this.cur = this.hfs.getKeyValue();
        }
        if (this.cur == null) {
            this.close();
            return false;
        }
        if (this.cur.getMvccVersion() <= readPoint) {
            this.cur.setMvccVersion(0L);
        }
        return true;
    }

    @Override
    public void close() {
        this.cur = null;
    }

    public static boolean seekAtOrAfter(HFileScanner s, KeyValue k) throws IOException {
        int result = s.seekTo(k.getBuffer(), k.getKeyOffset(), k.getKeyLength());
        if (result < 0) {
            if (result == -2) {
                return true;
            }
            return s.seekTo();
        }
        if (result > 0) {
            return s.next();
        }
        return true;
    }

    static boolean reseekAtOrAfter(HFileScanner s, KeyValue k) throws IOException {
        int result = s.reseekTo(k.getBuffer(), k.getKeyOffset(), k.getKeyLength());
        if (result <= 0) {
            if (result == -2) {
                return true;
            }
            if (!s.isSeeked()) {
                return s.seekTo();
            }
            return true;
        }
        return s.next();
    }

    @Override
    public long getSequenceID() {
        return this.reader.getSequenceID();
    }

    @Override
    public boolean requestSeek(KeyValue kv, boolean forward, boolean useBloom) throws IOException {
        if (kv.getFamilyLength() == 0) {
            useBloom = false;
        }
        boolean haveToSeek = true;
        if (useBloom) {
            if (this.reader.getBloomFilterType() == BloomType.ROWCOL) {
                haveToSeek = this.reader.passesGeneralBloomFilter(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
            } else if (this.matcher != null && !this.matcher.hasNullColumnInQuery() && (kv.isDeleteFamily() || kv.isDeleteFamilyVersion())) {
                haveToSeek = this.reader.passesDeleteFamilyBloomFilter(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength());
            }
        }
        this.delayedReseek = forward;
        this.delayedSeekKV = kv;
        if (haveToSeek) {
            this.realSeekDone = false;
            long maxTimestampInFile = this.reader.getMaxTimestamp();
            long seekTimestamp = kv.getTimestamp();
            if (seekTimestamp > maxTimestampInFile) {
                this.cur = kv.createFirstOnRowColTS(maxTimestampInFile);
            } else {
                this.enforceSeek();
            }
            return this.cur != null;
        }
        this.cur = kv.createLastOnRowCol();
        this.realSeekDone = true;
        return true;
    }

    StoreFile.Reader getReaderForTesting() {
        return this.reader;
    }

    @Override
    public boolean realSeekDone() {
        return this.realSeekDone;
    }

    @Override
    public void enforceSeek() throws IOException {
        if (this.realSeekDone) {
            return;
        }
        if (this.delayedReseek) {
            this.reseek(this.delayedSeekKV);
        } else {
            this.seek(this.delayedSeekKV);
        }
    }

    public void setScanQueryMatcher(ScanQueryMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean isFileScanner() {
        return true;
    }

    static final long getSeekCount() {
        return seekCount.get();
    }

    static final void instrument() {
        seekCount = new AtomicLong();
    }

    @Override
    public boolean shouldUseScanner(Scan scan, SortedSet<byte[]> columns, long oldestUnexpiredTS) {
        return this.reader.passesTimerangeFilter(scan, oldestUnexpiredTS) && this.reader.passesBloomFilter(scan, columns);
    }
}

