/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.handler.ParallelSeekHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class StoreScanner
extends NonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    static final Log LOG = LogFactory.getLog(StoreScanner.class);
    protected Store store;
    protected ScanQueryMatcher matcher;
    protected KeyValueHeap heap;
    protected boolean cacheBlocks;
    protected int countPerRow = 0;
    protected int storeLimit = -1;
    protected int storeOffset = 0;
    protected boolean closing = false;
    protected final boolean isGet;
    protected final boolean explicitColumnQuery;
    protected final boolean useRowColBloom;
    protected boolean isParallelSeekEnabled = false;
    protected ExecutorService executor;
    protected final Scan scan;
    protected final NavigableSet<byte[]> columns;
    protected final long oldestUnexpiredTS;
    protected final int minVersions;
    private long kvsScanned = 0L;
    static final boolean LAZY_SEEK_ENABLED_BY_DEFAULT = true;
    public static final String STORESCANNER_PARALLEL_SEEK_ENABLE = "hbase.storescanner.parallel.seek.enable";
    protected static boolean lazySeekEnabledGlobally = true;
    protected KeyValue lastTop = null;
    private boolean scanUsePread = false;
    private ReentrantLock lock = new ReentrantLock();

    protected StoreScanner(Store store, boolean cacheBlocks, Scan scan, NavigableSet<byte[]> columns, long ttl, int minVersions) {
        this.store = store;
        this.cacheBlocks = cacheBlocks;
        this.isGet = scan.isGetScan();
        int numCol = columns == null ? 0 : columns.size();
        this.explicitColumnQuery = numCol > 0;
        this.scan = scan;
        this.columns = columns;
        this.oldestUnexpiredTS = EnvironmentEdgeManager.currentTimeMillis() - ttl;
        this.minVersions = minVersions;
        this.useRowColBloom = numCol > 1 || !this.isGet && numCol == 1;
        this.scanUsePread = scan.isSmall();
        if (store != null && ((HStore)store).getHRegion() != null && store.getStorefilesCount() > 1) {
            RegionServerServices rsService = ((HStore)store).getHRegion().getRegionServerServices();
            if (rsService == null || !rsService.getConfiguration().getBoolean(STORESCANNER_PARALLEL_SEEK_ENABLE, false)) {
                return;
            }
            this.isParallelSeekEnabled = true;
            this.executor = rsService.getExecutorService();
        }
    }

    public StoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns) throws IOException {
        this(store, scan.getCacheBlocks(), scan, columns, scanInfo.getTtl(), scanInfo.getMinVersions());
        if (columns != null && scan.isRaw()) {
            throw new DoNotRetryIOException("Cannot specify any column for a raw scan");
        }
        this.matcher = new ScanQueryMatcher(scan, scanInfo, columns, ScanType.USER_SCAN, Long.MAX_VALUE, Long.MAX_VALUE, this.oldestUnexpiredTS);
        List<KeyValueScanner> scanners = this.getScannersNoCompaction();
        if (this.explicitColumnQuery && lazySeekEnabledGlobally) {
            for (KeyValueScanner scanner : scanners) {
                scanner.requestSeek(this.matcher.getStartKey(), false, true);
            }
        } else if (!this.isParallelSeekEnabled) {
            for (KeyValueScanner scanner : scanners) {
                scanner.seek(this.matcher.getStartKey());
            }
        } else {
            this.parallelSeek(scanners, this.matcher.getStartKey());
        }
        this.storeLimit = scan.getMaxResultsPerColumnFamily();
        this.storeOffset = scan.getRowOffsetPerColumnFamily();
        this.heap = new KeyValueHeap(scanners, store.getComparator());
        this.store.addChangedReaderObserver(this);
    }

    public StoreScanner(Store store, ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        this(store, scanInfo, scan, scanners, scanType, smallestReadPoint, earliestPutTs, null, null);
    }

    public StoreScanner(Store store, ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        this(store, scanInfo, scan, scanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    private StoreScanner(Store store, ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        this(store, false, scan, null, scanInfo.getTtl(), scanInfo.getMinVersions());
        this.matcher = dropDeletesFromRow == null ? new ScanQueryMatcher(scan, scanInfo, null, scanType, smallestReadPoint, earliestPutTs, this.oldestUnexpiredTS) : new ScanQueryMatcher(scan, scanInfo, null, smallestReadPoint, earliestPutTs, this.oldestUnexpiredTS, dropDeletesFromRow, dropDeletesToRow);
        scanners = this.selectScannersFrom(scanners);
        if (!this.isParallelSeekEnabled) {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.seek(this.matcher.getStartKey());
            }
        } else {
            this.parallelSeek(scanners, this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, store.getComparator());
    }

    StoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners) throws IOException {
        this(scan, scanInfo, scanType, columns, scanners, Long.MAX_VALUE);
    }

    StoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners, long earliestPutTs) throws IOException {
        this(null, scan.getCacheBlocks(), scan, columns, scanInfo.getTtl(), scanInfo.getMinVersions());
        this.matcher = new ScanQueryMatcher(scan, scanInfo, columns, scanType, Long.MAX_VALUE, earliestPutTs, this.oldestUnexpiredTS);
        if (!this.isParallelSeekEnabled) {
            for (KeyValueScanner scanner : scanners) {
                scanner.seek(this.matcher.getStartKey());
            }
        } else {
            this.parallelSeek(scanners, this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, scanInfo.getComparator());
    }

    protected List<KeyValueScanner> getScannersNoCompaction() throws IOException {
        boolean isCompaction = false;
        boolean usePread = this.isGet || this.scanUsePread;
        return this.selectScannersFrom(this.store.getScanners(this.cacheBlocks, this.isGet, usePread, false, this.matcher, this.scan.getStartRow(), this.scan.getStopRow()));
    }

    protected List<KeyValueScanner> selectScannersFrom(List<? extends KeyValueScanner> allScanners) {
        boolean filesOnly;
        boolean memOnly;
        if (this.scan instanceof InternalScan) {
            InternalScan iscan = (InternalScan)this.scan;
            memOnly = iscan.isCheckOnlyMemStore();
            filesOnly = iscan.isCheckOnlyStoreFiles();
        } else {
            memOnly = false;
            filesOnly = false;
        }
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(allScanners.size());
        long expiredTimestampCutoff = this.minVersions == 0 ? this.oldestUnexpiredTS : Long.MIN_VALUE;
        for (KeyValueScanner keyValueScanner : allScanners) {
            boolean isFile = keyValueScanner.isFileScanner();
            if (!isFile && filesOnly || isFile && memOnly || !keyValueScanner.shouldUseScanner(this.scan, this.columns, expiredTimestampCutoff)) continue;
            scanners.add(keyValueScanner);
        }
        return scanners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValue peek() {
        this.lock.lock();
        try {
            if (this.heap == null) {
                KeyValue keyValue = this.lastTop;
                return keyValue;
            }
            KeyValue keyValue = this.heap.peek();
            return keyValue;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.closing) {
                return;
            }
            this.closing = true;
            if (this.store != null) {
                this.store.deleteChangedReaderObserver(this);
            }
            if (this.heap != null) {
                this.heap.close();
            }
            this.heap = null;
            this.lastTop = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean seek(KeyValue key) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            boolean bl = this.heap.seek(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> outResult, int limit) throws IOException {
        this.lock.lock();
        try {
            KeyValue kv;
            if (this.checkReseek()) {
                boolean bl = true;
                return bl;
            }
            if (this.heap == null) {
                this.close();
                boolean bl = false;
                return bl;
            }
            KeyValue peeked = this.heap.peek();
            if (peeked == null) {
                this.close();
                boolean bl = false;
                return bl;
            }
            byte[] row = peeked.getBuffer();
            int offset = peeked.getRowOffset();
            short length = peeked.getRowLength();
            if (limit < 0 || this.matcher.row == null || !Bytes.equals((byte[])row, (int)offset, (int)length, (byte[])this.matcher.row, (int)this.matcher.rowOffset, (int)this.matcher.rowLength)) {
                this.countPerRow = 0;
                this.matcher.setRow(row, offset, length);
            }
            KeyValue prevKV = null;
            KeyValue.KVComparator comparator = this.store != null ? this.store.getComparator() : null;
            int count = 0;
            block21: while ((kv = this.heap.peek()) != null) {
                ++this.kvsScanned;
                assert (prevKV == null || comparator == null || comparator.compare((Cell)prevKV, (Cell)kv) <= 0) : "Key " + prevKV + " followed by a " + "smaller key " + kv + " in cf " + this.store;
                prevKV = kv;
                ScanQueryMatcher.MatchCode qcode = this.matcher.match(kv);
                switch (qcode) {
                    case INCLUDE: 
                    case INCLUDE_AND_SEEK_NEXT_ROW: 
                    case INCLUDE_AND_SEEK_NEXT_COL: {
                        Filter f = this.matcher.getFilter();
                        if (f != null) {
                            kv = KeyValueUtil.ensureKeyValue((Cell)f.transformCell((Cell)kv));
                        }
                        ++this.countPerRow;
                        if (this.storeLimit > -1 && this.countPerRow > this.storeLimit + this.storeOffset) {
                            if (!this.matcher.moreRowsMayExistAfter(kv)) {
                                boolean bl = false;
                                return bl;
                            }
                            this.reseek(this.matcher.getKeyForNextRow(kv));
                            break block21;
                        }
                        if (this.countPerRow > this.storeOffset) {
                            outResult.add((Cell)kv);
                            ++count;
                        }
                        if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) {
                            if (!this.matcher.moreRowsMayExistAfter(kv)) {
                                boolean bl = false;
                                return bl;
                            }
                            this.reseek(this.matcher.getKeyForNextRow(kv));
                        } else if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                            this.reseek(this.matcher.getKeyForNextColumn(kv));
                        } else {
                            this.heap.next();
                        }
                        if (limit <= 0 || count != limit) continue block21;
                        break block21;
                    }
                    case DONE: {
                        boolean bl = true;
                        return bl;
                    }
                    case DONE_SCAN: {
                        this.close();
                        boolean bl = false;
                        return bl;
                    }
                    case SEEK_NEXT_ROW: {
                        if (!this.matcher.moreRowsMayExistAfter(kv)) {
                            boolean bl = false;
                            return bl;
                        }
                        this.reseek(this.matcher.getKeyForNextRow(kv));
                        break;
                    }
                    case SEEK_NEXT_COL: {
                        this.reseek(this.matcher.getKeyForNextColumn(kv));
                        break;
                    }
                    case SKIP: {
                        this.heap.next();
                        break;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        KeyValue nextKV = KeyValueUtil.ensureKeyValue((Cell)this.matcher.getNextKeyHint((Cell)kv));
                        if (nextKV != null) {
                            this.reseek(nextKV);
                            break;
                        }
                        this.heap.next();
                        break;
                    }
                    default: {
                        throw new RuntimeException("UNEXPECTED");
                    }
                }
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
            this.close();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean next(List<Cell> outResult) throws IOException {
        return this.next(outResult, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReaders() throws IOException {
        this.lock.lock();
        try {
            if (this.closing) {
                return;
            }
            if (this.heap == null) {
                return;
            }
            this.lastTop = this.peek();
            this.heap.close();
            this.heap = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean checkReseek() throws IOException {
        if (this.heap == null && this.lastTop != null) {
            this.resetScannerStack(this.lastTop);
            if (this.heap.peek() == null || this.store.getComparator().compareRows(this.lastTop, this.heap.peek()) != 0) {
                LOG.debug((Object)("Storescanner.peek() is changed where before = " + this.lastTop.toString() + ",and after = " + this.heap.peek()));
                this.lastTop = null;
                return true;
            }
            this.lastTop = null;
        }
        return false;
    }

    protected void resetScannerStack(KeyValue lastTopKey) throws IOException {
        if (this.heap != null) {
            throw new RuntimeException("StoreScanner.reseek run on an existing heap!");
        }
        List<KeyValueScanner> scanners = this.getScannersNoCompaction();
        if (!this.isParallelSeekEnabled) {
            for (KeyValueScanner scanner : scanners) {
                scanner.seek(lastTopKey);
            }
        } else {
            this.parallelSeek(scanners, lastTopKey);
        }
        this.heap = new KeyValueHeap(scanners, this.store.getComparator());
        KeyValue kv = this.heap.peek();
        if (kv == null) {
            kv = lastTopKey;
        }
        byte[] row = kv.getBuffer();
        int offset = kv.getRowOffset();
        short length = kv.getRowLength();
        if (this.matcher.row == null || !Bytes.equals((byte[])row, (int)offset, (int)length, (byte[])this.matcher.row, (int)this.matcher.rowOffset, (int)this.matcher.rowLength)) {
            this.countPerRow = 0;
            this.matcher.reset();
            this.matcher.setRow(row, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reseek(KeyValue kv) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            if (this.explicitColumnQuery && lazySeekEnabledGlobally) {
                boolean bl = this.heap.requestSeek(kv, true, this.useRowColBloom);
                return bl;
            }
            boolean bl = this.heap.reseek(kv);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    private void parallelSeek(List<? extends KeyValueScanner> scanners, KeyValue kv) throws IOException {
        if (scanners.isEmpty()) {
            return;
        }
        int storeFileScannerCount = scanners.size();
        CountDownLatch latch = new CountDownLatch(storeFileScannerCount);
        ArrayList<ParallelSeekHandler> handlers = new ArrayList<ParallelSeekHandler>(storeFileScannerCount);
        for (KeyValueScanner keyValueScanner : scanners) {
            if (keyValueScanner instanceof StoreFileScanner) {
                ParallelSeekHandler seekHandler = new ParallelSeekHandler(keyValueScanner, kv, MultiVersionConsistencyControl.getThreadReadPoint(), latch);
                this.executor.submit(seekHandler);
                handlers.add(seekHandler);
                continue;
            }
            keyValueScanner.seek(kv);
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException(ie.getMessage());
        }
        for (ParallelSeekHandler parallelSeekHandler : handlers) {
            if (parallelSeekHandler.getErr() == null) continue;
            throw new IOException(parallelSeekHandler.getErr());
        }
    }

    List<KeyValueScanner> getAllScannersForTesting() {
        ArrayList<KeyValueScanner> allScanners = new ArrayList<KeyValueScanner>();
        KeyValueScanner current = this.heap.getCurrentForTesting();
        if (current != null) {
            allScanners.add(current);
        }
        for (KeyValueScanner scanner : this.heap.getHeap()) {
            allScanners.add(scanner);
        }
        return allScanners;
    }

    static void enableLazySeekGlobally(boolean enable) {
        lazySeekEnabledGlobally = enable;
    }

    public long getEstimatedNumberOfKvsScanned() {
        return this.kvsScanned;
    }
}

