/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.HBaseZeroCopyByteString;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.StorageClusterStatusMessage;
import org.apache.hadoop.hbase.util.Bytes;

@XmlRootElement(name="ClusterStatus")
@InterfaceAudience.Private
public class StorageClusterStatusModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    private List<Node> liveNodes = new ArrayList<Node>();
    private List<String> deadNodes = new ArrayList<String>();
    private int regions;
    private int requests;
    private double averageLoad;

    public Node addLiveNode(String name, long startCode, int heapSizeMB, int maxHeapSizeMB) {
        Node node = new Node(name, startCode);
        node.setHeapSizeMB(heapSizeMB);
        node.setMaxHeapSizeMB(maxHeapSizeMB);
        this.liveNodes.add(node);
        return node;
    }

    public Node getLiveNode(int index) {
        return this.liveNodes.get(index);
    }

    public void addDeadNode(String node) {
        this.deadNodes.add(node);
    }

    public String getDeadNode(int index) {
        return this.deadNodes.get(index);
    }

    @XmlElement(name="Node")
    @XmlElementWrapper(name="LiveNodes")
    public List<Node> getLiveNodes() {
        return this.liveNodes;
    }

    @XmlElement(name="Node")
    @XmlElementWrapper(name="DeadNodes")
    public List<String> getDeadNodes() {
        return this.deadNodes;
    }

    @XmlAttribute
    public int getRegions() {
        return this.regions;
    }

    @XmlAttribute
    public int getRequests() {
        return this.requests;
    }

    @XmlAttribute
    public double getAverageLoad() {
        return this.averageLoad;
    }

    public void setLiveNodes(List<Node> nodes) {
        this.liveNodes = nodes;
    }

    public void setDeadNodes(List<String> nodes) {
        this.deadNodes = nodes;
    }

    public void setRegions(int regions) {
        this.regions = regions;
    }

    public void setRequests(int requests) {
        this.requests = requests;
    }

    public void setAverageLoad(double averageLoad) {
        this.averageLoad = averageLoad;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d live servers, %d dead servers, %.4f average load%n%n", this.liveNodes.size(), this.deadNodes.size(), this.averageLoad));
        if (!this.liveNodes.isEmpty()) {
            sb.append(this.liveNodes.size());
            sb.append(" live servers\n");
            for (Node node : this.liveNodes) {
                sb.append("    ");
                sb.append(node.name);
                sb.append(' ');
                sb.append(node.startCode);
                sb.append("\n        requests=");
                sb.append(node.requests);
                sb.append(", regions=");
                sb.append(node.regions.size());
                sb.append("\n        heapSizeMB=");
                sb.append(node.heapSizeMB);
                sb.append("\n        maxHeapSizeMB=");
                sb.append(node.maxHeapSizeMB);
                sb.append("\n\n");
                for (Node.Region region : node.regions) {
                    sb.append("        ");
                    sb.append(Bytes.toString((byte[])region.name));
                    sb.append("\n            stores=");
                    sb.append(region.stores);
                    sb.append("\n            storefiless=");
                    sb.append(region.storefiles);
                    sb.append("\n            storefileSizeMB=");
                    sb.append(region.storefileSizeMB);
                    sb.append("\n            memstoreSizeMB=");
                    sb.append(region.memstoreSizeMB);
                    sb.append("\n            storefileIndexSizeMB=");
                    sb.append(region.storefileIndexSizeMB);
                    sb.append("\n            readRequestsCount=");
                    sb.append(region.readRequestsCount);
                    sb.append("\n            writeRequestsCount=");
                    sb.append(region.writeRequestsCount);
                    sb.append("\n            rootIndexSizeKB=");
                    sb.append(region.rootIndexSizeKB);
                    sb.append("\n            totalStaticIndexSizeKB=");
                    sb.append(region.totalStaticIndexSizeKB);
                    sb.append("\n            totalStaticBloomSizeKB=");
                    sb.append(region.totalStaticBloomSizeKB);
                    sb.append("\n            totalCompactingKVs=");
                    sb.append(region.totalCompactingKVs);
                    sb.append("\n            currentCompactedKVs=");
                    sb.append(region.currentCompactedKVs);
                    sb.append('\n');
                }
                sb.append('\n');
            }
        }
        if (!this.deadNodes.isEmpty()) {
            sb.append('\n');
            sb.append(this.deadNodes.size());
            sb.append(" dead servers\n");
            for (String string : this.deadNodes) {
                sb.append("    ");
                sb.append(string);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public byte[] createProtobufOutput() {
        StorageClusterStatusMessage.StorageClusterStatus.Builder builder = StorageClusterStatusMessage.StorageClusterStatus.newBuilder();
        builder.setRegions(this.regions);
        builder.setRequests(this.requests);
        builder.setAverageLoad(this.averageLoad);
        for (Node node : this.liveNodes) {
            StorageClusterStatusMessage.StorageClusterStatus.Node.Builder nodeBuilder = StorageClusterStatusMessage.StorageClusterStatus.Node.newBuilder();
            nodeBuilder.setName(node.name);
            nodeBuilder.setStartCode(node.startCode);
            nodeBuilder.setRequests(node.requests);
            nodeBuilder.setHeapSizeMB(node.heapSizeMB);
            nodeBuilder.setMaxHeapSizeMB(node.maxHeapSizeMB);
            for (Node.Region region : node.regions) {
                StorageClusterStatusMessage.StorageClusterStatus.Region.Builder regionBuilder = StorageClusterStatusMessage.StorageClusterStatus.Region.newBuilder();
                regionBuilder.setName(HBaseZeroCopyByteString.wrap((byte[])region.name));
                regionBuilder.setStores(region.stores);
                regionBuilder.setStorefiles(region.storefiles);
                regionBuilder.setStorefileSizeMB(region.storefileSizeMB);
                regionBuilder.setMemstoreSizeMB(region.memstoreSizeMB);
                regionBuilder.setStorefileIndexSizeMB(region.storefileIndexSizeMB);
                regionBuilder.setReadRequestsCount(region.readRequestsCount);
                regionBuilder.setWriteRequestsCount(region.writeRequestsCount);
                regionBuilder.setRootIndexSizeKB(region.rootIndexSizeKB);
                regionBuilder.setTotalStaticIndexSizeKB(region.totalStaticIndexSizeKB);
                regionBuilder.setTotalStaticBloomSizeKB(region.totalStaticBloomSizeKB);
                regionBuilder.setTotalCompactingKVs(region.totalCompactingKVs);
                regionBuilder.setCurrentCompactedKVs(region.currentCompactedKVs);
                nodeBuilder.addRegions(regionBuilder);
            }
            builder.addLiveNodes(nodeBuilder);
        }
        for (String string : this.deadNodes) {
            builder.addDeadNodes(string);
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        StorageClusterStatusMessage.StorageClusterStatus.Builder builder = StorageClusterStatusMessage.StorageClusterStatus.newBuilder();
        builder.mergeFrom(message);
        if (builder.hasRegions()) {
            this.regions = builder.getRegions();
        }
        if (builder.hasRequests()) {
            this.requests = builder.getRequests();
        }
        if (builder.hasAverageLoad()) {
            this.averageLoad = builder.getAverageLoad();
        }
        for (StorageClusterStatusMessage.StorageClusterStatus.Node node : builder.getLiveNodesList()) {
            long startCode = node.hasStartCode() ? node.getStartCode() : -1L;
            Node nodeModel = this.addLiveNode(node.getName(), startCode, node.getHeapSizeMB(), node.getMaxHeapSizeMB());
            int requests = node.hasRequests() ? node.getRequests() : 0;
            nodeModel.setRequests(requests);
            for (StorageClusterStatusMessage.StorageClusterStatus.Region region : node.getRegionsList()) {
                nodeModel.addRegion(region.getName().toByteArray(), region.getStores(), region.getStorefiles(), region.getStorefileSizeMB(), region.getMemstoreSizeMB(), region.getStorefileIndexSizeMB(), region.getReadRequestsCount(), region.getWriteRequestsCount(), region.getRootIndexSizeKB(), region.getTotalStaticIndexSizeKB(), region.getTotalStaticBloomSizeKB(), region.getTotalCompactingKVs(), region.getCurrentCompactedKVs());
            }
        }
        for (String string : builder.getDeadNodesList()) {
            this.addDeadNode(string);
        }
        return this;
    }

    public static class Node {
        private String name;
        private long startCode;
        private int requests;
        private int heapSizeMB;
        private int maxHeapSizeMB;
        private List<Region> regions = new ArrayList<Region>();

        public void addRegion(byte[] name, int stores, int storefiles, int storefileSizeMB, int memstoreSizeMB, int storefileIndexSizeMB, long readRequestsCount, long writeRequestsCount, int rootIndexSizeKB, int totalStaticIndexSizeKB, int totalStaticBloomSizeKB, long totalCompactingKVs, long currentCompactedKVs) {
            this.regions.add(new Region(name, stores, storefiles, storefileSizeMB, memstoreSizeMB, storefileIndexSizeMB, readRequestsCount, writeRequestsCount, rootIndexSizeKB, totalStaticIndexSizeKB, totalStaticBloomSizeKB, totalCompactingKVs, currentCompactedKVs));
        }

        public Region getRegion(int index) {
            return this.regions.get(index);
        }

        public Node() {
        }

        public Node(String name, long startCode) {
            this.name = name;
            this.startCode = startCode;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        @XmlAttribute
        public long getStartCode() {
            return this.startCode;
        }

        @XmlAttribute
        public int getHeapSizeMB() {
            return this.heapSizeMB;
        }

        @XmlAttribute
        public int getMaxHeapSizeMB() {
            return this.maxHeapSizeMB;
        }

        @XmlElement(name="Region")
        public List<Region> getRegions() {
            return this.regions;
        }

        @XmlAttribute
        public int getRequests() {
            return this.requests;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setStartCode(long startCode) {
            this.startCode = startCode;
        }

        public void setHeapSizeMB(int heapSizeMB) {
            this.heapSizeMB = heapSizeMB;
        }

        public void setMaxHeapSizeMB(int maxHeapSizeMB) {
            this.maxHeapSizeMB = maxHeapSizeMB;
        }

        public void setRegions(List<Region> regions) {
            this.regions = regions;
        }

        public void setRequests(int requests) {
            this.requests = requests;
        }

        public static class Region {
            private byte[] name;
            private int stores;
            private int storefiles;
            private int storefileSizeMB;
            private int memstoreSizeMB;
            private int storefileIndexSizeMB;
            private long readRequestsCount;
            private long writeRequestsCount;
            private int rootIndexSizeKB;
            private int totalStaticIndexSizeKB;
            private int totalStaticBloomSizeKB;
            private long totalCompactingKVs;
            private long currentCompactedKVs;

            public Region() {
            }

            public Region(byte[] name) {
                this.name = name;
            }

            public Region(byte[] name, int stores, int storefiles, int storefileSizeMB, int memstoreSizeMB, int storefileIndexSizeMB, long readRequestsCount, long writeRequestsCount, int rootIndexSizeKB, int totalStaticIndexSizeKB, int totalStaticBloomSizeKB, long totalCompactingKVs, long currentCompactedKVs) {
                this.name = name;
                this.stores = stores;
                this.storefiles = storefiles;
                this.storefileSizeMB = storefileSizeMB;
                this.memstoreSizeMB = memstoreSizeMB;
                this.storefileIndexSizeMB = storefileIndexSizeMB;
                this.readRequestsCount = readRequestsCount;
                this.writeRequestsCount = writeRequestsCount;
                this.rootIndexSizeKB = rootIndexSizeKB;
                this.totalStaticIndexSizeKB = totalStaticIndexSizeKB;
                this.totalStaticBloomSizeKB = totalStaticBloomSizeKB;
                this.totalCompactingKVs = totalCompactingKVs;
                this.currentCompactedKVs = currentCompactedKVs;
            }

            @XmlAttribute
            public byte[] getName() {
                return this.name;
            }

            @XmlAttribute
            public int getStores() {
                return this.stores;
            }

            @XmlAttribute
            public int getStorefiles() {
                return this.storefiles;
            }

            @XmlAttribute
            public int getStorefileSizeMB() {
                return this.storefileSizeMB;
            }

            @XmlAttribute
            public int getMemstoreSizeMB() {
                return this.memstoreSizeMB;
            }

            @XmlAttribute
            public int getStorefileIndexSizeMB() {
                return this.storefileIndexSizeMB;
            }

            @XmlAttribute
            public long getReadRequestsCount() {
                return this.readRequestsCount;
            }

            @XmlAttribute
            public long getWriteRequestsCount() {
                return this.writeRequestsCount;
            }

            @XmlAttribute
            public int getRootIndexSizeKB() {
                return this.rootIndexSizeKB;
            }

            @XmlAttribute
            public int getTotalStaticIndexSizeKB() {
                return this.totalStaticIndexSizeKB;
            }

            @XmlAttribute
            public int getTotalStaticBloomSizeKB() {
                return this.totalStaticBloomSizeKB;
            }

            @XmlAttribute
            public long getTotalCompactingKVs() {
                return this.totalCompactingKVs;
            }

            @XmlAttribute
            public long getCurrentCompactedKVs() {
                return this.currentCompactedKVs;
            }

            public void setReadRequestsCount(long readRequestsCount) {
                this.readRequestsCount = readRequestsCount;
            }

            public void setRootIndexSizeKB(int rootIndexSizeKB) {
                this.rootIndexSizeKB = rootIndexSizeKB;
            }

            public void setWriteRequestsCount(long writeRequestsCount) {
                this.writeRequestsCount = writeRequestsCount;
            }

            public void setCurrentCompactedKVs(long currentCompactedKVs) {
                this.currentCompactedKVs = currentCompactedKVs;
            }

            public void setTotalCompactingKVs(long totalCompactingKVs) {
                this.totalCompactingKVs = totalCompactingKVs;
            }

            public void setTotalStaticBloomSizeKB(int totalStaticBloomSizeKB) {
                this.totalStaticBloomSizeKB = totalStaticBloomSizeKB;
            }

            public void setTotalStaticIndexSizeKB(int totalStaticIndexSizeKB) {
                this.totalStaticIndexSizeKB = totalStaticIndexSizeKB;
            }

            public void setName(byte[] name) {
                this.name = name;
            }

            public void setStores(int stores) {
                this.stores = stores;
            }

            public void setStorefiles(int storefiles) {
                this.storefiles = storefiles;
            }

            public void setStorefileSizeMB(int storefileSizeMB) {
                this.storefileSizeMB = storefileSizeMB;
            }

            public void setMemstoreSizeMB(int memstoreSizeMB) {
                this.memstoreSizeMB = memstoreSizeMB;
            }

            public void setStorefileIndexSizeMB(int storefileIndexSizeMB) {
                this.storefileIndexSizeMB = storefileIndexSizeMB;
            }
        }
    }
}

