/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.filecompactions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.filecompactions.MobFileCompactionRequest;
import org.apache.hadoop.hbase.mob.filecompactions.MobFileCompactor;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactionRequest;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class PartitionedMobFileCompactor
extends MobFileCompactor {
    private static final Log LOG = LogFactory.getLog(PartitionedMobFileCompactor.class);
    protected long mergeableSize;
    protected int delFileMaxCount;
    protected int compactionBatchSize;
    protected int compactionKVMax;
    private Path tempPath;
    private Path bulkloadPath;
    private CacheConfig compactionCacheConfig;
    private Tag tableNameTag;

    public PartitionedMobFileCompactor(Configuration conf, FileSystem fs, TableName tableName, HColumnDescriptor column, ExecutorService pool) {
        super(conf, fs, tableName, column, pool);
        this.mergeableSize = conf.getLong("hbase.mob.file.compaction.mergeable.threshold", 0xC000000L);
        this.delFileMaxCount = conf.getInt("hbase.mob.delfile.max.count", 3);
        this.compactionBatchSize = conf.getInt("hbase.mob.file.compaction.batch.size", 100);
        this.tempPath = new Path(MobUtils.getMobHome(conf), ".tmp");
        this.bulkloadPath = new Path(this.tempPath, new Path(".bulkload", new Path(tableName.getNamespaceAsString(), tableName.getQualifierAsString())));
        this.compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        Configuration copyOfConf = new Configuration(conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        this.compactionCacheConfig = new CacheConfig(copyOfConf);
        this.tableNameTag = new Tag(6, tableName.getName());
    }

    @Override
    public List<Path> compact(List<FileStatus> files, boolean isForceAllFiles) throws IOException {
        if (files == null || files.isEmpty()) {
            LOG.info((Object)"No candidate mob files");
            return null;
        }
        LOG.info((Object)("isForceAllFiles: " + isForceAllFiles));
        PartitionedMobFileCompactionRequest request = this.select(files, isForceAllFiles);
        return this.performCompaction(request);
    }

    protected PartitionedMobFileCompactionRequest select(List<FileStatus> candidates, boolean isForceAllFiles) throws IOException {
        ArrayList<FileStatus> allDelFiles = new ArrayList<FileStatus>();
        HashMap<PartitionedMobFileCompactionRequest.CompactionPartitionId, PartitionedMobFileCompactionRequest.CompactionPartition> filesToCompact = new HashMap<PartitionedMobFileCompactionRequest.CompactionPartitionId, PartitionedMobFileCompactionRequest.CompactionPartition>();
        int selectedFileCount = 0;
        int irrelevantFileCount = 0;
        for (FileStatus file : candidates) {
            HFileLink link;
            if (!file.isFile()) {
                ++irrelevantFileCount;
                continue;
            }
            FileStatus linkedFile = file;
            if (HFileLink.isHFileLink(file.getPath()) && (linkedFile = this.getLinkedFileStatus(link = HFileLink.buildFromHFileLinkPattern(this.conf, file.getPath()))) == null) {
                ++irrelevantFileCount;
                continue;
            }
            if (StoreFileInfo.isDelFile(linkedFile.getPath())) {
                allDelFiles.add(file);
                continue;
            }
            if (!isForceAllFiles && linkedFile.getLen() >= this.mergeableSize) continue;
            MobFileName fileName = MobFileName.create(linkedFile.getPath().getName());
            PartitionedMobFileCompactionRequest.CompactionPartitionId id = new PartitionedMobFileCompactionRequest.CompactionPartitionId(fileName.getStartKey(), fileName.getDate());
            PartitionedMobFileCompactionRequest.CompactionPartition compactionPartition = (PartitionedMobFileCompactionRequest.CompactionPartition)filesToCompact.get(id);
            if (compactionPartition == null) {
                compactionPartition = new PartitionedMobFileCompactionRequest.CompactionPartition(id);
                compactionPartition.addFile(file);
                filesToCompact.put(id, compactionPartition);
            } else {
                compactionPartition.addFile(file);
            }
            ++selectedFileCount;
        }
        PartitionedMobFileCompactionRequest request = new PartitionedMobFileCompactionRequest(filesToCompact.values(), allDelFiles);
        if (candidates.size() == allDelFiles.size() + selectedFileCount + irrelevantFileCount) {
            request.setCompactionType(MobFileCompactionRequest.CompactionType.ALL_FILES);
        }
        LOG.info((Object)("The compaction type is " + (Object)((Object)request.getCompactionType()) + ", the request has " + allDelFiles.size() + " del files, " + selectedFileCount + " selected files, and " + irrelevantFileCount + " irrelevant files"));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Path> performCompaction(PartitionedMobFileCompactionRequest request) throws IOException {
        ArrayList<Path> delFilePaths = new ArrayList<Path>();
        for (FileStatus delFile : request.delFiles) {
            delFilePaths.add(delFile.getPath());
        }
        List<Path> newDelPaths = this.compactDelFiles(request, delFilePaths);
        ArrayList<StoreFile> newDelFiles = new ArrayList<StoreFile>();
        List<Path> paths = null;
        try {
            for (Path newDelPath : newDelPaths) {
                StoreFile sf = new StoreFile(this.fs, newDelPath, this.conf, this.compactionCacheConfig, BloomType.NONE);
                sf.createReader();
                newDelFiles.add(sf);
            }
            LOG.info((Object)("After merging, there are " + newDelFiles.size() + " del files"));
            paths = this.compactMobFiles(request, newDelFiles);
            LOG.info((Object)("After compaction, there are " + paths.size() + " mob files"));
        }
        finally {
            this.closeStoreFileReaders(newDelFiles);
        }
        if (request.type == MobFileCompactionRequest.CompactionType.ALL_FILES && !newDelPaths.isEmpty()) {
            LOG.info((Object)("After a mob file compaction with all files selected, archiving the del files " + newDelFiles));
            try {
                MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), newDelFiles);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to archive the del files " + newDelFiles), (Throwable)e);
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Path> compactMobFiles(final PartitionedMobFileCompactionRequest request, final List<StoreFile> delFiles) throws IOException {
        Collection<PartitionedMobFileCompactionRequest.CompactionPartition> partitions = request.compactionPartitions;
        if (partitions == null || partitions.isEmpty()) {
            LOG.info((Object)"No partitions of mob files");
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        final HTable table = new HTable(this.conf, this.tableName);
        try {
            HashMap<PartitionedMobFileCompactionRequest.CompactionPartitionId, Future<List<Path>>> results = new HashMap<PartitionedMobFileCompactionRequest.CompactionPartitionId, Future<List<Path>>>();
            for (final PartitionedMobFileCompactionRequest.CompactionPartition partition : partitions) {
                results.put(partition.getPartitionId(), this.pool.submit(new Callable<List<Path>>(){

                    @Override
                    public List<Path> call() throws Exception {
                        LOG.info((Object)("Compacting mob files for partition " + partition.getPartitionId()));
                        return PartitionedMobFileCompactor.this.compactMobFilePartition(request, partition, delFiles, table);
                    }
                }));
            }
            boolean hasFailure = false;
            for (Map.Entry result : results.entrySet()) {
                try {
                    paths.addAll((Collection)((Future)result.getValue()).get());
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to compact the partition " + result.getKey()), (Throwable)e);
                    hasFailure = true;
                }
            }
            if (hasFailure) {
                throw new IOException("Failed to compact the partitions");
            }
        }
        finally {
            try {
                table.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to close the HTable", (Throwable)e);
            }
        }
        return paths;
    }

    private List<Path> compactMobFilePartition(PartitionedMobFileCompactionRequest request, PartitionedMobFileCompactionRequest.CompactionPartition partition, List<StoreFile> delFiles, HTable table) throws IOException {
        ArrayList<Path> newFiles = new ArrayList<Path>();
        List<FileStatus> files = partition.listFiles();
        int offset = 0;
        Path bulkloadPathOfPartition = new Path(this.bulkloadPath, partition.getPartitionId().toString());
        Path bulkloadColumnPath = new Path(bulkloadPathOfPartition, this.column.getNameAsString());
        while (offset < files.size()) {
            int batch = this.compactionBatchSize;
            if (files.size() - offset < this.compactionBatchSize) {
                batch = files.size() - offset;
            }
            if (batch == 1 && delFiles.isEmpty()) {
                newFiles.add(files.get(offset).getPath());
                ++offset;
                continue;
            }
            this.fs.delete(bulkloadPathOfPartition, true);
            ArrayList<StoreFile> filesToCompact = new ArrayList<StoreFile>();
            for (int i = offset; i < batch + offset; ++i) {
                StoreFile sf = new StoreFile(this.fs, files.get(i).getPath(), this.conf, this.compactionCacheConfig, BloomType.NONE);
                filesToCompact.add(sf);
            }
            filesToCompact.addAll(delFiles);
            this.compactMobFilesInBatch(request, partition, table, filesToCompact, batch, bulkloadPathOfPartition, bulkloadColumnPath, newFiles);
            offset += batch;
        }
        LOG.info((Object)("Compaction is finished. The number of mob files is changed from " + files.size() + " to " + newFiles.size()));
        return newFiles;
    }

    private void closeStoreFileReaders(List<StoreFile> storeFiles) {
        for (StoreFile storeFile : storeFiles) {
            try {
                storeFile.closeReader(true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to close the reader on store file " + storeFile.getPath()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactMobFilesInBatch(PartitionedMobFileCompactionRequest request, PartitionedMobFileCompactionRequest.CompactionPartition partition, HTable table, List<StoreFile> filesToCompact, int batch, Path bulkloadPathOfPartition, Path bulkloadColumnPath, List<Path> newFiles) throws IOException {
        StoreScanner scanner = this.createScanner(filesToCompact, ScanType.COMPACT_DROP_DELETES);
        List<StoreFile> mobFilesToCompact = filesToCompact.subList(0, batch);
        Pair<Long, Long> fileInfo = this.getFileInfo(mobFilesToCompact);
        StoreFile.Writer writer = null;
        StoreFile.Writer refFileWriter = null;
        Path filePath = null;
        Path refFilePath = null;
        long mobCells = 0L;
        try {
            writer = MobUtils.createWriter(this.conf, this.fs, this.column, partition.getPartitionId().getDate(), this.tempPath, Long.MAX_VALUE, this.column.getCompactionCompression(), partition.getPartitionId().getStartKey(), this.compactionCacheConfig);
            filePath = writer.getPath();
            byte[] fileName = Bytes.toBytes((String)filePath.getName());
            refFileWriter = MobUtils.createRefFileWriter(this.conf, this.fs, this.column, bulkloadColumnPath, (Long)fileInfo.getSecond(), this.compactionCacheConfig);
            refFilePath = refFileWriter.getPath();
            ArrayList<Cell> cells = new ArrayList<Cell>();
            boolean hasMore = false;
            ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
            do {
                hasMore = scanner.next(cells, scannerContext);
                for (Cell cell : cells) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                    writer.append((Cell)kv);
                    KeyValue reference = MobUtils.createMobRefKeyValue((Cell)kv, fileName, this.tableNameTag);
                    refFileWriter.append((Cell)reference);
                    ++mobCells;
                }
                cells.clear();
            } while (hasMore);
            scanner.close();
        }
        catch (Throwable throwable) {
            scanner.close();
            this.closeMobFileWriter(writer, (Long)fileInfo.getFirst(), mobCells);
            this.closeRefFileWriter(refFileWriter, (Long)fileInfo.getFirst(), request.selectionTime);
            throw throwable;
        }
        this.closeMobFileWriter(writer, (Long)fileInfo.getFirst(), mobCells);
        this.closeRefFileWriter(refFileWriter, (Long)fileInfo.getFirst(), request.selectionTime);
        if (mobCells > 0L) {
            MobUtils.commitFile(this.conf, this.fs, filePath, this.mobFamilyDir, this.compactionCacheConfig);
            this.bulkloadRefFile(table, bulkloadPathOfPartition, filePath.getName());
            newFiles.add(new Path(this.mobFamilyDir, filePath.getName()));
        } else {
            this.deletePath(filePath);
            this.deletePath(refFilePath);
        }
        try {
            this.closeStoreFileReaders(mobFilesToCompact);
            MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), mobFilesToCompact);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to archive the files " + mobFilesToCompact), (Throwable)e);
        }
    }

    protected List<Path> compactDelFiles(PartitionedMobFileCompactionRequest request, List<Path> delFilePaths) throws IOException {
        if (delFilePaths.size() <= this.delFileMaxCount) {
            return delFilePaths;
        }
        int offset = 0;
        ArrayList<Path> paths = new ArrayList<Path>();
        while (offset < delFilePaths.size()) {
            int batch = this.compactionBatchSize;
            if (delFilePaths.size() - offset < this.compactionBatchSize) {
                batch = delFilePaths.size() - offset;
            }
            ArrayList<StoreFile> batchedDelFiles = new ArrayList<StoreFile>();
            if (batch == 1) {
                paths.add(delFilePaths.get(offset));
                ++offset;
                continue;
            }
            for (int i = offset; i < batch + offset; ++i) {
                batchedDelFiles.add(new StoreFile(this.fs, delFilePaths.get(i), this.conf, this.compactionCacheConfig, BloomType.NONE));
            }
            paths.add(this.compactDelFilesInBatch(request, batchedDelFiles));
            offset += batch;
        }
        return this.compactDelFiles(request, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path compactDelFilesInBatch(PartitionedMobFileCompactionRequest request, List<StoreFile> delFiles) throws IOException {
        Path filePath;
        block10: {
            StoreScanner scanner = this.createScanner(delFiles, ScanType.COMPACT_RETAIN_DELETES);
            StoreFile.Writer writer = null;
            filePath = null;
            try {
                writer = MobUtils.createDelFileWriter(this.conf, this.fs, this.column, MobUtils.formatDate(new Date(request.selectionTime)), this.tempPath, Long.MAX_VALUE, this.column.getCompactionCompression(), HConstants.EMPTY_START_ROW, this.compactionCacheConfig);
                filePath = writer.getPath();
                ArrayList<Cell> cells = new ArrayList<Cell>();
                boolean hasMore = false;
                ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
                do {
                    hasMore = scanner.next(cells, scannerContext);
                    for (Cell cell : cells) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        writer.append((Cell)kv);
                    }
                    cells.clear();
                } while (hasMore);
                scanner.close();
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                scanner.close();
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to close the writer of the file " + filePath), (Throwable)e);
                }
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to close the writer of the file " + filePath), (Throwable)e);
            }
        }
        Path path = MobUtils.commitFile(this.conf, this.fs, filePath, this.mobFamilyDir, this.compactionCacheConfig);
        try {
            MobUtils.removeMobFiles(this.conf, this.fs, this.tableName, this.mobTableDir, this.column.getName(), delFiles);
            return path;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to archive the old del files " + delFiles), (Throwable)e);
        }
        return path;
    }

    private StoreScanner createScanner(List<StoreFile> filesToCompact, ScanType scanType) throws IOException {
        List<KeyValueScanner> scanners = StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, true, false, null, Long.MAX_VALUE);
        Scan scan = new Scan();
        scan.setMaxVersions(this.column.getMaxVersions());
        long ttl = HStore.determineTTLFromFamily(this.column);
        ScanInfo scanInfo = new ScanInfo(this.column, ttl, 0L, KeyValue.COMPARATOR);
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners, 0L, Long.MAX_VALUE);
        return scanner;
    }

    private void bulkloadRefFile(HTable table, Path bulkloadDirectory, String fileName) throws IOException {
        try {
            LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(this.conf);
            bulkload.doBulkLoad(bulkloadDirectory, table);
        }
        catch (Exception e) {
            this.deletePath(new Path(this.mobFamilyDir, fileName));
            throw new IOException(e);
        }
        finally {
            this.deletePath(bulkloadDirectory);
        }
    }

    private void closeMobFileWriter(StoreFile.Writer writer, long maxSeqId, long mobCellsCount) throws IOException {
        if (writer != null) {
            writer.appendMetadata(maxSeqId, false, mobCellsCount);
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to close the writer of the file " + writer.getPath()), (Throwable)e);
            }
        }
    }

    private void closeRefFileWriter(StoreFile.Writer writer, long maxSeqId, long bulkloadTime) throws IOException {
        if (writer != null) {
            writer.appendMetadata(maxSeqId, false);
            writer.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)bulkloadTime));
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to close the writer of the ref file " + writer.getPath()), (Throwable)e);
            }
        }
    }

    private Pair<Long, Long> getFileInfo(List<StoreFile> storeFiles) throws IOException {
        long maxSeqId = 0L;
        long maxKeyCount = 0L;
        for (StoreFile sf : storeFiles) {
            maxSeqId = Math.max(maxSeqId, sf.getMaxSequenceId());
            byte[] count = sf.createReader().loadFileInfo().get(StoreFile.MOB_CELLS_COUNT);
            if (count == null) continue;
            maxKeyCount += Bytes.toLong((byte[])count);
        }
        return new Pair((Object)maxSeqId, (Object)maxKeyCount);
    }

    private void deletePath(Path path) {
        try {
            if (path != null) {
                this.fs.delete(path, true);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to delete the file " + path), (Throwable)e);
        }
    }

    private FileStatus getLinkedFileStatus(HFileLink link) throws IOException {
        Path[] locations;
        for (Path location : locations = link.getLocations()) {
            FileStatus file = this.getFileStatus(location);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private FileStatus getFileStatus(Path path) throws IOException {
        try {
            if (path != null) {
                FileStatus file = this.fs.getFileStatus(path);
                return file;
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("The file " + path + " can not be found"), (Throwable)e);
        }
        return null;
    }
}

