/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJobNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SweepMapper
extends TableMapper<Text, KeyValue> {
    private ZooKeeperWatcher zkw = null;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String id = context.getConfiguration().get("mob.sweep.job.id");
        String owner = context.getConfiguration().get("mob.sweep.job.servername");
        String sweeperNode = context.getConfiguration().get("mob.sweep.job.table.node");
        this.zkw = new ZooKeeperWatcher(context.getConfiguration(), id, (Abortable)new SweepJob.DummyMobAbortable());
        try {
            SweepJobNodeTracker tracker = new SweepJobNodeTracker(this.zkw, sweeperNode, owner);
            tracker.start();
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.zkw != null) {
            this.zkw.close();
        }
    }

    public void map(ImmutableBytesWritable r, Result columns, Mapper.Context context) throws IOException, InterruptedException {
        if (columns == null) {
            return;
        }
        KeyValue[] kvList = columns.raw();
        if (kvList == null || kvList.length == 0) {
            return;
        }
        for (KeyValue kv : kvList) {
            if (!MobUtils.hasValidMobRefCellValue((Cell)kv)) continue;
            String fileName = MobUtils.getMobFileName((Cell)kv);
            context.write((Object)new Text(fileName), (Object)kv);
        }
    }
}

