/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.pig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hcatalog.common.HCatConstants;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.data.Pair;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PigHCatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PigHCatUtil.class);
    static final int PIG_EXCEPTION_CODE = 1115;
    private static final String DEFAULT_DB = "default";
    private final Map<Pair<String, String>, Table> hcatTableCache = new HashMap<Pair<String, String>, Table>();
    private static final TupleFactory tupFac = TupleFactory.getInstance();
    private static boolean pigHasBooleanSupport = false;

    PigHCatUtil() {
    }

    public static boolean pigHasBooleanSupport() {
        return pigHasBooleanSupport;
    }

    public static Pair<String, String> getDBTableNames(String location) throws IOException {
        try {
            return HCatUtil.getDbAndTableName((String)location);
        }
        catch (IOException e) {
            String locationErrMsg = "The input location in load statement should be of the form <databasename>.<table name> or <table name>. Got " + location;
            throw new PigException(locationErrMsg, 1115);
        }
    }

    public static String getHCatServerUri(Job job) {
        return job.getConfiguration().get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    public static String getHCatServerPrincipal(Job job) {
        return job.getConfiguration().get(HCatConstants.HCAT_METASTORE_PRINCIPAL);
    }

    private static HiveMetaStoreClient getHiveMetaClient(String serverUri, String serverKerberosPrincipal, Class<?> clazz) throws Exception {
        HiveConf hiveConf = new HiveConf(clazz);
        if (serverUri != null) {
            hiveConf.set("hive.metastore.local", "false");
            hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, serverUri.trim());
        }
        if (serverKerberosPrincipal != null) {
            hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, true);
            hiveConf.setVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL, serverKerberosPrincipal);
        }
        try {
            return HCatUtil.getHiveClient((HiveConf)hiveConf);
        }
        catch (Exception e) {
            throw new Exception("Could not instantiate a HiveMetaStoreClient connecting to server uri:[" + serverUri + "]", e);
        }
    }

    HCatSchema getHCatSchema(List<LoadPushDown.RequiredField> fields, String signature, Class<?> classForUDFCLookup) throws IOException {
        if (fields == null) {
            return null;
        }
        Properties props = UDFContext.getUDFContext().getUDFProperties(classForUDFCLookup, new String[]{signature});
        HCatSchema hcatTableSchema = (HCatSchema)props.get("hcat.table.schema");
        ArrayList fcols = new ArrayList();
        for (LoadPushDown.RequiredField rf : fields) {
            fcols.add(hcatTableSchema.getFields().get(rf.getIndex()));
        }
        return new HCatSchema(fcols);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Table getTable(String location, String hcatServerUri, String hcatServerPrincipal) throws IOException {
        Pair loc_server = new Pair((Object)location, (Object)hcatServerUri);
        Table hcatTable = this.hcatTableCache.get(loc_server);
        if (hcatTable != null) {
            return hcatTable;
        }
        Pair<String, String> dbTablePair = PigHCatUtil.getDBTableNames(location);
        String dbName = (String)dbTablePair.first;
        String tableName = (String)dbTablePair.second;
        Table table = null;
        HiveMetaStoreClient client = null;
        try {
            client = PigHCatUtil.getHiveMetaClient(hcatServerUri, hcatServerPrincipal, PigHCatUtil.class);
            table = HCatUtil.getTable((HiveMetaStoreClient)client, (String)dbName, (String)tableName);
        }
        catch (NoSuchObjectException nsoe) {
            try {
                throw new PigException("Table not found : " + nsoe.getMessage(), 1115);
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            catch (Throwable throwable) {
                HCatUtil.closeHiveClientQuietly(client);
                throw throwable;
            }
        }
        HCatUtil.closeHiveClientQuietly((HiveMetaStoreClient)client);
        this.hcatTableCache.put((Pair<String, String>)loc_server, table);
        return table;
    }

    public static ResourceSchema getResourceSchema(HCatSchema hcatSchema) throws IOException {
        ArrayList<ResourceSchema.ResourceFieldSchema> rfSchemaList = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (HCatFieldSchema hfs : hcatSchema.getFields()) {
            ResourceSchema.ResourceFieldSchema rfSchema = PigHCatUtil.getResourceSchemaFromFieldSchema(hfs);
            rfSchemaList.add(rfSchema);
        }
        ResourceSchema rSchema = new ResourceSchema();
        rSchema.setFields(rfSchemaList.toArray(new ResourceSchema.ResourceFieldSchema[0]));
        return rSchema;
    }

    private static ResourceSchema.ResourceFieldSchema getResourceSchemaFromFieldSchema(HCatFieldSchema hfs) throws IOException {
        ResourceSchema.ResourceFieldSchema rfSchema = hfs.getType() == HCatFieldSchema.Type.STRUCT ? new ResourceSchema.ResourceFieldSchema().setName(hfs.getName()).setDescription(hfs.getComment()).setType(PigHCatUtil.getPigType(hfs)).setSchema(PigHCatUtil.getTupleSubSchema(hfs)) : (hfs.getType() == HCatFieldSchema.Type.ARRAY ? new ResourceSchema.ResourceFieldSchema().setName(hfs.getName()).setDescription(hfs.getComment()).setType(PigHCatUtil.getPigType(hfs)).setSchema(PigHCatUtil.getBagSubSchema(hfs)) : new ResourceSchema.ResourceFieldSchema().setName(hfs.getName()).setDescription(hfs.getComment()).setType(PigHCatUtil.getPigType(hfs)).setSchema(null));
        return rfSchema;
    }

    protected static ResourceSchema getBagSubSchema(HCatFieldSchema hfs) throws IOException {
        ResourceSchema s;
        Properties props = UDFContext.getUDFContext().getClientSystemProps();
        String innerTupleName = "innertuple";
        if (props != null && props.containsKey("hcat.pig.inner.tuple.name")) {
            innerTupleName = props.getProperty("hcat.pig.inner.tuple.name").replaceAll("FIELDNAME", hfs.getName());
        }
        String innerFieldName = "innerfield";
        if (props != null && props.containsKey("hcat.pig.inner.field.name")) {
            innerFieldName = props.getProperty("hcat.pig.inner.field.name").replaceAll("FIELDNAME", hfs.getName());
        }
        ResourceSchema.ResourceFieldSchema[] bagSubFieldSchemas = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName(innerTupleName).setDescription("The tuple in the bag").setType((byte)110)};
        HCatFieldSchema arrayElementFieldSchema = hfs.getArrayElementSchema().get(0);
        if (arrayElementFieldSchema.getType() == HCatFieldSchema.Type.STRUCT) {
            bagSubFieldSchemas[0].setSchema(PigHCatUtil.getTupleSubSchema(arrayElementFieldSchema));
        } else if (arrayElementFieldSchema.getType() == HCatFieldSchema.Type.ARRAY) {
            s = new ResourceSchema();
            List<ResourceSchema.ResourceFieldSchema> lrfs = Arrays.asList(PigHCatUtil.getResourceSchemaFromFieldSchema(arrayElementFieldSchema));
            s.setFields(lrfs.toArray(new ResourceSchema.ResourceFieldSchema[0]));
            bagSubFieldSchemas[0].setSchema(s);
        } else {
            ResourceSchema.ResourceFieldSchema[] innerTupleFieldSchemas = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema().setName(innerFieldName).setDescription("The inner field in the tuple in the bag").setType(PigHCatUtil.getPigType(arrayElementFieldSchema)).setSchema(null)};
            bagSubFieldSchemas[0].setSchema(new ResourceSchema().setFields(innerTupleFieldSchemas));
        }
        s = new ResourceSchema().setFields(bagSubFieldSchemas);
        return s;
    }

    private static ResourceSchema getTupleSubSchema(HCatFieldSchema hfs) throws IOException {
        ResourceSchema s = new ResourceSchema();
        ArrayList<ResourceSchema.ResourceFieldSchema> lrfs = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (HCatFieldSchema subField : hfs.getStructSubSchema().getFields()) {
            lrfs.add(PigHCatUtil.getResourceSchemaFromFieldSchema(subField));
        }
        s.setFields(lrfs.toArray(new ResourceSchema.ResourceFieldSchema[0]));
        return s;
    }

    public static byte getPigType(HCatFieldSchema hfs) throws IOException {
        return PigHCatUtil.getPigType(hfs.getType());
    }

    public static byte getPigType(HCatFieldSchema.Type type) throws IOException {
        if (type == HCatFieldSchema.Type.STRING) {
            return 55;
        }
        if (type == HCatFieldSchema.Type.INT || type == HCatFieldSchema.Type.SMALLINT || type == HCatFieldSchema.Type.TINYINT) {
            return 10;
        }
        if (type == HCatFieldSchema.Type.ARRAY) {
            return 120;
        }
        if (type == HCatFieldSchema.Type.STRUCT) {
            return 110;
        }
        if (type == HCatFieldSchema.Type.MAP) {
            return 100;
        }
        if (type == HCatFieldSchema.Type.BIGINT) {
            return 15;
        }
        if (type == HCatFieldSchema.Type.FLOAT) {
            return 20;
        }
        if (type == HCatFieldSchema.Type.DOUBLE) {
            return 25;
        }
        if (type == HCatFieldSchema.Type.BINARY) {
            return 50;
        }
        if (type == HCatFieldSchema.Type.BOOLEAN && pigHasBooleanSupport) {
            return 5;
        }
        throw new PigException("HCatalog column type '" + type.toString() + "' is not supported in Pig as a column type", 1115);
    }

    public static Tuple transformToTuple(HCatRecord hr, HCatSchema hs) throws Exception {
        if (hr == null) {
            return null;
        }
        return PigHCatUtil.transformToTuple((List<? extends Object>)hr.getAll(), hs);
    }

    public static Object extractPigObject(Object o, HCatFieldSchema hfs) throws Exception {
        Map<String, Object> result;
        HCatFieldSchema.Type itemType = hfs.getType();
        switch (itemType) {
            case BINARY: {
                result = o == null ? null : new DataByteArray((byte[])o);
                break;
            }
            case STRUCT: {
                result = PigHCatUtil.transformToTuple((List<? extends Object>)((List)((Object)o)), hfs);
                break;
            }
            case ARRAY: {
                result = PigHCatUtil.transformToBag((List)((Object)o), hfs);
                break;
            }
            case MAP: {
                result = PigHCatUtil.transformToPigMap((Map<Object, Object>)o, hfs);
                break;
            }
            default: {
                result = o;
            }
        }
        return result;
    }

    private static Tuple transformToTuple(List<? extends Object> objList, HCatFieldSchema hfs) throws Exception {
        try {
            return PigHCatUtil.transformToTuple(objList, hfs.getStructSubSchema());
        }
        catch (Exception e) {
            if (hfs.getType() != HCatFieldSchema.Type.STRUCT) {
                throw new Exception("Expected Struct type, got " + hfs.getType(), e);
            }
            throw e;
        }
    }

    private static Tuple transformToTuple(List<? extends Object> objList, HCatSchema hs) throws Exception {
        if (objList == null) {
            return null;
        }
        Tuple t = tupFac.newTuple(objList.size());
        List subFields = hs.getFields();
        for (int i = 0; i < subFields.size(); ++i) {
            t.set(i, PigHCatUtil.extractPigObject(objList.get(i), (HCatFieldSchema)subFields.get(i)));
        }
        return t;
    }

    private static Map<String, Object> transformToPigMap(Map<Object, Object> map, HCatFieldSchema hfs) throws Exception {
        if (map == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), PigHCatUtil.extractPigObject(entry.getValue(), hfs.getMapValueSchema().get(0)));
        }
        return result;
    }

    private static DataBag transformToBag(List<? extends Object> list, HCatFieldSchema hfs) throws Exception {
        if (list == null) {
            return null;
        }
        HCatFieldSchema elementSubFieldSchema = (HCatFieldSchema)hfs.getArrayElementSchema().getFields().get(0);
        DefaultDataBag db = new DefaultDataBag();
        for (Object object : list) {
            Tuple tuple = elementSubFieldSchema.getType() == HCatFieldSchema.Type.STRUCT ? PigHCatUtil.transformToTuple((List<? extends Object>)((List)object), elementSubFieldSchema) : tupFac.newTuple(PigHCatUtil.extractPigObject(object, elementSubFieldSchema));
            db.add(tuple);
        }
        return db;
    }

    private static void validateHCatSchemaFollowsPigRules(HCatSchema tblSchema) throws PigException {
        for (HCatFieldSchema hcatField : tblSchema.getFields()) {
            PigHCatUtil.validateHcatFieldFollowsPigRules(hcatField);
        }
    }

    private static void validateHcatFieldFollowsPigRules(HCatFieldSchema hcatField) throws PigException {
        try {
            HCatFieldSchema.Type hType = hcatField.getType();
            switch (hType) {
                case BOOLEAN: {
                    if (pigHasBooleanSupport) break;
                    throw new PigException("Incompatible type found in HCat table schema: " + hcatField, 1115);
                }
                case ARRAY: {
                    PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatField.getArrayElementSchema());
                    break;
                }
                case STRUCT: {
                    PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatField.getStructSubSchema());
                    break;
                }
                case MAP: {
                    if (hcatField.getMapKeyType() != HCatFieldSchema.Type.STRING) {
                        LOG.info("Converting non-String key of map " + hcatField.getName() + " from " + hcatField.getMapKeyType() + " to String.");
                    }
                    PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatField.getMapValueSchema());
                }
            }
        }
        catch (HCatException e) {
            throw new PigException("Incompatible type found in hcat table schema: " + hcatField, 1115, (Throwable)e);
        }
    }

    public static void validateHCatTableSchemaFollowsPigRules(HCatSchema hcatTableSchema) throws IOException {
        PigHCatUtil.validateHCatSchemaFollowsPigRules(hcatTableSchema);
    }

    public static void getConfigFromUDFProperties(Properties p, Configuration config, String propName) {
        if (p.getProperty(propName) != null) {
            config.set(propName, p.getProperty(propName));
        }
    }

    public static void saveConfigIntoUDFProperties(Properties p, Configuration config, String propName) {
        if (config.get(propName) != null) {
            p.setProperty(propName, config.get(propName));
        }
    }

    static {
        try {
            Schema schema = Utils.getSchemaFromString((String)"myBooleanField: boolean");
            pigHasBooleanSupport = schema.getField((String)"myBooleanField").type == 5;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!pigHasBooleanSupport) {
            LOG.info("This version of Pig does not support boolean fields. To enable boolean-to-integer conversion, set the hcat.data.convert.boolean.to.integer=true configuration parameter.");
        }
    }
}

