/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.LoopingByteArrayInputStream;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;

public class HiveConf
extends Configuration {
    protected String hiveJar;
    protected Properties origProp;
    protected String auxJars;
    private static final Log l4j = LogFactory.getLog(HiveConf.class);
    private static URL hiveDefaultURL = null;
    private static URL hiveSiteURL = null;
    private static byte[] confVarByteArray = null;
    private static final Map<String, ConfVars> vars = new HashMap<String, ConfVars>();
    private final List<String> restrictList = new ArrayList<String>();
    public static final String DATABASE_WAREHOUSE_SUFFIX = ".db";
    public static final String DEFAULT_DATABASE_COMMENT = "Default Hive database";
    public static final String DEFAULT_DATABASE_NAME = "default";
    public static final ConfVars[] metaVars;
    public static final ConfVars[] dbVars;
    public static final ConfVars[] userVars;
    public static final ConfVars[] restrictedVars;

    private static synchronized InputStream getConfVarInputStream() {
        if (confVarByteArray == null) {
            try {
                Configuration conf = new Configuration();
                HiveConf.applyDefaultNonNullConfVars(conf);
                ByteArrayOutputStream confVarBaos = new ByteArrayOutputStream();
                conf.writeXml((OutputStream)confVarBaos);
                confVarByteArray = confVarBaos.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize default Hive configuration variables!", e);
            }
        }
        return new LoopingByteArrayInputStream(confVarByteArray);
    }

    public void verifyAndSet(String name, String value) throws IllegalArgumentException {
        if (this.restrictList.contains(name)) {
            throw new IllegalArgumentException("Cann't modify " + name + " at runtime");
        }
        this.set(name, value);
    }

    public static int getIntVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Integer.class);
        return conf.getInt(var.varname, var.defaultIntVal);
    }

    public static void setIntVar(Configuration conf, ConfVars var, int val) {
        assert (var.valClass == Integer.class);
        conf.setInt(var.varname, val);
    }

    public int getIntVar(ConfVars var) {
        return HiveConf.getIntVar(this, var);
    }

    public void setIntVar(ConfVars var, int val) {
        HiveConf.setIntVar(this, var, val);
    }

    public static long getLongVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Long.class);
        return conf.getLong(var.varname, var.defaultLongVal);
    }

    public static long getLongVar(Configuration conf, ConfVars var, long defaultVal) {
        return conf.getLong(var.varname, defaultVal);
    }

    public static void setLongVar(Configuration conf, ConfVars var, long val) {
        assert (var.valClass == Long.class);
        conf.setLong(var.varname, val);
    }

    public long getLongVar(ConfVars var) {
        return HiveConf.getLongVar(this, var);
    }

    public void setLongVar(ConfVars var, long val) {
        HiveConf.setLongVar(this, var, val);
    }

    public static float getFloatVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Float.class);
        return conf.getFloat(var.varname, var.defaultFloatVal);
    }

    public static float getFloatVar(Configuration conf, ConfVars var, float defaultVal) {
        return conf.getFloat(var.varname, defaultVal);
    }

    public static void setFloatVar(Configuration conf, ConfVars var, float val) {
        assert (var.valClass == Float.class);
        ShimLoader.getHadoopShims().setFloatConf(conf, var.varname, val);
    }

    public float getFloatVar(ConfVars var) {
        return HiveConf.getFloatVar(this, var);
    }

    public void setFloatVar(ConfVars var, float val) {
        HiveConf.setFloatVar(this, var, val);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Boolean.class);
        return conf.getBoolean(var.varname, var.defaultBoolVal);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var, boolean defaultVal) {
        return conf.getBoolean(var.varname, defaultVal);
    }

    public static void setBoolVar(Configuration conf, ConfVars var, boolean val) {
        assert (var.valClass == Boolean.class);
        conf.setBoolean(var.varname, val);
    }

    public boolean getBoolVar(ConfVars var) {
        return HiveConf.getBoolVar(this, var);
    }

    public void setBoolVar(ConfVars var, boolean val) {
        HiveConf.setBoolVar(this, var, val);
    }

    public static String getVar(Configuration conf, ConfVars var) {
        assert (var.valClass == String.class);
        return conf.get(var.varname, var.defaultVal);
    }

    public static String getVar(Configuration conf, ConfVars var, String defaultVal) {
        return conf.get(var.varname, defaultVal);
    }

    public static void setVar(Configuration conf, ConfVars var, String val) {
        assert (var.valClass == String.class);
        conf.set(var.varname, val);
    }

    public static ConfVars getConfVars(String name) {
        return vars.get(name);
    }

    public String getVar(ConfVars var) {
        return HiveConf.getVar(this, var);
    }

    public void setVar(ConfVars var, String val) {
        HiveConf.setVar(this, var, val);
    }

    public void logVars(PrintStream ps) {
        for (ConfVars one : ConfVars.values()) {
            ps.println(one.varname + "=" + (this.get(one.varname) != null ? this.get(one.varname) : ""));
        }
    }

    public HiveConf() {
        this.initialize(((Object)((Object)this)).getClass());
    }

    public HiveConf(Class<?> cls) {
        this.initialize(cls);
    }

    public HiveConf(Configuration other, Class<?> cls) {
        super(other);
        this.initialize(cls);
    }

    public HiveConf(HiveConf other) {
        super((Configuration)other);
        this.hiveJar = other.hiveJar;
        this.auxJars = other.auxJars;
        this.origProp = (Properties)other.origProp.clone();
    }

    public Properties getAllProperties() {
        return HiveConf.getProperties(this);
    }

    private static Properties getProperties(Configuration conf) {
        Iterator iter = conf.iterator();
        Properties p = new Properties();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            p.setProperty((String)e.getKey(), (String)e.getValue());
        }
        return p;
    }

    private void initialize(Class<?> cls) {
        this.hiveJar = new JobConf(cls).getJar();
        this.origProp = this.getAllProperties();
        this.addResource(HiveConf.getConfVarInputStream());
        if (hiveSiteURL != null) {
            this.addResource(hiveSiteURL);
        }
        this.applySystemProperties();
        if (this.get("hive.metastore.local", null) != null) {
            l4j.warn((Object)"DEPRECATED: Configuration property hive.metastore.local no longer has any effect. Make sure to provide a valid value for hive.metastore.uris if you are connecting to a remote metastore.");
        }
        if (this.hiveJar == null) {
            this.hiveJar = this.get(ConfVars.HIVEJAR.varname);
        }
        if (this.auxJars == null) {
            this.auxJars = this.get(ConfVars.HIVEAUXJARS.varname);
        }
        for (ConfVars confVar : restrictedVars) {
            this.restrictList.add(confVar.varname);
        }
        String restrictListStr = this.get(ConfVars.HIVE_CONF_RESTRICTED_LIST.toString());
        if (restrictListStr != null) {
            for (String entry : restrictListStr.split(",")) {
                this.restrictList.add(entry);
            }
        }
        this.restrictList.add(ConfVars.HIVE_CONF_RESTRICTED_LIST.toString());
    }

    private void applySystemProperties() {
        Map<String, String> systemProperties = HiveConf.getConfSystemProperties();
        for (Map.Entry<String, String> systemProperty : systemProperties.entrySet()) {
            this.set(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    public static Map<String, String> getConfSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (ConfVars oneVar : ConfVars.values()) {
            if (System.getProperty(oneVar.varname) == null || System.getProperty(oneVar.varname).length() <= 0) continue;
            systemProperties.put(oneVar.varname, System.getProperty(oneVar.varname));
        }
        return systemProperties;
    }

    private static void applyDefaultNonNullConfVars(Configuration conf) {
        for (ConfVars var : ConfVars.values()) {
            if (var.defaultVal == null) continue;
            if (conf.get(var.varname) != null) {
                l4j.debug((Object)("Overriding Hadoop conf property " + var.varname + "='" + conf.get(var.varname) + "' with Hive default value '" + var.defaultVal + "'"));
            }
            conf.set(var.varname, var.defaultVal);
        }
    }

    public Properties getChangedProperties() {
        Properties ret = new Properties();
        Properties newProp = this.getAllProperties();
        for (Object one : newProp.keySet()) {
            String oneProp = (String)one;
            String oldValue = this.origProp.getProperty(oneProp);
            if (StringUtils.equals((String)oldValue, (String)newProp.getProperty(oneProp))) continue;
            ret.setProperty(oneProp, newProp.getProperty(oneProp));
        }
        return ret;
    }

    public String getJar() {
        return this.hiveJar;
    }

    public String getAuxJars() {
        return this.auxJars;
    }

    public void setAuxJars(String auxJars) {
        this.auxJars = auxJars;
        HiveConf.setVar(this, ConfVars.HIVEAUXJARS, auxJars);
    }

    public URL getHiveDefaultLocation() {
        return hiveDefaultURL;
    }

    public URL getHiveSiteLocation() {
        return hiveSiteURL;
    }

    public String getUser() throws IOException {
        try {
            UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf((Configuration)this);
            return ugi.getUserName();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }

    public static String getColumnInternalName(int pos) {
        return "_col" + pos;
    }

    public static int getPositionFromInternalName(String internalName) {
        Pattern internalPattern = Pattern.compile("_col([0-9]+)");
        Matcher m = internalPattern.matcher(internalName);
        if (!m.matches()) {
            return -1;
        }
        return Integer.parseInt(m.group(1));
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = HiveConf.class.getClassLoader();
        }
        hiveDefaultURL = classLoader.getResource("hive-default.xml");
        hiveSiteURL = classLoader.getResource("hive-site.xml");
        for (ConfVars confVar : ConfVars.values()) {
            vars.put(confVar.varname, confVar);
        }
        metaVars = new ConfVars[]{ConfVars.METASTOREDIRECTORY, ConfVars.METASTOREWAREHOUSE, ConfVars.METASTOREURIS, ConfVars.METASTORETHRIFTCONNECTIONRETRIES, ConfVars.METASTORETHRIFTFAILURERETRIES, ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, ConfVars.METASTOREPWD, ConfVars.METASTORECONNECTURLHOOK, ConfVars.METASTORECONNECTURLKEY, ConfVars.METASTOREATTEMPTS, ConfVars.METASTOREINTERVAL, ConfVars.METASTOREFORCERELOADCONF, ConfVars.METASTORESERVERMINTHREADS, ConfVars.METASTORESERVERMAXTHREADS, ConfVars.METASTORE_TCP_KEEP_ALIVE, ConfVars.METASTORE_INT_ORIGINAL, ConfVars.METASTORE_INT_ARCHIVED, ConfVars.METASTORE_INT_EXTRACTED, ConfVars.METASTORE_KERBEROS_KEYTAB_FILE, ConfVars.METASTORE_KERBEROS_PRINCIPAL, ConfVars.METASTORE_USE_THRIFT_SASL, ConfVars.METASTORE_CACHE_PINOBJTYPES, ConfVars.METASTORE_CONNECTION_POOLING_TYPE, ConfVars.METASTORE_VALIDATE_TABLES, ConfVars.METASTORE_VALIDATE_COLUMNS, ConfVars.METASTORE_VALIDATE_CONSTRAINTS, ConfVars.METASTORE_STORE_MANAGER_TYPE, ConfVars.METASTORE_AUTO_CREATE_SCHEMA, ConfVars.METASTORE_AUTO_START_MECHANISM_MODE, ConfVars.METASTORE_TRANSACTION_ISOLATION, ConfVars.METASTORE_CACHE_LEVEL2, ConfVars.METASTORE_CACHE_LEVEL2_TYPE, ConfVars.METASTORE_IDENTIFIER_FACTORY, ConfVars.METASTORE_PLUGIN_REGISTRY_BUNDLE_CHECK, ConfVars.METASTORE_AUTHORIZATION_STORAGE_AUTH_CHECKS, ConfVars.METASTORE_BATCH_RETRIEVE_MAX, ConfVars.METASTORE_EVENT_LISTENERS, ConfVars.METASTORE_EVENT_CLEAN_FREQ, ConfVars.METASTORE_EVENT_EXPIRY_DURATION, ConfVars.METASTORE_RAW_STORE_IMPL, ConfVars.METASTORE_END_FUNCTION_LISTENERS, ConfVars.METASTORE_PART_INHERIT_TBL_PROPS, ConfVars.METASTORE_BATCH_RETRIEVE_TABLE_PARTITION_MAX, ConfVars.METASTORE_INIT_HOOKS, ConfVars.METASTORE_PRE_EVENT_LISTENERS, ConfVars.HMSHANDLERATTEMPTS, ConfVars.HMSHANDLERINTERVAL, ConfVars.HMSHANDLERFORCERELOADCONF, ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN};
        dbVars = new ConfVars[]{ConfVars.HADOOPBIN, ConfVars.HADOOPJT, ConfVars.METASTOREWAREHOUSE, ConfVars.SCRATCHDIR};
        userVars = new ConfVars[]{ConfVars.SCRATCHDIR, ConfVars.LOCALSCRATCHDIR, ConfVars.DOWNLOADED_RESOURCES_DIR, ConfVars.HIVEHISTORYFILELOC};
        restrictedVars = new ConfVars[]{ConfVars.HIVE_CURRENT_DATABASE};
    }

    public static enum ConfVars {
        SCRIPTWRAPPER("hive.exec.script.wrapper", null),
        PLAN("hive.exec.plan", ""),
        SCRATCHDIR("hive.exec.scratchdir", "/tmp/hive-" + System.getProperty("user.name")),
        LOCALSCRATCHDIR("hive.exec.local.scratchdir", "/tmp/" + System.getProperty("user.name")),
        SUBMITVIACHILD("hive.exec.submitviachild", false),
        SCRIPTERRORLIMIT("hive.exec.script.maxerrsize", 100000),
        ALLOWPARTIALCONSUMP("hive.exec.script.allow.partial.consumption", false),
        COMPRESSRESULT("hive.exec.compress.output", false),
        COMPRESSINTERMEDIATE("hive.exec.compress.intermediate", false),
        COMPRESSINTERMEDIATECODEC("hive.intermediate.compression.codec", ""),
        COMPRESSINTERMEDIATETYPE("hive.intermediate.compression.type", ""),
        BYTESPERREDUCER("hive.exec.reducers.bytes.per.reducer", 1000000000L),
        MAXREDUCERS("hive.exec.reducers.max", 999),
        PREEXECHOOKS("hive.exec.pre.hooks", ""),
        POSTEXECHOOKS("hive.exec.post.hooks", ""),
        ONFAILUREHOOKS("hive.exec.failure.hooks", ""),
        CLIENTSTATSPUBLISHERS("hive.client.stats.publishers", ""),
        EXECPARALLEL("hive.exec.parallel", false),
        EXECPARALLETHREADNUMBER("hive.exec.parallel.thread.number", 8),
        HIVESPECULATIVEEXECREDUCERS("hive.mapred.reduce.tasks.speculative.execution", true),
        HIVECOUNTERSPULLINTERVAL("hive.exec.counters.pull.interval", 1000L),
        DYNAMICPARTITIONING("hive.exec.dynamic.partition", true),
        DYNAMICPARTITIONINGMODE("hive.exec.dynamic.partition.mode", "strict"),
        DYNAMICPARTITIONMAXPARTS("hive.exec.max.dynamic.partitions", 1000),
        DYNAMICPARTITIONMAXPARTSPERNODE("hive.exec.max.dynamic.partitions.pernode", 100),
        MAXCREATEDFILES("hive.exec.max.created.files", 100000L),
        DOWNLOADED_RESOURCES_DIR("hive.downloaded.resources.dir", "/tmp/${hive.session.id}_resources"),
        DEFAULTPARTITIONNAME("hive.exec.default.partition.name", "__HIVE_DEFAULT_PARTITION__"),
        DEFAULT_ZOOKEEPER_PARTITION_NAME("hive.lockmgr.zookeeper.default.partition.name", "__HIVE_DEFAULT_ZOOKEEPER_PARTITION__"),
        SHOW_JOB_FAIL_DEBUG_INFO("hive.exec.show.job.failure.debug.info", true),
        JOB_DEBUG_CAPTURE_STACKTRACES("hive.exec.job.debug.capture.stacktraces", true),
        JOB_DEBUG_TIMEOUT("hive.exec.job.debug.timeout", 30000),
        TASKLOG_DEBUG_TIMEOUT("hive.exec.tasklog.debug.timeout", 20000),
        OUTPUT_FILE_EXTENSION("hive.output.file.extension", null),
        LOCALMODEAUTO("hive.exec.mode.local.auto", false),
        LOCALMODEMAXBYTES("hive.exec.mode.local.auto.inputbytes.max", 0x8000000L),
        LOCALMODEMAXINPUTFILES("hive.exec.mode.local.auto.input.files.max", 4),
        DROPIGNORESNONEXISTENT("hive.exec.drop.ignorenonexistent", true),
        HIVEIGNOREMAPJOINHINT("hive.ignore.mapjoin.hint", true),
        HADOOPBIN("hadoop.bin.path", ConfVars.findHadoopBinary()),
        HADOOPFS("fs.default.name", null),
        HIVE_FS_HAR_IMPL("fs.har.impl", "org.apache.hadoop.hive.shims.HiveHarFileSystem"),
        HADOOPMAPFILENAME("map.input.file", null),
        HADOOPMAPREDINPUTDIR("mapred.input.dir", null),
        HADOOPMAPREDINPUTDIRRECURSIVE("mapred.input.dir.recursive", false),
        HADOOPJT("mapred.job.tracker", null),
        MAPREDMAXSPLITSIZE("mapred.max.split.size", 256000000L),
        MAPREDMINSPLITSIZE("mapred.min.split.size", 1L),
        MAPREDMINSPLITSIZEPERNODE("mapred.min.split.size.per.rack", 1L),
        MAPREDMINSPLITSIZEPERRACK("mapred.min.split.size.per.node", 1L),
        HADOOPNUMREDUCERS("mapred.reduce.tasks", -1),
        HADOOPJOBNAME("mapred.job.name", null),
        HADOOPSPECULATIVEEXECREDUCERS("mapred.reduce.tasks.speculative.execution", true),
        METASTOREDIRECTORY("hive.metastore.metadb.dir", ""),
        METASTOREWAREHOUSE("hive.metastore.warehouse.dir", "/user/hive/warehouse"),
        METASTOREURIS("hive.metastore.uris", ""),
        METASTORETHRIFTCONNECTIONRETRIES("hive.metastore.connect.retries", 3),
        METASTORETHRIFTFAILURERETRIES("hive.metastore.failure.retries", 1),
        METASTORE_CLIENT_CONNECT_RETRY_DELAY("hive.metastore.client.connect.retry.delay", 1),
        METASTORE_CLIENT_SOCKET_TIMEOUT("hive.metastore.client.socket.timeout", 20),
        METASTOREPWD("javax.jdo.option.ConnectionPassword", "mine"),
        METASTORECONNECTURLHOOK("hive.metastore.ds.connection.url.hook", ""),
        METASTOREMULTITHREADED("javax.jdo.option.Multithreaded", true),
        METASTORECONNECTURLKEY("javax.jdo.option.ConnectionURL", "jdbc:derby:;databaseName=metastore_db;create=true"),
        METASTOREATTEMPTS("hive.metastore.ds.retry.attempts", 1),
        METASTOREINTERVAL("hive.metastore.ds.retry.interval", 1000),
        METASTOREFORCERELOADCONF("hive.metastore.force.reload.conf", false),
        HMSHANDLERATTEMPTS("hive.hmshandler.retry.attempts", 1),
        HMSHANDLERINTERVAL("hive.hmshandler.retry.interval", 1000),
        HMSHANDLERFORCERELOADCONF("hive.hmshandler.force.reload.conf", false),
        METASTORESERVERMINTHREADS("hive.metastore.server.min.threads", 200),
        METASTORESERVERMAXTHREADS("hive.metastore.server.max.threads", 100000),
        METASTORE_TCP_KEEP_ALIVE("hive.metastore.server.tcp.keepalive", true),
        METASTORE_INT_ORIGINAL("hive.metastore.archive.intermediate.original", "_INTERMEDIATE_ORIGINAL"),
        METASTORE_INT_ARCHIVED("hive.metastore.archive.intermediate.archived", "_INTERMEDIATE_ARCHIVED"),
        METASTORE_INT_EXTRACTED("hive.metastore.archive.intermediate.extracted", "_INTERMEDIATE_EXTRACTED"),
        METASTORE_KERBEROS_KEYTAB_FILE("hive.metastore.kerberos.keytab.file", ""),
        METASTORE_KERBEROS_PRINCIPAL("hive.metastore.kerberos.principal", "hive-metastore/_HOST@EXAMPLE.COM"),
        METASTORE_USE_THRIFT_SASL("hive.metastore.sasl.enabled", false),
        METASTORE_USE_THRIFT_FRAMED_TRANSPORT("hive.metastore.thrift.framed.transport.enabled", false),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_CLS("hive.cluster.delegation.token.store.class", "org.apache.hadoop.hive.thrift.MemoryTokenStore"),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_ZK_CONNECTSTR("hive.cluster.delegation.token.store.zookeeper.connectString", ""),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_ZK_ZNODE("hive.cluster.delegation.token.store.zookeeper.znode", "/hive/cluster/delegation"),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_ZK_ACL("hive.cluster.delegation.token.store.zookeeper.acl", ""),
        METASTORE_CACHE_PINOBJTYPES("hive.metastore.cache.pinobjtypes", "Table,StorageDescriptor,SerDeInfo,Partition,Database,Type,FieldSchema,Order"),
        METASTORE_CONNECTION_POOLING_TYPE("datanucleus.connectionPoolingType", "DBCP"),
        METASTORE_VALIDATE_TABLES("datanucleus.validateTables", false),
        METASTORE_VALIDATE_COLUMNS("datanucleus.validateColumns", false),
        METASTORE_VALIDATE_CONSTRAINTS("datanucleus.validateConstraints", false),
        METASTORE_STORE_MANAGER_TYPE("datanucleus.storeManagerType", "rdbms"),
        METASTORE_AUTO_CREATE_SCHEMA("datanucleus.autoCreateSchema", true),
        METASTORE_AUTO_START_MECHANISM_MODE("datanucleus.autoStartMechanismMode", "checked"),
        METASTORE_TRANSACTION_ISOLATION("datanucleus.transactionIsolation", "read-committed"),
        METASTORE_CACHE_LEVEL2("datanucleus.cache.level2", false),
        METASTORE_CACHE_LEVEL2_TYPE("datanucleus.cache.level2.type", "none"),
        METASTORE_IDENTIFIER_FACTORY("datanucleus.identifierFactory", "datanucleus1"),
        METASTORE_PLUGIN_REGISTRY_BUNDLE_CHECK("datanucleus.plugin.pluginRegistryBundleCheck", "LOG"),
        METASTORE_BATCH_RETRIEVE_MAX("hive.metastore.batch.retrieve.max", 300),
        METASTORE_BATCH_RETRIEVE_TABLE_PARTITION_MAX("hive.metastore.batch.retrieve.table.partition.max", 1000),
        METASTORE_INIT_HOOKS("hive.metastore.init.hooks", ""),
        METASTORE_PRE_EVENT_LISTENERS("hive.metastore.pre.event.listeners", ""),
        METASTORE_EVENT_LISTENERS("hive.metastore.event.listeners", ""),
        METASTORE_AUTHORIZATION_STORAGE_AUTH_CHECKS("hive.metastore.authorization.storage.checks", false),
        METASTORE_EVENT_CLEAN_FREQ("hive.metastore.event.clean.freq", 0L),
        METASTORE_EVENT_EXPIRY_DURATION("hive.metastore.event.expiry.duration", 0L),
        METASTORE_EXECUTE_SET_UGI("hive.metastore.execute.setugi", false),
        METASTORE_PARTITION_NAME_WHITELIST_PATTERN("hive.metastore.partition.name.whitelist.pattern", ""),
        NEWTABLEDEFAULTPARA("hive.table.parameters.default", ""),
        DDL_CTL_PARAMETERS_WHITELIST("hive.ddl.createtablelike.properties.whitelist", ""),
        METASTORE_RAW_STORE_IMPL("hive.metastore.rawstore.impl", "org.apache.hadoop.hive.metastore.ObjectStore"),
        METASTORE_CONNECTION_DRIVER("javax.jdo.option.ConnectionDriverName", "org.apache.derby.jdbc.EmbeddedDriver"),
        METASTORE_MANAGER_FACTORY_CLASS("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.api.jdo.JDOPersistenceManagerFactory"),
        METASTORE_DETACH_ALL_ON_COMMIT("javax.jdo.option.DetachAllOnCommit", true),
        METASTORE_NON_TRANSACTIONAL_READ("javax.jdo.option.NonTransactionalRead", true),
        METASTORE_CONNECTION_USER_NAME("javax.jdo.option.ConnectionUserName", "APP"),
        METASTORE_END_FUNCTION_LISTENERS("hive.metastore.end.function.listeners", ""),
        METASTORE_PART_INHERIT_TBL_PROPS("hive.metastore.partition.inherit.table.properties", ""),
        METADATA_EXPORT_LOCATION("hive.metadata.export.location", ""),
        MOVE_EXPORTED_METADATA_TO_TRASH("hive.metadata.move.exported.metadata.to.trash", true),
        CLIIGNOREERRORS("hive.cli.errors.ignore", false),
        CLIPRINTCURRENTDB("hive.cli.print.current.db", false),
        CLIPROMPT("hive.cli.prompt", "hive"),
        CLIPRETTYOUTPUTNUMCOLS("hive.cli.pretty.output.num.cols", -1),
        HIVE_METASTORE_FS_HANDLER_CLS("hive.metastore.fs.handler.class", "org.apache.hadoop.hive.metastore.HiveMetaStoreFsImpl"),
        HIVESESSIONID("hive.session.id", ""),
        HIVESESSIONSILENT("hive.session.silent", false),
        HIVE_SESSION_HISTORY_ENABLED("hive.session.history.enabled", false),
        HIVEQUERYSTRING("hive.query.string", ""),
        HIVEQUERYID("hive.query.id", ""),
        HIVEPLANID("hive.query.planid", ""),
        HIVEJOBNAMELENGTH("hive.jobname.length", 50),
        HIVEJAR("hive.jar.path", ""),
        HIVEAUXJARS("hive.aux.jars.path", ""),
        HIVEADDEDFILES("hive.added.files.path", ""),
        HIVEADDEDJARS("hive.added.jars.path", ""),
        HIVEADDEDARCHIVES("hive.added.archives.path", ""),
        HIVES_AUTO_PROGRESS_TIMEOUT("hive.auto.progress.timeout", 0),
        HIVETABLENAME("hive.table.name", ""),
        HIVEPARTITIONNAME("hive.partition.name", ""),
        HIVESCRIPTAUTOPROGRESS("hive.script.auto.progress", false),
        HIVESCRIPTIDENVVAR("hive.script.operator.id.env.var", "HIVE_SCRIPT_OPERATOR_ID"),
        HIVESCRIPTTRUNCATEENV("hive.script.operator.truncate.env", false),
        HIVEMAPREDMODE("hive.mapred.mode", "nonstrict"),
        HIVEALIAS("hive.alias", ""),
        HIVEMAPSIDEAGGREGATE("hive.map.aggr", true),
        HIVEGROUPBYSKEW("hive.groupby.skewindata", false),
        HIVE_OPTIMIZE_MULTI_GROUPBY_COMMON_DISTINCTS("hive.optimize.multigroupby.common.distincts", true),
        HIVEJOINEMITINTERVAL("hive.join.emit.interval", 1000),
        HIVEJOINCACHESIZE("hive.join.cache.size", 25000),
        HIVEMAPJOINBUCKETCACHESIZE("hive.mapjoin.bucket.cache.size", 100),
        HIVEMAPJOINROWSIZE("hive.mapjoin.size.key", 10000),
        HIVEMAPJOINCACHEROWS("hive.mapjoin.cache.numrows", 25000),
        HIVEGROUPBYMAPINTERVAL("hive.groupby.mapaggr.checkinterval", 100000),
        HIVEMAPAGGRHASHMEMORY("hive.map.aggr.hash.percentmemory", 0.5f),
        HIVEMAPJOINFOLLOWEDBYMAPAGGRHASHMEMORY("hive.mapjoin.followby.map.aggr.hash.percentmemory", 0.3f),
        HIVEMAPAGGRMEMORYTHRESHOLD("hive.map.aggr.hash.force.flush.memory.threshold", 0.9f),
        HIVEMAPAGGRHASHMINREDUCTION("hive.map.aggr.hash.min.reduction", 0.5f),
        HIVEMULTIGROUPBYSINGLEREDUCER("hive.multigroupby.singlereducer", true),
        HIVE_MAP_GROUPBY_SORT("hive.map.groupby.sorted", false),
        HIVE_MAP_GROUPBY_SORT_TESTMODE("hive.map.groupby.sorted.testmode", false),
        HIVE_GROUPBY_ORDERBY_POSITION_ALIAS("hive.groupby.orderby.position.alias", false),
        HIVE_NEW_JOB_GROUPING_SET_CARDINALITY("hive.new.job.grouping.set.cardinality", 30),
        HIVEUDTFAUTOPROGRESS("hive.udtf.auto.progress", false),
        HIVEDEFAULTFILEFORMAT("hive.default.fileformat", "TextFile"),
        HIVEQUERYRESULTFILEFORMAT("hive.query.result.fileformat", "TextFile"),
        HIVECHECKFILEFORMAT("hive.fileformat.check", true),
        HIVEHISTORYFILELOC("hive.querylog.location", "/tmp/" + System.getProperty("user.name")),
        HIVE_LOG_INCREMENTAL_PLAN_PROGRESS("hive.querylog.enable.plan.progress", true),
        HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL("hive.querylog.plan.progress.interval", 60000L),
        HIVESCRIPTSERDE("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"),
        HIVESCRIPTRECORDREADER("hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader"),
        HIVESCRIPTRECORDWRITER("hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter"),
        HIVESCRIPTESCAPE("hive.transform.escape.input", false),
        HIVEBINARYRECORDMAX("hive.binary.record.max.length", 1000),
        HIVEHWILISTENHOST("hive.hwi.listen.host", "0.0.0.0"),
        HIVEHWILISTENPORT("hive.hwi.listen.port", "9999"),
        HIVEHWIWARFILE("hive.hwi.war.file", System.getenv("HWI_WAR_FILE")),
        HIVEHADOOPMAXMEM("hive.mapred.local.mem", 0),
        HIVESMALLTABLESFILESIZE("hive.mapjoin.smalltable.filesize", 25000000L),
        HIVESAMPLERANDOMNUM("hive.sample.seednumber", 0),
        HIVETESTMODE("hive.test.mode", false),
        HIVETESTMODEPREFIX("hive.test.mode.prefix", "test_"),
        HIVETESTMODESAMPLEFREQ("hive.test.mode.samplefreq", 32),
        HIVETESTMODENOSAMPLE("hive.test.mode.nosamplelist", ""),
        HIVEMERGEMAPFILES("hive.merge.mapfiles", true),
        HIVEMERGEMAPREDFILES("hive.merge.mapredfiles", false),
        HIVEMERGEMAPFILESSIZE("hive.merge.size.per.task", 256000000L),
        HIVEMERGEMAPFILESAVGSIZE("hive.merge.smallfiles.avgsize", 16000000L),
        HIVEMERGERCFILEBLOCKLEVEL("hive.merge.rcfile.block.level", true),
        HIVEMERGEINPUTFORMATBLOCKLEVEL("hive.merge.input.format.block.level", "org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat"),
        HIVEMERGECURRENTJOBHASDYNAMICPARTITIONS("hive.merge.current.job.has.dynamic.partitions", false),
        HIVEUSEEXPLICITRCFILEHEADER("hive.exec.rcfile.use.explicit.header", true),
        HIVEUSERCFILESYNCCACHE("hive.exec.rcfile.use.sync.cache", true),
        HIVE_ORC_FILE_MEMORY_POOL("hive.exec.orc.memory.pool", 0.5f),
        HIVESKEWJOIN("hive.optimize.skewjoin", false),
        HIVECONVERTJOIN("hive.auto.convert.join", true),
        HIVECONVERTJOINNOCONDITIONALTASK("hive.auto.convert.join.noconditionaltask", true),
        HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD("hive.auto.convert.join.noconditionaltask.size", 10000000L),
        HIVEOPTIMIZEMAPJOINFOLLOWEDBYMR("hive.optimize.mapjoin.mapreduce", false),
        HIVESKEWJOINKEY("hive.skewjoin.key", 100000),
        HIVESKEWJOINMAPJOINNUMMAPTASK("hive.skewjoin.mapjoin.map.tasks", 10000),
        HIVESKEWJOINMAPJOINMINSPLIT("hive.skewjoin.mapjoin.min.split", 0x2000000L),
        HIVESENDHEARTBEAT("hive.heartbeat.interval", 1000),
        HIVELIMITMAXROWSIZE("hive.limit.row.max.size", 100000L),
        HIVELIMITOPTLIMITFILE("hive.limit.optimize.limit.file", 10),
        HIVELIMITOPTENABLE("hive.limit.optimize.enable", false),
        HIVELIMITOPTMAXFETCH("hive.limit.optimize.fetch.max", 50000),
        HIVEHASHTABLETHRESHOLD("hive.hashtable.initialCapacity", 100000),
        HIVEHASHTABLELOADFACTOR("hive.hashtable.loadfactor", 0.75f),
        HIVEHASHTABLEFOLLOWBYGBYMAXMEMORYUSAGE("hive.mapjoin.followby.gby.localtask.max.memory.usage", 0.55f),
        HIVEHASHTABLEMAXMEMORYUSAGE("hive.mapjoin.localtask.max.memory.usage", 0.9f),
        HIVEHASHTABLESCALE("hive.mapjoin.check.memory.rows", 100000L),
        HIVEDEBUGLOCALTASK("hive.debug.localtask", false),
        HIVEJOBPROGRESS("hive.task.progress", false),
        HIVEINPUTFORMAT("hive.input.format", "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat"),
        HIVEENFORCEBUCKETING("hive.enforce.bucketing", false),
        HIVEENFORCESORTING("hive.enforce.sorting", false),
        HIVEOPTIMIZEBUCKETINGSORTING("hive.optimize.bucketingsorting", true),
        HIVEPARTITIONER("hive.mapred.partitioner", "org.apache.hadoop.hive.ql.io.DefaultHivePartitioner"),
        HIVEENFORCESORTMERGEBUCKETMAPJOIN("hive.enforce.sortmergebucketmapjoin", false),
        HIVEENFORCEBUCKETMAPJOIN("hive.enforce.bucketmapjoin", false),
        HIVE_AUTO_SORTMERGE_JOIN("hive.auto.convert.sortmerge.join", false),
        HIVE_AUTO_SORTMERGE_JOIN_BIGTABLE_SELECTOR("hive.auto.convert.sortmerge.join.bigtable.selection.policy", "org.apache.hadoop.hive.ql.optimizer.AvgPartitionSizeBasedBigTableSelectorForAutoSMJ"),
        HIVESCRIPTOPERATORTRUST("hive.exec.script.trust", false),
        HIVEROWOFFSET("hive.exec.rowoffset", false),
        HIVE_COMBINE_INPUT_FORMAT_SUPPORTS_SPLITTABLE("hive.hadoop.supports.splittable.combineinputformat", false),
        HIVEOPTCP("hive.optimize.cp", true),
        HIVEOPTINDEXFILTER("hive.optimize.index.filter", false),
        HIVEINDEXAUTOUPDATE("hive.optimize.index.autoupdate", false),
        HIVEOPTPPD("hive.optimize.ppd", true),
        HIVEPPDRECOGNIZETRANSITIVITY("hive.ppd.recognizetransivity", true),
        HIVEPPDREMOVEDUPLICATEFILTERS("hive.ppd.remove.duplicatefilters", true),
        HIVEMETADATAONLYQUERIES("hive.optimize.metadataonly", true),
        HIVEOPTPPD_STORAGE("hive.optimize.ppd.storage", true),
        HIVEOPTGROUPBY("hive.optimize.groupby", true),
        HIVEOPTBUCKETMAPJOIN("hive.optimize.bucketmapjoin", false),
        HIVEOPTSORTMERGEBUCKETMAPJOIN("hive.optimize.bucketmapjoin.sortedmerge", false),
        HIVEOPTREDUCEDEDUPLICATION("hive.optimize.reducededuplication", true),
        HIVEOPTREDUCEDEDUPLICATIONMINREDUCER("hive.optimize.reducededuplication.min.reducer", 4),
        HIVE_OPTIMIZE_UNION_REMOVE("hive.optimize.union.remove", false),
        HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES("hive.mapred.supports.subdirectories", false),
        HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME("hive.optimize.skewjoin.compiletime", false),
        HIVEOPTINDEXFILTER_COMPACT_MINSIZE("hive.optimize.index.filter.compact.minsize", 0x140000000L),
        HIVEOPTINDEXFILTER_COMPACT_MAXSIZE("hive.optimize.index.filter.compact.maxsize", -1L),
        HIVE_INDEX_COMPACT_QUERY_MAX_ENTRIES("hive.index.compact.query.max.entries", 10000000L),
        HIVE_INDEX_COMPACT_QUERY_MAX_SIZE("hive.index.compact.query.max.size", 0x280000000L),
        HIVE_INDEX_COMPACT_BINARY_SEARCH("hive.index.compact.binary.search", true),
        HIVESTATSAUTOGATHER("hive.stats.autogather", true),
        HIVESTATSDBCLASS("hive.stats.dbclass", "jdbc:derby"),
        HIVESTATSJDBCDRIVER("hive.stats.jdbcdriver", "org.apache.derby.jdbc.EmbeddedDriver"),
        HIVESTATSDBCONNECTIONSTRING("hive.stats.dbconnectionstring", "jdbc:derby:;databaseName=TempStatsStore;create=true"),
        HIVE_STATS_DEFAULT_PUBLISHER("hive.stats.default.publisher", ""),
        HIVE_STATS_DEFAULT_AGGREGATOR("hive.stats.default.aggregator", ""),
        HIVE_STATS_JDBC_TIMEOUT("hive.stats.jdbc.timeout", 30),
        HIVE_STATS_ATOMIC("hive.stats.atomic", false),
        HIVE_STATS_RETRIES_MAX("hive.stats.retries.max", 0),
        HIVE_STATS_RETRIES_WAIT("hive.stats.retries.wait", 3000),
        HIVE_STATS_COLLECT_RAWDATASIZE("hive.stats.collect.rawdatasize", true),
        CLIENT_STATS_COUNTERS("hive.client.stats.counters", ""),
        HIVE_STATS_RELIABLE("hive.stats.reliable", false),
        HIVE_STATS_COLLECT_TABLEKEYS("hive.stats.collect.tablekeys", false),
        HIVE_STATS_COLLECT_SCANCOLS("hive.stats.collect.scancols", false),
        HIVE_STATS_NDV_ERROR("hive.stats.ndv.error", 20.0f),
        HIVE_STATS_KEY_PREFIX_MAX_LENGTH("hive.stats.key.prefix.max.length", 200),
        HIVE_STATS_KEY_PREFIX("hive.stats.key.prefix", ""),
        HIVE_SUPPORT_CONCURRENCY("hive.support.concurrency", false),
        HIVE_LOCK_MANAGER("hive.lock.manager", "org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager"),
        HIVE_LOCK_NUMRETRIES("hive.lock.numretries", 100),
        HIVE_UNLOCK_NUMRETRIES("hive.unlock.numretries", 10),
        HIVE_LOCK_SLEEP_BETWEEN_RETRIES("hive.lock.sleep.between.retries", 60),
        HIVE_LOCK_MAPRED_ONLY("hive.lock.mapred.only.operation", false),
        HIVE_ZOOKEEPER_QUORUM("hive.zookeeper.quorum", ""),
        HIVE_ZOOKEEPER_CLIENT_PORT("hive.zookeeper.client.port", "2181"),
        HIVE_ZOOKEEPER_SESSION_TIMEOUT("hive.zookeeper.session.timeout", 600000),
        HIVE_ZOOKEEPER_NAMESPACE("hive.zookeeper.namespace", "hive_zookeeper_namespace"),
        HIVE_ZOOKEEPER_CLEAN_EXTRA_NODES("hive.zookeeper.clean.extra.nodes", false),
        HIVE_HBASE_WAL_ENABLED("hive.hbase.wal.enabled", true),
        HIVEARCHIVEENABLED("hive.archive.enabled", false),
        HIVEOPTGBYUSINGINDEX("hive.optimize.index.groupby", false),
        HIVEOUTERJOINSUPPORTSFILTERS("hive.outerjoin.supports.filters", true),
        HIVEFETCHTASKCONVERSION("hive.fetch.task.conversion", "minimal"),
        HIVEFETCHOUTPUTSERDE("hive.fetch.output.serde", "org.apache.hadoop.hive.serde2.DelimitedJSONSerDe"),
        HIVEVARIABLESUBSTITUTE("hive.variable.substitute", true),
        HIVEVARIABLESUBSTITUTEDEPTH("hive.variable.substitute.depth", 40),
        HIVECONFVALIDATION("hive.conf.validation", true),
        SEMANTIC_ANALYZER_HOOK("hive.semantic.analyzer.hook", ""),
        HIVE_AUTHORIZATION_ENABLED("hive.security.authorization.enabled", false),
        HIVE_AUTHORIZATION_MANAGER("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider"),
        HIVE_AUTHENTICATOR_MANAGER("hive.security.authenticator.manager", "org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator"),
        HIVE_METASTORE_AUTHORIZATION_MANAGER("hive.security.metastore.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveMetastoreAuthorizationProvider"),
        HIVE_METASTORE_AUTHENTICATOR_MANAGER("hive.security.metastore.authenticator.manager", "org.apache.hadoop.hive.ql.security.HadoopDefaultMetastoreAuthenticator"),
        HIVE_AUTHORIZATION_TABLE_USER_GRANTS("hive.security.authorization.createtable.user.grants", ""),
        HIVE_AUTHORIZATION_TABLE_GROUP_GRANTS("hive.security.authorization.createtable.group.grants", ""),
        HIVE_AUTHORIZATION_TABLE_ROLE_GRANTS("hive.security.authorization.createtable.role.grants", ""),
        HIVE_AUTHORIZATION_TABLE_OWNER_GRANTS("hive.security.authorization.createtable.owner.grants", ""),
        HIVE_CLI_PRINT_HEADER("hive.cli.print.header", false),
        HIVE_ERROR_ON_EMPTY_PARTITION("hive.error.on.empty.partition", false),
        HIVE_INDEX_IGNORE_HDFS_LOC("hive.index.compact.file.ignore.hdfs", false),
        HIVE_EXIM_URI_SCHEME_WL("hive.exim.uri.scheme.whitelist", "hdfs,pfile"),
        HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS("hive.mapper.cannot.span.multiple.partitions", false),
        HIVE_REWORK_MAPREDWORK("hive.rework.mapredwork", false),
        HIVE_CONCATENATE_CHECK_INDEX("hive.exec.concatenate.check.index", true),
        HIVE_IO_EXCEPTION_HANDLERS("hive.io.exception.handlers", ""),
        HIVE_LOG4J_FILE("hive.log4j.file", ""),
        HIVE_EXEC_LOG4J_FILE("hive.exec.log4j.file", ""),
        HIVE_AUTOGEN_COLUMNALIAS_PREFIX_LABEL("hive.autogen.columnalias.prefix.label", "_c"),
        HIVE_AUTOGEN_COLUMNALIAS_PREFIX_INCLUDEFUNCNAME("hive.autogen.columnalias.prefix.includefuncname", false),
        HIVE_PERF_LOGGER("hive.exec.perf.logger", "org.apache.hadoop.hive.ql.log.PerfLogger"),
        HIVE_START_CLEANUP_SCRATCHDIR("hive.start.cleanup.scratchdir", false),
        HIVE_INSERT_INTO_MULTILEVEL_DIRS("hive.insert.into.multilevel.dirs", false),
        HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS("hive.warehouse.subdir.inherit.perms", false),
        HIVE_INSERT_INTO_EXTERNAL_TABLES("hive.insert.into.external.tables", true),
        HIVE_DRIVER_RUN_HOOKS("hive.exec.driver.run.hooks", ""),
        HIVE_DDL_OUTPUT_FORMAT("hive.ddl.output.format", null),
        HIVE_ENTITY_SEPARATOR("hive.entity.separator", "@"),
        HIVE_HUMAN_FRIENDLY_FORMAT("hive.human.friendly.format", true),
        HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS("hive.server2.thrift.min.worker.threads", 5),
        HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS("hive.server2.thrift.max.worker.threads", 100),
        HIVE_SERVER2_THRIFT_PORT("hive.server2.thrift.port", 10000),
        HIVE_SERVER2_THRIFT_BIND_HOST("hive.server2.thrift.bind.host", ""),
        HIVE_SERVER2_AUTHENTICATION("hive.server2.authentication", "NONE"),
        HIVE_SERVER2_KERBEROS_KEYTAB("hive.server2.authentication.kerberos.keytab", ""),
        HIVE_SERVER2_KERBEROS_PRINCIPAL("hive.server2.authentication.kerberos.principal", ""),
        HIVE_SERVER2_PLAIN_LDAP_URL("hive.server2.authentication.ldap.url", null),
        HIVE_SERVER2_PLAIN_LDAP_BASEDN("hive.server2.authentication.ldap.baseDN", null),
        HIVE_SERVER2_CUSTOM_AUTHENTICATION_CLASS("hive.server2.custom.authentication.class", null),
        HIVE_SERVER2_ENABLE_DOAS("hive.server2.enable.doAs", true),
        HIVE_CONF_RESTRICTED_LIST("hive.conf.restricted.list", null),
        HIVE_MULTI_INSERT_MOVE_TASKS_SHARE_DEPENDENCIES("hive.multi.insert.move.tasks.share.dependencies", false),
        HIVE_INFER_BUCKET_SORT("hive.exec.infer.bucket.sort", false),
        HIVE_INFER_BUCKET_SORT_NUM_BUCKETS_POWER_TWO("hive.exec.infer.bucket.sort.num.buckets.power.two", false),
        HIVEMERGECURRENTJOBCONCATENATELISTBUCKETING("hive.merge.current.job.concatenate.list.bucketing", true),
        HIVEMERGECURRENTJOBCONCATENATELISTBUCKETINGDEPTH("hive.merge.current.job.concatenate.list.bucketing.depth", 0),
        HIVEOPTLISTBUCKETING("hive.optimize.listbucketing", false),
        SERVER_READ_SOCKET_TIMEOUT("hive.server.read.socket.timeout", 10),
        SERVER_TCP_KEEP_ALIVE("hive.server.tcp.keepalive", true),
        HIVE_DECODE_PARTITION_NAME("hive.decode.partition.name", false),
        HIVE_PTF_PARTITION_PERSISTENCE_CLASS("hive.ptf.partition.persistence", "org.apache.hadoop.hive.ql.exec.PTFPersistence$PartitionedByteBasedList"),
        HIVE_PTF_PARTITION_PERSISTENT_SIZE("hive.ptf.partition.persistence.memsize", (int)Math.pow(2.0, 25.0)),
        HIVE_CURRENT_DATABASE("hive.current.db", "default");

        public final String varname;
        public final String defaultVal;
        public final int defaultIntVal;
        public final long defaultLongVal;
        public final float defaultFloatVal;
        public final Class<?> valClass;
        public final boolean defaultBoolVal;
        private final VarType type;

        private ConfVars(String varname, String defaultVal) {
            this.varname = varname;
            this.valClass = String.class;
            this.defaultVal = defaultVal;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
            this.type = VarType.STRING;
        }

        private ConfVars(String varname, int defaultIntVal) {
            this.varname = varname;
            this.valClass = Integer.class;
            this.defaultVal = Integer.toString(defaultIntVal);
            this.defaultIntVal = defaultIntVal;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
            this.type = VarType.INT;
        }

        private ConfVars(String varname, long defaultLongVal) {
            this.varname = varname;
            this.valClass = Long.class;
            this.defaultVal = Long.toString(defaultLongVal);
            this.defaultIntVal = -1;
            this.defaultLongVal = defaultLongVal;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
            this.type = VarType.LONG;
        }

        private ConfVars(String varname, float defaultFloatVal) {
            this.varname = varname;
            this.valClass = Float.class;
            this.defaultVal = Float.toString(defaultFloatVal);
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = defaultFloatVal;
            this.defaultBoolVal = false;
            this.type = VarType.FLOAT;
        }

        private ConfVars(String varname, boolean defaultBoolVal) {
            this.varname = varname;
            this.valClass = Boolean.class;
            this.defaultVal = Boolean.toString(defaultBoolVal);
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = defaultBoolVal;
            this.type = VarType.BOOLEAN;
        }

        public boolean isType(String value) {
            return this.type.isType(value);
        }

        public String typeString() {
            return this.type.typeString();
        }

        public String toString() {
            return this.varname;
        }

        private static String findHadoopBinary() {
            String val = System.getenv("HADOOP_HOME");
            if (val == null) {
                val = System.getenv("HADOOP_PREFIX");
            }
            val = (val == null ? File.separator + "usr" : val) + File.separator + "bin" + File.separator + "hadoop";
            return val + (Shell.WINDOWS ? ".cmd" : "");
        }

        static enum VarType {
            STRING{

                @Override
                void checkType(String value) throws Exception {
                }
            }
            ,
            INT{

                @Override
                void checkType(String value) throws Exception {
                    Integer.valueOf(value);
                }
            }
            ,
            LONG{

                @Override
                void checkType(String value) throws Exception {
                    Long.valueOf(value);
                }
            }
            ,
            FLOAT{

                @Override
                void checkType(String value) throws Exception {
                    Float.valueOf(value);
                }
            }
            ,
            BOOLEAN{

                @Override
                void checkType(String value) throws Exception {
                    Boolean.valueOf(value);
                }
            };


            boolean isType(String value) {
                try {
                    this.checkType(value);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }

            String typeString() {
                return this.name().toUpperCase();
            }

            abstract void checkType(String var1) throws Exception;
        }
    }
}

