/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapJoinMetaData;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectValue;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.ReflectionUtils;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)MapJoinOperator.class.getName());
    protected transient Map<Byte, HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue>> mapJoinTables;
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Mapside join exceeds available memory. Please try removing the mapjoin hint."};
    protected transient Map<Byte, MapJoinRowContainer<ArrayList<Object>>> rowContainerMap;
    transient int metadataKeyTag;
    transient int[] metadataValueTag;
    transient boolean hashTblInitedOnce;
    private int bigTableAlias;

    public MapJoinOperator() {
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int pos;
        super.initializeOp(hconf);
        this.metadataValueTag = new int[this.numAliases];
        for (pos = 0; pos < this.numAliases; ++pos) {
            this.metadataValueTag[pos] = -1;
        }
        this.metadataKeyTag = -1;
        this.bigTableAlias = this.order[this.posBigTable].byteValue();
        this.mapJoinTables = new HashMap<Byte, HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue>>();
        this.rowContainerMap = new HashMap<Byte, MapJoinRowContainer<ArrayList<Object>>>();
        for (pos = 0; pos < this.numAliases; ++pos) {
            if (pos == this.posBigTable) continue;
            HashMapWrapper hashTable = new HashMapWrapper();
            this.mapJoinTables.put((byte)pos, hashTable);
            MapJoinRowContainer rowContainer = new MapJoinRowContainer();
            this.rowContainerMap.put((byte)pos, rowContainer);
        }
        this.hashTblInitedOnce = false;
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator " + this.getOperatorId() + " (id=" + this.id + "): " + FATAL_ERR_MSG[(int)counterCode]);
    }

    public void generateMapMetaData() throws HiveException, SerDeException {
        TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
        SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
        keySerializer.initialize(null, keyTableDesc.getProperties());
        MapJoinMetaData.put(this.metadataKeyTag, new HashTableSinkOperator.HashTableSinkObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(keySerializer.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), keySerializer, keyTableDesc, this.hconf));
        for (int tag = 0; tag < this.order.length; ++tag) {
            byte alias = this.order[tag];
            if (alias == this.bigTableAlias) continue;
            TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getNoOuterJoin() ? ((MapJoinDesc)this.conf).getValueTblDescs().get(tag) : ((MapJoinDesc)this.conf).getValueFilteredTblDescs().get(tag);
            SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
            valueSerDe.initialize(null, valueTableDesc.getProperties());
            MapJoinMetaData.put(Integer.valueOf(alias), new HashTableSinkOperator.HashTableSinkObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(valueSerDe.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), valueSerDe, valueTableDesc, this.hconf));
        }
    }

    private void loadHashTable() throws HiveException {
        if (!this.getExecContext().getLocalWork().getInputFileChangeSensitive()) {
            if (this.hashTblInitedOnce) {
                return;
            }
            this.hashTblInitedOnce = true;
        }
        String baseDir = null;
        String currentInputFile = this.getExecContext().getCurrentInputFile();
        LOG.info((Object)("******* Load from HashTable File: input : " + currentInputFile));
        String fileName = this.getExecContext().getLocalWork().getBucketFileName(currentInputFile);
        try {
            if (ShimLoader.getHadoopShims().isLocalMode(this.hconf)) {
                baseDir = this.getExecContext().getLocalWork().getTmpFileURI();
            } else {
                String stageID = this.getExecContext().getLocalWork().getStageID();
                String suffix = Utilities.generateTarFileName(stageID);
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.hconf);
                Path[] localArchives = DistributedCache.getLocalCacheArchives((Configuration)this.hconf);
                for (int j = 0; j < localArchives.length; ++j) {
                    Path archive = localArchives[j];
                    if (!archive.getName().endsWith(suffix)) continue;
                    Path archiveLocalLink = archive.makeQualified((FileSystem)localFs);
                    baseDir = archiveLocalLink.toUri().getPath();
                }
            }
            for (Map.Entry<Byte, HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue>> entry : this.mapJoinTables.entrySet()) {
                Byte pos = entry.getKey();
                HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue> hashtable = entry.getValue();
                String filePath = Utilities.generatePath(baseDir, ((MapJoinDesc)this.conf).getDumpFilePrefix(), pos, fileName);
                Path path = new Path(filePath);
                LOG.info((Object)("\tLoad back 1 hashtable file from tmp file uri:" + path.toString()));
                hashtable.initilizePersistentHash(path.toUri().getPath());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Load Distributed Cache Error");
            throw new HiveException(e.getMessage());
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        try {
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.loadHashTable();
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.alias = this.order[tag];
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            AbstractMapJoinKey key = JoinUtil.computeMapJoinKeys(row, (List)this.joinKeys.get(this.alias), (List)this.joinKeysObjectInspectors.get(this.alias));
            ArrayList<Object> value = JoinUtil.computeValues(row, (List)this.joinValues.get(this.alias), (List)this.joinValuesObjectInspectors.get(this.alias), (List)this.joinFilters.get(this.alias), (List)this.joinFilterObjectInspectors.get(this.alias), this.filterMap == null ? null : this.filterMap[this.alias]);
            ((AbstractRowContainer)this.storage.get((byte)tag)).add(value);
            for (Byte pos : this.order) {
                if (pos.intValue() == tag) continue;
                MapJoinObjectValue o = this.mapJoinTables.get(pos).get(key);
                MapJoinRowContainer<ArrayList<Object>> rowContainer = this.rowContainerMap.get(pos);
                if (o == null || key.hasAnyNulls(this.nullsafes)) {
                    if (this.noOuterJoin) {
                        this.storage.put(pos, this.emptyList);
                        continue;
                    }
                    this.storage.put(pos, this.dummyObjVectors[pos.intValue()]);
                    continue;
                }
                rowContainer.reset(o.getObj());
                this.storage.put(pos, rowContainer);
            }
            this.checkAndGenObject();
            ((AbstractRowContainer)this.storage.get((byte)tag)).clear();
            for (Byte pos : this.order) {
                if (pos.intValue() == tag) continue;
                this.storage.put(pos, null);
            }
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.mapJoinTables != null) {
            for (HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue> hashTable : this.mapJoinTables.values()) {
                hashTable.close();
            }
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return MapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

