/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public final class MapJoinFactory {
    public static int getPositionParent(AbstractMapJoinOperator<? extends MapJoinDesc> op, Stack<Node> stack) {
        int pos = 0;
        int size = stack.size();
        assert (size >= 2 && stack.get(size - 1) == op);
        Operator parent = (Operator)stack.get(size - 2);
        List<Operator<OperatorDesc>> parOp = op.getParentOperators();
        pos = parOp.indexOf(parent);
        assert (pos < parOp.size());
        return pos;
    }

    public static NodeProcessor getTableScanMapJoin() {
        return new TableScanMapJoin();
    }

    public static NodeProcessor getUnionMapJoin() {
        return new UnionMapJoin();
    }

    public static NodeProcessor getReduceSinkMapJoin() {
        return new ReduceSinkMapJoin();
    }

    public static NodeProcessor getMapJoin() {
        return new MapJoin();
    }

    public static NodeProcessor getMapJoinMapJoin() {
        return new MapJoinMapJoin();
    }

    private MapJoinFactory() {
    }

    public static class UnionMapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean local;
            GenMRProcContext ctx = (GenMRProcContext)procCtx;
            ParseContext parseCtx = ctx.getParseCtx();
            UnionProcContext uCtx = parseCtx.getUCtx();
            if (uCtx.isMapOnlySubq()) {
                return new TableScanMapJoin().process(nd, stack, procCtx, nodeOutputs);
            }
            UnionOperator currUnion = ctx.getCurrUnionOp();
            assert (currUnion != null);
            ctx.getUnionTask(currUnion);
            AbstractMapJoinOperator mapJoin = (AbstractMapJoinOperator)nd;
            int pos = MapJoinFactory.getPositionParent(mapJoin, stack);
            LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
            GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(mapJoin.getParentOperators().get(pos));
            Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
            MapredWork currPlan = (MapredWork)currTask.getWork();
            AbstractMapJoinOperator reducer = mapJoin;
            HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
            Task<? extends Serializable> opMapTask = opTaskMap.get(reducer);
            boolean bl = local = pos != ((MapJoinDesc)mapJoin.getConf()).getPosBigTable();
            if (local) {
                throw new SemanticException(ErrorMsg.INVALID_MAPJOIN_TABLE.getMsg());
            }
            if (opMapTask == null) {
                assert (currPlan.getReducer() == null);
                ctx.setCurrMapJoinOp(mapJoin);
                GenMapRedUtils.initMapJoinPlan(mapJoin, ctx, true, true, false, pos);
                ctx.setCurrUnionOp(null);
            } else {
                Task<? extends Serializable> uTask = ctx.getUnionTask(ctx.getCurrUnionOp()).getUTask();
                if (uTask.getId().equals(opMapTask.getId())) {
                    GenMapRedUtils.joinPlan(mapJoin, null, opMapTask, ctx, pos, false, false, true);
                } else {
                    GenMapRedUtils.joinPlan(mapJoin, uTask, opMapTask, ctx, pos, false, false, true);
                }
                currTask = opMapTask;
                ctx.setCurrTask(currTask);
            }
            mapCurrCtx.put(mapJoin, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
            return null;
        }
    }

    public static class MapJoinMapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AbstractMapJoinOperator mapJoin = (AbstractMapJoinOperator)nd;
            GenMRProcContext ctx = (GenMRProcContext)procCtx;
            ctx.getParseCtx();
            AbstractMapJoinOperator<? extends MapJoinDesc> oldMapJoin = ctx.getCurrMapJoinOp();
            GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(mapJoin);
            if (mjCtx != null) {
                mjCtx.setOldMapJoin(oldMapJoin);
            } else {
                ctx.setMapJoinCtx(mapJoin, new GenMRProcContext.GenMRMapJoinCtx(null, null, null, oldMapJoin));
            }
            ctx.setCurrMapJoinOp(mapJoin);
            int pos = MapJoinFactory.getPositionParent(mapJoin, stack);
            LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
            GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(mapJoin.getParentOperators().get(pos));
            Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
            MapredWork currPlan = (MapredWork)currTask.getWork();
            mapredCtx.getCurrAliasId();
            AbstractMapJoinOperator reducer = mapJoin;
            HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
            Task<? extends Serializable> opMapTask = opTaskMap.get(reducer);
            ctx.setCurrTask(currTask);
            if (opMapTask == null) {
                assert (currPlan.getReducer() == null);
                GenMapRedUtils.initMapJoinPlan(mapJoin, ctx, true, false, false, pos);
            } else {
                GenMapRedUtils.joinPlan(mapJoin, currTask, opMapTask, ctx, pos, false, true, false);
                currTask = opMapTask;
                ctx.setCurrTask(currTask);
            }
            mapCurrCtx.put(mapJoin, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null, null));
            return null;
        }
    }

    public static class MapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator sel = (SelectOperator)nd;
            AbstractMapJoinOperator mapJoin = (AbstractMapJoinOperator)sel.getParentOperators().get(0);
            assert (sel.getParentOperators().size() == 1);
            GenMRProcContext ctx = (GenMRProcContext)procCtx;
            ParseContext parseCtx = ctx.getParseCtx();
            List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOps = parseCtx.getListMapJoinOpsNoReducer();
            if (listMapJoinOps.contains(mapJoin)) {
                ctx.setCurrAliasId(null);
                ctx.setCurrTopOp(null);
                LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
                mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null, null));
                return null;
            }
            ctx.setCurrMapJoinOp(mapJoin);
            Task<? extends Serializable> currTask = ctx.getCurrTask();
            GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(mapJoin);
            if (mjCtx == null) {
                mjCtx = new GenMRProcContext.GenMRMapJoinCtx();
                ctx.setMapJoinCtx(mapJoin, mjCtx);
            }
            MapredWork mjPlan = GenMapRedUtils.getMapRedWork(parseCtx);
            Task<MapredWork> mjTask = TaskFactory.get(mjPlan, parseCtx.getConf(), new Task[0]);
            TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(mapJoin.getSchema(), "temporarycol"));
            Context baseCtx = parseCtx.getContext();
            String taskTmpDir = baseCtx.getMRTmpFileURI();
            mjCtx.setTaskTmpDir(taskTmpDir);
            mjCtx.setTTDesc(tt_desc);
            mjCtx.setRootMapJoinOp(sel);
            sel.setParentOperators(null);
            Operator<FileSinkDesc> fs_op = OperatorFactory.get(new FileSinkDesc(taskTmpDir, tt_desc, parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE)), mapJoin.getSchema(), new Operator[0]);
            assert (mapJoin.getChildOperators().size() == 1);
            mapJoin.getChildOperators().set(0, fs_op);
            ArrayList<Operator<? extends OperatorDesc>> parentOpList = new ArrayList<Operator<? extends OperatorDesc>>();
            parentOpList.add(mapJoin);
            fs_op.setParentOperators(parentOpList);
            currTask.addDependentTask(mjTask);
            ctx.setCurrTask(mjTask);
            ctx.setCurrAliasId(null);
            ctx.setCurrTopOp(null);
            LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
            mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null, null));
            return null;
        }
    }

    public static class ReduceSinkMapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AbstractMapJoinOperator mapJoin = (AbstractMapJoinOperator)nd;
            GenMRProcContext opProcCtx = (GenMRProcContext)procCtx;
            ParseContext parseCtx = opProcCtx.getParseCtx();
            MapredWork cplan = GenMapRedUtils.getMapRedWork(parseCtx);
            Task<MapredWork> redTask = TaskFactory.get(cplan, parseCtx.getConf(), new Task[0]);
            Task<? extends Serializable> currTask = opProcCtx.getCurrTask();
            int pos = MapJoinFactory.getPositionParent(mapJoin, stack);
            boolean local = pos != ((MapJoinDesc)mapJoin.getConf()).getPosBigTable();
            GenMapRedUtils.splitTasks(mapJoin, currTask, redTask, opProcCtx, false, local, pos);
            currTask = opProcCtx.getCurrTask();
            HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
            Task<? extends Serializable> opMapTask = opTaskMap.get(mapJoin);
            if (opMapTask == null) {
                assert (cplan.getReducer() == null);
                opTaskMap.put(mapJoin, currTask);
                opProcCtx.setCurrMapJoinOp(null);
            } else {
                GenMapRedUtils.joinPlan(mapJoin, currTask, opMapTask, opProcCtx, pos, false, false, false);
                currTask = opMapTask;
                opProcCtx.setCurrTask(currTask);
            }
            return null;
        }
    }

    public static class TableScanMapJoin
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AbstractMapJoinOperator mapJoin = (AbstractMapJoinOperator)nd;
            GenMRProcContext ctx = (GenMRProcContext)procCtx;
            int pos = MapJoinFactory.getPositionParent(mapJoin, stack);
            LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
            GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(mapJoin.getParentOperators().get(pos));
            Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
            MapredWork currPlan = (MapredWork)currTask.getWork();
            Operator<? extends OperatorDesc> currTopOp = mapredCtx.getCurrTopOp();
            String currAliasId = mapredCtx.getCurrAliasId();
            AbstractMapJoinOperator reducer = mapJoin;
            HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
            Task<? extends Serializable> opMapTask = opTaskMap.get(reducer);
            ctx.setCurrTopOp(currTopOp);
            ctx.setCurrAliasId(currAliasId);
            ctx.setCurrTask(currTask);
            if (opMapTask == null) {
                assert (currPlan.getReducer() == null);
                GenMapRedUtils.initMapJoinPlan(mapJoin, ctx, false, false, false, pos);
            } else {
                GenMapRedUtils.joinPlan(mapJoin, null, opMapTask, ctx, pos, false, false, false);
                currTask = opMapTask;
                ctx.setCurrTask(currTask);
            }
            mapCurrCtx.put(mapJoin, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
            return null;
        }
    }
}

